/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.report.rptinput;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.imc.rim.common.license.LicenseReportPlugin;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.PermissionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;

public class RptInputPlugin
extends LicenseReportPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String pageId = this.getView().getPageId();
        this.getView().getPageCache().remove(pageId + "checkSeqList");
        Label label = (Label)this.getControl("labelap1");
        label.setText(ResManager.loadKDString((String)"\u5df2\u9009\u62e9 0/3 \u4e2a\u7ef4\u5ea6", (String)"RptInputPlugin_10", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.initDefaultValue();
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent sortAndFilter : allColumns) {
            sortAndFilter.setFilter(true);
            sortAndFilter.setSort(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (!name.endsWith("_check")) {
            return;
        }
        Boolean checkBoxValue = (Boolean)this.getModel().getValue(name);
        this.changeCheck(name, checkBoxValue);
        String pageId = this.getView().getPageId();
        String checkSeqListStr = this.getView().getPageCache().get(pageId + "checkSeqList");
        List<String> checkSeqList = Arrays.asList(checkSeqListStr.split(","));
        Label label = (Label)this.getControl("labelap1");
        label.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$s/3 \u4e2a\u7ef4\u5ea6", (String)"RptInputPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), checkSeqList.size()));
    }

    private void initDefaultValue() {
        Date threeMonthAgo = DateUtils.getFirstDateOfThreeMonth((Date)new Date());
        this.getModel().setValue("create_time_startdate", (Object)threeMonthAgo);
        this.getModel().setValue("create_time_enddate", (Object)new Date());
    }

    private void changeCheck(String name, Boolean checkBoxValue) {
        String pageId = this.getView().getPageId();
        String checkSeqListStr = this.getView().getPageCache().get(pageId + "checkSeqList");
        ArrayList checkSeqList = Lists.newArrayList();
        if (StringUtils.isNotEmpty((String)checkSeqListStr)) {
            String[] split;
            for (String s : split = checkSeqListStr.split(",")) {
                checkSeqList.add(s);
            }
        }
        if ((StringUtils.equals((String)name, (String)"unitprice_check") || StringUtils.equals((String)name, (String)"tax_check")) && checkSeqList.size() > 0) {
            ArrayList<String> copyList = new ArrayList<String>(Arrays.asList(new String[checkSeqList.size()]));
            Collections.copy(copyList, checkSeqList);
            copyList.stream().forEach(i -> this.getModel().setValue(i, (Object)Boolean.FALSE));
            checkSeqList.clear();
        }
        if (checkBoxValue.booleanValue()) {
            if (checkSeqList.size() == 1 && checkSeqList.contains("unitprice_check")) {
                this.getModel().setValue("unitprice_check", (Object)Boolean.FALSE);
                checkSeqList.clear();
            }
            if (checkSeqList.size() == 1 && checkSeqList.contains("tax_check")) {
                this.getModel().setValue("tax_check", (Object)Boolean.FALSE);
                checkSeqList.clear();
            }
            if (checkSeqList.size() > 2) {
                String checkName = (String)checkSeqList.get(0);
                this.getModel().setValue(checkName, (Object)Boolean.FALSE);
                checkSeqList.remove(checkName);
            }
            checkSeqList.add(name);
        } else if (checkSeqList.contains(name)) {
            checkSeqList.remove(name);
        }
        if (checkSeqList.contains("tax_check") || checkSeqList.contains("unitprice_check")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"goods_name"});
        } else {
            this.getModel().setValue("goods_name", (Object)"");
            this.getView().setVisible(Boolean.FALSE, new String[]{"goods_name"});
        }
        this.getView().getPageCache().put(pageId + "checkSeqList", checkSeqList.stream().collect(Collectors.joining(",")));
    }

    public void afterSetModelValue(DynamicObject scheme) {
        DataEntityPropertyCollection properties = scheme.getDynamicObjectType().getProperties();
        for (IDataEntityProperty prop : properties) {
            Object val = scheme.get(prop.getName());
            this.getModel().setValue(prop.getName(), val);
            if (!prop.getName().endsWith("_check") || !((Boolean)val).booleanValue()) continue;
            this.changeCheck(prop.getName(), (Boolean)val);
        }
        String pageId = this.getView().getPageId();
        String checkSeqListStr = this.getView().getPageCache().get(pageId + "checkSeqList");
        List<String> checkSeqList = Arrays.asList(checkSeqListStr.split(","));
        Label label = (Label)this.getControl("labelap1");
        label.setText(String.format(ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$s/3 \u4e2a\u7ef4\u5ea6", (String)"RptInputPlugin_9", (String)"imc-rim-formplugin", (Object[])new Object[0]), checkSeqList.size()));
        this.getView().updateView();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.setSortInfo("");
        String formId = (String)this.getView().getFormShowParameter().getCustomParams().get("formId");
        String configKey = formId + "_reportlistap_gridConfig";
        UserConfigServiceHelper.clearSetting((long)Long.parseLong(RequestContext.get().getUserId()), (String)configKey);
        String pageId = this.getView().getPageId();
        String checkSeqListStr = this.getView().getPageCache().get(pageId + "checkSeqList");
        List<String> checkSeqList = Arrays.asList(checkSeqListStr.split(","));
        JSONObject checkSeqMap = new JSONObject();
        if (checkSeqList.size() == 0) {
            ReportQueryParam queryParam1 = this.getView().getQueryParam();
            List filterItems = queryParam1.getFilter().getFilterItems();
            List checkList = filterItems.stream().filter(f -> f.getPropName().endsWith("_check") && Boolean.TRUE.equals(f.getValue())).collect(Collectors.toList());
            for (int i = 0; i < checkList.size(); ++i) {
                checkSeqMap.put(((FilterItemInfo)checkList.get(i)).getPropName(), (Object)String.valueOf(i));
            }
        } else {
            for (int i = 0; i < checkSeqList.size(); ++i) {
                checkSeqMap.put(checkSeqList.get(i), (Object)String.valueOf(i));
            }
        }
        this.getPageCache().put("customParam", checkSeqMap.toJSONString());
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_rpt_input", (String)"47150e89000000ac");
        boolean isAdmin = hasPermOrgResult.hasAllOrgPerm();
        if (!isAdmin) {
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            ArrayList filters = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
                QFilter orgFilter = new QFilter("org", "in", (Object)hasPermOrgs);
                filters.add(orgFilter);
            } else {
                QFilter orgFilter = new QFilter("org", "=", (Object)"-100");
                filters.add(orgFilter);
            }
            queryParam.getFilter().setQFilters((List)filters);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        List filterItems = queryParam.getFilter().getFilterItems();
        String pageId = this.getView().getPageId();
        String checkSeqListStr = this.getView().getPageCache().get(pageId + "checkSeqList");
        if (StringUtils.isEmpty((String)checkSeqListStr)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u7ef4\u5ea6", (String)"RptInputPlugin_11", (String)"imc-rim-formplugin", (Object[])new Object[0]));
            filterItems.stream().filter(f -> f.getPropName().endsWith("_check")).forEach(f -> f.setValue((Object)Boolean.FALSE));
            return false;
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObject rowData = hyperLinkClickEvent.getRowData();
        Map customParams = DynamicObjectUtil.dynamicObject2Map((DynamicObject)rowData);
        String pageId = this.getView().getPageId();
        String checkSeqListStr = this.getView().getPageCache().get(pageId + "checkSeqList");
        List<String> checkSeqList = Arrays.asList(checkSeqListStr.split(","));
        customParams.put("checkSeqList", checkSeqList);
        ReportQueryParam queryParam = this.getView().getQueryParam();
        List filterItems = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo f : filterItems) {
            if (!ObjectUtils.isEmpty(customParams.get(f.getPropName()))) continue;
            customParams.put(f.getPropName() + "_query", f.getValue());
        }
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)this.getView(), (String)"rim_rpt_input", (String)"47150e89000000ac");
        boolean isAdmin = hasPermOrgResult.hasAllOrgPerm();
        customParams.put("isAdmin", isAdmin);
        List authList = queryParam.getFilter().getQFilters();
        customParams.put("authList", authList);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(true);
        showParameter.setCustomParams(customParams);
        showParameter.setFormId("rim_rpt_detail_main");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u7968\u7edf\u8ba1\u660e\u7ec6", (String)"RptInputPlugin_12", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }
}

