/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.verify;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.imc.rim.common.utils.ScriptUtils;

public class CostomVerifyPlugin
extends AbstractFormPlugin {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String BTN_OK = "btnok";
    private static int CONFIG_TEXT_MAX_LENGTH = 10000;
    private static final Set<String> CUSTOM_CONFIG_FIELDS = new HashSet<String>(Arrays.asList("items_spec_model", "items_goods_code", "seat_grade_name"));
    private static final Set<String> CUSTOM_CONFIG_FIELDS_1 = new HashSet<String>(Arrays.asList("special_type_mark", "ticket_changes", "business_type", "items_zerotaxrate_flag", "items_spec_model", "items_goods_code", "authenticate_flag", "tax_recorded_status"));
    private static final Set<String> COMPARE_TYPES = Stream.of(CompareTypeEnum.EQUAL, CompareTypeEnum.NOTEQUAL, CompareTypeEnum.IN, CompareTypeEnum.NOTIN, CompareTypeEnum.LIKE, CompareTypeEnum.NOTLIKE, CompareTypeEnum.LEFTLIKE, CompareTypeEnum.RIGHTLIKE).map(CompareTypeEnum::getId).collect(Collectors.toSet());
    private static final String KEY_ = "";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void beforeBindData(EventObject e) {
        this.iniFilterGrid();
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        Object index = customParams.get("index");
        if (index != null) {
            this.getModel().setValue("custom_name", customParams.get("custom_name"));
            this.getModel().setValue("custom_level", customParams.get("custom_level"));
            this.getModel().setValue("custom_invoice_type", customParams.get("custom_invoice_type"));
            this.getModel().setValue("custom_desc", customParams.get("custom_desc"));
            String custom_config = (String)customParams.get("custom_config");
            if (StringUtils.isNotEmpty((String)custom_config)) {
                FilterCondition filterCondition2 = (FilterCondition)SerializationUtils.fromJsonString((String)custom_config, FilterCondition.class);
                filterGrid.SetValue(filterCondition2);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object index = customParams.get("index");
        if (index != null) {
            this.getModel().setValue("custom_name", customParams.get("custom_name"));
            this.getModel().setValue("custom_level", customParams.get("custom_level"));
            this.getModel().setValue("custom_invoice_type", customParams.get("custom_invoice_type"));
            this.getModel().setValue("custom_desc", customParams.get("custom_desc"));
        }
    }

    private void iniFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        filterCondition.getFilterRow().clear();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_verify_filter");
        DataEntityPropertyCollection mainPros = mainEntityType.getProperties();
        ArrayList<Map> filterColumns = new ArrayList<Map>(8);
        for (IDataEntityProperty property : mainPros) {
            List compareTypes;
            List<CompareTypeDto> finalCompareTypes;
            if (!(property instanceof IFieldHandle)) continue;
            IFieldHandle handle = (IFieldHandle)property;
            String propertyName = property.getName();
            if ("id".equals(propertyName) || "invoice_type_id".equals(propertyName) || "items_tax_rate".equals(propertyName)) continue;
            FilterField filterField = handle.createFilterField(mainEntityType, property.getName());
            Map filterColumn = filterField.createFilterColumn(true);
            if (filterColumn != null && !CollectionUtils.isEmpty(finalCompareTypes = this.removeSomeTypes(propertyName, compareTypes = (List)filterColumn.get("compareTypes")))) {
                filterColumn.put("compareTypes", finalCompareTypes);
            }
            filterColumns.add(filterColumn);
        }
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber("rim_verify_filter");
    }

    private List<CompareTypeDto> removeSomeTypes(String propertyName, List<CompareTypeDto> compareTypes) {
        List<Object> finalCollect = new ArrayList();
        if ("invoice_code".equals(propertyName) || "invoice_no".equals(propertyName)) {
            finalCollect = compareTypes.stream().filter(f -> !CompareTypeEnum.GREATER.getId().equals(f.getId()) && !CompareTypeEnum.LESS.getId().equals(f.getId()) && !CompareTypeEnum.LESSOREQUAL.getId().equals(f.getId()) && !CompareTypeEnum.GREATEROREQUAL.getId().equals(f.getId())).collect(Collectors.toList());
        } else if (CUSTOM_CONFIG_FIELDS.contains(propertyName)) {
            finalCollect = compareTypes.stream().filter(f -> COMPARE_TYPES.contains(f.getId())).collect(Collectors.toList());
            if ("seat_grade_name".equals(propertyName)) {
                finalCollect = finalCollect.stream().filter(f -> !CompareTypeEnum.LEFTLIKE.getId().equals(f.getId()) && !CompareTypeEnum.RIGHTLIKE.getId().equals(f.getId())).collect(Collectors.toList());
            }
        } else if (propertyName.equals("items_tax_rate")) {
            Set tmp = Stream.of(CompareTypeEnum.GREATER, CompareTypeEnum.GREATEROREQUAL, CompareTypeEnum.LESS, CompareTypeEnum.LESSOREQUAL).map(CompareTypeEnum::getId).collect(Collectors.toSet());
            finalCollect = compareTypes.stream().filter(f -> tmp.contains(f.getId())).collect(Collectors.toList());
        }
        if (CUSTOM_CONFIG_FIELDS_1.contains(propertyName)) {
            finalCollect = finalCollect.isEmpty() ? compareTypes : finalCollect;
            Function<CompareTypeDto, Boolean> isFieldCompare = f -> f.getId().contains("-") || f.getId().equals(CompareTypeEnum.ISNULL.getId()) || f.getId().equals(CompareTypeEnum.ISNOTNULL.getId()) || f.getId().equals(CompareTypeEnum.COMBOBOXISNOTNULL.getId()) || f.getId().equals(CompareTypeEnum.COMBOBOXISNULL.getId());
            finalCollect = finalCollect.stream().filter(f -> (Boolean)isFieldCompare.apply((CompareTypeDto)f) == false).collect(Collectors.toList());
        }
        return finalCollect;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (BTN_OK.equals(control.getKey())) {
            FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
            FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
            String customConfig = SerializationUtils.toJsonString((Object)filterCondition);
            if (customConfig.length() > CONFIG_TEXT_MAX_LENGTH) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539", (String)"CostomVerifyPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            List filterRowList = filterCondition.getFilterRow();
            StringBuilder sb = new StringBuilder();
            for (SimpleFilterRow row : filterRowList) {
                if (StringUtils.isNotEmpty((String)row.getLeftBracket())) {
                    sb.append(row.getLeftBracket());
                }
                sb.append("true");
                if (StringUtils.isNotEmpty((String)row.getRightBracket())) {
                    sb.append(row.getRightBracket());
                }
                if ("0".equals(row.getLogic())) {
                    sb.append("&&");
                    continue;
                }
                sb.append("||");
            }
            sb.append("true");
            try {
                ScriptUtils.eval((String)sb.toString());
            }
            catch (Exception e) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539", (String)"CostomVerifyPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            HashMap<String, String> result = new HashMap<String, String>(4);
            result.put("custom_name", (String)this.getModel().getValue("custom_name"));
            result.put("custom_level", (String)this.getModel().getValue("custom_level"));
            result.put("custom_invoice_type", (String)this.getModel().getValue("custom_invoice_type"));
            result.put("custom_desc", (String)this.getModel().getValue("custom_desc"));
            result.put("custom_config", customConfig);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object index = customParams.get("index");
            if (index != null) {
                result.put("index", index.toString());
            }
            this.getView().returnDataToParent(result);
            this.getView().close();
        } else {
            this.getView().close();
        }
    }

    private List<CompareType> getCompareTypes() {
        CompareTypeEnum[] typeEnum = new CompareTypeEnum[]{CompareTypeEnum.EQUAL, CompareTypeEnum.NOTEQUAL};
        ArrayList<CompareType> list = new ArrayList<CompareType>(8);
        for (CompareTypeEnum type : typeEnum) {
            CompareType compare = new CompareType();
            compare.setId(type.getId());
            compare.setName(new LocaleString(type.name()));
            list.add(compare);
        }
        return list;
    }
}

