/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.verify;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.RimPermItemEnum;
import kd.imc.rim.common.license.LicenseListPlugin;
import kd.imc.rim.common.utils.PermissionUtils;

public class VerifyListPlugin
extends LicenseListPlugin {
    private static final String ITEM_NEW = "new";
    private static final String ITEM_COPY = "copy";
    private static final String ITEM_DELETE = "delete";
    private static final String PAGE_CONFIG = "rim_verify_config";

    public void afterCreateNewData(EventObject e) {
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (ITEM_NEW.equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_NEW, (String)ITEM_NEW);
            this.openConfigPage(key, null);
        } else if (ITEM_COPY.equals(key)) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRow row = billlist.getCurrentSelectedRowInfo();
            this.openConfigPage(key, row.getPrimaryKeyValue());
        } else if (ITEM_DELETE.equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DELETE, (String)ITEM_DELETE);
        } else if ("enable".equals(key) || "disable".equals(key)) {
            DynamicObject[] objs;
            if ("enable".equals(key)) {
                PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_ENABLE, (String)"enable");
            } else {
                PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.ITEM_DISABLE, (String)"disable");
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billlist.getSelectedRows();
            if (rows == null || rows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u64cd\u4f5c\u7684\u8bb0\u5f55", (String)"VerifyListPlugin_0", (String)"imc-rim-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Object[] pks = rows.getPrimaryKeyValues();
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"rim_verify");
            for (DynamicObject obj : objs = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)mainEntityType)) {
                if ("disable".equals(key)) {
                    obj.set("status", (Object)"0");
                } else if ("enable".equals(key)) {
                    obj.set("status", (Object)"1");
                }
                obj.set("update_time", (Object)new Date());
                obj.set("modifier", (Object)RequestContext.get().getUserId());
            }
            SaveServiceHelper.save((DynamicObject[])objs);
            billlist.refresh();
        } else if ("expense_type".equals(key)) {
            PermissionUtils.checkPermission((AbstractFormPlugin)this, (RimPermItemEnum)RimPermItemEnum.RIM_EXP_STATUS_UPDATE, (String)"expense_type");
            ListShowParameter showParameter = new ListShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("rim_expense_type");
            showParameter.setListFilterParameter(listFilterParameter);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent hyperEvt = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperEvt.getSource();
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        this.openConfigPage("edit", currentSelectedRowInfo.getPrimaryKeyValue());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (PAGE_CONFIG.equals(closedCallBackEvent.getActionId())) {
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refresh();
        }
    }

    private void openConfigPage(String type, Object rowId) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        customParams.put("configId", rowId);
        customParams.put("operateType", type);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(PAGE_CONFIG);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PAGE_CONFIG);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

