/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.formplugin.verify;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.license.LicenseFormPlugin;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;

public class VerifyMainPlugin
extends LicenseFormPlugin {
    private static final String ORG_NAME = "orgname";
    private static final String STATISTICS_SCOPE = "statistics_scope";
    private static final String VERIFY_COUNT = "verify_count";
    private static final String VERIFY_FAIL_COUNT = "verify_fail_count";
    private static final String VERIFY_FAIL_AMOUNT = "verify_fail_amount";
    private static final String VERIFY_ITEMS = "entryentity";
    private static final String VERIFY_RISK = "risk_grade";
    private static final Log LOGGER = LogFactory.getLog(VerifyMainPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"dmp_exportpdf"});
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("mul_org", (Object)new Long[]{RequestContext.get().getOrgId()});
        this.showOrgName();
        List<Date> dateScope = this.getDateScope();
        String startDate = DateUtils.format((Date)dateScope.get(0));
        String endDate = DateUtils.format((Date)dateScope.get(dateScope.size() - 1));
        Label scopeLabel = (Label)this.getControl(STATISTICS_SCOPE);
        scopeLabel.setText(String.format(ResManager.loadKDString((String)"\u7edf\u8ba1\u8303\u56f4:%1$s~%2$s", (String)"VerifyMainPlugin_24", (String)"imc-rim-formplugin", (Object[])new Object[0]), startDate, endDate));
        this.query();
    }

    public void setColor() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(VERIFY_ITEMS);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(VERIFY_ITEMS);
        for (int i = 0; i < entryentity.size(); ++i) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey(VERIFY_RISK);
            cellStyle.setRow(i);
            if ("3".equals(((DynamicObject)entryentity.get(i)).get(VERIFY_RISK))) {
                cellStyle.setForeColor("red");
            } else if ("2".equals(((DynamicObject)entryentity.get(i)).get(VERIFY_RISK))) {
                cellStyle.setForeColor("orange");
            } else {
                cellStyle.setForeColor("blue");
            }
            cellStyles.add(cellStyle);
            entryGrid.setCellStyle(cellStyles);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(VERIFY_ITEMS);
        CellStyle cellStyle = new CellStyle();
        cellStyle.setFieldKey(VERIFY_RISK);
        cellStyle.setRow(e.getInsertRow() + 1);
        if ("3".equals(((DynamicObject)entryentity.get(e.getInsertRow() + 1)).get(VERIFY_RISK))) {
            cellStyle.setForeColor("red");
        } else if ("2".equals(((DynamicObject)entryentity.get(e.getInsertRow() + 1)).get(VERIFY_RISK))) {
            cellStyle.setForeColor("orange");
        } else {
            cellStyle.setForeColor("blue");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl(VERIFY_ITEMS);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(VERIFY_ITEMS);
        for (int i = 0; i < entryentity.size(); ++i) {
            CellStyle cellStyle = new CellStyle();
            cellStyle.setFieldKey(VERIFY_RISK);
            cellStyle.setRow(i);
            if ("3".equals(((DynamicObject)entryentity.get(i)).get(VERIFY_RISK))) {
                cellStyle.setForeColor("red");
            } else if ("2".equals(((DynamicObject)entryentity.get(i)).get(VERIFY_RISK))) {
                cellStyle.setForeColor("orange");
            } else {
                cellStyle.setForeColor("blue");
            }
            cellStyles.add(cellStyle);
            entryGrid.setCellStyle(cellStyles);
        }
    }

    private void showOrgName() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String name = "";
        if (org != null) {
            name = org.getString("name");
        }
        Label orgnameLabel = (Label)this.getControl(ORG_NAME);
        orgnameLabel.setText(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%1$s", (String)"VerifyMainPlugin_25", (String)"imc-rim-formplugin", (Object[])new Object[0]), name));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if ("mul_org".equals(fieldKey)) {
            this.query();
            this.setColor();
        }
    }

    private void query() {
        List<Date> dateScope = this.getDateScope();
        Integer totalCount = 0;
        Integer totalVerifyFailCount = 0;
        BigDecimal totalVerifyFailAmount = BigDecimal.ZERO;
        GroupInfo groupInfo = new GroupInfo();
        ArrayList<String> demensions = new ArrayList<String>(8);
        ArrayList<Number> verifySuccessList = new ArrayList<Number>(8);
        ArrayList<Number> verifyFailList = new ArrayList<Number>(8);
        ArrayList<Number> verifyRateList = new ArrayList<Number>(8);
        HashMap<String, Integer> failCauseMap = new HashMap<String, Integer>(8);
        HashMap<Long, Integer> invoiceTypeMap = new HashMap<Long, Integer>(8);
        HashMap<String, JSONObject> failItemMap = new HashMap<String, JSONObject>(8);
        List<Object> org = this.getCurrentOrgIds();
        for (Date date : dateScope) {
            List<Map<String, Object>> detailList;
            Object rate;
            demensions.add(DateUtils.format((Date)date, (String)"yyyy-MM"));
            Date startDate = DateUtils.getFirstDateOfMonth((Date)date);
            Date endDate = DateUtils.getLastDateOfMonth((Date)date);
            Integer successCount = 0;
            Integer failCount = 0;
            List<Map<String, Object>> totalList = this.queryTotal(startDate, endDate, org);
            if (totalList == null || totalList.isEmpty()) {
                verifySuccessList.add(successCount);
                verifyFailList.add(failCount);
                rate = 0;
                verifyRateList.add((Number)rate);
                continue;
            }
            for (Map<String, Object> map : totalList) {
                int invoiceCount = BigDecimalUtil.transDecimal((Object)map.get("INVOICE_COUNT")).intValue();
                totalCount = totalCount + invoiceCount;
                if ("1".equals(map.get("FCOMPLIANCE"))) {
                    successCount = successCount + invoiceCount;
                    continue;
                }
                failCount = failCount + invoiceCount;
                totalVerifyFailCount = totalVerifyFailCount + invoiceCount;
                totalVerifyFailAmount = totalVerifyFailAmount.add(BigDecimalUtil.transDecimal((Object)map.get("FTOTAL_AMOUNT")));
                Long invoiceType = BigDecimalUtil.transDecimal((Object)map.get("FINVOICE_TYPE")).longValue();
                Integer value2 = invoiceTypeMap.getOrDefault(invoiceType, 0);
                value2 = value2 + invoiceCount;
                invoiceTypeMap.put(invoiceType, value2);
            }
            if (failCount > 0 && (detailList = this.queryDetail(startDate, endDate, org)) != null && !detailList.isEmpty()) {
                for (Map<String, Object> map : detailList) {
                    String verifyName = String.valueOf(map.get("FVERIFY_NAME"));
                    String verifyDescription = String.valueOf(map.get("FVERIFY_DESCRIPTION"));
                    String riskGrade = String.valueOf(map.get("FRISK_GRADE"));
                    Integer value = failCauseMap.getOrDefault(verifyName, 0);
                    int invoiceCount = BigDecimalUtil.transDecimal((Object)map.get("INVOICE_COUNT")).intValue();
                    value = value + invoiceCount;
                    failCauseMap.put(verifyName, value);
                    JSONObject failItem = failItemMap.getOrDefault(verifyName, new JSONObject());
                    failItem.put("verifyName", (Object)verifyName);
                    failItem.put("verifyDescription", (Object)verifyDescription);
                    failItem.put("riskGrade", (Object)riskGrade);
                    Integer count = failItem.getInteger("failCount");
                    if (count == null || count == 0) {
                        count = 0;
                    }
                    count = count + invoiceCount;
                    failItem.put("failCount", (Object)count);
                    failItemMap.put(verifyName, failItem);
                }
            }
            verifySuccessList.add(successCount);
            verifyFailList.add(failCount);
            rate = 0;
            if (successCount + failCount > 0) {
                rate = successCount;
                rate = new BigDecimal(String.valueOf(successCount)).divide(new BigDecimal(String.valueOf(successCount + failCount)), 2, 4);
            }
            verifyRateList.add((Number)rate);
        }
        groupInfo.setDemensions(demensions);
        groupInfo.setVerifySuccessList(verifySuccessList);
        groupInfo.setVerifyFailList(verifyFailList);
        groupInfo.setVerifyRateList(verifyRateList);
        Label totalCountLabel = (Label)this.getControl(VERIFY_COUNT);
        totalCountLabel.setText(String.valueOf(totalCount));
        Label failCountLabel = (Label)this.getControl(VERIFY_FAIL_COUNT);
        failCountLabel.setText(String.valueOf(totalVerifyFailCount));
        BigDecimal bigDecimal = new BigDecimal("10000");
        this.getModel().setValue(VERIFY_FAIL_AMOUNT, (Object)totalVerifyFailAmount.divide(bigDecimal));
        this.drawCustomChart(groupInfo);
        this.drawPointLineChart(groupInfo);
        this.drawPieChart(failCauseMap);
        this.drawInvoiceTypeChart(invoiceTypeMap);
        this.showFailItems(failItemMap);
    }

    private List<Map<String, Object>> queryTotal(Date startDate, Date endDate, List<Object> org) {
        String orgStr = org.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = "select a.finvoice_type,a.fcompliance ,count(1) as invoice_count,sum(a.ftotal_amount) as ftotal_amount  from t_rim_verify_statistic a  where a.forg_id in(" + orgStr + ") and a.fcreatetime >= ? and a.fcreatetime <= ?  group by a.finvoice_type, a.fcompliance";
        List list = DBUtils.query((String)sql, (Object[])new Object[]{startDate, endDate});
        return list;
    }

    private List<Map<String, Object>> queryDetail(Date startDate, Date endDate, List<Object> org) {
        String orgStr = org.stream().map(String::valueOf).collect(Collectors.joining(","));
        String sql = "select a.finvoice_type,a.fcompliance ,b.frisk_grade ,b.fverify_name,b.fverify_description,b.frisk_grade,count(1) as invoice_count,sum(a.ftotal_amount) as ftotal_amount from t_rim_verify_statistic a, t_rim_verify_detail b where a.fid = b.fid and a.forg_id in(" + orgStr + ") and a.fcreatetime >= ? and a.fcreatetime <= ? group by a.finvoice_type,a.fcompliance ,b.frisk_grade ,b.fverify_name,b.fverify_description,b.frisk_grade";
        List list = DBUtils.query((String)sql, (Object[])new Object[]{startDate, endDate});
        return list;
    }

    private void showFailItems(Map<String, JSONObject> failItemMap) {
        this.getModel().deleteEntryData(VERIFY_ITEMS);
        for (Map.Entry<String, JSONObject> entry : failItemMap.entrySet()) {
            JSONObject item = entry.getValue();
            int row = this.getModel().createNewEntryRow(VERIFY_ITEMS);
            this.getModel().setValue("verify_name", (Object)item.getString("verifyName"), row);
            this.getModel().setValue("verify_description", (Object)item.getString("verifyDescription"), row);
            this.getModel().setValue(VERIFY_RISK, (Object)item.getString("riskGrade"), row);
            this.getModel().setValue("fail_count", (Object)item.getInteger("failCount"), row);
        }
    }

    private void drawPieChart(Map<String, Integer> failCauseMap) {
        LOGGER.info("\u997c\u72b6\u56fe\uff1a{}", failCauseMap);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.clearData();
        boolean isShowTitle = true;
        pieChart.setShowTitle(isShowTitle);
        boolean isShowLegend = false;
        pieChart.setShowLegend(isShowLegend);
        boolean isShowTooltip = true;
        pieChart.setShowTooltip(isShowTooltip);
        boolean isLegendVertical = false;
        pieChart.setLegendVertical(isLegendVertical);
        pieChart.setLegendAlign(XAlign.right, YAlign.bottom);
        pieChart.setMargin(Position.right, "80px");
        pieChart.setMargin(Position.top, "60px");
        pieChart.setLegendPropValue("left", (Object)"700");
        PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"\u4e0d\u5408\u89c4\u539f\u56e0", (String)"VerifyMainPlugin_26", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        series.setRadius(" 0%", "70%");
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(failCauseMap.entrySet());
        Collections.sort(entryList, Comparator.comparing(Map.Entry::getValue));
        if (entryList.size() > 9) {
            int other = 0;
            int n = entryList.size();
            for (int i = 0; i < n - 9; ++i) {
                other += ((Integer)((Map.Entry)entryList.get(0)).getValue()).intValue();
                entryList.remove(0);
            }
            series.addData(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"VerifyMainPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]), (Number)other);
        }
        LOGGER.info("entryList\u6570\u91cf" + entryList.size());
        for (Map.Entry entry : entryList) {
            String name = MetadataUtil.getComboItemName((String)"rim_verify_statistics", (String)"verify_name", (String)((String)entry.getKey()));
            if (StringUtils.isEmpty((CharSequence)name)) {
                name = (String)entry.getKey();
            }
            LOGGER.info("\u5408\u89c4\u6027\u6821\u9a8c\u997c\u72b6\u56fe\uff1a" + name + "\u6570\u636e" + entry.getValue());
            series.addData(name, (Number)entry.getValue());
        }
        pieChart.refresh();
    }

    private void drawPointLineChart(GroupInfo groupInfo) {
        PointLineChart pointLineChart = (PointLineChart)this.getControl("pointlinechartap");
        pointLineChart.clearData();
        boolean isShowTitle = true;
        pointLineChart.setShowTitle(isShowTitle);
        boolean isShowLegend = false;
        pointLineChart.setShowLegend(isShowLegend);
        boolean isShowTooltip = true;
        pointLineChart.setShowTooltip(isShowTooltip);
        Axis x = pointLineChart.createXAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"VerifyMainPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.category);
        Axis y = pointLineChart.createYAxis(ResManager.loadKDString((String)"\u5408\u89c4\u7387", (String)"VerifyMainPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("rotate", Integer.valueOf(36));
        x.setPropValue("axisLabel", axisLabel);
        x.setPropValue("data", (Object)groupInfo.getDemensions().toArray());
        LineSeries lineSeries = pointLineChart.createLineSeries(ResManager.loadKDString((String)"\u5408\u89c4\u7387", (String)"VerifyMainPlugin_29", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        lineSeries.setData(groupInfo.getVerifyRateList().toArray(new Number[groupInfo.getVerifyRateList().size()]));
        HashMap markLine = new HashMap(8);
        ArrayList data = new ArrayList(8);
        HashMap<String, String> average = new HashMap<String, String>(8);
        average.put("type", "average");
        average.put("name", ResManager.loadKDString((String)"\u5e73\u5747\u503c", (String)"VerifyMainPlugin_30", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        data.add(average);
        markLine.put("data", data);
        lineSeries.setPropValue("markLine", markLine);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(2);
        Boolean show = Boolean.FALSE;
        axisTick.put("show", show);
        x.setPropValue("axisTick", axisTick);
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>(2);
        splitLine.put("show", show);
        x.setPropValue("splitLine", splitLine);
        pointLineChart.refresh();
    }

    private void drawCustomChart(GroupInfo groupInfo) {
        BarChart barChart = (BarChart)this.getControl("barchartap");
        barChart.clearData();
        boolean isShowTitle = true;
        barChart.setShowTitle(isShowTitle);
        boolean isShowLegend = false;
        barChart.setShowLegend(isShowLegend);
        boolean isLegendVertical = false;
        barChart.setLegendVertical(isLegendVertical);
        boolean isShowTooltip = true;
        barChart.setShowTooltip(isShowTooltip);
        Axis x = barChart.createXAxis(ResManager.loadKDString((String)"\u65e5\u671f", (String)"VerifyMainPlugin_28", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.category);
        Axis y = barChart.createYAxis(ResManager.loadKDString((String)"\u7968\u6b21(\u5f20)", (String)"VerifyMainPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Comparable<Boolean>> axisLabel = new HashMap<String, Comparable<Boolean>>();
        axisLabel.put("show", Boolean.TRUE);
        axisLabel.put("rotate", Integer.valueOf(36));
        x.setPropValue("data", (Object)groupInfo.getDemensions().toArray());
        x.setPropValue("axisLabel", axisLabel);
        BarSeries barSeries = barChart.createBarSeries(ResManager.loadKDString((String)"\u5408\u89c4", (String)"VerifyMainPlugin_32", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries.setData(groupInfo.getVerifySuccessList().toArray(new Number[groupInfo.getVerifySuccessList().size()]));
        BarSeries barSeries2 = barChart.createBarSeries(ResManager.loadKDString((String)"\u4e0d\u5408\u89c4", (String)"VerifyMainPlugin_33", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries2.setData(groupInfo.getVerifyFailList().toArray(new Number[groupInfo.getVerifyFailList().size()]));
        Boolean show = Boolean.FALSE;
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>(2);
        axisTick.put("show", show);
        x.setPropValue("axisTick", axisTick);
        HashMap<String, Boolean> splitLine = new HashMap<String, Boolean>(2);
        splitLine.put("show", show);
        x.setPropValue("splitLine", splitLine);
        barChart.refresh();
    }

    private void drawInvoiceTypeChart(Map<Long, Integer> invoiceTypeMap) {
        ArrayList<Map.Entry<Long, Integer>> entryList = new ArrayList<Map.Entry<Long, Integer>>(invoiceTypeMap.entrySet());
        Collections.sort(entryList, Comparator.comparing(Map.Entry::getValue));
        if (entryList.size() > 9) {
            int other = 0;
            HashMap<Long, Integer> otherInvoice = new HashMap<Long, Integer>();
            int size = entryList.size();
            for (int i = 0; i < size - 9; ++i) {
                other += ((Integer)((Map.Entry)entryList.get(0)).getValue()).intValue();
                entryList.remove(0);
            }
            otherInvoice.put(1L, other);
            Iterator iterator = otherInvoice.entrySet().iterator();
            while (iterator.hasNext()) {
                entryList.add(iterator.next());
            }
        }
        Collections.sort(entryList, Comparator.comparing(Map.Entry::getValue));
        List demensions = entryList.stream().map(Map.Entry::getKey).collect(Collectors.toList());
        List<Number> counts = entryList.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        ArrayList<String> demensionsStr = new ArrayList<String>(demensions.size());
        for (Long invoiceTypeId : demensions) {
            InputInvoiceTypeEnum invoiceTypeEnum = InputInvoiceTypeEnum.getInvoiceType((Long)invoiceTypeId);
            String invoiceTypeName = ResManager.loadKDString((String)"\u672a\u77e5", (String)"VerifyMainPlugin_34", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            if (invoiceTypeEnum != null) {
                invoiceTypeName = invoiceTypeEnum.getName();
            } else if (invoiceTypeId == 1L) {
                invoiceTypeName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"VerifyMainPlugin_27", (String)"imc-rim-formplugin", (Object[])new Object[0]);
            }
            demensionsStr.add(invoiceTypeName);
        }
        BarChart barChart = (BarChart)this.getControl("barchartap1");
        barChart.clearData();
        barChart.setMargin(Position.right, "10%");
        boolean isShowTitle = true;
        barChart.setShowTitle(isShowTitle);
        boolean isShowLegend = false;
        barChart.setShowLegend(isShowLegend);
        boolean isShowTooltip = true;
        barChart.setShowTooltip(isShowTooltip);
        Axis x = barChart.createXAxis(ResManager.loadKDString((String)"\u7968\u6b21(\u5f20)", (String)"VerifyMainPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.value);
        Axis y = barChart.createYAxis(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"VerifyMainPlugin_35", (String)"imc-rim-formplugin", (Object[])new Object[0]), AxisType.category);
        y.setPropValue("data", (Object)demensionsStr.toArray());
        BarSeries barSeries = barChart.createBarSeries(ResManager.loadKDString((String)"\u7968\u6b21(\u5f20)", (String)"VerifyMainPlugin_31", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        barSeries.setData(counts.toArray(new Number[counts.size()]));
        barSeries.setBarWidth("14px");
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setPosition(Position.right);
        label.setShow(true);
        barSeries.setLabel(label);
        Boolean show = Boolean.FALSE;
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", show);
        y.setPropValue("axisTick", axisTick);
        HashMap<String, Serializable> splitLine = new HashMap<String, Serializable>(4);
        HashMap<String, String> lineStyle = new HashMap<String, String>(4);
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        x.setPropValue("splitLine", splitLine);
        splitLine.put("show", Boolean.TRUE);
        x.setPropValue("splitLine", splitLine);
        barChart.refresh();
    }

    private List<Date> getDateScope() {
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Date date = new Date();
        for (int i = 11; i > 0; --i) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(2, calendar.get(2) - i);
            calendar.set(5, 1);
            Date date2 = calendar.getTime();
            dates.add(date2);
        }
        dates.add(date);
        return dates;
    }

    private List<Object> getCurrentOrgIds() {
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("mul_org");
        Long orgId = RequestContext.get().getOrgId();
        ArrayList<Object> list = new ArrayList<Object>();
        if (orgs != null) {
            for (DynamicObject obj : orgs) {
                list.add(obj.getDynamicObject("fbasedataid").getPkValue());
            }
        }
        return list;
    }

    private static class GroupInfo {
        private List<String> demensions;
        private List<Number> verifySuccessList;
        private List<Number> verifyFailList;
        private List<Number> verifyRateList;

        private GroupInfo() {
        }

        public List<String> getDemensions() {
            return this.demensions;
        }

        public void setDemensions(List<String> demensions) {
            this.demensions = demensions;
        }

        public List<Number> getVerifySuccessList() {
            return this.verifySuccessList;
        }

        public void setVerifySuccessList(List<Number> verifySuccessList) {
            this.verifySuccessList = verifySuccessList;
        }

        public List<Number> getVerifyFailList() {
            return this.verifyFailList;
        }

        public void setVerifyFailList(List<Number> verifyFailList) {
            this.verifyFailList = verifyFailList;
        }

        public List<Number> getVerifyRateList() {
            return this.verifyRateList;
        }

        public void setVerifyRateList(List<Number> verifyRateList) {
            this.verifyRateList = verifyRateList;
        }
    }
}

