/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.invoice.deduction.AsyncDeductHelper;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.StringUtils;

public class RimProgressTask
implements Runnable {
    private static Log LOGGER = LogFactory.getLog(RimProgressTask.class);
    private RequestContext requestContext;
    private PageCache pageCache;
    private long runningTimeMillis = 600000L;

    public RimProgressTask(RequestContext requestContext, String pageId, long runningTimeMillis) {
        this.requestContext = requestContext;
        this.pageCache = new PageCache(pageId);
        if (runningTimeMillis < 600000L) {
            this.runningTimeMillis = runningTimeMillis;
        }
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        long endTime = startTime + this.runningTimeMillis;
        while (System.currentTimeMillis() < endTime) {
            try {
                QFilter filter;
                DynamicObjectCollection list;
                String batchNoListStr;
                if (this.pageCache == null || StringUtils.isBlank((CharSequence)(batchNoListStr = this.pageCache.get("batchNolist")))) break;
                JSONArray jsonArray = JSON.parseArray((String)batchNoListStr);
                boolean stopTaskFlag = false;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String batchNo = jsonArray.getString(i);
                    String stopFlag = CacheHelper.get((String)("progressStopFlag" + batchNo));
                    if (!StringUtils.equals((CharSequence)"1", (CharSequence)stopFlag)) continue;
                    if (!stopTaskFlag) {
                        stopTaskFlag = true;
                    }
                    CacheHelper.remove((String)("progressStopFlag" + batchNo));
                    break;
                }
                if (stopTaskFlag) break;
                String entityName = this.pageCache.get("entityName");
                String statusFieldName = this.pageCache.get("statusFieldName");
                String queryFields = this.pageCache.get("queryFields");
                String handlingStatusListStr = this.pageCache.get("handlingStatusList");
                String filterFieldName = this.pageCache.get("filterFieldName");
                if (StringUtils.isNotEmpty((CharSequence)queryFields) && !queryFields.contains("id")) {
                    queryFields = queryFields + ",id";
                }
                if (CollectionUtils.isEmpty((Collection)(list = QueryServiceHelper.query((String)entityName, (String)queryFields, (QFilter[])new QFilter[]{filter = new QFilter(filterFieldName, "in", (Object)jsonArray)})))) break;
                JSONArray handlingStatusArr = JSON.parseArray((String)handlingStatusListStr);
                Object[] handlingIds = list.stream().filter(log -> handlingStatusArr.contains((Object)log.getString(statusFieldName))).map(log -> log.get("id")).toArray();
                if (ObjectUtils.isEmpty((Object[])handlingIds)) {
                    this.getTotalData(entityName, filter);
                    this.pageCache.put("finishFlag", "1");
                    break;
                }
                String progressSleep = ImcConfigUtil.getValue((String)"rim_deduction", (String)"select_progress_sleep", (String)"20000");
                Thread.sleep(BigDecimalUtil.transDecimal((Object)progressSleep).longValue());
                this.queryHandlingTaskResult(handlingIds, entityName);
            }
            catch (InterruptedException e) {
                LOGGER.info("\u7ebf\u7a0b\u4f11\u7720\u62a5\u9519\uff0c \u7ebf\u7a0bid: {}", (Object)Thread.currentThread().getId(), (Object)e);
                break;
            }
            catch (Exception e) {
                LOGGER.info("\u7ebf\u7a0bid: {}", (Object)Thread.currentThread().getId(), (Object)e);
                break;
            }
        }
    }

    private void queryHandlingTaskResult(Object[] ids, String entityName) {
        if (ObjectUtils.isEmpty((Object[])ids) || StringUtils.isEmpty((CharSequence)entityName)) {
            return;
        }
        Object[] logs = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
        if (ObjectUtils.isEmpty((Object[])logs)) {
            return;
        }
        if ("rim_select_log".equals(entityName)) {
            for (Object log : logs) {
                if (!"3".equals(log.getString("handle_status"))) continue;
                AsyncDeductHelper.handleAsyncLog((DynamicObject)log);
            }
        }
    }

    private void getTotalData(String entityName, QFilter filter) {
        DynamicObjectCollection countReuslt = QueryServiceHelper.query((String)entityName, (String)"total_num, success_num", (QFilter[])new QFilter[]{filter});
        int totalNum = 0;
        int successNum = 0;
        for (DynamicObject dynamicObject : countReuslt) {
            totalNum += dynamicObject.getInt("total_num");
            successNum += dynamicObject.getInt("success_num");
        }
        this.pageCache.put("totalNum", String.valueOf(totalNum));
        this.pageCache.put("successNum", String.valueOf(successNum));
        this.pageCache.put("failNum", String.valueOf(totalNum - successNum));
    }
}

