/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.inputdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.InputInvoiceTypeEnum;
import kd.imc.rim.common.invoice.input.InputInvoiceDataService;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.RimConfigUtils;

public class InputDataBoardJob
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(InputDataBoardJob.class);
    public static final String CREATE_TIME = "fcreatetime";
    public static final String INVOICE_DATE = "finvoice_date";
    public static final String AUTH_TIME = "fauthenticate_time";

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        block18: {
            logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
            try (DLock lock = DLock.create((String)"InputDataBoardJob", (String)"InputDataBoardJob.lock");){
                if (lock.tryLock(500L)) {
                    long start = System.currentTimeMillis();
                    try {
                        Date lastDay = DateUtils.getLastDay();
                        Date dayStart = DateUtils.getDayStart((Date)lastDay);
                        Date dayEnd = DateUtils.getDayEnd((Date)lastDay);
                        InputInvoiceDataService service = new InputInvoiceDataService();
                        service.init(dayStart, dayEnd);
                        List timeList = service.queryTaskParam();
                        for (JSONObject time : timeList) {
                            String timeStr = time.getString("dataDate");
                            String queryType = time.getString("queryType");
                            Date date = DateUtils.stringToDate((String)timeStr);
                            Date startDate = DateUtils.getDayStart((Date)date);
                            Date endDate = DateUtils.getDayEnd((Date)date);
                            if (INVOICE_DATE.equals(queryType)) {
                                this.saveLoadData(INVOICE_DATE, startDate, endDate);
                            }
                            if (AUTH_TIME.equals(queryType)) {
                                this.saveLoadData(AUTH_TIME, startDate, endDate);
                            }
                            if (!CREATE_TIME.equals(queryType)) continue;
                            this.saveLoadData(CREATE_TIME, startDate, endDate);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u8fdb\u9879\u6570\u636e\u770b\u677f\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
                    }
                    long end = System.currentTimeMillis();
                    logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
                    break block18;
                }
                logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u4e2d\u4e0d\u91cd\u590d\u6267\u884c");
            }
        }
    }

    public void run() {
        InputInvoiceDataService service = new InputInvoiceDataService();
        List timeList = service.queryTaskParam();
        for (JSONObject time : timeList) {
            String timeStr = time.getString("dataDate");
            String queryType = time.getString("queryType");
            Date date = DateUtils.stringToDate((String)timeStr);
            Date startDate = DateUtils.getDayStart((Date)date);
            Date endDate = DateUtils.getDayEnd((Date)date);
            if (INVOICE_DATE.equals(queryType)) {
                this.saveLoadData(INVOICE_DATE, startDate, endDate);
            }
            if (AUTH_TIME.equals(queryType)) {
                this.saveLoadData(AUTH_TIME, startDate, endDate);
            }
            if (!CREATE_TIME.equals(queryType)) continue;
            this.saveLoadData(CREATE_TIME, startDate, endDate);
        }
    }

    public void runAuthTime(Set<String> dateCollection) {
        if (CollectionUtils.isEmpty(dateCollection)) {
            return;
        }
        long start = System.currentTimeMillis();
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u8ba4\u8bc1\u65e5\u671f\u7edf\u8ba1\u5f00\u59cb{}", (Object)dateCollection.size());
        dateCollection.forEach(f -> {
            try {
                Date date = DateUtils.stringToDate((String)f, (String)"yyyy-MM-dd");
                Date startDate = DateUtils.getDayStart((Date)date);
                Date endDate = DateUtils.getDayEnd((Date)date);
                this.saveLoadData(AUTH_TIME, startDate, endDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u8ba4\u8bc1\u65e5\u671f\u7edf\u8ba1\u7ed3\u675f{}\u4e2a\u603b\u8017\u65f6{}", (Object)dateCollection.size(), (Object)(System.currentTimeMillis() - start));
    }

    public void runInvoiceDate(Set<String> dateCollection) {
        if (CollectionUtils.isEmpty(dateCollection)) {
            return;
        }
        long start = System.currentTimeMillis();
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u5f00\u7968\u65e5\u671f\u7edf\u8ba1\u5f00\u59cb{}", (Object)dateCollection.size());
        dateCollection.forEach(f -> {
            try {
                Date date = DateUtils.stringToDate((String)f, (String)"yyyy-MM-dd");
                Date startDate = DateUtils.getDayStart((Date)date);
                Date endDate = DateUtils.getDayEnd((Date)date);
                this.saveLoadData(INVOICE_DATE, startDate, endDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u5f00\u7968\u65e5\u671f\u7edf\u8ba1\u7ed3\u675f{}\u4e2a\u603b\u8017\u65f6{}", (Object)dateCollection.size(), (Object)(System.currentTimeMillis() - start));
    }

    public void saveLoadData(String timeFilterStr, Date dayStart, Date dayEnd) {
        Date maxDate;
        long start = System.currentTimeMillis();
        String showUncheckConfig = RimConfigUtils.getConfig((String)"show_uncheck");
        if (dayStart == null || dayEnd == null) {
            Date lastDay = DateUtils.getLastDay();
            dayStart = DateUtils.getDayStart((Date)lastDay);
            dayEnd = DateUtils.getDayEnd((Date)lastDay);
        }
        if (dayEnd.compareTo(maxDate = DateUtils.addDay((Date)new Date(), (int)2)) > 0) {
            logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u7edf\u8ba1{}\u5f00\u59cb,\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}\u65f6\u95f4\u8303\u56f4\u9519\u8bef\uff0c\u76f4\u63a5\u7ed3\u675f\u4e0d\u5904\u7406", new Object[]{timeFilterStr, dayStart, dayEnd});
            InputInvoiceDataService dataSerice = new InputInvoiceDataService();
            dataSerice.deleteTaskParam(timeFilterStr, dayStart, dayEnd, Long.valueOf(0L));
            return;
        }
        QFilter filter = new QFilter("deal_time", "=", (Object)dayStart).and("query_type", "=", (Object)timeFilterStr);
        DeleteServiceHelper.delete((String)"rim_idb_detail", (QFilter[])filter.toArray());
        String startStr = DateUtils.format((Date)dayStart);
        String endStr = DateUtils.format((Date)dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u7edf\u8ba1{}\u5f00\u59cb,\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", new Object[]{timeFilterStr, startStr, endStr});
        this.countInvoiceByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u7d2f\u8ba1\u53d1\u7968\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countAttachSumByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u7d2f\u8ba1\u9644\u4ef6\u6570\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countTaxAmountByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u7d2f\u8ba1\u5df2\u62b5\u6263\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countInvoiceTypeByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u79cd\u7c7b\u5206\u5e03\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countExpenseStatusByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u4f7f\u7528\u72b6\u6001\u5206\u5e03\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countInputTaxAmountByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u7a0e\u989d\u5206\u5e03\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countTaxRateByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u53d1\u7968\u7a0e\u7387\u5206\u5e03\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countCollectTypeByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f-\u91c7\u96c6\u65b9\u5f0f\u5206\u5e03\u8ba1\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", (Object)startStr, (Object)endStr);
        this.countDeductTaxAmountByOrg(timeFilterStr, showUncheckConfig, dayStart, dayEnd);
        logger.info("\u8fdb\u9879\u6570\u636e\u770b\u677f\u7edf\u8ba1{}\u7ed3\u675f({}ms),\u5f00\u59cb\u65e5\u671f{}\u7ed3\u675f\u65e5\u671f{}", new Object[]{timeFilterStr, System.currentTimeMillis() - start, startStr, endStr});
        InputInvoiceDataService dataSerice = new InputInvoiceDataService();
        dataSerice.deleteTaskParam(timeFilterStr, dayStart, dayEnd, Long.valueOf(0L));
    }

    private void countTaxRateByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        JSONArray ordinaryArray = this.queryItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_ordinary", Arrays.asList(InputInvoiceTypeEnum.ORDINARY_ELECTRON.getCode(), InputInvoiceTypeEnum.ORDINARY_PAPER.getCode()));
        JSONArray specialArray = this.queryItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_special", Arrays.asList(InputInvoiceTypeEnum.SPECIAL_PAPER.getCode(), InputInvoiceTypeEnum.SPECIAL_ELECTRON.getCode()));
        JSONArray electricArray = this.queryItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_electric", Arrays.asList(InputInvoiceTypeEnum.ELECTRIC_ORDINARY.getCode(), InputInvoiceTypeEnum.ELECTRIC_SPECIAL.getCode()));
        JSONArray tollArray = this.queryItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_toll", Collections.singletonList(InputInvoiceTypeEnum.TOLL_ELECTRON.getCode()));
        JSONArray airArray = this.queryNoItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_air", Collections.singletonList(InputInvoiceTypeEnum.AIR_INVOICE.getCode()));
        JSONArray motorArray = this.queryNoItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_motor", Collections.singletonList(InputInvoiceTypeEnum.MOTOR_INVOICE.getCode()));
        JSONArray transportArray = this.queryNoItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_transport", Arrays.asList(InputInvoiceTypeEnum.TRANSPORT_INVOICE.getCode(), InputInvoiceTypeEnum.BOAT_INVOICE.getCode()));
        JSONArray trainArray = this.queryNoItemRate(timeFilterStr, showUncheckConfig, dayStart, dayEnd, "t_rim_inv_train", Collections.singletonList(InputInvoiceTypeEnum.TRAIN_INVOICE.getCode()));
        JSONArray allArray = new JSONArray();
        allArray.addAll((Collection)ordinaryArray);
        allArray.addAll((Collection)specialArray);
        allArray.addAll((Collection)electricArray);
        allArray.addAll((Collection)tollArray);
        allArray.addAll((Collection)airArray);
        allArray.addAll((Collection)motorArray);
        allArray.addAll((Collection)transportArray);
        allArray.addAll((Collection)trainArray);
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>();
        for (int i = 0; i < allArray.size(); ++i) {
            JSONObject object = allArray.getJSONObject(i);
            if (object.isEmpty()) continue;
            Long org_id = object.getLong("FORG_ID");
            if (result.containsKey(org_id)) {
                Map stringIntegerMap = (Map)result.get(org_id);
                if (stringIntegerMap.containsKey(object.getString("TAX_RATE"))) {
                    int count_num = (Integer)stringIntegerMap.get(object.getString("TAX_RATE"));
                    stringIntegerMap.put(object.getString("TAX_RATE"), count_num += object.getInteger("COUNT_NUM").intValue());
                    continue;
                }
                stringIntegerMap.put(object.getString("TAX_RATE"), object.getInteger("COUNT_NUM"));
                continue;
            }
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(object.getString("TAX_RATE"), object.getInteger("COUNT_NUM"));
            result.put(org_id, map);
        }
        this.saveTaxRateResult(dayStart, result, timeFilterStr);
    }

    private void saveTaxRateResult(Date dayStart, Map<Long, Map<String, Object>> result, String timeFilterStr) {
        if (result.isEmpty()) {
            return;
        }
        for (Map.Entry<Long, Map<String, Object>> entry : result.entrySet()) {
            Long org_id = entry.getKey();
            Map<String, Object> rateCountMap = entry.getValue();
            Set<String> keySet = rateCountMap.keySet();
            DynamicObject[] saveObjects = new DynamicObject[keySet.size()];
            int index = 0;
            for (Map.Entry<String, Object> subEntry : rateCountMap.entrySet()) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_idb_detail");
                dynamicObject.set("org", (Object)org_id);
                dynamicObject.set("deal_time", (Object)dayStart);
                dynamicObject.set("query_type", (Object)timeFilterStr);
                dynamicObject.set("parent_category", (Object)"input_tax_rate");
                dynamicObject.set("sub_category", (Object)new BigDecimal(subEntry.getKey()).setScale(3, 4));
                dynamicObject.set("category_sum", subEntry.getValue());
                saveObjects[index++] = dynamicObject;
            }
            SaveServiceHelper.save((DynamicObject[])saveObjects);
        }
    }

    private JSONArray queryNoItemRate(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd, String tableName, List<Long> invoiceTypes) {
        StringBuilder authSql = new StringBuilder();
        authSql.append(" select t1.forg_id , round(t2.ftax_rate,3) as tax_rate , count(t2.fid) as count_num from t_rim_invoice t1, ");
        authSql.append(tableName).append(" t2 ");
        authSql.append(" where t1.fdelete = '1' and t1.fserial_no = t2.fserial_no ");
        authSql.append(" and t1.").append(timeFilterStr).append("< ? ");
        authSql.append(" and t1.").append(timeFilterStr).append(">= ? ");
        authSql.append(" and t1.finvoice_type in ( ");
        for (Long type : invoiceTypes) {
            authSql.append(type).append(",");
        }
        StringBuilder authSqlCopy = new StringBuilder(authSql.substring(0, authSql.toString().length() - 1));
        authSqlCopy.append(" ) ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSqlCopy.append("and t1.fcheck_status = '1' ");
        }
        authSqlCopy.append("group by t1.forg_id , round(t2.ftax_rate,3) order by t1.forg_id , round(t2.ftax_rate,3)");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        return DBUtils.queryJSONArray((String)authSqlCopy.toString(), (Object[])authParam);
    }

    private JSONArray queryItemRate(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd, String tableName, List<Long> invoiceTypes) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select t1.forg_id, round(t3.ftax_rate,3) as tax_rate , count(t3.fid) as count_num from t_rim_invoice t1, ");
        authSql.append(tableName).append(" t2, ");
        authSql.append(tableName).append("_item ").append(" t3 ");
        authSql.append(" where t1.fdelete = '1' and t1.fserial_no = t2.fserial_no and t2.fid = t3.fid ");
        authSql.append(" and t1.finvoice_type in ( ");
        for (Long type : invoiceTypes) {
            authSql.append(type).append(",");
        }
        StringBuilder authSqlCopy = new StringBuilder(authSql.substring(0, authSql.toString().length() - 1));
        authSqlCopy.append(" ) ");
        authSqlCopy.append(" and t1.").append(timeFilterStr).append("< ? ");
        authSqlCopy.append(" and t1.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSqlCopy.append(" and t1.fcheck_status = '1' ");
        }
        authSqlCopy.append(" group by t1.forg_id, round(t3.ftax_rate,3) order by t1.forg_id, round(t3.ftax_rate,3)");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        return DBUtils.queryJSONArray((String)authSqlCopy.toString(), (Object[])authParam);
    }

    private void countDeductTaxAmountByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select forg_id ,finvoice_type ,sum(ftotal_tax_amount) - sum(case when (ftransport_deduction = '1' or (fauthenticate_flag in ('2', '3') and fdeduction_purpose = '1')) then feffective_tax_amount  else 0 end ) as undeduct_amount , sum(case when (ftransport_deduction = '1' or (fauthenticate_flag in ('2', '3') and fdeduction_purpose = '1')) then feffective_tax_amount  else 0 end ) as deducted_amount from t_rim_invoice ");
        authSql.append("where fdelete = '1' and fdeduction_flag = '1' and finvoice_type in (961640926684439552, 961641064953820160,961642651029877760,961642939052733440,961634333825754112,961639304377984000,961642468384760832,961641829533496320,961643098478273536,1376129725579325440,961640097369875456) ");
        authSql.append("and ").append(timeFilterStr).append("< ? ");
        authSql.append("and ").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and fcheck_status = '1' ");
        }
        authSql.append("group by forg_id ,finvoice_type order by forg_id ,finvoice_type");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount_deduct", "FINVOICE_TYPE", null, "DEDUCTED_AMOUNT");
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount_undeduct", "FINVOICE_TYPE", null, "UNDEDUCT_AMOUNT");
        }
    }

    private void countCollectTypeByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select t1.forg_id, t1.fcollect_type, count(t1.fserial_no) as collect_type_count from t_rim_invoice t1 where t1.fdelete = '1' and t1.fcollect_type != ' '");
        authSql.append("and t1.").append(timeFilterStr).append("< ? ");
        authSql.append("and t1.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and t1.fcheck_status = '1' ");
        }
        authSql.append("group by t1.forg_id, t1.fcollect_type order by t1.forg_id, t1.fcollect_type");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_collect_type", "FCOLLECT_TYPE", "COLLECT_TYPE_COUNT", null);
        }
    }

    private void countInputTaxAmountByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select t1.forg_id, sum(case when t1.finvoice_type in (961639304377984000, 961640097369875456,1376129725579325440) and t1.fdeduction_purpose = '1' and t1.fauthenticate_flag  in ('2', '3') then t1.feffective_tax_amount else 0 end) as vat_tax_amount, sum(case when t1.finvoice_type in (961634333825754112, 961640926684439552, 961641064953820160, 961642651029877760, 961642939052733440) and t1.ftransport_deduction = '1' then t1.feffective_tax_amount else 0 end) as trans_tax_amount, sum(case when t1.finvoice_type = 961642468384760832 and t1.fdeduction_purpose = '1' and t1.fauthenticate_flag in ('2','3') then t1.feffective_tax_amount else 0 end) as toll_tax_amount, sum(case when t1.finvoice_type = 961641829533496320 and t1.fdeduction_purpose = '1' and t1.fauthenticate_flag in ('2','3') then t1.feffective_tax_amount else 0 end) as motor_tax_amount, sum(case when t1.finvoice_type = 961643098478273536 and t1.fdeduction_purpose = '1' and t1.fauthenticate_flag in ('2','3') then t1.feffective_tax_amount else 0 end) as hgjks_tax_amount from t_rim_invoice t1 where t1.fdeduction_flag  = '1' and t1.fdelete = '1' and finvoice_type in (961640926684439552, 961641064953820160, 961642651029877760, 961642939052733440, 961634333825754112, 961639304377984000, 961642468384760832, 961641829533496320, 961643098478273536, 1376129725579325440, 961640097369875456)");
        authSql.append("and t1.").append(timeFilterStr).append("< ? ");
        authSql.append("and t1.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and t1.fcheck_status = '1' ");
        }
        authSql.append("group by t1.forg_id order by t1.forg_id");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount", "vat_tax_amount", null, "VAT_TAX_AMOUNT");
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount", "trans_tax_amount", null, "TRANS_TAX_AMOUNT");
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount", "toll_tax_amount", null, "TOLL_TAX_AMOUNT");
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount", "motor_tax_amount", null, "MOTOR_TAX_AMOUNT");
            this.saveDataCount(dayStart, authArray, timeFilterStr, "input_tax_amount", "hgjks_tax_amount", null, "HGJKS_TAX_AMOUNT");
        }
    }

    private void countExpenseStatusByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select tri.forg_id, tri.fexpense_status, count(tri.fserial_no) as status_count from t_rim_invoice tri where tri.fdelete = '1'");
        authSql.append("and tri.").append(timeFilterStr).append("< ? ");
        authSql.append("and tri.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and tri.fcheck_status = '1' ");
        }
        authSql.append("group by tri.forg_id, tri.fexpense_status order by tri.forg_id, tri.fexpense_status");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "expense_status_count", "FEXPENSE_STATUS", "STATUS_COUNT", null);
        }
    }

    private void countInvoiceTypeByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select tri.forg_id, tri.finvoice_type, count(tri.fserial_no) as type_count from t_rim_invoice tri where tri.fdelete = '1'");
        authSql.append("and tri.").append(timeFilterStr).append("< ? ");
        authSql.append("and tri.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and tri.fcheck_status = '1' ");
        }
        authSql.append("group by tri.forg_id, tri.finvoice_type order by tri.forg_id, tri.finvoice_type");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "invoice_type_count", "FINVOICE_TYPE", "TYPE_COUNT", null);
        }
    }

    private void countTaxAmountByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select t1.forg_id, sum(case when t1.finvoice_type in (961634333825754112, 961640926684439552, 961641064953820160, 961642651029877760, 961642939052733440) and t1.ftransport_deduction = '1' then t1.feffective_tax_amount else 0 end) +sum(case when t1.finvoice_type in (961640097369875456, 961639304377984000, 961642468384760832, 961641829533496320, 961643098478273536, 1376129725579325440, 961634333825754112) and t1.fdeduction_purpose = '1' and t1.fauthenticate_flag  in ('2', '3') then t1.feffective_tax_amount else 0 end) as tax_amount_sum from t_rim_invoice t1 where t1.fdelete = '1' and t1.fdeduction_flag  = '1' and finvoice_type in (961640926684439552, 961641064953820160, 961642651029877760, 961642939052733440, 961634333825754112, 961639304377984000, 961642468384760832, 961641829533496320, 961643098478273536, 1376129725579325440, 961640097369875456)");
        authSql.append("and t1.").append(timeFilterStr).append("< ? ");
        authSql.append("and t1.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and t1.fcheck_status = '1' ");
        }
        authSql.append("group by t1.forg_id order by t1.forg_id");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "invoice_base_data", "total_tax_amount_sum", null, "TAX_AMOUNT_SUM");
        }
    }

    private void countAttachSumByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql2 = new StringBuilder("select t2.forg_id as org_id,count(distinct t1.fattach_id) as attach_num from t_rim_attach_relation t1 , t_rim_invoice t2 where t2.fdelete = '1' and t1.frelation_id  = t2.fserial_no and t1.frelation_type = '3' ");
        authSql2.append("and t2.").append(timeFilterStr).append("< ? ");
        authSql2.append("and t2.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql2.append("and t2.fcheck_status = '1' ");
        }
        authSql2.append("group by t2.forg_id order by t2.forg_id");
        Object[] authParam2 = new Object[]{dayEnd, dayStart};
        JSONArray authArray2 = DBUtils.queryJSONArray((String)authSql2.toString(), (Object[])authParam2);
        JSONObject result = new JSONObject();
        for (int i = 0; i < authArray2.size(); ++i) {
            JSONObject object = authArray2.getJSONObject(i);
            String org_id = object.getString("ORG_ID");
            int attach_num = object.getInteger("ATTACH_NUM");
            if (result.containsKey((Object)org_id)) {
                int temp = result.getInteger(org_id);
                attach_num += temp;
            }
            result.put(org_id, (Object)attach_num);
        }
        if (!result.isEmpty()) {
            Iterator iterator = result.keySet().iterator();
            DynamicObject[] saveObjects = new DynamicObject[result.keySet().size()];
            int index = 0;
            while (iterator.hasNext()) {
                String org_id = (String)iterator.next();
                int attach_num = result.getInteger(org_id);
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_idb_detail");
                dynamicObject.set("org", (Object)org_id);
                dynamicObject.set("deal_time", (Object)dayStart);
                dynamicObject.set("query_type", (Object)timeFilterStr);
                dynamicObject.set("parent_category", (Object)"invoice_base_data");
                dynamicObject.set("sub_category", (Object)"attach_sum");
                dynamicObject.set("category_sum", (Object)attach_num);
                saveObjects[index++] = dynamicObject;
            }
            SaveServiceHelper.save((DynamicObject[])saveObjects);
        }
    }

    private void countInvoiceByOrg(String timeFilterStr, String showUncheckConfig, Date dayStart, Date dayEnd) {
        StringBuilder authSql = new StringBuilder();
        authSql.append("select tri.forg_id, count(tri.fserial_no) as invoice_num, sum(case when tri.finvoice_type in (961634333825754112, 961639304377984000, 961639799666521088, 961640097369875456, 961640365939504128, 961642468384760832, 961641829533496320, 961641980209718272, 1376129725579325440, 1376129501813207040) then 1 else 0 end) as vat_count, sum(case when tri.finvoice_type not in (961634333825754112, 961639304377984000, 961639799666521088, 961640097369875456,961640365939504128, 961642468384760832, 961641829533496320, 961641980209718272, 1376129725579325440, 1376129501813207040) then 1 else 0 end) as un_vat_count, sum(tri.ftotal_amount) as amount_sum from t_rim_invoice tri where tri.fdelete = '1' ");
        authSql.append("and tri.").append(timeFilterStr).append("< ? ");
        authSql.append("and tri.").append(timeFilterStr).append(">= ? ");
        if (StringUtils.isBlank((CharSequence)showUncheckConfig) || "0".equals(showUncheckConfig)) {
            authSql.append("and tri.fcheck_status = '1' ");
        }
        authSql.append("group by tri.forg_id order by tri.forg_id");
        Object[] authParam = new Object[]{dayEnd, dayStart};
        JSONArray authArray = DBUtils.queryJSONArray((String)authSql.toString(), (Object[])authParam);
        if (authArray.size() > 0) {
            this.saveDataCount(dayStart, authArray, timeFilterStr, "invoice_base_data", "invoice_sum", "INVOICE_NUM", null);
            this.saveDataCount(dayStart, authArray, timeFilterStr, "invoice_base_data", "vat_sum", "VAT_COUNT", null);
            this.saveDataCount(dayStart, authArray, timeFilterStr, "invoice_base_data", "un_vat_sum", "UN_VAT_COUNT", null);
            this.saveDataCount(dayStart, authArray, timeFilterStr, "invoice_base_data", "total_amount_sum", null, "AMOUNT_SUM");
        }
    }

    private void saveDataCount(Date dayStart, JSONArray authArray, String timeFilterStr, String parentKey, String subKey, String valueKey1, String valueKey2) {
        DynamicObject[] saveObjects = new DynamicObject[authArray.size()];
        for (int i = 0; i < authArray.size(); ++i) {
            JSONObject result = authArray.getJSONObject(i);
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"rim_idb_detail");
            dynamicObject.set("org", (Object)result.getLong("FORG_ID"));
            dynamicObject.set("deal_time", (Object)dayStart);
            dynamicObject.set("query_type", (Object)timeFilterStr);
            dynamicObject.set("parent_category", (Object)parentKey);
            if (result.get((Object)subKey) == null) {
                dynamicObject.set("sub_category", (Object)subKey);
            } else {
                dynamicObject.set("sub_category", result.get((Object)subKey));
            }
            if (valueKey1 != null) {
                dynamicObject.set("category_sum", (Object)result.getInteger(valueKey1));
            }
            if (valueKey2 != null) {
                dynamicObject.set("category_amount", (Object)result.getBigDecimal(valueKey2));
            }
            saveObjects[i] = dynamicObject;
        }
        SaveServiceHelper.save((DynamicObject[])saveObjects);
    }
}

