/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.inputdata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.MetadataUtil;
import kd.imc.rim.formplugin.query.operate.UpdateVouchService;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateVouchTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpdateVouchTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            Date currentDateMonth = DateUtils.getLastDayOfMonth();
            Date prevMonthFirstDate = DateUtils.getPrevMonthFirstDate();
            QFilter accountDateStart = new QFilter("account_date", ">=", (Object)prevMonthFirstDate);
            QFilter accountDateEnd = new QFilter("account_date", "<=", (Object)currentDateMonth);
            LOGGER.info("\u66f4\u65b0\u5168\u7968\u6c60\u51ed\u8bc1\u4fe1\u606f\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb,\u76ee\u6807\u6570\u636e\u7684\u4f1a\u8ba1\u5c5e\u671f\uff1a{} \u81f3 {} ", (Object)prevMonthFirstDate, (Object)currentDateMonth);
            DynamicObjectCollection targetCollect = QueryServiceHelper.query((String)"rim_invoice", (String)"expense_num, invoice_no, serial_no, vouch_no", (QFilter[])new QFilter[]{accountDateStart, accountDateEnd});
            if (CollectionUtils.isEmpty((Collection)targetCollect)) {
                LOGGER.info("\u672a\u627e\u5230\u76ee\u6807\u6570\u636e\uff0c\u8c03\u5ea6\u7ed3\u675f..");
                return;
            }
            Set vouchBill = null;
            try {
                vouchBill = (Set)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"DapQueryDataService", (String)"getCanBuildVoucherBillNames", (Object[])new Object[0]);
            }
            catch (Exception e) {
                LOGGER.info("DapQueryDataService getCanBuildVoucherBillNames error:", (Object)e);
            }
            LOGGER.info("\u67e5\u8be2\u5141\u8bb8\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u7c7b\u578b\u96c6\u5408\u4e3a:{}", (Object)vouchBill);
            if (vouchBill == null) {
                return;
            }
            HashMap targetMaps = Maps.newHashMap();
            HashMap<String, String> invoiceBillsMap = new HashMap<String, String>(8);
            for (DynamicObject mainInvoice : targetCollect) {
                String expenseNo = mainInvoice.getString("expense_num");
                String vouchNo = mainInvoice.getString("vouch_no");
                if (StringUtils.isEmpty((CharSequence)expenseNo) || StringUtils.isEmpty((CharSequence)vouchNo)) continue;
                targetMaps.put(mainInvoice.getString("serial_no"), expenseNo);
                invoiceBillsMap.put(mainInvoice.getString("invoice_no"), expenseNo);
            }
            Pair<JSONArray, Boolean> validateResult = this.validateBill(targetMaps, vouchBill);
            if (validateResult.getLeft() == null || ((JSONArray)validateResult.getLeft()).isEmpty()) {
                LOGGER.info("\u672c\u6b21\u76ee\u6807\u6570\u636e\u4e2d\u4e0d\u5b58\u5728\u5185\u90e8\u51ed\u8bc1\u5355\u636e\u96c6\u5408\u4e3a:{}", (Object)vouchBill);
                return;
            }
            UpdateVouchService service = new UpdateVouchService(null, null);
            service.updateVouch((JSONArray)validateResult.getLeft(), invoiceBillsMap, false);
        }
        catch (Exception e) {
            LOGGER.info("\u66f4\u65b0\u51ed\u8bc1\u51fa\u9519\uff1a", (Object)e);
        }
        LOGGER.info("\u66f4\u65b0\u51ed\u8bc1\u7ed3\u675f...");
    }

    private Pair<JSONArray, Boolean> validateBill(Map<String, String> targetMaps, Set<String> vouchBill) {
        if (targetMaps.isEmpty()) {
            return Pair.of(null, (Object)false);
        }
        JSONArray result = new JSONArray();
        for (Map.Entry<String, String> entry : targetMaps.entrySet()) {
            QFilter filter;
            String expenseNo = entry.getValue();
            if (expenseNo.contains(",")) {
                String[] expenseNos = expenseNo.split(",");
                filter = new QFilter("expense_num", "in", Arrays.asList(expenseNos));
            } else {
                filter = new QFilter("expense_num", "=", (Object)expenseNo);
            }
            QFilter serialFilter = new QFilter("serial_no", "=", (Object)entry.getKey());
            DynamicObjectCollection query = QueryServiceHelper.query((String)"rim_expense_relation", (String)MetadataUtil.getFields((String)"rim_expense_relation"), (QFilter[])new QFilter[]{filter, serialFilter});
            for (DynamicObject obj : query) {
                JSONObject billInfo = new JSONObject();
                String entityId = obj.getString("entityid");
                if (!vouchBill.contains(entityId)) continue;
                billInfo.put(obj.getString("entityid"), (Object)obj.getString("expense_id"));
                result.add((Object)billInfo);
            }
        }
        return Pair.of((Object)result, (Object)true);
    }
}

