/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicecheck;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.check.UnCheckListCheckTask;

public class InvoiceCheckJob
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InvoiceCheckJob.class);
    private final List<String> STATUS_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("3");
            this.add("2");
        }
    };

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u53d1\u7968\u67e5\u9a8c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        try {
            this.uncheckedInvoiceCheck();
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u7968\u67e5\u9a8c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u53d1\u7968\u67e5\u9a8c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void uncheckedInvoiceCheck() throws ExecutionException, InterruptedException {
        QFilter uncheckedFilter = new QFilter("check_status", "in", this.STATUS_LIST);
        QFilter deleteFilter = new QFilter("delete", "!=", (Object)"3");
        QFilter timesFilter = new QFilter("check_times", "<", (Object)4);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_invoice_uncheck", (String)"id", (QFilter[])new QFilter[]{uncheckedFilter, deleteFilter, timesFilter});
        int total = collection.size();
        int success = 0;
        for (DynamicObject obj : collection) {
            Object id = obj.get("id");
            try {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"rim_invoice_uncheck");
                LOGGER.info("\u53d1\u7968\u67e5\u9a8c\uff1a\u53d1\u7968\u53f7\u7801[{}-{}]", (Object)dynamicObject.getString("invoice_code"), (Object)dynamicObject.getString("invoice_no"));
                try {
                    UnCheckListCheckTask task = new UnCheckListCheckTask(RequestContext.get(), dynamicObject);
                    JSONObject result = task.call();
                    if (ResultContant.isSuccess((JSONObject)result).booleanValue()) {
                        ++success;
                    }
                    this.afterCheck(dynamicObject, result);
                }
                catch (Exception e) {
                    LOGGER.error("\u53d1\u7968\u67e5\u9a8c\u5b9a\u65f6error" + dynamicObject.getString("invoice_code") + "-" + dynamicObject.getString("invoice_no"), (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.info("\u67e5\u9a8c\u5931\u8d25id{}", id);
            }
        }
        LOGGER.info("\u53d1\u7968\u67e5\u9a8c\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5171{}\u6761\uff0c\u67e5\u9a8c\u6210\u529f{}\u6761...", (Object)total, (Object)success);
    }

    protected void afterCheck(DynamicObject dynamicObject, JSONObject result) {
    }
}

