/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicecheck.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.constant.ResultContant;
import kd.imc.rim.common.invoice.checknew.model.CheckParam;
import kd.imc.rim.common.invoice.checknew.model.CheckResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveResult;
import kd.imc.rim.common.invoice.save.InvoiceSaveService;
import kd.imc.rim.common.service.SimplyCheckService;
import kd.imc.rim.common.utils.DynamicObjectUtil;
import kd.imc.rim.common.utils.TenantUtils;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCheckTask
implements Callable<JSONObject> {
    private RequestContext ctx;
    private DynamicObject unCheckObject;

    public InvoiceCheckTask(RequestContext ctx, DynamicObject unCheckObject) {
        this.ctx = ctx;
        this.unCheckObject = unCheckObject;
    }

    @Override
    public JSONObject call() throws Exception {
        String taxNo;
        if (null == this.unCheckObject) {
            return ResultContant.createJSONObject((String)"0001", (String)ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u7a7a", (String)"InvoiceCheckTask_5", (String)"imc-rim-formplugin", (Object[])new Object[0]));
        }
        RequestContext.copyAndSet((RequestContext)this.ctx);
        String invoiceCode = this.unCheckObject.getString("invoice_code");
        String invoiceNo = this.unCheckObject.getString("invoice_no");
        Date invoiceDate = this.unCheckObject.getDate("invoice_date");
        BigDecimal invoiceAmount = this.unCheckObject.getBigDecimal("invoice_amount");
        String checkCode = this.unCheckObject.getString("check_code");
        Long invoiceType = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.unCheckObject.get("invoice_type"));
        CheckParam checkParam = new CheckParam(invoiceCode, invoiceNo, invoiceType, invoiceDate, invoiceAmount, checkCode, null);
        Long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)this.unCheckObject.get("org"));
        if (orgId == 0L) {
            orgId = this.ctx.getOrgId();
        }
        if (StringUtils.isEmpty((CharSequence)(taxNo = this.unCheckObject.getString("buyer_tax_no")))) {
            taxNo = TenantUtils.getTaxNoByOrgId((Long)orgId);
        }
        HashMap extMap = Maps.newHashMap();
        extMap.put("orgId", orgId);
        extMap.put("taxNo", taxNo);
        extMap.put("eid", RequestContext.get().getUserId());
        checkParam.setExtMap((Map)extMap);
        CheckResult checkResult = SimplyCheckService.checkInvoice((CheckParam)checkParam, (Long)orgId, (String)taxNo);
        String errorCode = checkResult.getErrcode();
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            if ("0000".equals(errorCode)) {
                Object invoiceEntity = checkResult.getData();
                String invoiceCheckStr = JSONObject.toJSONString((Object)invoiceEntity);
                JSONObject invoiceJson = JSON.parseObject((String)invoiceCheckStr);
                InvoiceSaveService invoiceSaveService = InvoiceSaveService.newInstance((String)invoiceJson.getString("invoiceType"));
                InvoiceSaveResult result = invoiceSaveService.save(invoiceJson);
                this.unCheckObject.set("check_status", (Object)"1");
                String fserial_no = this.unCheckObject.getString("serial_no");
                Boolean isExist = this.checkExist(fserial_no);
                if (!isExist.booleanValue()) {
                    this.unCheckObject.set("delete", (Object)"3");
                } else {
                    this.unCheckObject.set("serial_no", (Object)result.getSerialNo());
                }
            } else {
                this.unCheckObject.set("check_status", (Object)"2");
            }
            int check_times = this.unCheckObject.getInt("check_times");
            this.unCheckObject.set("check_times", (Object)(++check_times));
            this.unCheckObject.set("check_time", (Object)new Date());
            this.unCheckObject.set("check_result", (Object)errorCode);
            this.unCheckObject.set("update_time", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.unCheckObject});
            JSONObject jSONObject = ResultContant.createJSONObject((String)errorCode, (String)checkResult.getDescription());
            return jSONObject;
        }
        catch (Throwable e) {
            h.markRollback();
            JSONObject jSONObject = ResultContant.createJSONObject((String)"0002", (String)String.format(ResManager.loadKDString((String)"\u67e5\u9a8c\u5931\u8d25\uff1a%1$s", (String)"InvoiceCheckTask_4", (String)"imc-rim-formplugin", (Object[])new Object[0]), e.getMessage()));
            return jSONObject;
        }
    }

    private Boolean checkExist(String fserial_no) {
        if (kd.bos.util.StringUtils.isEmpty((String)fserial_no)) {
            return Boolean.FALSE;
        }
        QFilter filter = new QFilter("serial_no", "=", (Object)fserial_no);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"rim_expense_relation", (String)"id", (QFilter[])new QFilter[]{filter});
        return !CollectionUtils.isEmpty((Collection)collection);
    }
}

