/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.service;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.CacheHelper;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.schedule.invoicedownload.task.TableHeadApplyTask;

public class InvoiceDownTaskHelper {
    private static final Log LOGGER = LogFactory.getLog(TableHeadApplyTask.class);
    private static final Integer MAX_INPUT_DOWN_DEAL_DATE = 60;
    private static final String CONFIG_INPUT_DOWN_KEY = "inoutput_down_dates";

    public static DynamicObject[] getDownDynamicObject(String entity, List<Long> idList, int pageSize, String cacheKey) {
        DynamicObject[] downInitDynamicObjects = new DynamicObject[]{};
        if (!CollectionUtils.isEmpty(idList)) {
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (idList.size() <= pageSize) {
                downInitDynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)mainEntityType);
                CacheHelper.remove((String)cacheKey);
            } else {
                List<Long> downIdList = idList.subList(0, pageSize);
                downInitDynamicObjects = BusinessDataServiceHelper.load((Object[])downIdList.toArray(), (DynamicObjectType)mainEntityType);
                idList.removeAll(downIdList);
                int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)24, (String)(cacheKey + "_hours"));
                CacheHelper.put((String)cacheKey, (String)SerializationUtils.toJsonString(idList), (int)(3600 * maxHours));
            }
        }
        return downInitDynamicObjects;
    }

    public static List<Long> getDownIds(String cacheKey) {
        String cache = CacheHelper.get((String)cacheKey);
        List idList = Collections.emptyList();
        if (!StringUtils.isEmpty((CharSequence)cache)) {
            idList = SerializationUtils.fromJsonStringToList((String)cache, Long.class);
        }
        LOGGER.info("{}\u5269\u4f59\u4e0b\u8f7d\u6570\u91cf:{}", (Object)cacheKey, (Object)idList.size());
        return idList;
    }

    public static void putCacheHeadDownload(boolean isAll) {
        try (DLock lock = DLock.create((String)"InputDownCacheBatchNoTask", (String)"InputDownCacheBatchNoTask.lock");){
            if (lock.tryLock()) {
                int maxDownDates;
                Date maxDate;
                QFilter dateFilter;
                QFilter govStatusFilter;
                DynamicObjectCollection collection;
                String cacheCert = CacheHelper.get((String)"invoice_full_down_cache");
                String cacheRpa = CacheHelper.get((String)"invoice_full_down_rpa_cache");
                if ((StringUtils.isEmpty((CharSequence)cacheCert) || StringUtils.isEmpty((CharSequence)cacheRpa)) && !CollectionUtils.isEmpty((Collection)(collection = QueryServiceHelper.query((String)"rim_down_log", (String)"id,tax_no,inout", (QFilter[])new QFilter[]{govStatusFilter = new QFilter("gov_status", "in", (Object)InvoiceDownloadConstant.ALLOW_DOWN_STATUS), dateFilter = new QFilter("createtime", ">=", (Object)(maxDate = DateUtils.getDayStart((Date)DateUtils.addDay((Date)new Date(), (int)(0 - (maxDownDates = InvoiceDownloadConstant.getPageSizeFromConfig((int)MAX_INPUT_DOWN_DEAL_DATE, (String)CONFIG_INPUT_DOWN_KEY)))))))})))) {
                    HashSet certIdList = Sets.newHashSet();
                    HashSet rpaIdList = Sets.newHashSet();
                    for (DynamicObject dynamicObject : collection) {
                        String taxNo = dynamicObject.getString("tax_no");
                        String inout = dynamicObject.getString("inout");
                        String dkType = DeductionConstant.getDkType((String)taxNo);
                        if (!"4".equals(dkType = InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType))) {
                            certIdList.add(dynamicObject.getLong("id"));
                            continue;
                        }
                        if ("1".equals(inout) || "2".equals(inout)) {
                            if (!InvoiceDownloadConstant.isSyncDown((String)taxNo)) {
                                certIdList.add(dynamicObject.getLong("id"));
                                continue;
                            }
                            rpaIdList.add(dynamicObject.getLong("id"));
                            continue;
                        }
                        certIdList.add(dynamicObject.getLong("id"));
                    }
                    if (StringUtils.isEmpty((CharSequence)cacheCert) && !CollectionUtils.isEmpty((Collection)certIdList)) {
                        int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)36, (String)"invoice_full_down_cache_hours");
                        CacheHelper.put((String)"invoice_full_down_cache", (String)SerializationUtils.toJsonString((Object)certIdList), (int)(maxHours * 60 * 60));
                    }
                    if (StringUtils.isEmpty((CharSequence)cacheRpa) && !CollectionUtils.isEmpty((Collection)rpaIdList) && isAll) {
                        int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)36, (String)"invoice_full_down_rpa_cache_hours");
                        CacheHelper.put((String)"invoice_full_down_rpa_cache", (String)SerializationUtils.toJsonString((Object)rpaIdList), (int)(maxHours * 60 * 60));
                    }
                }
            } else {
                LOGGER.info("InputDownCacheBatchNoTask-Lock");
            }
        }
    }
}

