/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InvoiceDownServiceTask;
import kd.imc.rim.common.invoice.download.LeqiPurposeServiceTask;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.schedule.invoicedownload.service.InvoiceDownTaskHelper;

public class InputDownloadTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(InputDownloadTask.class);
    private static final String CONFIG_KEY = "inoutput_down_size";
    private static int THREADPOOL_SIZE = RimConfigUtils.getPageSizeFromConfig((int)8, (String)"rim_sch", (String)"inoutput_down_pool_size");
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"InputOutputDownloadTask", (int)THREADPOOL_SIZE);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u4e0b\u8f7d\u8fdb\u9879\u53d1\u7968\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"InputDownloadLockTask", (String)"InputDownloadLockTask.lock");){
            if (lock.tryLock()) {
                InvoiceDownTaskHelper.putCacheHeadDownload(false);
                List<Long> downLogIds = InvoiceDownTaskHelper.getDownIds("invoice_full_down_cache");
                int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)900, (String)CONFIG_KEY);
                DynamicObject[] downLogDynamicObjects = InvoiceDownTaskHelper.getDownDynamicObject("rim_down_log", downLogIds, pageSize, "invoice_full_down_cache");
                this.downInvoice(requestContext, downLogDynamicObjects, pageSize);
                this.batchDownPurpose(requestContext);
            } else {
                LOGGER.info("InputDownloadLockTask-Lock");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u4e0b\u8f7d\u8fdb\u9879\u53d1\u7968\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void batchDownPurpose(RequestContext requestContext) {
        int count;
        LOGGER.info("downPurpose\u5f00\u59cb... ");
        int pageSize = InvoiceDownloadConstant.getPageSizeFromConfig((int)300, (String)CONFIG_KEY);
        for (int i = 0; i < 10 && (count = this.downPurpose(requestContext, pageSize)) >= 1; ++i) {
        }
        LOGGER.info("downPurpose\u7ed3\u675f... ");
    }

    private int downPurpose(RequestContext requestContext, int pageSize) {
        QFilter filter = new QFilter("handle_status", "=", (Object)"0");
        List idList = QueryServiceHelper.queryPrimaryKeys((String)"rim_leqi_purpose", (QFilter[])new QFilter[]{filter}, null, (int)pageSize);
        if (CollectionUtils.isEmpty((Collection)idList)) {
            return 0;
        }
        int index = 0;
        ArrayList<Future> futureList = new ArrayList<Future>(8);
        for (Object id : idList) {
            LeqiPurposeServiceTask task = new LeqiPurposeServiceTask(requestContext, id);
            futureList.add(threadPool.submit((Callable)task));
            CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)(++index));
        }
        CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)THREADPOOL_SIZE);
        return idList.size();
    }

    private void downInvoice(RequestContext requestContext, DynamicObject[] downLogDynamicObject, int pageSize) {
        if (ObjectUtils.isEmpty((Object[])downLogDynamicObject)) {
            return;
        }
        String isSinglethread = RimConfigUtils.getConfig((String)"rim_deduction", (String)"down_singlethread");
        ArrayList<DynamicObject> downLogList = new ArrayList<DynamicObject>(Arrays.asList(downLogDynamicObject));
        Map<String, List<DynamicObject>> logGroupMap = downLogList.stream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("tax_no"))).collect(Collectors.groupingBy(s -> s.getString("tax_no")));
        if (CollectionUtils.isEmpty(logGroupMap)) {
            return;
        }
        Set<Map.Entry<String, List<DynamicObject>>> entrySet = logGroupMap.entrySet();
        ArrayList<Future> futureList = new ArrayList<Future>(8);
        int index = 0;
        for (Map.Entry<String, List<DynamicObject>> entry : entrySet) {
            InvoiceDownServiceTask task = new InvoiceDownServiceTask(requestContext, entry.getValue(), pageSize);
            if ("1".equals(isSinglethread)) {
                try {
                    task.call();
                }
                catch (Exception exception) {}
                continue;
            }
            futureList.add(threadPool.submit((Callable)task));
            CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)(++index));
        }
        CommonUtils.futureWait(futureList, (int)THREADPOOL_SIZE, (int)THREADPOOL_SIZE);
    }

    static {
        LOGGER.info("\u4e0b\u8f7d\u53d1\u7968\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60:{}", (Object)THREADPOOL_SIZE);
    }
}

