/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.invoice.download.InvoiceDownHelper;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class SuccessStatusTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SuccessStatusTask.class);
    private static final String[] STATUS = new String[]{"2", "3", "8"};

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u7edf\u8ba1\u6210\u529f\u6570\u91cf\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        try (DLock lock = DLock.create((String)"SuccessStatusLockTask", (String)"SuccessStatusLockTask");){
            if (lock.tryLock()) {
                DynamicObject[] logs = BusinessDataServiceHelper.load((String)"rim_down_log", (String)"batch_no,gov_status,success_num,modifytime,description,inout,total_num,taskno", (QFilter[])new QFilter[]{new QFilter("gov_status", "in", (Object)STATUS)}, null, (int)50000);
                InvoiceDownHelper.updateSuccessStatus((DynamicObject[])logs);
                this.deleteInputTable();
            } else {
                LOGGER.info("SuccessStatusLockTask-Lock");
            }
        }
    }

    private void deleteInputTable() {
        try {
            int result1;
            for (int i = 0; i < 50 && (result1 = this.deleteData()) != 0; ++i) {
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u8fdb\u9879\u8868\u5934\u62a5\u9519", (Throwable)e);
        }
    }

    private int deleteData() {
        int maxDateInt = InvoiceDownloadConstant.getPageSizeFromConfig((int)6, (String)"max_delete_input_table");
        int maxDeleteCount = InvoiceDownloadConstant.getPageSizeFromConfig((int)50000, (String)"max_delete_count");
        Date maxDate = DateUtils.addHour((Date)new Date(), (int)(0 - maxDateInt));
        QFilter dateFilter = new QFilter("createtime", "<", (Object)maxDate).and("status", "=", (Object)"1");
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"rim_input_table", (QFilter[])new QFilter[]{dateFilter}, null, (int)maxDeleteCount);
        if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
            DBUtils.deleteByIds((String)"rim_input_table", (List)primaryKeys);
            return primaryKeys.size() < maxDeleteCount ? 0 : 1;
        }
        return 0;
    }
}

