/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.rim.common.constant.DeductionConstant;
import kd.imc.rim.common.constant.InvoiceDownloadConstant;
import kd.imc.rim.common.utils.CacheHelper;

public class TableHeadApplyTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(TableHeadApplyTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u83b7\u53d6\u53d1\u7968\u5934\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        long start = System.currentTimeMillis();
        try (DLock lock = DLock.create((String)"TableHeadApplyLockTask", (String)"TableHeadApplyLockTask.lock");){
            if (lock.tryLock()) {
                this.putCacheHeadDownload();
            } else {
                LOGGER.info("TableHeadApplyLockTask-Lock");
            }
        }
        long end = System.currentTimeMillis();
        LOGGER.info("\u83b7\u53d6\u53d1\u7968\u5934\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f,\u8017\u65f6\uff1a" + (end - start));
    }

    private void putCacheHeadDownload() {
        QFilter usestateFilter;
        DynamicObjectCollection collection;
        String cacheHeader = CacheHelper.get((String)"invoice_head_down_cache");
        String cacheIncremen = CacheHelper.get((String)"invoice_increment_down_cache");
        String cacheFull = CacheHelper.get((String)"invoice_down_init_cache");
        if ((StringUtils.isEmpty((CharSequence)cacheHeader) || StringUtils.isEmpty((CharSequence)cacheIncremen) || StringUtils.isEmpty((CharSequence)cacheFull)) && !ObjectUtils.isEmpty((Object)(collection = QueryServiceHelper.query((String)"rim_down_init", (String)"id,output_download,userorg.taxpayer_tax_no", (QFilter[])(usestateFilter = new QFilter("usestate", "=", (Object)Boolean.TRUE)).toArray())))) {
            if (StringUtils.isEmpty((CharSequence)cacheHeader)) {
                this.putTableHeadInitId(collection);
            }
            if (StringUtils.isEmpty((CharSequence)cacheIncremen)) {
                this.putLqIncrementInitId(collection);
            }
            if (StringUtils.isEmpty((CharSequence)cacheFull)) {
                this.putFullDownInitId(collection);
            }
        }
    }

    private void putLqIncrementInitId(DynamicObjectCollection collection) {
        HashSet incrementIdList = Sets.newHashSet();
        for (DynamicObject dynamicObject : collection) {
            String outputDownload = dynamicObject.getString("output_download");
            if (!StringUtils.isNotEmpty((CharSequence)outputDownload) || !outputDownload.contains(",4,")) continue;
            String taxNo = dynamicObject.getString("userorg.taxpayer_tax_no");
            String dkType = DeductionConstant.getDkType((String)taxNo);
            if (!"5".equals(dkType = InvoiceDownloadConstant.convertLqCollect((String)taxNo, (String)dkType))) continue;
            incrementIdList.add(dynamicObject.getLong("id"));
        }
        if (!CollectionUtils.isEmpty((Collection)incrementIdList)) {
            int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)24, (String)"invoice_increment_down_cache_hours");
            CacheHelper.put((String)"invoice_increment_down_cache", (String)SerializationUtils.toJsonString((Object)incrementIdList), (int)(maxHours * 60 * 60));
        }
    }

    private void putTableHeadInitId(DynamicObjectCollection collection) {
        Set idList = collection.parallelStream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("output_download")) && s.getString("output_download").contains(",3,")).map(s -> s.getLong("id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(idList)) {
            int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)24, (String)"invoice_head_down_cache_hours");
            CacheHelper.put((String)"invoice_head_down_cache", (String)SerializationUtils.toJsonString(idList), (int)(maxHours * 60 * 60));
        }
    }

    private void putFullDownInitId(DynamicObjectCollection collection) {
        Set idList = collection.parallelStream().filter(s -> StringUtils.isNotEmpty((CharSequence)s.getString("output_download")) && (s.getString("output_download").contains(",1,") || s.getString("output_download").contains(",2,") || s.getString("output_download").contains(",6,"))).map(s -> s.getLong("id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(idList)) {
            int maxHours = InvoiceDownloadConstant.getPageSizeFromConfig((int)24, (String)"invoice_down_init_cache_hours");
            CacheHelper.put((String)"invoice_down_init_cache", (String)SerializationUtils.toJsonString(idList), (int)(maxHours * 60 * 60));
        }
    }
}

