/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicedownload.task;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.common.utils.StringUtils;
import kd.imc.rim.common.utils.UUID;

public class UpdateDownSchTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpdateDownSchTask.class);
    private static final String CRON = "%s %s/%s * * * ?";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("\u66f4\u65b0\u4e0b\u8f7d\u8c03\u5ea6\u9891\u7387\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f00\u59cb... ");
        try (DLock lock = DLock.create((String)"UpdateDownSchTask", (String)"UpdateDownSchTask");){
            if (lock.tryLock()) {
                ArrayList<Object> schIds = new ArrayList<Object>();
                schIds.add("1S6G0Z10TJOW");
                String config = RimConfigUtils.getConfig((String)"sch", (String)"updatedown_task_ids");
                if (StringUtils.isNotEmpty((CharSequence)config)) {
                    schIds.add(CommonUtils.getMultiValues((String)config));
                }
                int downMin = RimConfigUtils.getPageSizeFromConfig((int)10, (String)"rim_sch", (String)"down_mins");
                for (Object e : schIds) {
                    this.updateDownSch(e, downMin);
                }
                int deductMin = RimConfigUtils.getPageSizeFromConfig((int)5, (String)"rim_sch", (String)"deduct_mins");
                this.updateDownSch("22Y3IQ+4Q01D", deductMin);
            } else {
                LOGGER.info("UpdateDownSchTask-Lock");
            }
        }
    }

    private void updateDownSch(Object schId, int min) {
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)schId, (String)"sch_schedule");
            if (dynamicObject != null) {
                String status = dynamicObject.getString("status");
                if (!"1".equals(status)) {
                    return;
                }
                dynamicObject.set("repeatmode", (Object)"def");
                int r1 = UUID.getOneRandom((int)60);
                if (min <= 1) {
                    min = 10;
                }
                int r2 = UUID.getOneRandom((int)min);
                String plan = String.format(CRON, r1, r2, min);
                dynamicObject.set("plan", (Object)plan);
                OperationResult schSchedule = SaveServiceHelper.saveOperate((String)"sch_schedule", (DynamicObject[])new DynamicObject[]{dynamicObject}, null);
                if (schSchedule != null && schSchedule.isSuccess()) {
                    LOGGER.info("\u66f4\u65b0[{}]\u4e0b\u8f7d\u8c03\u5ea6\u9891\u7387\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u6210\u529f... ", (Object)dynamicObject.getString("name"));
                } else {
                    LOGGER.info("\u66f4\u65b0[{}]\u4e0b\u8f7d\u8c03\u5ea6\u9891\u7387\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25... ", (Object)dynamicObject.getString("name"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.info("UpdateDownSchTask-Exception:{}", (Object)e);
        }
    }
}

