/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.schedule.invoicehisdata;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.imc.rim.common.utils.BigDecimalUtil;
import kd.imc.rim.common.utils.CommonUtils;
import kd.imc.rim.common.utils.DBUtils;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.RimConfigUtils;
import kd.imc.rim.formplugin.downloadcenter.DownLoadService;

public class ClearJob
extends AbstractTask {
    private static Log logger = LogFactory.getLog(ClearJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("ClearJob");
        try (DLock lock = DLock.create((String)"rim-ClearJob");){
            if (lock.tryLock()) {
                this.clearRecogTemp();
                this.clearDownloadFile();
                this.clearCheckResult();
                this.delete("t_rim_down_account", "fcreatetime", 30);
                this.delete("t_rim_invoice_log", "fcreate_time", 90);
                this.delete("t_rim_down_input", "fmodifytime", 30);
                this.delete("t_rim_down_apply_log", "fcreatetime", 5);
                CommonUtils.deleteCache((int)100000);
                this.deleteLeqiPurpose();
                this.deleteSelectAccount();
                this.delete("t_rim_select_account", "fcreate_time", 45);
                this.delete("t_rim_select_log", "fcreate_time", 45);
                String saveDateNum = RimConfigUtils.getConfig((String)"rim_config", (String)"expense_df_log_save_date");
                int dateNum = 180;
                if (StringUtils.isNotEmpty((CharSequence)saveDateNum)) {
                    dateNum = Integer.parseInt(saveDateNum);
                }
                this.delete("t_rim_expense_df_log", "fcreate_time", dateNum);
            }
        }
    }

    private void delete(String table, String dateColumn, int date) {
        logger.info("\u5f00\u59cb\u5220\u9664\u4e34\u65f6\u6570\u636e{},{},{}", new Object[]{table, dateColumn, 0 - date});
        try {
            String sql = "delete from " + table + " where " + dateColumn + "<= ?";
            DBUtils.execute((String)sql, (Object[])new Object[]{DateUtils.addDay((Date)new Date(), (int)(0 - date))});
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u6570\u636e\u5931\u8d25" + table, (Throwable)e);
        }
    }

    private void deleteLeqiPurpose() {
        logger.info("\u5f00\u59cb\u5220\u9664\u4e50\u4f01\u7528\u9014\u4e34\u65f6\u6570\u636e");
        try {
            String initSql = "delete from t_rim_leqi_purpose  where fhandle_status = ? and fcreatetime <= ?";
            DBUtils.execute((String)initSql, (Object[])new Object[]{"1", DateUtils.addDay((Date)new Date(), (int)-5)});
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u4e50\u4f01\u7528\u9014\u4e34\u65f6\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void deleteSelectAccount() {
        logger.info("\u5f00\u59cb\u5220\u9664\u52fe\u9009\u53f0\u8d26\u6570\u636e");
        try {
            String initSql = "delete from t_rim_select_account  where fhandle_status != ? and fcreate_time <= ?";
            DBUtils.execute((String)initSql, (Object[])new Object[]{"3", DateUtils.addDay((Date)new Date(), (int)-30)});
        }
        catch (Exception e) {
            logger.error("\u5f00\u59cb\u5220\u9664\u52fe\u9009\u53f0\u8d26\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    private void clearCheckResult() {
        try {
            int date = 10;
            String checkdate = RimConfigUtils.getConfig((String)"checkdate");
            if (StringUtils.isNotEmpty((CharSequence)checkdate)) {
                date = BigDecimalUtil.transDecimal((Object)checkdate).intValue();
            }
            if (date < 10) {
                date = 10;
            }
            logger.info("\u6e05\u9664\u67e5\u9a8c\u4e34\u65f6\u8868:{}\u5c0f\u65f6", (Object)date);
            Calendar cd = Calendar.getInstance();
            cd.setTime(new Date());
            cd.add(5, 0 - date);
            QFilter filter3 = new QFilter("check_time", "<", (Object)cd.getTime());
            DeleteServiceHelper.delete((String)"rim_check_result", (QFilter[])new QFilter[]{filter3});
        }
        catch (Exception e) {
            logger.info("\u6e05\u9664\u67e5\u9a8c\u4e34\u65f6\u8868\u5931\u8d25" + e.getMessage());
        }
    }

    private void clearRecogTemp() {
        try {
            Map configMap = ImcConfigUtil.getValue((String)"rim_recog_check");
            String cachhour = (String)configMap.get("cache_hour");
            int cacheHour = 24;
            if (!StringUtils.isEmpty((CharSequence)cachhour) && (cacheHour = BigDecimalUtil.transDecimal(configMap.get("cache_hour")).intValue()) < 0) {
                cacheHour = 0;
            }
            logger.info("\u6e05\u9664\u8bc6\u522b\u4e34\u65f6\u8868:{}\u5c0f\u65f6", (Object)cacheHour);
            Calendar cd = Calendar.getInstance();
            cd.setTime(new Date());
            cd.add(10, 0 - cacheHour);
            QFilter filter3 = new QFilter("create_time", "<", (Object)cd.getTime());
            DeleteServiceHelper.delete((String)"rim_recognition_result", (QFilter[])new QFilter[]{filter3});
        }
        catch (Exception e) {
            logger.info("\u6e05\u9664\u8bc6\u522b\u4e34\u65f6\u8868\u5931\u8d25" + e.getMessage());
        }
    }

    private void clearDownloadFile() {
        try {
            logger.info("\u6e05\u9664\u4e0b\u8f7d\u4e2d\u5fc3\u8fc7\u671f\u6570\u636e");
            new DownLoadService().clear();
        }
        catch (Exception e) {
            logger.info("\u6e05\u9664\u8bc6\u522b\u4e34\u65f6\u8868\u5931\u8d25" + e.getMessage());
        }
    }
}

