/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.upgrade;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imc.rim.common.utils.ImcConfigUtil;
import kd.imc.rim.common.utils.UUID;

public class BillConfigUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setLog("upgrade bill config");
        long startTime = System.currentTimeMillis();
        final HashSet newConfigNumberSet = new HashSet(8);
        String newConfigSql = "select fbill_number, fseq from t_rim_fpzs_config_entry";
        final Integer[] seq = new Integer[]{0};
        DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)newConfigSql, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet result) throws Exception {
                while (result.next()) {
                    String configNumber = result.getString(1);
                    seq[0] = result.getInt(2);
                    newConfigNumberSet.add(configNumber);
                }
                return null;
            }
        });
        final JSONArray oldConfigArray = new JSONArray();
        final HashSet oldConfigNumberSet = new HashSet(8);
        String oldConfigSql = "select fnumber,fname,foperate_upload,foperate_scanner,foperate_qrcode,foperate_qrcode_type,foperate_enter,foperate_san_gun,foperate_company_invoice,foperate_person_invoice,foperate_excel_import,foperate_attach_upload,foperate_attach_scanner,foperate_attach_qrcode,foperate_att_qrcode_type from t_rim_expense_type";
        DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)oldConfigSql, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet result) throws Exception {
                while (result.next()) {
                    String configNumber = result.getString(1);
                    if (oldConfigNumberSet.contains(configNumber) || newConfigNumberSet.contains(configNumber)) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("number", (Object)result.getString(1));
                    jsonObject.put("name", (Object)result.getString(2));
                    jsonObject.put("operate_upload", (Object)result.getString(3));
                    jsonObject.put("operate_scanner", (Object)result.getString(4));
                    jsonObject.put("operate_qrcode", (Object)result.getString(5));
                    String oldOperateType = result.getString(6);
                    if ("weixin".equals(oldOperateType)) {
                        jsonObject.put("operate_qrcode_type", (Object)"2");
                    } else {
                        jsonObject.put("operate_qrcode_type", (Object)"1");
                    }
                    jsonObject.put("operate_enter", (Object)result.getString(7));
                    jsonObject.put("operate_san_gun", (Object)result.getString(8));
                    jsonObject.put("operate_company_invoice", (Object)result.getString(9));
                    jsonObject.put("operate_person_invoice", (Object)result.getString(10));
                    jsonObject.put("operate_excel_import", (Object)result.getString(11));
                    jsonObject.put("operate_attach_upload", (Object)result.getString(12));
                    jsonObject.put("operate_attach_scanner", (Object)result.getString(13));
                    jsonObject.put("operate_attach_qrcode", (Object)result.getString(14));
                    jsonObject.put("operate_att_qrcode_type", (Object)result.getString(15));
                    oldConfigNumberSet.add(configNumber);
                    oldConfigArray.add((Object)jsonObject);
                }
                return null;
            }
        });
        if (oldConfigArray.size() <= 0) {
            result.setLog("upgrade bill config - configArray is null");
            return result;
        }
        Long user = Long.parseLong(RequestContext.get().getUserId());
        if (!CollectionUtils.isEmpty((Collection)oldConfigArray)) {
            ArrayList<Object[]> configParam = new ArrayList<Object[]>(oldConfigArray.size());
            ArrayList<Object[]> configEntryParam = new ArrayList<Object[]>(oldConfigArray.size());
            String fpzsConfigSql = "insert into t_rim_fpzs_config(fid, fschema_number, fschema_name, fsuitable_bill_types, fqrcode_type, fcreatedate, fmodifydate, fcreater, fstatus, fpc_config_tag, fmobile_config_tag) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String fpzsConfigEntrySql = "insert into t_rim_fpzs_config_entry(fid, fentryid, fseq, fbill_number, fbill_name) values(?, ?, ?, ?, ?)";
            int seqNum = seq[0];
            for (int i = 0; i < oldConfigArray.size(); ++i) {
                JSONObject config = oldConfigArray.getJSONObject(i);
                if (config == null) continue;
                ++seqNum;
                Long id = Long.parseLong(UUID.getRandomNum((int)19));
                String number = config.getString("number");
                if ("fpqs".equals(number) || "adqs".equals(number) || "fpzs".equals(number)) continue;
                String name = config.getString("name");
                String suitableType = "0";
                String qrcodeType = config.getString("operate_qrcode_type");
                JSONObject pcConfig = new JSONObject();
                pcConfig.put("operate_upload", (Object)config.getString("operate_upload"));
                pcConfig.put("operate_qrcode", (Object)config.getString("operate_qrcode"));
                pcConfig.put("operate_enter", (Object)config.getString("operate_enter"));
                pcConfig.put("operate_scanner", (Object)config.getString("operate_scanner"));
                pcConfig.put("operate_san_gun", (Object)config.getString("operate_san_gun"));
                pcConfig.put("operate_company_invoice", (Object)config.getString("operate_company_invoice"));
                pcConfig.put("operate_person_invoice", (Object)config.getString("operate_person_invoice"));
                pcConfig.put("operate_excel_import", (Object)config.getString("operate_excel_import"));
                pcConfig.put("operate_attach_qrcode", (Object)config.getString("operate_attach_qrcode"));
                pcConfig.put("operate_attach_upload", (Object)config.getString("operate_attach_upload"));
                pcConfig.put("operate_attach_scanner", (Object)config.getString("operate_attach_scanner"));
                pcConfig.put("pc_invoice", (Object)"1");
                pcConfig.put("pc_oversea", (Object)"1");
                pcConfig.put("pc_contract", (Object)"1");
                pcConfig.put("pc_attach", (Object)"1");
                JSONObject mobileConfig = new JSONObject();
                Map fpzsConfig = ImcConfigUtil.getValue((String)"rim_fpzs");
                String sacnConfig = (String)fpzsConfig.get("scan");
                String scan = "0";
                if ("1".equals(sacnConfig)) {
                    scan = "1";
                }
                String emailConfig = (String)fpzsConfig.get("email");
                String email = "0";
                if ("1".equals(emailConfig)) {
                    email = "1";
                }
                String handConfig = (String)fpzsConfig.get("hand");
                String hand = "0";
                if ("1".equals(handConfig)) {
                    hand = "1";
                }
                String message = "0";
                String messageConfig = (String)fpzsConfig.get("message");
                if ("1".equals(messageConfig)) {
                    message = "1";
                }
                mobileConfig.put("mob_invoice_camera", (Object)config.getString("operate_upload"));
                mobileConfig.put("mob_invoice_scan_qrcode", (Object)scan);
                mobileConfig.put("mob_invoice_hand_add", (Object)hand);
                mobileConfig.put("mob_invoice_message", (Object)message);
                mobileConfig.put("mob_invoice_email", (Object)email);
                mobileConfig.put("mob_invoice_pocket", (Object)"1");
                mobileConfig.put("mob_attach_camera", (Object)config.getString("operate_attach_upload"));
                mobileConfig.put("mob_attach_pocket", (Object)"1");
                mobileConfig.put("mobile_invoice", (Object)"1");
                mobileConfig.put("mobile_attach", (Object)"1");
                mobileConfig.put("mobile_oversea", (Object)"1");
                Object[] configParamArray = new Object[]{id, number, name, suitableType, qrcodeType, new Date(), new Date(), user, 1, pcConfig.toJSONString(), mobileConfig.toJSONString()};
                configParam.add(configParamArray);
                Long entryId = Long.parseLong(UUID.getRandomNum((int)19));
                Object[] configParamEntryArray = new Object[]{id, entryId, seqNum, number, name};
                configEntryParam.add(configParamEntryArray);
            }
            if (configParam.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)fpzsConfigSql, configParam);
            }
            if (configEntryParam.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)fpzsConfigEntrySql, configEntryParam);
            }
        }
        long endQIdTime = System.currentTimeMillis();
        result.setLog("end upgrade blackList and sensitive words" + (endQIdTime - startTime));
        return result;
    }
}

