/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imc.rim.common.utils.DateUtils;
import kd.imc.rim.common.utils.UUID;

public class BlackSenseUpgradeService
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        Object[] array;
        Long id;
        UpgradeResult result = new UpgradeResult();
        result.setLog("upgrade blackList and sensitive words");
        long startTime = System.currentTimeMillis();
        final HashSet hasSensitiveWords = new HashSet(16);
        final HashSet hasBlackList = new HashSet(16);
        String repeatSql = "select fblack_list,fsensitive_word from t_rim_verify";
        DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)repeatSql, (ResultSetHandler)new ResultSetHandler(){

            public Object handle(ResultSet result) throws Exception {
                while (result.next()) {
                    hasBlackList.add(result.getString(1));
                    hasSensitiveWords.add(result.getString(2));
                }
                return null;
            }
        });
        if (CollectionUtils.isEmpty(hasBlackList) && CollectionUtils.isEmpty(hasSensitiveWords)) {
            return result;
        }
        ArrayList blackList = new ArrayList(16);
        ArrayList sensitiveWordsList = new ArrayList(16);
        if (!CollectionUtils.isEmpty(hasSensitiveWords)) {
            for (String sensitiveWords : hasSensitiveWords) {
                List billSensitiveList;
                if (StringUtils.isEmpty((Object)sensitiveWords) || CollectionUtils.isEmpty((Collection)(billSensitiveList = SerializationUtils.fromJsonStringToList((String)sensitiveWords, String.class)))) continue;
                sensitiveWordsList.addAll(billSensitiveList);
            }
        }
        if (!CollectionUtils.isEmpty(hasBlackList)) {
            for (String blackListWords : hasBlackList) {
                List billBlackList;
                if (StringUtils.isEmpty((Object)blackListWords) || CollectionUtils.isEmpty((Collection)(billBlackList = SerializationUtils.fromJsonStringToList((String)blackListWords, String.class)))) continue;
                blackList.addAll(billBlackList);
            }
        }
        HashSet blackListSet = new HashSet(blackList);
        HashSet sensitiveWordsSet = new HashSet(sensitiveWordsList);
        Date date = new Date();
        Long user = Long.parseLong(RequestContext.get().getUserId());
        String dateStr = DateUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        if (!CollectionUtils.isEmpty(blackListSet)) {
            ArrayList<Object[]> blackListParam = new ArrayList<Object[]>(blackListSet.size());
            String blackListSql = "insert into t_bdm_blacklist_config(fid, fname, fcreatetime, fmodifytime, fenable, fmasterid, fstatus, fcreatorid) values(?, ?,?, ?, ?, ?, ?, ?)";
            for (String blackListword : blackListSet) {
                if (StringUtils.isEmpty((Object)blackListword)) continue;
                id = Long.parseLong(UUID.getRandomNum((int)19));
                array = new Object[]{id, blackListword, new Date(), new Date(), "1", id, "C", user};
                blackListParam.add(array);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)blackListSql, blackListParam);
        }
        if (!CollectionUtils.isEmpty(sensitiveWordsSet)) {
            ArrayList<Object[]> sensitivWordsParam = new ArrayList<Object[]>(sensitiveWordsSet.size());
            String sensitiveWordSql = "insert into t_bdm_sensitive_wordlist(fid, fname, fcreatetime, fmodifytime, fenable, fmasterid, fstatus, fcreatorid) values(?, ?,?, ?, ?, ?, ?, ?)";
            for (String sensitiveWord : sensitiveWordsSet) {
                if (StringUtils.isEmpty((Object)sensitiveWord)) continue;
                id = Long.parseLong(UUID.getRandomNum((int)19));
                array = new Object[]{id, sensitiveWord, new Date(), new Date(), "1", id, "C", user};
                sensitivWordsParam.add(array);
            }
            DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)sensitiveWordSql, sensitivWordsParam);
        }
        long endQIdTime = System.currentTimeMillis();
        result.setLog("end upgrade blackList and sensitive words" + (endQIdTime - startTime));
        return result;
    }
}

