/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.imc.aws.ofd.util.analysis.IOfdRead;
import kd.imc.aws.ofd.util.analysis.InvoiceReadUtils;
import kd.imc.aws.ofd.util.analysis.OfdReadUtils;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.rim.file.pdfanalysis.utils.PatternPool;
import kd.imc.rim.file.pdfanalysis.utils.ReUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.AirEleTicket;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.AirEleTicketConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.AirEleTicketItem;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.utils.StrUtil;
import org.dom4j.Element;

public class AirEleTicketOfdRead
implements IOfdRead {
    @Override
    public JSONObject readData(List<Element> svgList, InvoiceTypeEnum invoiceType) {
        Element pageEle = svgList.get(0);
        List<List<TextCode>> codeList = OfdReadUtils.getListByMap(pageEle);
        AirEleTicket airEleTicket = this.getAirEleTicket(codeList, invoiceType);
        return OfdReadUtils.getReturnJson("3", null, null, airEleTicket);
    }

    private AirEleTicket getAirEleTicket(List<List<TextCode>> contentList, InvoiceTypeEnum invoiceType) {
        AirEleTicket airEleTicket = new AirEleTicket(invoiceType.getCode());
        ArrayList<List<TextCode>> itemContentList = new ArrayList<List<TextCode>>();
        StringBuilder allText = new StringBuilder();
        boolean itemFlag = false;
        for (int j = 0; j < contentList.size(); ++j) {
            List<TextCode> xList = contentList.get(j);
            String everyFirstContent = InvoiceReadUtils.replaceSpaceToEmpty(xList.get(0).getContent());
            String everySecondContent = "";
            if (itemFlag) {
                if (xList.size() > 1) {
                    everySecondContent = InvoiceReadUtils.replaceSpaceToEmpty(xList.get(1).getContent());
                }
                if (everyFirstContent.contains("\u7968\u4ef7") || everySecondContent.contains("\u7968\u4ef7")) {
                    this.setAmount(xList, contentList.get(++j), airEleTicket);
                    itemFlag = false;
                    continue;
                }
            }
            if ("\u65c5\u5ba2\u59d3\u540d".equals(everyFirstContent)) {
                List<TextCode> nextLineList = contentList.get(j + 1);
                this.setCustomerName(nextLineList, airEleTicket);
                ++j;
                continue;
            }
            if (everyFirstContent.contains("\u627f\u8fd0\u4eba") || itemFlag) {
                itemContentList.add(xList);
                itemFlag = true;
                continue;
            }
            StringBuilder currentLineText = new StringBuilder();
            for (TextCode TextCode2 : xList) {
                String content = TextCode2.getContent();
                if (content != null) {
                    content = content.replace("\uff1a", ":");
                    if (currentLineText.toString().contains(":") && content.contains(":")) {
                        allText.append(System.lineSeparator());
                        currentLineText = new StringBuilder();
                    }
                    currentLineText.append(content);
                    allText.append(content);
                    if (content.endsWith(":")) continue;
                }
                currentLineText = new StringBuilder();
                allText.append(System.lineSeparator());
            }
        }
        InvoiceReadUtils.setPatternMatchValue(airEleTicket, allText.toString(), "\u56fd\u5185\u56fd\u9645\u6807\u8bc6:(?<internationalFlag>\\S*)|\u53d1\u7968\u53f7\u7801:(?<invoiceNo>\\S*)|\u7535\u5b50\u5ba2\u7968\u53f7\u7801:(?<electronicTicketNum>\\S*)|\u9a8c\u8bc1\u7801:(?<checkCode>\\S*)|\u63d0\u793a\u4fe1\u606f:(?<promptInformation>\\S*)|\u4fdd\u9669\u8d39:(?<insurancePremium>\\S*)|\u9500\u552e\u7f51\u70b9\u4ee3\u53f7:(?<salesUnitCode>\\S*)|\u586b\u5f00\u5355\u4f4d:(?<fillingUnit>\\S*)|\u586b\u5f00\u65e5\u671f:(?<issueDate>\\S*)|\u8d2d\u4e70\u65b9\u540d\u79f0:(?<buyerName>\\S*)|\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7:(?<unifiedSocialCreditCodeOfPurchaser>\\S*)|\u5f00\u7968\u72b6\u6001:(?<invoiceStatus>\\S*)", AirEleTicketConstants.DATA_KEYS);
        airEleTicket.setTaxRate(InvoiceReadUtils.getTaxRate(airEleTicket.getTaxRate()));
        this.setInvoiceStatus(airEleTicket);
        this.setInternationalFlag(airEleTicket);
        this.setItemList(airEleTicket, itemContentList);
        return airEleTicket;
    }

    private void setCustomerName(List<TextCode> nextLineList, AirEleTicket airEleTicket) {
        if (nextLineList != null) {
            int size = nextLineList.size();
            airEleTicket.setCustomerName(nextLineList.get(0).getContent());
            airEleTicket.setCustomerIdentityNum(nextLineList.get(1).getContent());
            if (size > 2) {
                airEleTicket.setEndorsement(nextLineList.get(2).getContent());
            }
        }
    }

    private void setAmount(List<TextCode> headList, List<TextCode> nextLineList, AirEleTicket airEleTicket) {
        if (nextLineList != null) {
            int index = 0;
            for (TextCode moneyCode : nextLineList) {
                String moneyContent = moneyCode.getContent();
                if (moneyContent != null && (moneyContent.contains("\u81f3") || "CNY".equals(moneyContent))) continue;
                index = this.getHeadIndex(headList, index, moneyCode.getX());
                this.setAmount(airEleTicket, index, moneyContent);
                ++index;
            }
        }
    }

    private int getHeadIndex(List<TextCode> headList, int index, BigDecimal contentX) {
        if (index == headList.size() - 1) {
            return index;
        }
        TextCode headCode = headList.get(index);
        TextCode nextHeadCode = headList.get(index + 1);
        if (contentX.compareTo(headCode.getX()) > 0 && contentX.compareTo(nextHeadCode.getX()) < 0) {
            return index;
        }
        return this.getHeadIndex(headList, index + 1, contentX);
    }

    private void setAmount(AirEleTicket airEleTicket, int index, String content) {
        content = StrUtil.nullToEmpty(ReUtil.delAll(PatternPool.WORD, (CharSequence)content));
        switch (index) {
            case 0: {
                airEleTicket.setTicketPrice(content);
                break;
            }
            case 1: {
                airEleTicket.setFuelSurcharge(content);
                break;
            }
            case 2: {
                airEleTicket.setTaxRate(content);
                break;
            }
            case 3: {
                airEleTicket.setTotalTaxAmount(content);
                break;
            }
            case 4: {
                airEleTicket.setAirportConstructionFee(content);
                break;
            }
            case 5: {
                airEleTicket.setOtherTotalTaxAmount(content);
                break;
            }
            case 6: {
                airEleTicket.setTotalAmount(content);
            }
        }
    }

    private void setInvoiceStatus(AirEleTicket airEleTicket) {
        String invoiceStatus = airEleTicket.getInvoiceStatus();
        if ("\u7ea2\u51b2".equals(invoiceStatus)) {
            airEleTicket.setInvoiceStatus("3");
        } else if ("\u6b63\u5e38".equals(invoiceStatus)) {
            airEleTicket.setInvoiceStatus("0");
        }
    }

    private void setInternationalFlag(AirEleTicket airEleTicket) {
        String internationalFlag = airEleTicket.getInternationalFlag();
        if ("\u56fd\u9645".equals(internationalFlag)) {
            airEleTicket.setInternationalFlag("2");
        } else if ("\u56fd\u5185".equals(internationalFlag)) {
            airEleTicket.setInternationalFlag("1");
        } else {
            airEleTicket.setInternationalFlag("0");
        }
    }

    public void setItemList(AirEleTicket airEleTicket, List<List<TextCode>> contentList) {
        ArrayList<AirEleTicketItem> itemList = new ArrayList<AirEleTicketItem>();
        List<TextCode> headList = null;
        int index = 0;
        for (List<TextCode> xList : contentList) {
            if (++index == 1) {
                headList = InvoiceReadUtils.getItemHeadList(xList);
                continue;
            }
            AirEleTicketItem airEleTicketItem = AirEleTicketOfdRead.getItemByXList(airEleTicket, xList, headList);
            if (StrUtil.isEmpty(airEleTicketItem.getCarrier())) continue;
            itemList.add(airEleTicketItem);
        }
        airEleTicket.setItem(itemList);
    }

    public static AirEleTicketItem getItemByXList(AirEleTicket airEleTicket, List<TextCode> xList, List<TextCode> headList) {
        BigDecimal firstX = headList.get(0).getX();
        AirEleTicketItem airEleTicketItem = new AirEleTicketItem();
        StringBuilder lineStrPre = new StringBuilder();
        block0: for (TextCode TextCode2 : xList) {
            BigDecimal width;
            BigDecimal x = TextCode2.getX();
            if (x.add(width = TextCode2.getWidth()).compareTo(firstX) < 0) {
                lineStrPre.append(TextCode2.getContent());
                continue;
            }
            for (int i = 0; i < headList.size(); ++i) {
                TextCode headPre = null;
                TextCode headNext = null;
                if (i > 0) {
                    headPre = headList.get(i - 1);
                }
                if (i < headList.size() - 1) {
                    headNext = headList.get(i + 1);
                }
                TextCode head = headList.get(i);
                if (headPre == null && x.add(TextCode2.getWidth()).compareTo(head.getX()) <= 0) continue block0;
                if ((headPre != null || x.compareTo(head.getWidth()) >= 0) && (headPre == null || x.compareTo(headPre.getWidth().subtract(new BigDecimal("11"))) < 0) || headNext != null && x.add(width).compareTo(headNext.getX().add(new BigDecimal("7"))) > 0) continue;
                String headContent = head.getContent();
                String content = TextCode2.getContent();
                AirEleTicketOfdRead.setItemModel(airEleTicketItem, headContent, content);
                continue block0;
            }
        }
        InvoiceReadUtils.setPatternMatchValue(airEleTicket, lineStrPre.toString(), "\u81ea:(?<placeOfDeparture>\\S*)", AirEleTicketConstants.DEPARTURE_KEYS);
        InvoiceReadUtils.setPatternMatchValue(airEleTicket, lineStrPre.toString(), "\u81f3:(?<destination>\\S*)", AirEleTicketConstants.DESTINATION_KEYS, true);
        return airEleTicketItem;
    }

    private static void setItemModel(AirEleTicketItem airEleTicketItem, String headContent, String content) {
        content = StrUtil.nullToEmpty(content);
        if ("\u627f\u8fd0\u4eba".equals(headContent)) {
            airEleTicketItem.setCarrier(StrUtil.nullToEmpty(airEleTicketItem.getCarrier()) + content);
        } else if ("\u822a\u73ed\u53f7".equals(headContent)) {
            airEleTicketItem.setFlightNum(StrUtil.nullToEmpty(airEleTicketItem.getFlightNum()) + content);
        } else if ("\u5ea7\u4f4d\u7b49\u7ea7".equals(headContent)) {
            airEleTicketItem.setSeatGrade(StrUtil.nullToEmpty(airEleTicketItem.getSeatGrade()) + content);
        } else if ("\u65e5\u671f".equals(headContent)) {
            airEleTicketItem.setInvoiceDate(StrUtil.nullToEmpty(airEleTicketItem.getInvoiceDate()) + content);
        } else if ("\u65f6\u95f4".equals(headContent)) {
            airEleTicketItem.setTakePlaneTime(StrUtil.nullToEmpty(airEleTicketItem.getTakePlaneTime()) + content);
        } else if ("\u5ba2\u7968\u7ea7\u522b/\u5ba2\u7968\u7c7b\u522b".equals(headContent)) {
            airEleTicketItem.setFareBasis(StrUtil.nullToEmpty(airEleTicketItem.getFareBasis()) + content);
        } else if ("\u5ba2\u7968\u751f\u6548\u65e5\u671f".equals(headContent)) {
            airEleTicketItem.setEffectiveDate(StrUtil.nullToEmpty(airEleTicketItem.getEffectiveDate()) + content);
        } else if ("\u6709\u6548\u622a\u6b62\u65e5\u671f".equals(headContent)) {
            airEleTicketItem.setExpirationDate(StrUtil.nullToEmpty(airEleTicketItem.getExpirationDate()) + content);
        } else if ("\u514d\u8d39\u884c\u674e".equals(headContent)) {
            airEleTicketItem.setFreeBaggageAllowance(StrUtil.nullToEmpty(airEleTicketItem.getFreeBaggageAllowance()) + content);
        }
    }
}

