/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.analysis;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.dataentity.resource.ResManager;
import kd.imc.aws.ofd.util.analysis.AirEleTicketOfdRead;
import kd.imc.aws.ofd.util.analysis.DigitalInvoiceRead;
import kd.imc.aws.ofd.util.analysis.IOfdRead;
import kd.imc.aws.ofd.util.analysis.TrainEleTicketOfdRead;
import kd.imc.aws.ofd.util.analysis.VatInvoiceRead;
import kd.imc.aws.ofd.util.model.TextCode;
import kd.imc.aws.ofd.util.ofd.OfdConvertUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.DigitalPdfConstants;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.InvoiceTypeEnum;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.SpecialCodeEnum;
import kd.imc.rim.file.utils.StrUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class OfdReadUtils {
    public static JSONObject readData(byte[] fileBytes) {
        String type = "-1";
        try {
            String svgStr = OfdConvertUtil.ofdToSvgStr(fileBytes, false, -1);
            Document documents = DocumentHelper.parseText((String)svgStr);
            List svgList = documents.getRootElement().elements("svg");
            if (svgList == null || svgList.isEmpty()) {
                return OfdReadUtils.getReturnJson("-1", ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u4e0d\u652f\u6301\u89e3\u6790\u3002", (String)"OfdReadUtils_0", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u6587\u4ef6\u4e0d\u652f\u6301\u89e3\u6790", (String)"OfdReadUtils_1", (String)"imc-rim-file", (Object[])new Object[0]), null);
            }
            Element firstPageEle = (Element)svgList.get(0);
            Map<BigDecimal, Map<BigDecimal, TextCode>> coordinateMap = OfdReadUtils.firstSort(firstPageEle);
            Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap = OfdReadUtils.secondSort(coordinateMap);
            InvoiceTypeEnum invoiceTypeEnum = OfdReadUtils.getInvoiceType(secondSortMap);
            if (invoiceTypeEnum == null) {
                return OfdReadUtils.getReturnJson(type, ResManager.loadKDString((String)"\u5f53\u524d\u7c7b\u578b\u7684\u6587\u4ef6\u4e0d\u652f\u6301\u89e3\u6790\u3002", (String)"OfdReadUtils_2", (String)"imc-rim-file", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f53\u524d\u7c7b\u578b\u7684\u6587\u4ef6\u4e0d\u652f\u6301\u89e3\u6790", (String)"OfdReadUtils_3", (String)"imc-rim-file", (Object[])new Object[0]), null);
            }
            IOfdRead ofdReadByType = OfdReadUtils.getOfdReadByType(invoiceTypeEnum);
            return ofdReadByType.readData(svgList, invoiceTypeEnum);
        }
        catch (Exception e) {
            return OfdReadUtils.getReturnJson(type, null, String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u89e3\u6790\u51fa\u9519%1$s", (String)"OfdReadUtils_4", (String)"imc-rim-file", (Object[])new Object[0]), e.getMessage()), null);
        }
    }

    private static IOfdRead getOfdReadByType(InvoiceTypeEnum invoiceTypeEnum) {
        if (InvoiceTypeEnum.DIGITAL_ELE_INVOICE_ORDINARY == invoiceTypeEnum || InvoiceTypeEnum.DIGITAL_ELE_INVOICE_SPECIAL == invoiceTypeEnum) {
            return new DigitalInvoiceRead();
        }
        if (InvoiceTypeEnum.DIGITAL_ELE_AIR_TRANSPORT_TICKET_ITINERARY == invoiceTypeEnum) {
            return new AirEleTicketOfdRead();
        }
        if (InvoiceTypeEnum.DIGITAL_ELE_TRAIN_INVOICE == invoiceTypeEnum) {
            return new TrainEleTicketOfdRead();
        }
        return new VatInvoiceRead();
    }

    public static Map<BigDecimal, Map<BigDecimal, TextCode>> secondSort(Map<BigDecimal, Map<BigDecimal, TextCode>> firstSortMap) {
        TreeMap<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap = new TreeMap<BigDecimal, Map<BigDecimal, TextCode>>();
        for (Map.Entry<BigDecimal, Map<BigDecimal, TextCode>> firstMapEntry : firstSortMap.entrySet()) {
            BigDecimal yKey = firstMapEntry.getKey();
            Map<BigDecimal, TextCode> xMap = firstMapEntry.getValue();
            String everyContent = "";
            BigDecimal xFirst = BigDecimal.ZERO;
            BigDecimal lastX = BigDecimal.ZERO;
            BigDecimal lastWidth = BigDecimal.ZERO;
            BigDecimal totalWidth = BigDecimal.ZERO;
            for (Map.Entry<BigDecimal, TextCode> xMapEntry : xMap.entrySet()) {
                BigDecimal xKey = xMapEntry.getKey();
                TextCode pdfTextCode = xMapEntry.getValue();
                BigDecimal width = pdfTextCode.getWidth().add(BigDecimal.ONE);
                String content = pdfTextCode.getContent();
                if ("\u53d1".equals(content) && everyContent.endsWith("\u589e\u503c\u7a0e\u7535\u5b50")) continue;
                if (totalWidth.compareTo(BigDecimal.ZERO) == 0) {
                    xFirst = xKey;
                }
                BigDecimal diffBig = everyContent.endsWith(DigitalPdfConstants.EN_COLON) || everyContent.endsWith(DigitalPdfConstants.CN_COLON) ? new BigDecimal("5") : new BigDecimal("0.5");
                if (lastX.compareTo(BigDecimal.ZERO) != 0 && lastX.add(lastWidth).add(diffBig).compareTo(xKey) < 0) {
                    OfdReadUtils.setSortContentData(secondSortMap, xFirst, yKey, totalWidth, everyContent, 5);
                    everyContent = "";
                    totalWidth = BigDecimal.ZERO;
                    xFirst = xKey;
                }
                everyContent = everyContent + content;
                totalWidth = totalWidth.add(width);
                lastX = xKey;
                lastWidth = width;
            }
            if (!StringUtils.isNotBlank((CharSequence)everyContent)) continue;
            OfdReadUtils.setSortContentData(secondSortMap, xFirst, yKey, totalWidth, everyContent, 5);
        }
        return secondSortMap;
    }

    private static InvoiceTypeEnum getInvoiceType(Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap) {
        for (Map.Entry<BigDecimal, Map<BigDecimal, TextCode>> secondSortEntity : secondSortMap.entrySet()) {
            Map<BigDecimal, TextCode> codeMap = secondSortEntity.getValue();
            for (Map.Entry<BigDecimal, TextCode> codeEntry : codeMap.entrySet()) {
                String content = codeEntry.getValue().getContent();
                InvoiceTypeEnum typeEnum = InvoiceTypeEnum.getByDesc(content);
                if (typeEnum == null) continue;
                return typeEnum;
            }
        }
        return null;
    }

    public static JSONObject getDataJsonByList(List<List<TextCode>> contentList) {
        JSONObject dataJson = new JSONObject();
        Map<String, TextCode> specialMap = OfdReadUtils.getSpecialMap(contentList);
        StringBuilder sb = new StringBuilder();
        contentList.forEach(list -> {
            BigDecimal x = BigDecimal.ZERO;
            BigDecimal y = BigDecimal.ZERO;
            BigDecimal width = BigDecimal.ZERO;
            StringBuilder lineStr = new StringBuilder();
            for (TextCode code : list) {
                if (x.compareTo(BigDecimal.ZERO) == 0) {
                    x = code.getX();
                    y = code.getY();
                }
                String specialCode = null;
                String content = code.getContent();
                BigDecimal currentX = code.getX();
                if (("\u5bc6".equals(content) || content.contains("\u5bc6\u7801\u533a")) && currentX.compareTo(new BigDecimal("300")) > 0) {
                    specialCode = SpecialCodeEnum.CODE_AREA.getCode();
                } else if ("\u8d2d".equals(content) && currentX.compareTo(new BigDecimal("60")) < 0) {
                    specialCode = SpecialCodeEnum.BUYER_INFO.getCode();
                } else if ("\u9500".equals(content)) {
                    specialCode = SpecialCodeEnum.SALER_INFO.getCode();
                }
                if (specialCode != null) {
                    specialMap.putIfAbsent(specialCode, new TextCode(code.getX(), code.getY(), width, content));
                }
                width = code.getX().add(code.getWidth()).subtract(x);
                if (lineStr.toString().startsWith(SpecialCodeEnum.COMBINE_TOTAL.getDesc()) && !content.startsWith("\u00a5")) {
                    content = "\u00a5" + content;
                }
                lineStr.append(content);
            }
            OfdReadUtils.setSpecialMap(specialMap, lineStr.toString(), x, y, width);
            sb.append((CharSequence)lineStr).append("\r\n");
        });
        dataJson.put("allText", (Object)sb.toString());
        dataJson.put("specialMap", specialMap);
        return dataJson;
    }

    private static Map<String, TextCode> getSpecialMap(List<List<TextCode>> contentList) {
        HashMap<String, TextCode> specialMap = new HashMap<String, TextCode>();
        TreeMap xCodeMap = new TreeMap();
        contentList.forEach(codeList -> codeList.forEach(code -> {
            String content = code.getContent();
            if (DigitalPdfConstants.SPECIAL_KEYS.contains(content) || DigitalPdfConstants.SPECIAL_STR_KEYS.contains(content)) {
                OfdReadUtils.setXcodeMap(xCodeMap, code);
            }
        }));
        for (Map.Entry listEntry : xCodeMap.entrySet()) {
            StringBuilder contentBuilder = new StringBuilder();
            BigDecimal lastY = BigDecimal.ZERO;
            List currentList = (List)listEntry.getValue();
            TextCode firstCode = (TextCode)currentList.get(0);
            for (TextCode textCode : currentList) {
                if (lastY.compareTo(BigDecimal.ZERO) != 0 && lastY.subtract(textCode.getY()).abs().compareTo(new BigDecimal("50")) > 0) {
                    OfdReadUtils.setSpecialMap(specialMap, contentBuilder.toString(), firstCode);
                    contentBuilder = new StringBuilder();
                    firstCode = textCode;
                }
                contentBuilder.append(textCode.getContent());
                lastY = textCode.getY();
            }
            OfdReadUtils.setSpecialMap(specialMap, contentBuilder.toString(), firstCode);
        }
        return specialMap;
    }

    private static void setSpecialMap(Map<String, TextCode> specialMap, String content, TextCode code) {
        for (SpecialCodeEnum specialCodeEnum : DigitalPdfConstants.SPECIAL_ENUMS) {
            if (!content.startsWith(specialCodeEnum.getDesc())) continue;
            specialMap.put(specialCodeEnum.getCode(), code);
            break;
        }
    }

    private static void setXcodeMap(Map<BigDecimal, List<TextCode>> xCodeMap, TextCode code) {
        BigDecimal x = code.getX();
        List<TextCode> list = null;
        for (int i = 0; i < 6; ++i) {
            list = xCodeMap.get(x.add(new BigDecimal(i)));
            if (list != null) {
                x = x.add(new BigDecimal(i));
                break;
            }
            list = xCodeMap.get(x.subtract(new BigDecimal(i)));
            if (list == null) continue;
            x = x.subtract(new BigDecimal(i));
            break;
        }
        if (list == null) {
            list = new ArrayList<TextCode>();
        }
        list.add(code);
        xCodeMap.put(x, list);
    }

    public static void setSpecialMap(Map<String, TextCode> specialMap, String str, BigDecimal x, BigDecimal y, BigDecimal width) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return;
        }
        SpecialCodeEnum specialCode = SpecialCodeEnum.getByDesc(str);
        if (specialCode != null) {
            TextCode pdfTextCode = new TextCode(x, y, width, str);
            String code = specialCode.getCode();
            if (SpecialCodeEnum.BANK_ACCOUNT == specialCode) {
                code = !specialMap.containsKey(SpecialCodeEnum.BUYER_ACCOUNT.getCode()) ? SpecialCodeEnum.BUYER_ACCOUNT.getCode() : SpecialCodeEnum.SALER_ACCOUNT.getCode();
            }
            specialMap.putIfAbsent(code, pdfTextCode);
        }
    }

    public static void setSortContentData(Map<BigDecimal, Map<BigDecimal, TextCode>> contentMap, BigDecimal x, BigDecimal y, BigDecimal width, String content, int diff) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return;
        }
        Map<BigDecimal, TextCode> xMap = contentMap.get(y);
        BigDecimal currentY = y;
        for (int i = 1; i <= diff && xMap == null; ++i) {
            currentY = y.subtract(new BigDecimal(i));
            xMap = contentMap.get(currentY);
        }
        if (xMap != null) {
            if (xMap.containsKey(x)) {
                TextCode code = xMap.get(x);
                code.setWidth(code.getWidth().add(width));
                code.setContent(code.getContent() + content);
                return;
            }
            if (diff != 2) {
                for (Map.Entry<BigDecimal, TextCode> codeEntry : xMap.entrySet()) {
                    TextCode code = codeEntry.getValue();
                    BigDecimal widthPre = code.getWidth();
                    BigDecimal subtractDiff = new BigDecimal("0.5");
                    int contentLength = code.getContent().length();
                    if (widthPre.divide(new BigDecimal(contentLength), 0, RoundingMode.HALF_UP).compareTo(new BigDecimal("11")) >= 0) {
                        subtractDiff = new BigDecimal("3");
                    }
                    BigDecimal xPre = code.getX();
                    BigDecimal length = xPre.add(widthPre);
                    if (xPre.compareTo(x) == 0 || x.subtract(length).abs().compareTo(subtractDiff) < 0) {
                        code.setWidth(widthPre.add(width));
                        code.setContent(code.getContent() + content);
                        return;
                    }
                    if (!DigitalPdfConstants.INFO_KEYS.contains(code.getContent())) continue;
                    xMap = null;
                    break;
                }
            }
        }
        if (xMap == null) {
            currentY = y;
            xMap = contentMap.computeIfAbsent(y, k -> new TreeMap());
        }
        xMap.put(x, new TextCode(x, currentY, width, content));
    }

    public static List<List<TextCode>> getListByMap(Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap) {
        ArrayList<List<TextCode>> list = new ArrayList<List<TextCode>>(secondSortMap.size());
        for (Map.Entry<BigDecimal, Map<BigDecimal, TextCode>> secondSortEntry : secondSortMap.entrySet()) {
            Map<BigDecimal, TextCode> xMap = secondSortEntry.getValue();
            ArrayList<TextCode> xList = new ArrayList<TextCode>(xMap.size());
            for (Map.Entry<BigDecimal, TextCode> xMapEntry : xMap.entrySet()) {
                xList.add(xMapEntry.getValue());
            }
            list.add(xList);
        }
        return list;
    }

    public static List<List<TextCode>> getListByMap(Element pageEle) {
        Map<BigDecimal, Map<BigDecimal, TextCode>> coordinateMap = OfdReadUtils.firstSort(pageEle);
        Map<BigDecimal, Map<BigDecimal, TextCode>> secondSortMap = OfdReadUtils.secondSort(coordinateMap);
        return OfdReadUtils.getListByMap(secondSortMap);
    }

    public static String replaceSpecailChar(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        str = str.replaceAll(" ", "").replaceAll("\u3000", "").replaceAll("\uff08", "(").replaceAll("\uff09", ")").replaceAll("\uff1a", ":").replaceAll(" ", "");
        str = OfdReadUtils.replaceSpecailCharNoBlank(str);
        return str;
    }

    public static String replaceSpecailCharNoBlank(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        str = str.replaceAll("\uffe5", "\u00a5").replaceAll("\u00a0", "").replaceAll("\uff0a", "*").replaceAll("\u2f08", "\u4eba").replaceAll("\u2f47", "\u65e5").replaceAll("\u2f6c", "\u76ee").replaceAll("\u2fa6", "\u91d1").replaceAll("\u2f29", "\u5c0f").replaceAll("\u2f45", "\u65b9").replaceAll("\u4fe1", "\u4fe1").replaceAll("\u2f24", "\u5927").replaceAll("\u2ec6", "\u89d2").replaceAll("\u2ecb", "\u8f66").replaceAll("\u2ed4", "\u95e8").replaceAll("\u2f34", "\u5e7f").replaceAll("\u2f3e", "\u6237").replaceAll("\u2f8f", "\u884c").replaceAll("\u2f2f", "\u5de5").replaceAll("\u2fa5", "\u91cc").replaceAll("\u2fbc", "\u9ad8").replaceAll("\u2ee9", "\u9ec4").replaceAll("\u2f64", "\u7528").replaceAll("\u2ef0", "\u9f99").replaceAll("\u2f6f", "\u77f3").replaceAll("\u2f69", "\u767d").replaceAll("\u2f40", "\u652f").replaceAll("\u2f65", "\u7530").replaceAll("\u2f54", "\u6c34").replaceAll("\u2ea0", "\u6c11").replaceAll("\u2f9a", "\u8d64").replaceAll("\u2fa6", "\u91d1").replaceAll("\u2ec1", "\u864e").replaceAll("\u2fcd", "\u9f0e").replaceAll("\u2ee2", "\u9a6c").replaceAll("\u2ed8", "\u9752").replaceAll("\u2f3c", "\u5fc3").replaceAll("\u2f7a", "\u7f8a");
        return str;
    }

    public static Map<BigDecimal, Map<BigDecimal, TextCode>> firstSort(Element svgEle) {
        TreeMap<BigDecimal, Map<BigDecimal, TextCode>> map = new TreeMap<BigDecimal, Map<BigDecimal, TextCode>>();
        List elements = svgEle.elements("text");
        for (Element element : elements) {
            BigDecimal lastX = BigDecimal.ZERO;
            String text = element.getText();
            List tspanList = element.elements("tspan");
            boolean firstFlag = true;
            if (tspanList != null && !tspanList.isEmpty()) {
                for (int i = 0; i < tspanList.size(); ++i) {
                    Element tspan = (Element)tspanList.get(i);
                    BigDecimal currentX = new BigDecimal(tspan.attributeValue("x").replace("mm", ""));
                    if (i == 0) {
                        Element nextTspan;
                        BigDecimal nextX;
                        BigDecimal thisWidth;
                        BigDecimal fontSize = new BigDecimal(element.attributeValue("font-size").replace("mm", ""));
                        if (tspanList.size() > 1 && (thisWidth = (nextX = new BigDecimal((nextTspan = (Element)tspanList.get(1)).attributeValue("x").replace("mm", ""))).subtract(currentX)).subtract(fontSize).abs().compareTo(new BigDecimal("2")) <= 0) {
                            firstFlag = false;
                            OfdReadUtils.setContentData(map, element, thisWidth, currentX, tspan.getText() + nextTspan.getText());
                            lastX = nextX;
                            ++i;
                            continue;
                        }
                    }
                    BigDecimal currentWidth = BigDecimal.ZERO;
                    if (!firstFlag && currentX.compareTo(BigDecimal.ZERO) != 0) {
                        currentWidth = currentX.subtract(lastX);
                    }
                    firstFlag = false;
                    OfdReadUtils.setContentData(map, element, currentWidth, currentX, tspan.getText());
                    lastX = currentX;
                }
                continue;
            }
            OfdReadUtils.setContentData(map, element, BigDecimal.ZERO, lastX, text);
        }
        return OfdReadUtils.sortMap(map);
    }

    private static void setContentData(Map<BigDecimal, Map<BigDecimal, TextCode>> map, Element element, BigDecimal currentWidth, BigDecimal lastX, String text) {
        BigDecimal width;
        BigDecimal x = new BigDecimal(element.attributeValue("x").replace("mm", ""));
        BigDecimal y = new BigDecimal(element.attributeValue("y").replace("mm", ""));
        BigDecimal fontSize = new BigDecimal(element.attributeValue("font-size").replace("mm", ""));
        String transform = element.attributeValue("transform");
        if (StringUtils.isNotEmpty((CharSequence)transform) && transform.contains("matrix")) {
            transform = transform.replace("matrix(", "").replace(")", "");
            String[] ctmStrArr = transform.split(" ");
            BigDecimal a = new BigDecimal(ctmStrArr[0]);
            BigDecimal b = new BigDecimal(ctmStrArr[1]);
            BigDecimal c = new BigDecimal(ctmStrArr[2]);
            BigDecimal d = new BigDecimal(ctmStrArr[3]);
            BigDecimal e = OfdReadUtils.pxToMm(new BigDecimal(ctmStrArr[4]));
            BigDecimal f = OfdReadUtils.pxToMm(new BigDecimal(ctmStrArr[5]));
            if (b.compareTo(BigDecimal.ZERO) != 0 || c.compareTo(BigDecimal.ZERO) != 0) {
                return;
            }
            x = a.multiply(x).add(e).setScale(6, RoundingMode.HALF_UP);
            y = d.multiply(y).add(f).setScale(6, RoundingMode.HALF_UP);
            fontSize = a.multiply(fontSize);
            currentWidth = BigDecimal.ZERO;
        }
        y = OfdReadUtils.mmToPx(y).setScale(0, RoundingMode.HALF_UP);
        x = OfdReadUtils.mmToPx(x).setScale(0, RoundingMode.HALF_UP);
        if (currentWidth.compareTo(BigDecimal.ZERO) == 0) {
            boolean containChinese = StrUtil.isContainChinese(text);
            if (!containChinese) {
                fontSize = fontSize.divide(new BigDecimal("2"), 6, RoundingMode.HALF_UP);
            }
            width = OfdReadUtils.mmToPx(fontSize).multiply(new BigDecimal(text.length())).setScale(2, RoundingMode.HALF_UP);
        } else {
            width = OfdReadUtils.mmToPx(currentWidth).setScale(2, RoundingMode.HALF_UP);
        }
        OfdReadUtils.setSortContentData(map, x, y, width, OfdReadUtils.replaceSpecailChar(text), 2);
    }

    private static Map<BigDecimal, Map<BigDecimal, TextCode>> sortMap(Map<BigDecimal, Map<BigDecimal, TextCode>> map) {
        TreeMap<BigDecimal, Map<BigDecimal, TextCode>> currentMap = new TreeMap<BigDecimal, Map<BigDecimal, TextCode>>();
        for (Map.Entry<BigDecimal, Map<BigDecimal, TextCode>> entry : map.entrySet()) {
            Map<BigDecimal, TextCode> codeMap = entry.getValue();
            for (Map.Entry<BigDecimal, TextCode> xEntry : codeMap.entrySet()) {
                TextCode code = xEntry.getValue();
                OfdReadUtils.setSortContentData(currentMap, code.getX(), code.getY(), code.getWidth(), code.getContent(), 2);
            }
        }
        return currentMap;
    }

    private static BigDecimal pxToMm(BigDecimal value) {
        return value.multiply(new BigDecimal("25.4")).divide(new BigDecimal("96"), 6, RoundingMode.HALF_UP);
    }

    private static BigDecimal mmToPx(BigDecimal value) {
        return value.multiply(new BigDecimal("72")).divide(new BigDecimal("25.4"), 6, RoundingMode.HALF_UP);
    }

    public static JSONObject getReturnJson(String type, String description, String error, Object data) {
        if ("1".equals(type)) {
            description = ResManager.loadKDString((String)"\u975e\u6570\u7535\u7968", (String)"OfdReadUtils_5", (String)"imc-rim-file", (Object[])new Object[0]);
        } else if ("2".equals(type)) {
            description = ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"OfdReadUtils_6", (String)"imc-rim-file", (Object[])new Object[0]);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("type", (Object)type);
        jsonObject.put("description", (Object)description);
        jsonObject.put("error", (Object)error);
        jsonObject.put("invoice", data);
        return jsonObject;
    }
}

