/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.ofd;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.config.exception.ReadException;
import kd.imc.aws.ofd.util.CompressHelper;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.aws.ofd.util.StrUtil;
import kd.imc.aws.ofd.util.XmlUtil;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class OfdReadUtil {
    private static Log LOGGER = LogFactory.getLog(OfdReadUtil.class);

    public static Map<String, Object> extractData(byte[] fileBytes) {
        byte[] invoiceByte;
        Document document;
        String rootName;
        byte[] documentByte;
        String attachmentsPath;
        byte[] ofdMainByte;
        String docRootPath;
        StringBuilder dirPath;
        String path;
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
        byte[] attachmentsByte = decompressFileMap.get(path = (dirPath = OfdReadUtil.getLastDirPath(docRootPath = OfdReadUtil.getTextByPath(ofdMainByte = decompressFileMap.get("OFD.xml"), "DocBody/DocRoot"))).append(attachmentsPath = OfdReadUtil.getTextByPath(documentByte = decompressFileMap.get(docRootPath), "Attachments")).toString().trim());
        String attachmentPath = OfdReadUtil.getTextByPath(attachmentsByte, "Attachment/FileLoc");
        if (attachmentPath == null) {
            attachmentPath = OfdReadUtil.getTextByPath(attachmentsByte, "Attachment/FileLoc");
        }
        if ("xbrl".equalsIgnoreCase(rootName = (document = OfdReadUtil.getDocumentByBytes(invoiceByte = decompressFileMap.get((dirPath = OfdReadUtil.getLastDirPath(path).append(attachmentPath)).toString()))).getRootElement().getQName().getName()) || !StringUtils.isEmpty((CharSequence)attachmentPath) && attachmentPath.toLowerCase(Locale.ROOT).endsWith("xbrl")) {
            String fileName = attachmentPath;
            String[] attachmentArr = attachmentPath.split("/");
            if (attachmentArr.length > 0) {
                fileName = attachmentArr[attachmentArr.length - 1];
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("file_type", "xbrl");
            dataMap.put("file_data", document.asXML());
            dataMap.put("file_name", fileName);
            return dataMap;
        }
        return OfdReadUtil.getInvoiceMap(invoiceByte);
    }

    public static Map<String, Object> extractDataFromAttachment(byte[] invoiceByte, String attachmentPath) {
        Document document = OfdReadUtil.getDocumentByBytes(invoiceByte);
        String rootName = document.getRootElement().getQName().getName();
        if ("xbrl".equalsIgnoreCase(rootName) || !StringUtils.isEmpty((CharSequence)attachmentPath) && attachmentPath.toLowerCase(Locale.ROOT).endsWith("xbrl")) {
            String fileName = attachmentPath;
            String[] attachmentArr = attachmentPath.split("/");
            if (attachmentArr.length > 0) {
                fileName = attachmentArr[attachmentArr.length - 1];
            }
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("file_type", "xbrl");
            dataMap.put("file_data", document.asXML());
            dataMap.put("file_name", fileName);
            return dataMap;
        }
        Map<String, Object> invoiceMap = OfdReadUtil.getInvoiceMap(invoiceByte);
        invoiceMap.put("file_type", "xml");
        return invoiceMap;
    }

    public static Map<String, Object> extractAllElectricInvoiceData(byte[] fileBytes) {
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
        byte[] ofdMainByte = decompressFileMap.get("OFD.xml");
        return OfdReadUtil.getAllElectricInvoiceMap(ofdMainByte);
    }

    private static Map<String, Object> getAllElectricInvoiceMap(byte[] invoiceByte) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        try {
            Map<String, Object> map = XmlUtil.Dom2AllElectricInvoiceMap(invoiceByte);
            BigDecimal invoiceAmount = new BigDecimal((String)map.get("invoiceAmount"));
            BigDecimal totalTaxAmount = new BigDecimal((String)map.get("totalTaxAmount"));
            map.put("totalAmount", "\u00a5" + invoiceAmount.add(totalTaxAmount));
            map.put("invoiceAmount", "\u00a5" + invoiceAmount);
            map.put("totalTaxAmount", "\u00a5" + totalTaxAmount);
            map.put("invoiceType", "26");
            map.put("invoiceCode", "");
            map.put("buyerName", "");
            resultMap.put("invoice", map);
            resultMap.put("description", ResManager.loadKDString((String)"\u6570\u7535\u7968", (String)"OfdReadUtils_6", (String)"imc-rim-file", (Object[])new Object[0]));
            resultMap.put("type", "2");
            return resultMap;
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    public static Element parse(Element node, String type, String val) {
        Iterator iter = node.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            Attribute name = element.attribute(type);
            if (name == null) continue;
            String value = name.getValue();
            if (value != null && val.equals(value)) {
                return element;
            }
            OfdReadUtil.parse(element, type, val);
        }
        return null;
    }

    public static Map<String, Object> getInvoiceMap(byte[] invoiceByte) {
        try {
            Document document = OfdReadUtil.getDocumentByBytes(invoiceByte);
            String xml = document.asXML();
            return XmlUtil.Dom2Map(xml);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    public static Map<String, Object> getOfdContentTagMap(byte[] dataByte) {
        try {
            Document document = OfdReadUtil.getDocumentByBytes(dataByte);
            String xml = document.asXML();
            return XmlUtil.Dom2MapV2(xml);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    private static Document getDocumentByBytes(byte[] invoiceByte) {
        try {
            return XmlUtil.loadXML(invoiceByte);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, Element element, String dirPath) {
        String docPath = element.attributeValue("BaseLoc");
        if (docPath != null) {
            if (!docPath.contains(dirPath)) {
                docPath = dirPath + docPath;
            }
            if (docPath.startsWith("/")) {
                docPath = docPath.substring(1);
            }
        }
        return OfdReadUtil.getElementByByte(ofdFileMap.get(docPath));
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        return OfdReadUtil.getElementByByte(OfdReadUtil.getByteByPath(ofdFileMap, filePath));
    }

    public static byte[] getByteByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        if (filePath != null && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return ofdFileMap.get(filePath);
    }

    public static Element getElementByByte(byte[] fileByte) {
        try {
            if (fileByte == null || fileByte.length == 0) {
                return null;
            }
            Document document = XmlUtil.loadXML(fileByte);
            return document.getRootElement();
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new ReadException(OfdErrorType.LOAD_ERROR);
        }
    }

    public static StringBuilder getLastDirPath(String path) {
        String[] pathArr;
        StringBuilder buffer = new StringBuilder();
        for (String pathStr : pathArr = path.split("/")) {
            if (pathStr == null || pathStr.trim().equals("") || pathStr.contains(".")) continue;
            buffer.append(pathStr).append("/");
        }
        return buffer;
    }

    public static void getAllElementByElementName(Element parentElement, String elementName, String moreElementName, List<Element> targetList) {
        try {
            List moreElementList;
            List elementList = parentElement.elements(elementName);
            if (elementList != null && !elementList.isEmpty()) {
                targetList.addAll(elementList);
            }
            if ((moreElementList = parentElement.elements(moreElementName)) != null && !moreElementList.isEmpty()) {
                for (Element moreElement : moreElementList) {
                    OfdReadUtil.getAllElementByElementName(moreElement, elementName, moreElementName, targetList);
                }
            }
        }
        catch (Exception e) {
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    public static String getDirPath(String path, String lastPath) {
        if (!StrUtil.isEmpty(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!StrUtil.isEmpty(lastPath) && !path.startsWith(lastPath = OfdReadUtil.getLastDirPath(lastPath).toString())) {
                path = lastPath + path;
            }
        }
        return path;
    }

    public static String getTextByPath(byte[] fileByte, String path) {
        String text;
        try {
            String[] dirArr;
            Element elementNow = OfdReadUtil.getElementByByte(fileByte);
            for (String dir : dirArr = path.split("/")) {
                String[] arr;
                boolean moreFlag = false;
                if (dir.contains("|||") && (arr = dir.split("\\|\\|\\|")) != null && arr.length == 2) {
                    List elementList = elementNow.elements(arr[0]);
                    for (Element e : elementList) {
                        if (!arr[1].equals(e.attributeValue("Name"))) continue;
                        elementNow = e;
                        moreFlag = true;
                        break;
                    }
                }
                if (moreFlag) continue;
                if (elementNow.element(dir) != null) {
                    elementNow = elementNow.element(dir);
                    continue;
                }
                return null;
            }
            text = elementNow.getText();
            text = OfdReadUtil.removeStartSymbol(text, "/");
        }
        catch (Exception e) {
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
        return text;
    }

    private static String removeStartSymbol(String str, String symbol) {
        while (!StrUtil.isEmpty(str) && str.startsWith(symbol)) {
            str = str.substring(1);
        }
        return str;
    }

    public static int getPageNum(byte[] fileBytes) {
        try {
            Map<String, byte[]> ofdFileMap = CompressHelper.decompress(fileBytes);
            byte[] ofdMainByte = ofdFileMap.get("OFD.xml");
            String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
            byte[] documentByte = ofdFileMap.get(docRootPath);
            Element documentEle = OfdReadUtil.getElementByByte(documentByte);
            if (documentEle != null) {
                Element pagesEle = documentEle.element("Pages");
                List pageEleList = pagesEle.elements("Page");
                return pageEleList.size();
            }
            return 1;
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }
}

