/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.aws.ofd.util.ofd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.config.exception.VerifyException;
import kd.imc.aws.ofd.util.Base64Util;
import kd.imc.aws.ofd.util.CompressHelper;
import kd.imc.aws.ofd.util.DLTaggedObjectUtils;
import kd.imc.aws.ofd.util.HexUtil;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.aws.ofd.util.SM3Util;
import kd.imc.aws.ofd.util.ofd.OfdReadUtil;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.DLTaggedObject;
import org.dom4j.Element;

public class OfdSignUtil {
    private static Log LOGGER = LogFactory.getLog(OfdSignUtil.class);

    public static Map<String, Object> verifySignAndGetCerInfo(byte[] fileBytes, boolean fullFlag, boolean taxFlag) {
        Map<String, Object> certMap;
        try {
            Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
            byte[] ofdMainByte = decompressFileMap.get("OFD.xml");
            String signaturesPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/Signatures");
            byte[] signaturesByte = decompressFileMap.get(signaturesPath);
            Element signaturesEle = OfdReadUtil.getElementByByte(signaturesByte);
            String maxSignId = signaturesEle.elementText("MaxSignId");
            String signaturePath = OfdSignUtil.getSignaturePath(maxSignId, signaturesEle);
            signaturePath = OfdReadUtil.getDirPath(signaturePath, signaturesPath);
            byte[] signatureByte = decompressFileMap.get(signaturePath);
            Element signatureEle = OfdReadUtil.getElementByByte(signatureByte);
            Element signedInfoEle = signatureEle.element("SignedInfo");
            Element referencesEle = signedInfoEle.element("References");
            String checkMethod = referencesEle.attributeValue("CheckMethod");
            OfdSignUtil.checkHashValue(referencesEle, checkMethod, decompressFileMap);
            String signedValuePath = signatureEle.elementText("SignedValue");
            signedValuePath = OfdReadUtil.getDirPath(signedValuePath, signaturePath);
            byte[] signedValueByte = decompressFileMap.get(signedValuePath);
            certMap = OfdSignUtil.checkSignValue(signedValueByte, SM3Util.doDigestToBase64Str(signatureByte), fullFlag, taxFlag);
        }
        catch (Exception e) {
            throw new VerifyException(OfdErrorType.CHECK_SIGN_ERROR.getErrcode(), String.format(ResManager.loadKDString((String)"\u9a8c\u7b7e\u5931\u8d25:%1$s", (String)"OfdSignUtil_1", (String)"imc-rim-file", (Object[])new Object[0]), e.getMessage()));
        }
        return certMap;
    }

    public static boolean verifySign(byte[] fileBytes, boolean taxFlag) {
        OfdSignUtil.verifySignAndGetCerInfo(fileBytes, false, taxFlag);
        return true;
    }

    private static String getSignaturePath(String maxSignId, Element signaturesEle) {
        String signaturePath = null;
        if (maxSignId != null && !"".equals(maxSignId.trim())) {
            List signaturesEleList = signaturesEle.elements("Signature");
            for (Element signatureEle : signaturesEleList) {
                if (!maxSignId.equals(signatureEle.attributeValue("ID"))) continue;
                signaturePath = signatureEle.attributeValue("BaseLoc");
                break;
            }
        }
        if (signaturePath == null && signaturesEle != null) {
            signaturePath = signaturesEle.element("Signature").attributeValue("BaseLoc");
        }
        if (signaturePath != null && signaturePath.startsWith("/")) {
            signaturePath = signaturePath.substring(1);
        }
        return signaturePath;
    }

    private static void checkHashValue(Element referencesEle, String checkMethod, Map<String, byte[]> decompressFileMap) {
        List elementList = referencesEle.elements("Reference");
        for (Element referenceEle : elementList) {
            String filePath = referenceEle.attributeValue("FileRef");
            String checkValue = referenceEle.elementText("CheckValue");
            if (filePath.startsWith("/")) {
                filePath = filePath.substring(1);
            }
            byte[] fileByte = decompressFileMap.get(filePath);
            String hashValue = null;
            if ("1.2.156.10197.1.401".equals(checkMethod) || "sm3".equalsIgnoreCase(checkMethod)) {
                hashValue = SM3Util.doDigestToBase64Str(fileByte);
            }
            if (hashValue == null || hashValue.equals(checkValue)) continue;
            LOGGER.error(OfdErrorType.HASH_NOT_CORRECT.toString());
            throw new VerifyException(OfdErrorType.HASH_NOT_CORRECT);
        }
    }

    private static Map<String, Object> checkSignValue(byte[] signFileByte, String signFileHash, boolean fullFlag, boolean taxFlag) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
            ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
            ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
            ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
            if (asn1Sequence.getObjectAt(0) instanceof ASN1ObjectIdentifier) {
                return OfdSignUtil.checkStandardSignValue(asn1Sequence, signFileHash, fullFlag, taxFlag);
            }
            ASN1Sequence sealInfoSeq = (ASN1Sequence)asn1Sequence.getObjectAt(0);
            Map<String, Object> certMap = null;
            try {
                ASN1Encodable cerObject = asn1Sequence.getObjectAt(1);
                DEROctetString cerStr = cerObject instanceof DEROctetString ? (DEROctetString)cerObject : (DEROctetString)sealInfoSeq.getObjectAt(5);
                certMap = OfdSignUtil.checkCertIsTrue(cerStr.getOctets(), fullFlag, taxFlag);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u7b7e\u7ae0\u8bc1\u4e66\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            DERBitString hashDer = (DERBitString)sealInfoSeq.getObjectAt(3);
            String originalHash = Base64Util.base64encoder(hashDer.getBytes());
            if (!originalHash.equals(signFileHash)) {
                LOGGER.error(OfdErrorType.HASH_NOT_CORRECT.getDescription());
                throw new VerifyException(OfdErrorType.HASH_NOT_CORRECT);
            }
            return certMap;
        }
        catch (VerifyException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(OfdErrorType.CHECK_SIGN_ERROR.toString(), (Throwable)e);
            throw new VerifyException(OfdErrorType.CHECK_SIGN_ERROR);
        }
    }

    private static Map<String, Object> checkStandardSignValue(ASN1Sequence asn1Sequence, String signFileHash, boolean fullFlag, boolean taxFlag) {
        DLSequence signedDataSeq = (DLSequence)DLTaggedObjectUtils.getObject((ASN1TaggedObject)((DLTaggedObject)asn1Sequence.getObjectAt(1)));
        DLSequence signerInfoSeq = (DLSequence)((DLSet)signedDataSeq.getObjectAt(4)).getObjectAt(0);
        DLSequence hashDataSeq = (DLSequence)DLTaggedObjectUtils.getObject((ASN1TaggedObject)((DLTaggedObject)signerInfoSeq.getObjectAt(3)));
        DLSet hashDataSet = (DLSet)((DLSequence)hashDataSeq.getObjectAt(2)).getObjectAt(1);
        byte[] hashDataBytes = ((DEROctetString)hashDataSet.getObjectAt(0)).getOctets();
        String hashDataBase64 = Base64Util.base64encoder(hashDataBytes);
        if (!hashDataBase64.equals(signFileHash)) {
            LOGGER.error(OfdErrorType.HASH_NOT_CORRECT.toString());
            throw new VerifyException(OfdErrorType.HASH_NOT_CORRECT);
        }
        return new HashMap<String, Object>();
    }

    private static byte[] getCertByte(byte[] derByte) throws IOException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(derByte);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)inStream);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        ASN1Sequence cerSeq = (ASN1Sequence)seq.getObjectAt(0);
        ASN1Sequence cerValueSeq = (ASN1Sequence)cerSeq.getObjectAt(6);
        return cerValueSeq.getEncoded();
    }

    private static Map<String, Object> getCertInfo(byte[] signFileByte, boolean fullFlag) throws IOException, ParseException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(signFileByte);
        ASN1StreamParser asn1StreamParser = new ASN1StreamParser((InputStream)inputStream);
        ASN1Encodable asn1Encodable = asn1StreamParser.readObject();
        ASN1Sequence asn1Sequence = (ASN1Sequence)asn1Encodable.toASN1Primitive();
        ASN1Sequence asn1Sequence0 = (ASN1Sequence)asn1Sequence.getObjectAt(0);
        if (asn1Sequence0.size() < 7) {
            return null;
        }
        ASN1Sequence extSeq = (ASN1Sequence)DLTaggedObjectUtils.getObject((ASN1TaggedObject)asn1Sequence0.getObjectAt(7));
        String issuedStr = null;
        if (extSeq != null) {
            ASN1Sequence issuedSeq = null;
            issuedSeq = extSeq.size() == 13 ? (ASN1Sequence)extSeq.getObjectAt(2) : (ASN1Sequence)extSeq.getObjectAt(4);
            if (issuedSeq == null || !"2.5.29.35".equals(issuedSeq.getObjectAt(0))) {
                for (int i = 0; i < extSeq.size(); ++i) {
                    String identifiesStr = ((ASN1Sequence)extSeq.getObjectAt(i)).getObjectAt(0).toString();
                    if (!"2.5.29.35".equals(identifiesStr)) continue;
                    issuedSeq = (ASN1Sequence)extSeq.getObjectAt(i);
                    break;
                }
            }
            if (issuedSeq != null) {
                issuedStr = HexUtil.encodeHexStr(((ASN1OctetString)issuedSeq.getObjectAt(1)).getOctets()).substring(8);
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap<String, String> issuedMap = new HashMap<String, String>();
        issuedMap.put("FINGER_PRINT", issuedStr);
        if (fullFlag) {
            ASN1Sequence issuedSeq = (ASN1Sequence)asn1Sequence0.getObjectAt(3);
            String inssuedCStr = OfdSignUtil.getCertInfoStrBySeq(issuedSeq, 0);
            String inssuedOUStr = OfdSignUtil.getCertInfoStrBySeq(issuedSeq, 1);
            String inssuedCNStr = OfdSignUtil.getCertInfoStrBySeq(issuedSeq, 2);
            issuedMap.put("C", inssuedCStr);
            issuedMap.put("OU", inssuedOUStr);
            issuedMap.put("CN", inssuedCNStr);
            ASN1Sequence validitySeq = (ASN1Sequence)asn1Sequence0.getObjectAt(4);
            Date certStartDate = ((ASN1UTCTime)validitySeq.getObjectAt(0)).getDate();
            Date certEndDate = ((ASN1UTCTime)validitySeq.getObjectAt(1)).getDate();
            issuedMap.put("START_TIME", String.valueOf(certStartDate.getTime()));
            issuedMap.put("END_TIME", String.valueOf(certEndDate.getTime()));
            ASN1Sequence useSeq = (ASN1Sequence)asn1Sequence0.getObjectAt(5);
            String useCStr = OfdSignUtil.getCertInfoStrBySeq(useSeq, 0);
            String useOUStr = OfdSignUtil.getCertInfoStrBySeq(useSeq, 1);
            String useCNStr = OfdSignUtil.getCertInfoStrBySeq(useSeq, 2);
            HashMap<String, String> userMap = new HashMap<String, String>();
            userMap.put("C", useCStr);
            userMap.put("OU", useOUStr);
            userMap.put("CN", useCNStr);
            String userStr = HexUtil.encodeHexStr(((ASN1OctetString)((ASN1Sequence)extSeq.getObjectAt(3)).getObjectAt(1)).getOctets()).substring(4);
            userMap.put("FINGER_PRINT", userStr);
            paramMap.put("userInfo", userMap);
        }
        paramMap.put("issuedInfo", issuedMap);
        return paramMap;
    }

    private static Map<String, Object> checkCertIsTrue(byte[] signFileByte, boolean fullFlag, boolean taxFlag) {
        Map issuedInfoMap;
        String issuedStr;
        Map<String, Object> certInfoMap;
        try {
            certInfoMap = OfdSignUtil.getCertInfo(signFileByte, fullFlag);
        }
        catch (IOException | ParseException e) {
            LOGGER.error(OfdErrorType.SIGN_READ_CERT_ERROR.toString());
            throw new VerifyException(OfdErrorType.SIGN_READ_CERT_ERROR);
        }
        if (taxFlag && !"b8b09a6007ea05b7b0b7e7cb42763129971576b3".equals(issuedStr = (String)(issuedInfoMap = (Map)certInfoMap.get("issuedInfo")).get("FINGER_PRINT")) && !"1fe6cfd48fc5222a974a298a15e716c99234c4b6".equals(issuedStr)) {
            LOGGER.error(OfdErrorType.SIGN_CERT_NOT_CORRECT.toString());
            throw new VerifyException(OfdErrorType.SIGN_CERT_NOT_CORRECT);
        }
        return certInfoMap;
    }

    private static String getCertInfoStrBySeq(ASN1Sequence issuedSeq, int index) {
        String str = null;
        if (issuedSeq != null && issuedSeq.size() > index) {
            str = ((ASN1Sequence)((ASN1Set)issuedSeq.getObjectAt(index)).getObjectAt(0)).getObjectAt(1).toString();
        }
        return str;
    }
}

