/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.model.ofd;

import java.util.List;
import java.util.stream.Collectors;
import kd.imc.rim.file.model.ofd.OfdTextObject;

public class OfdTextObjectBlock {
    private String id;
    private double starterCoordinateX;
    private double starterCoordinateY;
    private double totalOffsetX;
    private double totalOffsetY;
    private String textCodeValue;
    private List<OfdTextObject> textObjects;

    public OfdTextObjectBlock(List<OfdTextObject> textObjects, String id) {
        this.textObjects = textObjects;
        this.starterCoordinateX = textObjects.get(0).getCoordinateX();
        this.starterCoordinateY = textObjects.get(0).getCoordinateY();
        this.totalOffsetX = textObjects.stream().mapToDouble(OfdTextObject::getOffsetX).sum();
        this.totalOffsetY = textObjects.stream().mapToDouble(OfdTextObject::getCoordinateY).sum();
        this.textCodeValue = textObjects.stream().map(OfdTextObject::getTextCodeValue).collect(Collectors.joining());
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getStarterCoordinateX() {
        return this.starterCoordinateX;
    }

    public void setStarterCoordinateX(float starterCoordinateX) {
        this.starterCoordinateX = starterCoordinateX;
    }

    public double getStarterCoordinateY() {
        return this.starterCoordinateY;
    }

    public void setStarterCoordinateY(float starterCoordinateY) {
        this.starterCoordinateY = starterCoordinateY;
    }

    public double getTotalOffsetX() {
        return this.totalOffsetX;
    }

    public void setTotalOffsetX(double totalOffsetX) {
        this.totalOffsetX = totalOffsetX;
    }

    public double getTotalOffsetY() {
        return this.totalOffsetY;
    }

    public void setTotalOffsetY(double totalOffsetY) {
        this.totalOffsetY = totalOffsetY;
    }

    public String getTextCodeValue() {
        return this.textCodeValue;
    }

    public void setTextCodeValue(String textCodeValue) {
        this.textCodeValue = textCodeValue;
    }

    public List<OfdTextObject> getTextObjects() {
        return this.textObjects;
    }

    public void setTextObjects(List<OfdTextObject> textObjects) {
        this.textObjects = textObjects;
    }
}

