/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.StringJoiner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.PdfUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.PDFAnalysisUtil;
import kd.imc.rim.file.utils.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public class PdfAnalysisService {
    private static Log logger = LogFactory.getLog(PdfAnalysisService.class);
    public static final String IS_NOT_ELECTRIC = "1";
    public static final String IS_ELECTRIC = "2";

    public static JSONObject analysis(PDDocument document) {
        try {
            JSONObject invoiceData = PDFAnalysisUtil.analysisAllDP(document);
            if (IS_ELECTRIC.equals(invoiceData.getString("type"))) {
                String result;
                JSONObject invoice = invoiceData.getJSONObject("invoice");
                String totalAmount = invoice.getString("totalAmount");
                String invoiceAmount = invoice.getString("invoiceAmount");
                String totalTaxAmount = invoice.getString("totalTaxAmount");
                if (totalAmount != null) {
                    invoice.put("totalAmount", (Object)totalAmount.replaceAll("\u00a5", ""));
                }
                if (invoiceAmount != null) {
                    invoice.put("invoiceAmount", (Object)invoiceAmount.replaceAll("\u00a5", ""));
                }
                if (totalTaxAmount != null) {
                    invoice.put("totalTaxAmount", (Object)totalTaxAmount.replaceAll("\u00a5", ""));
                }
                BigDecimal total1 = BigDecimalUtil.transDecimal(invoice.get((Object)"totalAmount"));
                BigDecimal total2 = BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")).add(BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount")));
                if (total1.compareTo(BigDecimal.ZERO) == 0 && total2.compareTo(BigDecimal.ZERO) != 0) {
                    invoice.put("totalAmount", (Object)total2);
                }
                if ((result = PdfAnalysisService.verifyInvoiceData(invoice)).length() != 0) {
                    logger.info("\u5168\u7535\u53d1\u7968\u6821\u9a8c\u5931\u8d25{},{}", (Object)result, (Object)invoice);
                    return JSON.parseObject((String)result);
                }
            }
            return invoiceData;
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790pdf\u5931\u8d25");
            return null;
        }
    }

    public static JSONObject analysis(byte[] fileBytes, boolean more) {
        try {
            return PdfUtil.getAllDigitalVatInvoice(fileBytes, more);
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790pdf\u5931\u8d25");
            return null;
        }
    }

    public static JSONObject fixInvoiceInfo(JSONObject invoice) {
        String result;
        if (invoice == null) {
            return new JSONObject();
        }
        String totalAmount = invoice.getString("totalAmount");
        String invoiceAmount = invoice.getString("invoiceAmount");
        String totalTaxAmount = invoice.getString("totalTaxAmount");
        if (totalAmount != null) {
            invoice.put("totalAmount", (Object)totalAmount.replaceAll("\u00a5", ""));
        }
        if (invoiceAmount != null) {
            invoice.put("invoiceAmount", (Object)invoiceAmount.replaceAll("\u00a5", ""));
        }
        if (totalTaxAmount != null) {
            invoice.put("totalTaxAmount", (Object)totalTaxAmount.replaceAll("\u00a5", ""));
        }
        BigDecimal total1 = BigDecimalUtil.transDecimal(invoice.get((Object)"totalAmount"));
        BigDecimal total2 = BigDecimalUtil.transDecimal(invoice.get((Object)"invoiceAmount")).add(BigDecimalUtil.transDecimal(invoice.get((Object)"totalTaxAmount")));
        if (total1.compareTo(BigDecimal.ZERO) == 0 && total2.compareTo(BigDecimal.ZERO) != 0) {
            invoice.put("totalAmount", (Object)total2);
        }
        if ((result = PdfAnalysisService.verifyInvoiceData(invoice)).length() != 0) {
            logger.info("\u5168\u7535\u53d1\u7968\u6821\u9a8c\u5931\u8d25{},{}", (Object)result, (Object)invoice);
        }
        return invoice;
    }

    private static String verifyInvoiceData(JSONObject invoiceData) {
        StringJoiner result = new StringJoiner("|");
        if (invoiceData != null) {
            if (!StringUtils.isNotBlank((CharSequence)invoiceData.getString("invoiceNo"))) {
                result.add("invoiceNo");
            }
            if (!StringUtils.isNotBlank((CharSequence)invoiceData.getString("invoiceDate"))) {
                result.add("invoiceDate");
            }
        }
        return result.toString();
    }
}

