/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.pdfanalysis.utils.analysis.PDFAnalysisUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfReadUtil;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.PdfTextCode;
import kd.imc.rim.file.pdfanalysis.utils.analysis.digital.VatInvoice;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;

public class PdfExtractUtil {
    private static Log logger = LogFactory.getLog(PdfExtractUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JSONObject extractJSON(byte[] fileBytes) {
        try (PDDocument document = PDDocument.load((byte[])fileBytes);){
            JSONObject jSONObject = PDFAnalysisUtil.readReceiptPdfByAllDP(document);
            return jSONObject;
        }
        catch (IOException e) {
            logger.info("Exception while trying to read pdf document - " + e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] extractXbrl(byte[] fileBytes) {
        try (PDDocument document = PDDocument.load((byte[])fileBytes);){
            byte[] byArray = PdfExtractUtil.extractXbrl(document);
            return byArray;
        }
        catch (IOException e) {
            logger.info("Exception while trying to read pdf document - " + e);
            return null;
        }
    }

    protected static byte[] extractXbrl(PDDocument document) {
        try {
            PDDocumentNameDictionary namesDictionary = new PDDocumentNameDictionary(document.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode efTree = namesDictionary.getEmbeddedFiles();
            if (efTree != null) {
                Map names = efTree.getNames();
                if (names != null) {
                    return PdfExtractUtil.extractXbrlFiles(names);
                }
                List kids = efTree.getKids();
                Iterator iterator = kids.iterator();
                if (iterator.hasNext()) {
                    PDNameTreeNode node = (PDNameTreeNode)iterator.next();
                    names = node.getNames();
                    return PdfExtractUtil.extractXbrlFiles(names);
                }
            }
        }
        catch (IOException e) {
            logger.info("Exception while trying to read pdf document - " + e);
        }
        return null;
    }

    protected static byte[] extractFiles(Map<String, PDComplexFileSpecification> names, String fileEnd) throws IOException {
        for (Map.Entry<String, PDComplexFileSpecification> entry : names.entrySet()) {
            PDComplexFileSpecification fileSpec = entry.getValue();
            String filename = fileSpec.getFile();
            String fileType = PdfExtractUtil.getFileType(filename);
            if (filename == null || !fileType.equalsIgnoreCase(fileEnd)) continue;
            PDEmbeddedFile embeddedFile = PdfExtractUtil.getEmbeddedFile(fileSpec);
            return embeddedFile.toByteArray();
        }
        return null;
    }

    public static String getFileType(String fileName) {
        if (fileName == null) {
            return "";
        }
        int index = fileName.lastIndexOf(46);
        int length = fileName.length();
        if (index <= 0 || length - index < 1) {
            return "";
        }
        String type = fileName.substring(index + 1, length);
        return type;
    }

    protected static byte[] extractXbrlFiles(Map<String, PDComplexFileSpecification> names) throws IOException {
        return PdfExtractUtil.extractFiles(names, "xbrl");
    }

    protected static PDEmbeddedFile getEmbeddedFile(PDComplexFileSpecification fileSpec) {
        PDEmbeddedFile embeddedFile = null;
        if (fileSpec != null) {
            embeddedFile = fileSpec.getEmbeddedFileUnicode();
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileDos();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileMac();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFileUnix();
            }
            if (embeddedFile == null) {
                embeddedFile = fileSpec.getEmbeddedFile();
            }
        }
        return embeddedFile;
    }

    public static JSONObject getPageCodeNum(VatInvoice invoice, PDDocument document, int pageNo, String invoiceCodeReg, String[] invoiceCodeKeys) throws IOException {
        JSONObject result = new JSONObject();
        List<List<PdfTextCode>> contentList = PdfReadUtil.getContentListByPageNum(document, pageNo);
        JSONObject dataJson = PdfReadUtil.getDataJsonByList(contentList);
        String allText = dataJson.getString("allText");
        PdfReadUtil.setPatternMatchValue(invoice, allText, invoiceCodeReg, invoiceCodeKeys);
        result.put("invoiceCode", (Object)invoice.getInvoiceCode());
        result.put("invoiceNo", (Object)invoice.getInvoiceNo());
        return result;
    }

    public static JSONObject getPageCodeNum2(VatInvoice invoice, PDDocument document, int pageNo, String invoiceCodeReg, String[] invoiceCodeKeys) throws IOException {
        JSONObject result = new JSONObject();
        List<List<PdfTextCode>> contentList = PdfReadUtil.getContentListByPageNum(document, pageNo);
        JSONObject dataJson = PdfReadUtil.getDataJsonByList(contentList);
        String allText = dataJson.getString("allText");
        PdfReadUtil.setPatternMatchValue(invoice, allText, invoiceCodeReg, invoiceCodeKeys, false);
        result.put("invoiceCode", (Object)invoice.getInvoiceCode());
        result.put("invoiceNo", (Object)invoice.getInvoiceNo());
        return result;
    }
}

