/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberValidationUtils {
    private static boolean isMatch(String regex, String orginal) {
        if (orginal == null || orginal.trim().equals("")) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher isNum = pattern.matcher(orginal);
        return isNum.matches();
    }

    public static boolean isPositiveInteger(String orginal) {
        return NumberValidationUtils.isMatch("^\\+{0,1}[1-9]\\d*", orginal);
    }

    public static boolean isNegativeInteger(String orginal) {
        return NumberValidationUtils.isMatch("^-[1-9]\\d*", orginal);
    }

    public static boolean isWholeNumber(String orginal) {
        return NumberValidationUtils.isMatch("[+-]{0,1}0", orginal) || NumberValidationUtils.isPositiveInteger(orginal) || NumberValidationUtils.isNegativeInteger(orginal);
    }

    public static boolean isPositiveDecimal(String orginal) {
        return NumberValidationUtils.isMatch("\\+{0,1}[0]\\.[1-9]*|\\+{0,1}[1-9]\\d*\\.\\d*", orginal);
    }

    public static boolean isNegativeDecimal(String orginal) {
        return NumberValidationUtils.isMatch("^-[0]\\.[1-9]*|^-[1-9]\\d*\\.\\d*", orginal);
    }

    public static boolean isDecimal(String orginal) {
        return NumberValidationUtils.isMatch("[-+]{0,1}\\d+\\.\\d*|[-+]{0,1}\\d*\\.\\d+", orginal);
    }

    public static boolean isRealNumber(String orginal) {
        return NumberValidationUtils.isWholeNumber(orginal) || NumberValidationUtils.isDecimal(orginal);
    }

    public static String scientificChange(String str) {
        if ((str = str.trim().replaceAll(" ", "")).indexOf("E") > -1) {
            BigDecimal bd = new BigDecimal(str);
            return bd.toPlainString();
        }
        if (NumberValidationUtils.isRealNumber(str)) {
            return str;
        }
        return "";
    }
}

