/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.imc.rim.file.pdfanalysis.model.ReceiptPosition;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PDFTextStripperNew
extends PDFTextStripper {
    private List<ReceiptPosition> posList = new ArrayList<ReceiptPosition>();

    protected List<ReceiptPosition> getPosList() {
        return this.posList;
    }

    protected void processTextPosition(TextPosition pos) {
        float posEndX = pos.getEndX();
        float posEndY = pos.getEndY();
        float posX = pos.getX();
        String text = pos.getUnicode();
        boolean hasData = false;
        for (ReceiptPosition item : this.posList) {
            String textItem;
            if (!(Math.abs(item.getPosLastY() - posEndY) < 1.0f) || !(Math.abs(item.getPosLastX() - posX) < 1.0f) && !(Math.abs(item.getPosLastX() - posEndX) < 1.0f) || (textItem = item.getText()).endsWith(":") || textItem.indexOf("\u7a0e\u7387") > -1 || textItem.indexOf("(\u5c0f\u5199)") > -1 || textItem.indexOf("\uff08\u5c0f\u5199\uff09") > -1 || textItem.indexOf("    ") > -1 && textItem.indexOf("\ufffd\ufffd") == -1) continue;
            if (Math.abs(item.getPosLastX() - posX) < 1.0f) {
                textItem = textItem + text;
                item.setPosLastX(posEndX);
            } else if (Math.abs(item.getPosLastX() - posEndX) < 1.0f) {
                textItem = text + textItem;
                item.setPosLastX(posX);
            }
            item.setText(textItem);
            hasData = true;
        }
        if (!hasData && StringUtils.isNotBlank((CharSequence)text)) {
            ReceiptPosition posItem = new ReceiptPosition();
            posItem.setText(text);
            posItem.setPosX(posX);
            posItem.setPosY(posEndY);
            posItem.setPosLastX(posEndX);
            posItem.setPosLastY(posEndY);
            this.posList.add(posItem);
        }
    }
}

