/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;

public class SortUtil {
    public static <V> void sort(List<V> list, final String ... properties) {
        Collections.sort(list, new Comparator<V>(){

            @Override
            public int compare(V o1, V o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                for (String property : properties) {
                    BeanComparator c = new BeanComparator(property);
                    int result = c.compare(o1, o2);
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }
        });
    }

    public static <V> void invertedSequenceSort(List<V> list, final String ... properties) {
        Collections.sort(list, new Comparator<V>(){

            @Override
            public int compare(V o2, V o1) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                for (String property : properties) {
                    try {
                        BeanComparator c = new BeanComparator(property);
                        int result = c.compare(o1, o2);
                        if (result == 0) continue;
                        return result;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                return 0;
            }
        });
    }
}

