/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.pdfanalysis.utils.analysis.digital;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.ReflectionUtils;
import kd.imc.aws.ofd.config.exception.ReadException;
import kd.imc.aws.ofd.util.OfdErrorType;

public class ReflectUtil {
    private static final Map<Class<?>, List<Field>> FIELDS_CACHE = new HashMap();

    public static Object getFieldValue(Object obj, String fieldName) {
        Object result = null;
        Field field = ReflectUtil.getField(obj, fieldName);
        if (field != null) {
            try {
                result = field.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                JSONObject invoice = JSON.parseObject((String)JSON.toJSONString((Object)obj));
                result = invoice.get((Object)fieldName);
            }
        }
        return result;
    }

    public static Field getField(Object obj, String fieldName) {
        Field field = null;
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, String fieldValue) {
        Field field = ReflectUtil.getField(obj, fieldName);
        if (field != null) {
            try {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(obj, fieldValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        List<Field> fields = ReflectUtil.getFields(beanClass);
        for (Field field : fields) {
            if (!name.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static List<Field> getFields(Class<?> beanClass) throws SecurityException {
        List<Field> allFields = FIELDS_CACHE.get(beanClass);
        if (null != allFields && !allFields.isEmpty()) {
            return allFields;
        }
        allFields = ReflectUtil.getFieldsDirectly(beanClass, true);
        FIELDS_CACHE.put(beanClass, allFields);
        return allFields;
    }

    public static List<Field> getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        ArrayList<Field> allFields = null;
        Class<?> searchType = beanClass;
        while (searchType != null) {
            Field[] declaredFields = searchType.getDeclaredFields();
            if (null == allFields) {
                allFields = new ArrayList<Field>();
            }
            allFields.addAll(Arrays.asList(declaredFields));
            searchType = withSuperClassFields ? searchType.getSuperclass() : null;
        }
        return allFields;
    }

    public static void setFieldValue(Object obj, Field field, Object value) {
        try {
            ReflectionUtils.makeAccessible((Field)field);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getFieldValue(Object obj, Field field) {
        if (null == field) {
            return null;
        }
        if (obj instanceof Class) {
            obj = null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException var4) {
            throw new ReadException(OfdErrorType.EXTRACT_ERROR.getErrcode(), ResManager.loadKDString((String)"\u8bfb\u53d6\u5b57\u6bb5\u4fe1\u606f\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ReflectUtil_0", (String)"imc-rim-file", (Object[])new Object[0]));
        }
    }
}

