/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.Image;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.constant.ErrorCodeConstant;
import kd.imc.rim.file.model.protocol.COMMON_FPKJ_FPT;
import kd.imc.rim.file.model.protocol.COMMON_FPKJ_XMXX;
import kd.imc.rim.file.model.protocol.PdfProduceBean;
import kd.imc.rim.file.model.protocol.PdfReturnBean;
import kd.imc.rim.file.model.protocol.REQUEST_COMMON_FPKJ;
import kd.imc.rim.file.service.PdfService;
import kd.imc.rim.file.service.TaxCodeService;
import kd.imc.rim.file.service.TextFactory;
import kd.imc.rim.file.utils.Crc16Util;
import kd.imc.rim.file.utils.Handle;
import kd.imc.rim.file.utils.InvoiceConvertUtilv2;
import kd.imc.rim.file.utils.LoadFontUtils;
import kd.imc.rim.file.utils.QrcodeUtil;
import kd.imc.rim.file.utils.UUID;
import org.apache.commons.lang3.StringUtils;

public class PdfHandleService {
    private static final Log logger = LogFactory.getLog(PdfHandleService.class);
    private TaxCodeService iTaxCodeService = new TaxCodeService();
    private PdfService iPdfService = new PdfService();

    public byte[] generate(JSONObject invoice) {
        return this.generateInvoicePdf(PdfHandleService.createPdfRequest(invoice));
    }

    public static JSONObject createPdfRequest(JSONObject selfJson) {
        JSONObject succData = new JSONObject();
        succData.put("invoiceCode", (Object)selfJson.getString("invoiceCode"));
        succData.put("invoiceNo", (Object)selfJson.getString("invoiceNo"));
        succData.put("machineNo", (Object)selfJson.getString("machineNo"));
        succData.put("invoiceType", (Object)selfJson.getString("invoiceType"));
        succData.put("invoiceDate", (Object)selfJson.getString("invoiceDate"));
        succData.put("secret", (Object)"");
        succData.put("checkCode", (Object)selfJson.getString("checkCode"));
        succData.put("buyerName", (Object)selfJson.getString("buyerName").trim());
        succData.put("buyerTaxNo", (Object)selfJson.getString("buyerTaxNo").trim());
        succData.put("buyerAddressPhone", (Object)selfJson.getString("buyerAddressPhone").trim());
        succData.put("buyerAccount", (Object)selfJson.getString("buyerAccount").trim());
        succData.put("salerName", (Object)selfJson.getString("salerName").trim());
        succData.put("salerTaxNo", (Object)selfJson.getString("salerTaxNo").trim());
        succData.put("salerAddressPhone", (Object)selfJson.getString("salerAddressPhone").trim());
        succData.put("salerAccount", (Object)selfJson.getString("salerAccount").trim());
        succData.put("totalPriceTax", (Object)selfJson.getString("totalAmount").trim());
        if ("5".equals(selfJson.getString("invoiceType"))) {
            succData.put("totalAmount", (Object)selfJson.getString("totalAmount").trim());
        } else {
            succData.put("totalAmount", (Object)selfJson.getString("invoiceAmount").trim());
        }
        succData.put("totalTax", (Object)selfJson.getString("totalTaxAmount").trim());
        succData.put("remark", (Object)selfJson.getString("remark"));
        succData.put("payee", (Object)selfJson.getString("payee").trim());
        succData.put("reviewer", (Object)selfJson.getString("reviewer").trim());
        succData.put("drawer", (Object)selfJson.getString("drawer").trim());
        succData.put("invoiceType", (Object)"0");
        succData.put("type", (Object)selfJson.getString("type"));
        succData.put("originalinvoiceCode", (Object)"");
        succData.put("originalinvoiceNo", (Object)"");
        JSONArray serviceArr = selfJson.getJSONArray("items");
        JSONArray itemsArr = new JSONArray();
        DecimalFormat decimalFormat = new DecimalFormat("#0.##%");
        if (serviceArr != null) {
            if (serviceArr.size() > 0) {
                for (int i = 0; i < serviceArr.size(); ++i) {
                    String taxRate;
                    String vehPlate;
                    String endDate;
                    JSONObject itemsucc = serviceArr.getJSONObject(i);
                    JSONObject itemData = new JSONObject();
                    itemData.put("goodsName", (Object)itemsucc.getString("goodsName"));
                    itemData.put("num", (Object)itemsucc.getString("num").trim());
                    itemData.put("unit", (Object)itemsucc.getString("unit").trim());
                    itemData.put("detailAmount", (Object)itemsucc.getString("detailAmount").trim());
                    itemData.put("specModel", (Object)itemsucc.getString("specModel"));
                    itemData.put("taxAmount", (Object)itemsucc.getString("taxAmount").trim());
                    itemData.put("goodsCode", (Object)itemsucc.getString("goodsCode"));
                    itemData.put("unitPrice", (Object)itemsucc.getString("unitPrice").trim());
                    itemData.put("isDiscount", (Object)itemsucc.getString("discountType"));
                    String startDate = itemsucc.getString("startDate");
                    if (!StringUtils.isEmpty((CharSequence)startDate)) {
                        itemData.put("startDate", (Object)startDate.replace("-", ""));
                    }
                    if (!StringUtils.isEmpty((CharSequence)(endDate = itemsucc.getString("endDate")))) {
                        itemData.put("endDate", (Object)endDate.replace("-", ""));
                    }
                    if (!StringUtils.isEmpty((CharSequence)(vehPlate = itemsucc.getString("vehPlate")))) {
                        itemData.put("licensePlateNumber", (Object)vehPlate);
                    }
                    if (null != (taxRate = itemsucc.getString("taxRate").trim())) {
                        if (taxRate.contains("%")) {
                            taxRate = taxRate.replace("%", "");
                            itemData.put("taxRate", (Object)taxRate);
                        } else if (taxRate.contains(".")) {
                            taxRate = decimalFormat.format(new BigDecimal(taxRate));
                            itemData.put("taxRate", (Object)taxRate);
                        } else {
                            itemData.put("taxRate", (Object)taxRate);
                        }
                    }
                    itemsArr.add((Object)itemData);
                }
            }
            succData.put("items", (Object)itemsArr);
        } else {
            succData.put("items", (Object)"");
        }
        return succData;
    }

    public byte[] generateInvoicePdf(JSONObject invoice) {
        this.checkInvoiceEmptyData(invoice);
        String createType = invoice.getString("invoiceType");
        if (StringUtils.isEmpty((CharSequence)createType)) {
            throw new KDException(ErrorCodeConstant.PDF_PARAM_ERROR, new Object[0]);
        }
        this.checkInputInvoiceType(invoice.getString("invoiceCode"), invoice.getString("invoiceNo"), invoice.getJSONArray("items"));
        return this.generatePDFHandleCommon(invoice);
    }

    private byte[] generatePDFHandleCommon(JSONObject invoice) {
        long start = System.currentTimeMillis();
        String serialNo = UUID.randomUUID();
        REQUEST_COMMON_FPKJ requestInvoiceData = this.resolveInvoiceData(invoice);
        Map<String, Object> QrCodeMap = this.generateQrCode(this.assembleInvoiceMap(invoice));
        Map<String, Object> extraParamMap = this.assembleExtraParamMap(invoice, QrCodeMap);
        extraParamMap.put("tenantNo", invoice.get((Object)"tenantNo"));
        extraParamMap.put("previewFlag", invoice.get((Object)"previewFlag"));
        extraParamMap.put("inventoryFlag", invoice.get((Object)"inventoryFlag"));
        byte[] result = this.convertInvoiceDataToPDF(requestInvoiceData, extraParamMap, serialNo);
        logger.info("\u751f\u6210\u5e95\u8d26\u6587\u4ef6{}\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start), invoice.get((Object)"serialNo"));
        return result;
    }

    private REQUEST_COMMON_FPKJ resolveInvoiceData(JSONObject invoice) {
        REQUEST_COMMON_FPKJ requestCommonFpkj = new REQUEST_COMMON_FPKJ();
        COMMON_FPKJ_FPT invoiceCommonData = this.assembleInvoiceCommonData(invoice);
        Map<String, Object> dataMap = this.assembleInputInvoiceDetailList(invoiceCommonData, invoice);
        requestCommonFpkj.setCOMMON_FPKJ_FPT((COMMON_FPKJ_FPT)dataMap.get("bill"));
        requestCommonFpkj.setCOMMON_FPKJ_XMXXS((List)dataMap.get("items"));
        return requestCommonFpkj;
    }

    private COMMON_FPKJ_FPT assembleInvoiceCommonData(JSONObject invoice) {
        logger.info("\u7ec4\u88c5\u53d1\u7968\u57fa\u7840\u6570\u636e\u5f00\u59cb...");
        String type = invoice.getString("type");
        String originalInvoiceCode = invoice.getString("originalInvoiceCode");
        String originalInvoiceNo = invoice.getString("originalInvoiceNo");
        String invoiceDate = invoice.getString("invoiceDate");
        String buyerName = null;
        String buyerTaxNo = null;
        String buyerAddressPhone = null;
        String buyerAccount = null;
        String salesName = null;
        String salerTaxNo = null;
        String salesAddress = null;
        String salerAccount = null;
        String isPurchaseSign = invoice.getString("isPurchaseSign");
        if (!"1".equals(isPurchaseSign)) {
            buyerName = invoice.getString("buyerName");
            buyerTaxNo = invoice.getString("buyerTaxNo");
            buyerAddressPhone = invoice.getString("buyerAddressPhone");
            buyerAccount = invoice.getString("buyerAccount");
            salesName = invoice.getString("salerName");
            salerTaxNo = invoice.getString("salerTaxNo");
            salesAddress = invoice.getString("salerAddressPhone");
            salerAccount = invoice.getString("salerAccount");
        } else {
            buyerName = invoice.getString("salerName");
            buyerTaxNo = invoice.getString("salerTaxNo");
            buyerAddressPhone = invoice.getString("salerAddressPhone");
            buyerAccount = invoice.getString("salerAccount");
            salesName = invoice.getString("buyerName");
            salerTaxNo = invoice.getString("buyerTaxNo");
            salesAddress = invoice.getString("buyerAddressPhone");
            salerAccount = invoice.getString("buyerAccount");
        }
        String remark = invoice.getString("remark");
        String payee = invoice.getString("payee");
        String reviewer = invoice.getString("reviewer");
        String drawer = invoice.getString("drawer");
        COMMON_FPKJ_FPT commonFpkjFpt = new COMMON_FPKJ_FPT();
        commonFpkjFpt.setNSRSBH(salerTaxNo);
        commonFpkjFpt.setNSRMC(salesName);
        commonFpkjFpt.setXHF_NSRSBH(salerTaxNo);
        commonFpkjFpt.setXHF_MC(salesName);
        commonFpkjFpt.setXHF_MC(salesName);
        commonFpkjFpt.setXHF_DZ(salesAddress);
        commonFpkjFpt.setSKF_YHZH(salerAccount);
        commonFpkjFpt.setGHF_MC(buyerName);
        commonFpkjFpt.setGHF_NSRSBH(buyerTaxNo);
        commonFpkjFpt.setGHF_DZ(buyerAddressPhone);
        commonFpkjFpt.setFKF_YHZH(buyerAccount);
        commonFpkjFpt.setKPY(drawer);
        commonFpkjFpt.setSKY(payee);
        commonFpkjFpt.setFHR(reviewer);
        commonFpkjFpt.setKPLX(type);
        commonFpkjFpt.setKPRQ(invoiceDate);
        commonFpkjFpt.setBZ(remark);
        commonFpkjFpt.setYFP_DM(originalInvoiceCode);
        commonFpkjFpt.setYFP_HM(originalInvoiceNo);
        return commonFpkjFpt;
    }

    private Map<String, Object> assembleInputInvoiceDetailList(COMMON_FPKJ_FPT common, JSONObject invoice) {
        logger.info("\u7ec4\u88c5\u8fdb\u9879\u53d1\u7968\u660e\u7ec6\u6570\u636e\u5f00\u59cb...");
        HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
        ArrayList<COMMON_FPKJ_XMXX> list = new ArrayList<COMMON_FPKJ_XMXX>(8);
        DecimalFormat df = new DecimalFormat("######0.00");
        JSONArray items = invoice.getJSONArray("items");
        String invoiceType = InvoiceConvertUtilv2.checkInvoiceType(invoice.getString("invoiceCode"), invoice.getString("invoiceNo"));
        for (int i = 0; i < items.size(); ++i) {
            String isDiscount;
            String amount;
            String invoiceDate;
            COMMON_FPKJ_XMXX commonFpkjXmxx = new COMMON_FPKJ_XMXX();
            JSONObject items1Json = items.getJSONObject(i);
            if (Handle.isNotEmpty(items1Json.getString("goodsName"))) {
                commonFpkjXmxx.setXMMC(items1Json.getString("goodsName"));
            }
            String specification = "";
            specification = "15".equals(invoiceType) ? items1Json.getString("licensePlateNumber") : items1Json.getString("specModel");
            if (Handle.isNotEmpty(specification)) {
                commonFpkjXmxx.setGGXH(specification);
            }
            String unit = "";
            unit = "15".equals(invoiceType) ? items1Json.getString("specModel") : items1Json.getString("unit");
            if (Handle.isNotEmpty(unit)) {
                commonFpkjXmxx.setXMDW(unit);
            }
            if ((invoiceDate = invoice.getString("invoiceDate")) != null && (invoiceDate = invoiceDate.replace("-", "")).length() >= 8) {
                invoiceDate = invoiceDate.substring(0, 8);
            }
            String quantity = "";
            if ("15".equals(invoiceType)) {
                quantity = items1Json.getString("startDate");
                if (Handle.isEmpty(quantity)) {
                    quantity = invoiceDate;
                }
            } else {
                quantity = items1Json.getString("num");
            }
            if (Handle.isNotEmpty(quantity)) {
                commonFpkjXmxx.setXMSL(quantity);
            }
            String price = "";
            if ("15".equals(invoiceType)) {
                price = items1Json.getString("endDate");
                if (Handle.isEmpty(price)) {
                    price = invoiceDate;
                }
            } else {
                price = items1Json.getString("unitPrice");
            }
            if (Handle.isNotEmpty(price)) {
                commonFpkjXmxx.setXMDJ(price);
            }
            if (Handle.isNotEmpty(amount = items1Json.getString("detailAmount"))) {
                commonFpkjXmxx.setXMJE(amount);
            }
            if (Handle.isEmpty(isDiscount = items1Json.getString("isDiscount"))) {
                commonFpkjXmxx.setFPHXZ("1");
            } else {
                commonFpkjXmxx.setFPHXZ(isDiscount);
            }
            String taxRateOne = items1Json.getString("taxRate");
            if (StringUtils.isEmpty((CharSequence)taxRateOne)) {
                commonFpkjXmxx.setSL("");
            } else if (taxRateOne.indexOf(37) > 0) {
                commonFpkjXmxx.setSL(taxRateOne);
            } else {
                commonFpkjXmxx.setSL(taxRateOne + "%");
            }
            String tax = items1Json.getString("taxAmount");
            if (taxRateOne.equals("0")) {
                tax = "0";
                commonFpkjXmxx.setSE(tax);
            } else if (Handle.isNotEmpty(tax)) {
                commonFpkjXmxx.setSE(tax);
            }
            list.add(commonFpkjXmxx);
        }
        if (Handle.isNotEmpty(list) && list.size() > 0) {
            common.setKPXM(((COMMON_FPKJ_XMXX)list.get(0)).getXMMC());
        }
        String totalAmount = invoice.getString("totalAmount");
        String totalpricetax = invoice.getString("totalPriceTax");
        String totaltax = invoice.getString("totalTax");
        BigDecimal totalAmount2 = new BigDecimal(String.valueOf(totalAmount));
        BigDecimal totalpricetax2 = new BigDecimal(String.valueOf(totalpricetax));
        BigDecimal totaltax2 = new BigDecimal(String.valueOf(totaltax));
        common.setKPHJJE(df.format(totalpricetax2));
        common.setHJBHSJE(df.format(totalAmount2));
        common.setKPHJSE(df.format(totaltax2));
        dataMap.put("bill", common);
        dataMap.put("items", list);
        return dataMap;
    }

    private Map<String, Object> generateQrCode(Map<String, Object> paramMap) {
        logger.info("\u5f00\u59cb\u751f\u6210\u4e8c\u7ef4\u7801\u5f00\u59cb...");
        try {
            String billDate = (String)paramMap.get("KPRQ");
            String billYear = billDate.substring(0, 4);
            String billMonth = billDate.substring(5, 7);
            String billDay = billDate.substring(8, 10);
            String kprqQrCode = billYear + billMonth + billDay;
            long timeNow = System.currentTimeMillis();
            int qrWidth = 82;
            int qrHeight = 82;
            byte[] qrCodeByte = null;
            if (Handle.isEmpty(paramMap.get("blockchain"))) {
                char ch;
                StringBuilder sb = new StringBuilder();
                sb.append("0110").append(paramMap.get("FP_DM")).append(paramMap.get("FP_HM")).append(paramMap.get("HJBHSJE")).append(billYear).append(billMonth).append(billDay).append(paramMap.get("JYM"));
                byte[] crc16 = sb.toString().getBytes("UTF-8");
                char i = ch = Crc16Util.calCRC(crc16);
                String str = Integer.toHexString(i);
                str = this.addZeroForString(str);
                StringBuilder msg = new StringBuilder();
                msg.append("01,10,").append(paramMap.get("FP_DM")).append(',').append(paramMap.get("FP_HM")).append(',').append(paramMap.get("HJBHSJE")).append(',').append(kprqQrCode).append(',').append(paramMap.get("JYM")).append(',').append(str).append(',');
                qrCodeByte = QrcodeUtil.encode(msg.toString(), qrWidth, qrHeight);
            } else {
                BigDecimal totalAmount = new BigDecimal(paramMap.get("totalPriceTax").toString());
                String qrContent = String.format("https://bcfp.shenzhen.chinatax.gov.cn/verify/scan?hash=%s&bill_num=%s&total_amount=%d", paramMap.get("txHash").toString(), paramMap.get("FP_HM").toString(), totalAmount.scaleByPowerOfTen(2).longValue());
                qrCodeByte = QrcodeUtil.generateQrBlockc(qrContent, qrWidth, qrHeight);
            }
            paramMap.put("image", Image.getInstance((byte[])qrCodeByte));
            return paramMap;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u4e8c\u7ef4\u7801error", (Throwable)e);
            return paramMap;
        }
    }

    private Map<String, Object> assembleExtraParamMap(JSONObject invoice, Map<String, Object> paramMap) {
        DecimalFormat df = new DecimalFormat("######0.00");
        paramMap.put("jqbh", invoice.getString("machineNo"));
        if (Handle.isNotEmpty(invoice.getString("secret"))) {
            paramMap.put("FWMW", invoice.getString("secret"));
        } else {
            paramMap.put("FWMW", "");
        }
        paramMap.put("SSYF", invoice.getString("invoiceDate").substring(5, 7));
        paramMap.put("HJSE", df.format(invoice.getBigDecimal("totalTax")));
        paramMap.put("blockchain", invoice.getString("blockchain"));
        paramMap.put("invoiceType", InvoiceConvertUtilv2.checkInvoiceTypeNew(paramMap.get("FP_DM").toString(), paramMap.get("FP_HM").toString()));
        return paramMap;
    }

    private Map<String, Object> assembleInvoiceMap(JSONObject invoice) {
        DecimalFormat df = new DecimalFormat("######0.00");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (Handle.isNotEmpty(invoice.getString("checkCode"))) {
            paramMap.put("JYM", invoice.getString("checkCode"));
        } else {
            paramMap.put("JYM", "");
        }
        paramMap.put("KPRQ", invoice.getString("invoiceDate"));
        paramMap.put("FP_DM", invoice.getString("invoiceCode"));
        paramMap.put("FP_HM", invoice.getString("invoiceNo"));
        paramMap.put("HJBHSJE", df.format(invoice.getBigDecimal("totalAmount")));
        if (Handle.isNotEmpty(invoice.getString("blockchain"))) {
            paramMap.put("sellerTaxCode", invoice.getString("salerTaxNo"));
            paramMap.put("txHash", invoice.getString("secret"));
            paramMap.put("blockchain", invoice.getString("blockchain"));
            paramMap.put("totalPriceTax", invoice.getString("totalPriceTax"));
        }
        logger.info("\u5f53\u524d\u53d1\u7968\u4e94\u8981\u7d20\uff1a" + paramMap);
        return paramMap;
    }

    private byte[] convertInvoiceDataToPDF(REQUEST_COMMON_FPKJ requestInvoiceData, Map<String, Object> extraParamMap, String serinalNo) {
        PdfProduceBean pdfProduceBean = this.iTaxCodeService.taxCode(requestInvoiceData, extraParamMap);
        logger.info("=========\u7ec4\u88c5\u751f\u6210PDF\u6587\u4ef6\u53c2\u6570\u5b8c\u6210==============" + pdfProduceBean);
        PdfReturnBean pdfReturnBean = this.iPdfService.pdfProduceService(pdfProduceBean);
        Map<Integer, Object> pathList = pdfReturnBean.getResultMap();
        return TextFactory.mergePdfFiles(pathList);
    }

    private void checkInvoiceEmptyData(JSONObject invoice) {
        if (Handle.isEmpty(invoice)) {
            throw new KDException(ErrorCodeConstant.INVOICE_DATA_NULL, new Object[0]);
        }
        if (Handle.isEmpty(invoice.getString("invoiceCode")) || Handle.isEmpty(invoice.getString("invoiceNo"))) {
            throw new KDException(ErrorCodeConstant.INVOICE_CODE_NULL, new Object[0]);
        }
    }

    private void checkInputInvoiceType(String invoiceCode, String invoiceNo, JSONArray items) {
        if (Handle.isNotEmpty(invoiceNo) && invoiceNo.length() != 8) {
            throw new KDException(ErrorCodeConstant.INVOICE_CODE_LENGTH_ERROR, new Object[0]);
        }
        String invoiceType = InvoiceConvertUtilv2.checkInvoiceTypeNew(invoiceCode, invoiceNo);
        if (!(!Handle.isNotEmpty(invoiceType) || "1".equals(invoiceType) || "3".equals(invoiceType) || "4".equals(invoiceType) || "15".equals(invoiceType) || "2".equals(invoiceType))) {
            throw new KDException(ErrorCodeConstant.INVOICE_TYPE_ERROR, new Object[0]);
        }
    }

    private String addZeroForString(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return code;
        }
        if (code.length() == 1) {
            code = "000" + code;
            return code;
        }
        if (code.length() == 2) {
            code = "00" + code;
            return code;
        }
        if (code.length() == 3) {
            code = "0" + code;
            return code;
        }
        return code;
    }

    static {
        LoadFontUtils.init();
    }
}

