/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service.einvoicepdf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfGState;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.constant.FullDigitalEInvoiceConstant;
import kd.imc.rim.file.service.einvoicepdf.FullDigitalEInvoicePdfWriteDataService;
import kd.imc.rim.file.service.einvoicepdf.FullDigitalEInvoicePdfWritePathService;
import kd.imc.rim.file.service.einvoicepdf.dto.CargoTransportItem;
import kd.imc.rim.file.service.einvoicepdf.dto.EInvoicePdfResultDTO;
import kd.imc.rim.file.service.einvoicepdf.dto.FDEIPositionContent;
import kd.imc.rim.file.service.einvoicepdf.dto.FullDigitalEInvoice;
import kd.imc.rim.file.service.einvoicepdf.dto.PDFTemplatePosition;
import kd.imc.rim.file.service.einvoicepdf.dto.PassengerTransportItem;
import kd.imc.rim.file.service.einvoicepdf.dto.RightLinePosition;
import kd.imc.rim.file.service.einvoicepdf.enums.DifferenceTaxTypeEnum;
import kd.imc.rim.file.service.einvoicepdf.enums.InvoiceTypeEnum;
import kd.imc.rim.file.service.einvoicepdf.enums.SpecialTypeEnum;
import kd.imc.rim.file.service.einvoicepdf.enums.ZeroTaxRateFlagEnum;
import kd.imc.rim.file.service.einvoicepdf.vo.FileCenterResult;
import kd.imc.rim.file.utils.BigDecimalUtil;
import kd.imc.rim.file.utils.DateUtil;
import kd.imc.rim.file.utils.EInvoicePdfUtils;
import kd.imc.rim.file.utils.MoneyUtil;
import kd.imc.rim.file.utils.PDFXmlUtils;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.common.QRCodeUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class FullDigitalEInvoicePdfService {
    private static final Log log = LogFactory.getLog(FullDigitalEInvoicePdfService.class);
    private FullDigitalEInvoicePdfWriteDataService writeDataService = new FullDigitalEInvoicePdfWriteDataService();
    private FullDigitalEInvoicePdfWritePathService writePathService = new FullDigitalEInvoicePdfWritePathService();

    public FileCenterResult<EInvoicePdfResultDTO> createAndUploadPdf(FullDigitalEInvoice fullDigitalEInvoice) {
        byte[] pdfBytes;
        String appName = fullDigitalEInvoice.getAppName();
        String clientId = fullDigitalEInvoice.getClientId();
        if (StrUtil.isEmpty(appName) || StrUtil.isEmpty(clientId)) {
            log.error("clientId\u6216\u8005appGroup\u4e3a\u7a7a\uff0c\u7981\u6b62\u751f\u6210\u3002");
            throw new KDException(new ErrorCode("A0420", "appName or clientId is Empty"), new Object[0]);
        }
        try {
            pdfBytes = this.createPdf(fullDigitalEInvoice);
        }
        catch (Exception e) {
            return new FileCenterResult<EInvoicePdfResultDTO>("9999", e.getMessage());
        }
        try {
            String fileName = fullDigitalEInvoice.getInvoiceNo() + "." + "pdf";
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            ByteArrayInputStream stream = new ByteArrayInputStream(pdfBytes);
            String storePath = FullDigitalEInvoicePdfService.getInvoiceDir("temp") + fileName;
            FileItem fileItem = new FileItem(fileName, storePath, (InputStream)stream);
            if (fileService.exists(storePath)) {
                log.info("delete-file-uploadBase64:{}", (Object)storePath);
                fileService.delete(storePath);
            }
            String path = fileService.upload(fileItem);
            return new FileCenterResult<String>(path);
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002", (Throwable)e);
            throw new KDException(new ErrorCode("C0001", "upload file error"), new Object[0]);
        }
    }

    public static String getInvoiceDir(String type) {
        RequestContext context = RequestContext.get();
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        int tempMonth = calendar.get(2) + 1;
        String month = tempMonth >= 10 ? String.valueOf(tempMonth) : "0" + tempMonth;
        int date = calendar.get(5);
        return String.format("/%s/%s/%s%s/rim/%s/%s/", context.getTenantId(), context.getAccountId(), year, month, date, type);
    }

    public byte[] createPdf(FullDigitalEInvoice fullDigitalEInvoice) throws DocumentException {
        if (fullDigitalEInvoice.getItemList().isEmpty()) {
            throw new KDException(new ErrorCode("A0420", "invoice items data is empty"), new Object[0]);
        }
        InvoiceTypeEnum invoiceType = InvoiceTypeEnum.getInvoiceTypeByValue(fullDigitalEInvoice.getInvoiceType());
        if (invoiceType == null) {
            throw new KDException(new ErrorCode("A0420", "current invoicetype can't create pdf"), new Object[0]);
        }
        String specialTypeStr = fullDigitalEInvoice.getSpecialType();
        if (StringUtils.isEmpty((CharSequence)specialTypeStr)) {
            specialTypeStr = SpecialTypeEnum.OTHER.getValue();
        }
        SpecialTypeEnum specialType = SpecialTypeEnum.getSpecialTypeByValue(specialTypeStr);
        JSONObject templateJson = PDFXmlUtils.getPDFTemplateInfoFromXMLFile("template/full-digital-invoice-pdf.xml");
        if (templateJson.containsKey((Object)"TEMPLATE")) {
            templateJson = templateJson.getJSONObject("TEMPLATE");
        }
        JSONObject jjzJson = templateJson.getJSONObject("JJZ");
        List<PDFTemplatePosition> jjzPositionList = FullDigitalEInvoicePdfService.getJJZPositionList(jjzJson, fullDigitalEInvoice.getSalerTaxNo(), fullDigitalEInvoice.getTaxBureauCode(), true);
        JSONObject titleJson = templateJson.getJSONObject("TITLE");
        List<PDFTemplatePosition> titlePositionList = FullDigitalEInvoicePdfService.getTitlePositionList(titleJson, invoiceType.name());
        PDFTemplatePosition drawerPosition = (PDFTemplatePosition)templateJson.getObject("drawer", PDFTemplatePosition.class);
        PDFTemplatePosition dwfPosition = (PDFTemplatePosition)templateJson.getObject("DWF", PDFTemplatePosition.class);
        PDFTemplatePosition pageNoPosition = (PDFTemplatePosition)templateJson.getObject("pageNo", PDFTemplatePosition.class);
        RightLinePosition rightLinePosition = (RightLinePosition)templateJson.getObject("RIGHT_LINE", RightLinePosition.class);
        JSONObject contentJson = this.getContentJsonBySpecialType(templateJson, specialType);
        ArrayList<List<PDFTemplatePosition>> specialDataList = new ArrayList<List<PDFTemplatePosition>>();
        ArrayList<Integer> specialLineNumList = new ArrayList<Integer>();
        this.setSpecialDataList(specialDataList, specialLineNumList, fullDigitalEInvoice, contentJson, specialType);
        FDEIPositionContent contentPosition = this.getContentPosition(fullDigitalEInvoice, contentJson, specialType, specialLineNumList);
        contentPosition.setJjzPositionList(jjzPositionList);
        contentPosition.setTitlePositionList(titlePositionList);
        contentPosition.getDrawerPositionList().add(drawerPosition);
        contentPosition.getLastPositionList().add(dwfPosition);
        contentPosition.setPageNoPosition(pageNoPosition);
        contentPosition.setRightLinePosition(rightLinePosition);
        contentPosition.setSpecialType(specialType);
        contentPosition.setSpecialPositionList(specialDataList);
        byte[] pdfBytes = this.createPdfByPosition(contentPosition, specialLineNumList);
        if (pdfBytes == null || pdfBytes.length == 0) {
            throw new KDException(new ErrorCode("A0421", "create pdf fail, check param"), new Object[0]);
        }
        return pdfBytes;
    }

    private JSONObject getContentJsonBySpecialType(JSONObject templateJson, SpecialTypeEnum specialType) {
        JSONObject contentJson = new JSONObject();
        contentJson.putAll((Map)templateJson.getJSONObject("CONTENT"));
        if (specialType != null) {
            contentJson.putAll((Map)contentJson.getJSONObject(specialType.getIdentification()));
        }
        return contentJson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] createPdfByPosition(FDEIPositionContent contentPosition, List<Integer> specialLineNumList) throws DocumentException {
        float diffYMM;
        List<PDFTemplatePosition> detailDataList;
        int i;
        int remarkPageSize;
        BaseFont[] fonts;
        try {
            BaseFont courierFont = BaseFont.createFont((String)"fonts/cour.ttf", (String)"Identity-H", (boolean)false);
            BaseFont kaiFont = BaseFont.createFont((String)"fonts/simkai.ttf", (String)"Identity-H", (boolean)false);
            BaseFont songFont = BaseFont.createFont((String)"fonts/simsun.ttc,0", (String)"Identity-H", (boolean)false);
            fonts = new BaseFont[]{songFont, courierFont, kaiFont};
        }
        catch (Exception e) {
            log.error("\u5b57\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            throw new KDException(new ErrorCode("B0321", "font file is not exist"), new Object[0]);
        }
        List<List<PDFTemplatePosition>> detailPositionList = contentPosition.getDetailPositionList();
        List<List<PDFTemplatePosition>> remarkPositionList = contentPosition.getRemarkPositionList();
        List<Integer> currentPageSizeList = contentPosition.getCurrentPageSizeList();
        ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
        int pageNum = contentPosition.getPageNumber();
        boolean lastFlag = false;
        int specialLineNum = specialLineNumList.size();
        if (specialLineNum != 0) {
            --specialLineNum;
        }
        int totalPageNum = pageNum + specialLineNum;
        boolean multiPage = false;
        if (totalPageNum > 1) {
            multiPage = true;
        }
        if ((remarkPageSize = remarkPositionList.size()) > 0) {
            --remarkPageSize;
        }
        totalPageNum += remarkPageSize;
        int pageNo = 0;
        for (i = 0; i < pageNum; ++pageNo, ++i) {
            float specialHeight = 0.0f;
            float diffYMM2 = 0.0f;
            float tableContentHeight = 0.0f;
            detailDataList = detailPositionList.get(i);
            int currentPageSize = currentPageSizeList.get(i);
            if (i == pageNum - 1 && specialLineNumList.size() < 2) {
                lastFlag = true;
            }
            if (i == 0 && !specialLineNumList.isEmpty()) {
                specialHeight = (float)specialLineNumList.get(0).intValue() * 4.5f;
            }
            if (currentPageSize > 8) {
                diffYMM2 = tableContentHeight = (float)(currentPageSize - 8) * 4.5f;
            }
            if (multiPage) {
                diffYMM2 = lastFlag ? (diffYMM2 += 5.0f) : (diffYMM2 -= 23.0f);
            }
            if (specialHeight > 0.0f) {
                diffYMM2 = diffYMM2 + specialHeight + 5.0f;
            }
            this.setEveryPageDataToPdf(bytesList, contentPosition, detailDataList, fonts, multiPage, lastFlag, totalPageNum, pageNo, diffYMM2, tableContentHeight, specialHeight, false);
        }
        for (i = 1; i < specialLineNumList.size(); ++pageNo, ++i) {
            if (i == specialLineNumList.size() - 1) {
                lastFlag = true;
            }
            int currentPageSize = specialLineNumList.get(i);
            float tableContentHeight = (float)currentPageSize * 4.5f;
            diffYMM = (float)(currentPageSize - 8) * 4.5f;
            if (multiPage && !lastFlag) {
                diffYMM -= 28.0f;
            }
            detailDataList = contentPosition.getSpecialPositionList().get(i);
            this.setEveryPageDataToPdf(bytesList, contentPosition, detailDataList, fonts, multiPage, lastFlag, totalPageNum, pageNo, diffYMM, tableContentHeight, -1.0f, false);
        }
        if (remarkPositionList.size() > 1) {
            for (i = 1; i < remarkPositionList.size(); ++pageNo, ++i) {
                List<PDFTemplatePosition> remarkPositions = remarkPositionList.get(i);
                int currentPageSize = remarkPositions.size();
                diffYMM = 0.0f;
                if (currentPageSize > 18) {
                    diffYMM = (float)(currentPageSize - 18) * 3.5f;
                }
                float tableContentHeight = diffYMM;
                this.setEveryPageDataToPdf(bytesList, contentPosition, remarkPositions, fonts, false, false, totalPageNum, pageNo, diffYMM -= 5.0f, tableContentHeight, -1.0f, true);
            }
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            Document doc = null;
            PdfCopy pdfCopy = null;
            try {
                doc = new Document();
                pdfCopy = new PdfCopy(doc, (OutputStream)bos);
                pdfCopy.setFullCompression();
                doc.open();
                for (byte[] bytes : bytesList) {
                    PdfImportedPage impPage = pdfCopy.getImportedPage(new PdfReader(bytes), 1);
                    pdfCopy.addPage(impPage);
                }
                pdfCopy.close();
                doc.close();
            }
            catch (Exception e) {
                log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u5904\u7406\u7ed3\u679c\u6587\u4ef6\u65f6\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", (Throwable)e);
                throw new KDException(new ErrorCode("B0001", "create pdf error by IOException"), new Object[0]);
            }
            finally {
                if (pdfCopy != null) {
                    pdfCopy.close();
                }
                if (doc != null) {
                    doc.close();
                }
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u5904\u7406\u7ed3\u679c\u6587\u4ef6\u65f6\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", (Throwable)e);
            throw new KDException(new ErrorCode("B0001", "create pdf error by IOException"), new Object[0]);
        }
    }

    private void setEveryPageDataToPdf(List<byte[]> bytesList, FDEIPositionContent contentPosition, List<PDFTemplatePosition> detailDataList, BaseFont[] fonts, boolean multiPage, boolean lastFlag, int pageTotalNum, int pageIndex, float diffYMM, float tableContentHeight, float specialHeight, boolean moreRemark) throws DocumentException {
        boolean specialFlag = specialHeight == -1.0f;
        List<PDFTemplatePosition> lastPositionList = contentPosition.getLastPositionList();
        List<List<PDFTemplatePosition>> subMoneyPositionList = contentPosition.getSubMoneyPositionList();
        SpecialTypeEnum specialType = contentPosition.getSpecialType();
        List<List<PDFTemplatePosition>> specialPositionList = contentPosition.getSpecialPositionList();
        float diffY = 0.0f;
        if (diffYMM != 0.0f) {
            diffY = EInvoicePdfUtils.getPxByMm(diffYMM);
        }
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            float height = 140.0f + diffYMM;
            byte[] blankBytes = EInvoicePdfUtils.generateBlankPdf(210.0f, height);
            PdfReader reader = new PdfReader(blankBytes);
            PdfStamper stamp = new PdfStamper(reader, (OutputStream)bao);
            PdfContentByte under = stamp.getOverContent(1);
            this.setCommonData(contentPosition, under, fonts, pageTotalNum, pageIndex + 1, diffY, diffYMM);
            this.writeDataService.drawTable(under, specialType, diffYMM, tableContentHeight, specialHeight, lastFlag, multiPage, moreRemark);
            if (specialFlag) {
                this.setData(under, fonts, detailDataList, 0.0f, diffY + 125.0f);
            } else {
                this.setData(under, fonts, detailDataList, 0.0f, diffY);
                if (pageIndex == 0 && !specialPositionList.isEmpty()) {
                    specialHeight = multiPage ? (specialHeight -= 23.0f) : (specialHeight += 5.0f);
                    this.setData(under, fonts, specialPositionList.get(0), 0.0f, EInvoicePdfUtils.getPxByMm(specialHeight));
                }
            }
            float lastDiffY = 0.0f;
            if (multiPage) {
                if (!specialFlag) {
                    List<PDFTemplatePosition> subMoney = subMoneyPositionList.get(pageIndex);
                    this.setData(under, fonts, subMoney, 0.0f, diffY);
                } else {
                    lastDiffY = 9.0f;
                }
            }
            if (lastFlag) {
                this.setData(under, fonts, lastPositionList, 0.0f, lastDiffY);
            }
            this.setRightLine(under, contentPosition.getRightLinePosition(), specialFlag, diffY);
            if (contentPosition.isTest()) {
                this.setWaterMark(under, 210.0f, height, fonts[2]);
            }
            if (contentPosition.isInput()) {
                this.setInputWaterMark(under, 210.0f, height, fonts[2], true);
            }
            stamp.setFormFlattening(true);
            stamp.close();
            reader.close();
            bytesList.add(bao.toByteArray());
        }
        catch (Exception e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", (Throwable)e);
            throw new KDException(new ErrorCode("B0001", "create pdf error by IOException"), new Object[0]);
        }
    }

    private void setWaterMark(PdfContentByte under, float x, float y, BaseFont font) {
        if (under == null) {
            return;
        }
        int diff = 35;
        float xTimes = x / (float)diff;
        float yTimes = y / (float)diff;
        float startX = 21.0f;
        float startY = 15.0f;
        int i = 0;
        while ((float)i < xTimes) {
            int j = 0;
            while ((float)j < yTimes) {
                this.addText(under, 0.3f, Color.gray, font, 15.0f, "\u6837\u7968", startX + (float)(i * diff), startY + (float)(j * diff), 45.0f, true);
                ++j;
            }
            ++i;
        }
        this.addText(under, 1.0f, Color.RED, font, 17.0f, "\u6837\u7968", 41.0f, y - 26.0f, 0.0f, true);
    }

    public void setInputWaterMark(PdfContentByte under, float x, float y, BaseFont font, boolean isMM) {
    }

    private void addText(PdfContentByte under, float fillOpacity, Color fillColor, BaseFont font, float fontSize, String text, float x, float y, float rotation, boolean isMM) {
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(fillOpacity);
        under.saveState();
        under.beginText();
        under.setGState(gs);
        under.resetRGBColorFill();
        under.setColorFill(fillColor);
        under.setFontAndSize(font, fontSize);
        float pxX = x;
        float pxY = y;
        if (isMM) {
            pxX = EInvoicePdfUtils.getPxByMm(x);
            pxY = EInvoicePdfUtils.getPxByMm(y);
        }
        under.showTextAligned(1, text, pxX, pxY, rotation);
        under.endText();
        under.restoreState();
    }

    private void setRightLine(PdfContentByte under, RightLinePosition rightLinePosition, boolean specialFlag, float diffY) {
        PDFTemplatePosition top;
        if (rightLinePosition == null) {
            return;
        }
        BigDecimal specialHeight = BigDecimal.ZERO;
        if (specialFlag) {
            specialHeight = EInvoicePdfUtils.getBigPxByMm(new BigDecimal("3"));
        }
        BigDecimal diffPageYMM = BigDecimal.ZERO;
        if (diffY != 0.0f) {
            diffPageYMM = BigDecimalUtil.transDecimal(Float.valueOf(diffY));
        }
        diffPageYMM = diffPageYMM.subtract(specialHeight);
        BigDecimal diffPageYMMHalf = diffPageYMM.divide(new BigDecimal("2"), 6, RoundingMode.HALF_UP);
        BigDecimal rightLineYStart = EInvoicePdfUtils.getBigPxByMm(FullDigitalEInvoiceConstant.RIGHT_LINE_START_Y).add(specialHeight);
        BigDecimal rightLineHighHalf = EInvoicePdfUtils.getBigPxByMm(FullDigitalEInvoiceConstant.RIGHT_LINE_HIGH_HALF).add(diffPageYMMHalf);
        BigDecimal bottomEndY = rightLineYStart.add(rightLineHighHalf);
        BigDecimal topEndY = bottomEndY.add(rightLineHighHalf);
        BigDecimal rightLineX = EInvoicePdfUtils.getBigPxByMm(FullDigitalEInvoiceConstant.RIGHT_LINE_X);
        String bottomPathPosition = String.format("M %s %s L %s %s", rightLineX, rightLineYStart, rightLineX, bottomEndY);
        String topPathPosition = String.format("M %s %s L %s %s", rightLineX, bottomEndY, rightLineX, topEndY);
        PDFTemplatePosition bottom = rightLinePosition.getBottomPosition();
        if (bottom != null) {
            bottom.setPathLocation(bottomPathPosition);
        }
        if ((top = rightLinePosition.getTopPosition()) != null) {
            top.setPathLocation(topPathPosition);
        }
        this.setData(under, null, top, 0.0f, 0.0f);
        this.setData(under, null, bottom, 0.0f, 0.0f);
    }

    private void setCommonData(FDEIPositionContent contentPosition, PdfContentByte under, BaseFont[] fonts, int pageNum, int currentPageNo, float diffY, float diffYMM) throws DocumentException {
        List<PDFTemplatePosition> drawerPosition = contentPosition.getDrawerPositionList();
        String ewmLocation = contentPosition.getEwmLocation();
        List<PDFTemplatePosition> jjzList = contentPosition.getJjzPositionList();
        List<PDFTemplatePosition> titleList = contentPosition.getTitlePositionList();
        PDFTemplatePosition pageNoPosition = contentPosition.getPageNoPosition();
        List<PDFTemplatePosition> basicPositionList = contentPosition.getBasicPositionList();
        this.setData(under, fonts, basicPositionList, 0.0f, diffY);
        this.setData(under, fonts, jjzList, EInvoicePdfUtils.getPxByMm(90.0f), EInvoicePdfUtils.getPxByMm(140.0f + diffYMM - 8.5f - 20.0f));
        this.setData(under, fonts, titleList, 0.0f, diffY);
        List<PDFTemplatePosition> pageNoList = this.getPageNoList(pageNoPosition, pageNum, currentPageNo);
        this.setData(under, fonts, pageNoList, 0.0f, diffY);
        this.setData(under, fonts, drawerPosition, 0.0f, 0.0f);
        Image ewmImage = contentPosition.getEwmImage();
        String[] str = ewmLocation.split(",");
        String str1 = str[0];
        String str2 = str[str.length - 1];
        ewmImage.setAbsolutePosition(Float.parseFloat(str1), Float.parseFloat(str2) + diffY);
        ewmImage.scalePercent(37.0f);
        try {
            under.addImage(ewmImage);
        }
        catch (DocumentException e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", (Throwable)e);
            throw new KDException(new ErrorCode("B0001", "create pdf error by IOException"), new Object[0]);
        }
    }

    public void setData(PdfContentByte under, BaseFont[] fonts, List<PDFTemplatePosition> dataList, float diffX, float diffY) {
        for (PDFTemplatePosition position : dataList) {
            this.setData(under, fonts, position, diffX, diffY);
        }
    }

    private void setData(PdfContentByte under, BaseFont[] fonts, PDFTemplatePosition position, float diffX, float diffY) {
        if (position == null) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)position.getTextLocation())) {
            String ctmStr = position.getCtm();
            String[] ctmArr = null;
            if (!StrUtil.isEmpty(ctmStr)) {
                ctmArr = ctmStr.split(",");
            }
            String msg = position.getMsg();
            float fontSize = position.getFontSize();
            String textLocation = position.getTextLocation();
            String color = position.getColor();
            Integer[] colorArr = (Integer[])ConvertUtils.convert((String[])color.split(","), Integer.class);
            float space = position.getSpace();
            BaseFont font = EInvoicePdfUtils.getFont(position.getFontName(), fonts);
            if (space != 0.0f) {
                this.writeDataService.writePdfDataWithSpace(msg, under, font, Float.valueOf(fontSize), textLocation, colorArr, diffX, diffY, space);
            } else {
                this.writeDataService.writePdfData(msg, under, font, Float.valueOf(fontSize), textLocation, colorArr, ctmArr, diffX, diffY, position.getFontAlign());
            }
        } else {
            this.writePathService.setPathValue(position, under, diffX, diffY);
        }
    }

    public static List<PDFTemplatePosition> getJJZPositionList(JSONObject jjzJson, String nsrsbh, String taxBureauCode, boolean needCommon) {
        String areaCodeStr = EInvoicePdfUtils.getAreaCodeByNsrsbh(nsrsbh, taxBureauCode);
        JSONArray commonArray = jjzJson.getJSONArray("COMMON");
        JSONArray areaArray = jjzJson.getJSONArray(areaCodeStr);
        JSONArray dataArray = new JSONArray();
        if (needCommon) {
            if (commonArray == null || commonArray.isEmpty()) {
                commonArray = FullDigitalEInvoicePdfService.getJzzCommonArray();
            }
            dataArray.addAll((Collection)commonArray);
        }
        if (areaArray != null && !areaArray.isEmpty()) {
            dataArray.addAll((Collection)areaArray);
        }
        return dataArray.toJavaList(PDFTemplatePosition.class);
    }

    private static JSONArray getJzzCommonArray() {
        log.info("\u7248\u5f0f\u6587\u4ef6\u751f\u6210\u65f6,\u83b7\u53d6\u6a21\u7248\u76d1\u5236\u7ae0\u7684\u516c\u5171\u6570\u636e\u4e3a\u7a7a,\u5f00\u59cb\u8865\u507f\u5904\u7406");
        String str = "<COMMON><ROOT><textLocation>20.0342,23.817913</textLocation><msg>\u56fd</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><color>255,0,0</color></ROOT><ROOT><textLocation>27.531202,23.817913</textLocation><msg>\u5bb6</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><color>255,0,0</color></ROOT><ROOT><textLocation>35.028206,23.817913</textLocation><msg>\u7a0e</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><color>255,0,0</color></ROOT><ROOT><textLocation>42.525208,23.817913</textLocation><msg>\u52a1</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><color>255,0,0</color></ROOT><ROOT><textLocation>50.02221,23.817913</textLocation><msg>\u603b</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><color>255,0,0</color></ROOT><ROOT><textLocation>57.51921,23.817913</textLocation><msg>\u5c40</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><color>255,0,0</color></ROOT><ROOT><textLocation>-5.9888525,49.167213</textLocation><msg>\u5168</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.323729,-0.944243,0.9342,0.327214,13.057098,28.222712</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>-2.7256591,48.99626</textLocation><msg>\u56fd</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.802171,-0.584186,0.577971,0.8108,16.2368,35.395607</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>-1.268436,49.508427</textLocation><msg>\u7edf</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.933014,-0.330657,0.327143,0.943043,23.022005,39.917114</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>-0.5200271,52.56454</textLocation><msg>\u4e00</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.977357,-0.150971,0.149357,0.987857,30.892597,42.50152</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>-0.4860057,51.031532</textLocation><msg>\u53d1</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.988671,0.008271,-0.008186,0.999286,39.158195,43.669518</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>0.35299844,51.32928</textLocation><msg>\u7968</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.9773,0.151357,-0.149757,0.9878,47.4756,43.546013</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>1.527137,51.837067</textLocation><msg>\u76d1</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.932686,0.3316,-0.328071,0.942714,55.673794,42.197815</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>2.592499,53.17361</textLocation><msg>\u5236</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.801329,0.585371,-0.579157,0.809929,63.365204,39.427315</ctm><color>255,0,0</color></ROOT><ROOT><textLocation>1.7557312,56.796688</textLocation><msg>\u7ae0</msg><fontName>KaiTi</fontName><fontAlign>0</fontAlign><fontSize>7</fontSize><ctm>0.321071,0.945171,-0.935114,0.324529,69.88281,34.742714</ctm><color>255,0,0</color></ROOT><ROOT><strokeColor>#FF0000</strokeColor><width>2.8346457</width><transform>translate(-1.4228988,-1.4243017)</transform><pathLocation>M 85.04499 26.923916 C 85.04499 12.050915 66.643 -0.0060920715 43.941998 -0.0060920715 C 21.241995 -0.0060920715 2.8399975 12.050915 2.8399975 26.923916 C 2.8399975 41.79591 21.241995 53.852917 43.941998 53.852917 C 66.643 53.852917 85.04499 41.79591 85.04499 26.923916</pathLocation></ROOT><ROOT><strokeColor>#FF0000</strokeColor><width>0.8503937</width><transform>translate(3.8282995,3.8257005)</transform><pathLocation>M 76.534996 32.173912 C 76.534996 19.101913 59.591995 8.503914 38.692997 8.503914 C 17.792994 8.503914 0.84999686 19.101913 0.84999686 32.173912 C 0.84999686 45.24591 17.792994 55.842915 38.692997 55.842915 C 59.591995 55.842915 76.534996 45.24591 76.534996 32.173912</pathLocation></ROOT></COMMON>";
        JSONObject commonJson = null;
        try {
            commonJson = PDFXmlUtils.getTemplateInfo(str);
            return commonJson.getJSONArray("COMMON");
        }
        catch (Exception e) {
            log.info("getJzzCommonArray DocumentException", (Object)e);
            return null;
        }
    }

    private static List<PDFTemplatePosition> getTitlePositionList(JSONObject titleJson, String type) {
        JSONArray commonArray = titleJson.getJSONArray("COMMON");
        JSONObject typeJson = titleJson.getJSONObject(type);
        JSONArray dataArray = new JSONArray();
        dataArray.addAll((Collection)commonArray);
        dataArray.add((Object)typeJson);
        return dataArray.toJavaList(PDFTemplatePosition.class);
    }

    private static List<PDFTemplatePosition> getJsonPositionList(JSONObject json, String key) {
        PDFTemplatePosition position = (PDFTemplatePosition)json.getObject(key, PDFTemplatePosition.class);
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>(1);
        list.add(position);
        return list;
    }

    private FDEIPositionContent getContentPosition(FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType, List<Integer> specialLineNumList) {
        JSONObject dataJson = JSONObject.parseObject((String)JSON.toJSONString((Object)fullDigitalEInvoice));
        List<PDFTemplatePosition> basicPositionList = this.getBasicContentPositionList(dataJson, contentJson, specialType);
        if (fullDigitalEInvoice.isInput()) {
            PDFTemplatePosition currentPosition = this.getContentPositionByXmlAndStr(null, "inputDataFlag", contentJson, 0);
            basicPositionList.add(currentPosition);
        }
        ArrayList<List<PDFTemplatePosition>> detailPositionLists = new ArrayList<List<PDFTemplatePosition>>();
        ArrayList<List<PDFTemplatePosition>> subMoneyPositionLists = new ArrayList<List<PDFTemplatePosition>>();
        ArrayList<Integer> currentPageSizeList = new ArrayList<Integer>();
        ArrayList<PDFTemplatePosition> detailPositionList = new ArrayList<PDFTemplatePosition>();
        ArrayList emptyList = new ArrayList();
        ArrayList<PDFTemplatePosition> subMoneyPositionList = new ArrayList<PDFTemplatePosition>();
        ArrayList<PDFTemplatePosition> lastPositionList = new ArrayList<PDFTemplatePosition>();
        boolean transferFlag = SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType || SpecialTypeEnum.PASSENGER_TRANSPORT == specialType;
        int currentPageSize = 0;
        int currentPageIndex = 0;
        BigDecimal subMoney = BigDecimal.ZERO;
        BigDecimal subTax = BigDecimal.ZERO;
        boolean lastFlag = false;
        boolean lastDataFlag = false;
        JSONArray detailList = dataJson.getJSONArray("itemList");
        boolean differenceTaxFlag = false;
        String differenceTaxType = fullDigitalEInvoice.getDifferenceTaxType();
        if (DifferenceTaxTypeEnum.PART_DIFF == DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(differenceTaxType)) {
            differenceTaxFlag = true;
        }
        for (int i = 0; i < detailList.size(); ++i) {
            JSONObject detailJson = detailList.getJSONObject(i);
            for (String key : detailJson.keySet()) {
                PDFTemplatePosition contentPosition;
                if (!contentJson.containsKey((Object)key) || "goodsName".equals(key) || "specModel".equals(key) || "unit".equals(key)) continue;
                if ("taxRate".equals(key)) {
                    this.setTaxRate(detailJson, key, differenceTaxFlag);
                }
                if ((contentPosition = this.getContentPositionByXml(detailJson, key, contentJson, currentPageSize)) == null) continue;
                detailPositionList.add(contentPosition);
            }
            subMoney = subMoney.add(BigDecimalUtil.transDecimal(detailJson.get((Object)"detailAmount")));
            subTax = subTax.add(BigDecimalUtil.transDecimal(detailJson.get((Object)"taxAmount")));
            String goodsName = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("goodsName"));
            int goodsNameMaxLength = 11;
            try {
                goodsNameMaxLength = contentJson.getJSONObject("goodsName").getInteger("maxLength");
            }
            catch (Exception contentPosition) {
                // empty catch block
            }
            List<String> goodsNameList = EInvoicePdfUtils.subStringByChineseLength(goodsName, goodsNameMaxLength, true);
            String specModel = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("specModel"));
            JSONObject specModelJson = contentJson.getJSONObject("specModel");
            if (transferFlag) {
                specModelJson = null;
            }
            List<Object> specModelList = new ArrayList();
            if (specModelJson != null) {
                int specModelMaxLength = 7;
                try {
                    specModelMaxLength = specModelJson.getInteger("maxLength");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                specModelList = EInvoicePdfUtils.subStringByChineseLength(specModel, specModelMaxLength, true);
            }
            String unit = null;
            int unitMaxLength = 0;
            if (SpecialTypeEnum.PASSENGER_TRANSPORT != specialType) {
                unit = EInvoicePdfUtils.replaceBreakLine(detailJson.getString("unit"));
                unitMaxLength = 4;
                try {
                    unitMaxLength = contentJson.getJSONObject("unit").getInteger("maxLength");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            List<String> unitList = EInvoicePdfUtils.subStringByChineseLength(unit, unitMaxLength, true);
            int maxNum = Math.max(Math.max(goodsNameList.size(), specModelList.size()), unitList.size());
            for (int j = 0; j < maxNum; ++j) {
                PDFTemplatePosition contentPosition;
                if (j < goodsNameList.size() && !StrUtil.isEmpty(goodsNameList.get(j))) {
                    String currentgoodsName = goodsNameList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentgoodsName, "goodsName", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                if (j < specModelList.size() && !StrUtil.isEmpty((CharSequence)specModelList.get(j))) {
                    String currentspecModel = (String)specModelList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentspecModel, "specModel", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                if (j < unitList.size() && !StrUtil.isEmpty(unitList.get(j))) {
                    String currentUnit = unitList.get(j);
                    contentPosition = this.getContentPositionByXmlAndStr(currentUnit, "unit", contentJson, currentPageSize);
                    detailPositionList.add(contentPosition);
                }
                ++currentPageSize;
                if (i == detailList.size() - 1 && j == maxNum - 1) {
                    lastDataFlag = true;
                }
                if (lastDataFlag && specialLineNumList.size() < 2) {
                    lastFlag = true;
                }
                int specialMaxNum = 47;
                if (currentPageIndex == 0 && transferFlag) {
                    specialMaxNum = 20;
                }
                if (!lastDataFlag && currentPageSize < specialMaxNum) continue;
                int diffPageY = currentPageSize - 8;
                float totalAmountY = 0.0f;
                if (lastFlag && currentPageIndex == 0) {
                    totalAmountY = EInvoicePdfUtils.getPxByMm(5.0f);
                }
                this.setTotalMoneyList(detailPositionLists, detailPositionList, fullDigitalEInvoice, contentJson, totalAmountY, diffPageY);
                this.setSubMoneyList(subMoneyPositionLists, subMoneyPositionList, contentJson, subMoney, subTax, diffPageY);
                currentPageSizeList.add(currentPageSize);
                ++currentPageIndex;
                currentPageSize = 0;
                subMoney = BigDecimal.ZERO;
                subTax = BigDecimal.ZERO;
                detailPositionList = emptyList;
                subMoneyPositionList = emptyList;
            }
        }
        PDFTemplatePosition drawer = this.getContentPositionByXmlAndStr(fullDigitalEInvoice.getDrawer(), "drawer", contentJson, 0);
        ArrayList<PDFTemplatePosition> drawerList = new ArrayList<PDFTemplatePosition>();
        drawerList.add(drawer);
        this.setLastDataList(lastPositionList, contentJson, fullDigitalEInvoice);
        List<List<PDFTemplatePosition>> remarkList = this.getRemarkList(contentJson, fullDigitalEInvoice.getRemark());
        if (!remarkList.isEmpty()) {
            lastPositionList.addAll((Collection<PDFTemplatePosition>)remarkList.get(0));
        }
        Image image = QRCodeUtil.encoderQRCodeImage(fullDigitalEInvoice);
        String ewmLocation = this.getTextLocationByXml(contentJson.getJSONObject("qrCode"), 0);
        FDEIPositionContent fdeiPositionContent = new FDEIPositionContent();
        fdeiPositionContent.setBasicPositionList(basicPositionList);
        fdeiPositionContent.setCurrentPageSizeList(currentPageSizeList);
        fdeiPositionContent.setDetailPositionList(detailPositionLists);
        fdeiPositionContent.setSubMoneyPositionList(subMoneyPositionLists);
        fdeiPositionContent.setLastPositionList(lastPositionList);
        fdeiPositionContent.setRemarkPositionList(remarkList);
        fdeiPositionContent.setPageNumber(currentPageIndex);
        fdeiPositionContent.setEwmImage(image);
        fdeiPositionContent.setEwmLocation(ewmLocation);
        fdeiPositionContent.setDrawerPositionList(drawerList);
        fdeiPositionContent.setTest(fullDigitalEInvoice.isTest());
        fdeiPositionContent.setInput(fullDigitalEInvoice.isInput());
        return fdeiPositionContent;
    }

    private void setSpecialDataList(List<List<PDFTemplatePosition>> specialDataList, List<Integer> specialLineNumList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, SpecialTypeEnum specialType) {
        JSONArray specialArray;
        if (SpecialTypeEnum.CARGO_TRANSPORT_SERVICE == specialType) {
            List<CargoTransportItem> cargoTransportList = fullDigitalEInvoice.getCargoTransportList();
            specialArray = new JSONArray(cargoTransportList.size());
            specialArray.addAll(cargoTransportList);
        } else if (SpecialTypeEnum.PASSENGER_TRANSPORT == specialType) {
            List<PassengerTransportItem> passengerTransportList = fullDigitalEInvoice.getTravelerList();
            specialArray = new JSONArray(passengerTransportList.size());
            specialArray.addAll(passengerTransportList);
        } else {
            return;
        }
        if (!specialArray.isEmpty()) {
            Map<String, List<String>> specialDataMap = EInvoicePdfUtils.getSpecialDataMap(fullDigitalEInvoice, contentJson, specialType);
            if (specialDataMap.isEmpty()) {
                return;
            }
            List<String> remove = specialDataMap.remove("maxNum");
            int maxNum = Integer.parseInt(remove.get(0));
            List<Object> specialPositionList = new ArrayList();
            int pageNo = 0;
            int lineNum = 0;
            for (int i = 0; i < maxNum; ++i) {
                int maxLineNum;
                for (Map.Entry<String, List<String>> entry : specialDataMap.entrySet()) {
                    String key = entry.getKey();
                    List<String> valueList = entry.getValue();
                    if (i >= valueList.size()) continue;
                    String value = valueList.get(i);
                    PDFTemplatePosition contentPosition = this.getContentPositionByXmlAndStr(value, key, contentJson, lineNum);
                    specialPositionList.add(contentPosition);
                }
                int n = maxLineNum = pageNo == 0 ? 21 : 47;
                if (++lineNum != maxLineNum && i != maxNum - 1) continue;
                specialDataList.add(specialPositionList);
                if (lineNum < 8) {
                    lineNum = 8;
                }
                specialLineNumList.add(lineNum);
                specialPositionList = Collections.emptyList();
                lineNum = 0;
                ++pageNo;
            }
        }
    }

    private void setTaxRate(JSONObject detailJson, String key, boolean differenceTaxFlag) {
        ZeroTaxRateFlagEnum zeroTaxRateFlag;
        String taxRateStr = "***";
        String zeroTaxRateFlagStr = detailJson.getString("zeroTaxRateFlag");
        boolean zeroTaxFlag = false;
        if (!StrUtil.isEmpty(zeroTaxRateFlagStr) && (zeroTaxRateFlag = ZeroTaxRateFlagEnum.getZeroTaxRateFlagByValue(zeroTaxRateFlagStr)) != null) {
            if (!differenceTaxFlag) {
                taxRateStr = zeroTaxRateFlag.getMsg();
            }
            detailJson.put("taxAmount", (Object)zeroTaxRateFlag.getTaxAmount());
            zeroTaxFlag = true;
        }
        if (!differenceTaxFlag && !zeroTaxFlag) {
            BigDecimal taxRate = BigDecimalUtil.transDecimal(detailJson.getBigDecimal(key));
            taxRateStr = taxRate.compareTo(new BigDecimal("1")) <= 0 ? taxRate.multiply(new BigDecimal("100")).stripTrailingZeros().toPlainString() + "%" : taxRate.stripTrailingZeros().toPlainString() + "%";
        }
        detailJson.put(key, (Object)taxRateStr);
    }

    private void setLastDataList(List<PDFTemplatePosition> lastPositionList, JSONObject contentJson, FullDigitalEInvoice fullDigitalEInvoice) {
        BigDecimal totalAmount = fullDigitalEInvoice.getTotalAmount();
        lastPositionList.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(totalAmount), "totalAmount", contentJson, 0));
        lastPositionList.add(this.getContentPositionByXmlAndStr(MoneyUtil.moneyCapital(EInvoicePdfUtils.getPriceWithScale(totalAmount)), "totalAmountDX", contentJson, 0));
    }

    private void setTotalMoneyList(List<List<PDFTemplatePosition>> detailPositionLists, List<PDFTemplatePosition> detailPositionList, FullDigitalEInvoice fullDigitalEInvoice, JSONObject contentJson, float totalAmountY, int diffPageY) {
        BigDecimal invoiceAmount = fullDigitalEInvoice.getInvoiceAmount();
        BigDecimal totalTaxAmount = fullDigitalEInvoice.getTotalTaxAmount();
        detailPositionList.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(invoiceAmount), "invoiceAmount", contentJson, diffPageY, totalAmountY));
        detailPositionList.add(this.getContentPositionByXmlAndStrWithDiff(EInvoicePdfUtils.getPriceWithSymbol(totalTaxAmount), "totalTaxAmount", contentJson, diffPageY, totalAmountY));
        detailPositionLists.add(detailPositionList);
    }

    private void setSubMoneyList(List<List<PDFTemplatePosition>> subMoneyPositionLists, List<PDFTemplatePosition> subMoneyPositionList, JSONObject contentJson, BigDecimal subMoney, BigDecimal subTax, int diffPageY) {
        subMoneyPositionList.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(subMoney), "subAmWithoutTax", contentJson, diffPageY));
        subMoneyPositionList.add(this.getContentPositionByXmlAndStr(EInvoicePdfUtils.getPriceWithSymbol(subTax), "subTaxAm", contentJson, diffPageY));
        subMoneyPositionLists.add(subMoneyPositionList);
    }

    public List<PDFTemplatePosition> getBasicContentPositionList(JSONObject dataJson, JSONObject contentJson, SpecialTypeEnum specialType) {
        ArrayList<PDFTemplatePosition> list = new ArrayList<PDFTemplatePosition>();
        for (String key : contentJson.keySet()) {
            PDFTemplatePosition currentPosition;
            if ("differenceTaxType".equals(key)) {
                DifferenceTaxTypeEnum differenceTaxType = DifferenceTaxTypeEnum.getDifferenceTaxTypeByValue(dataJson.getString(key));
                if (differenceTaxType == null) continue;
                currentPosition = this.getContentPositionByXmlAndStr(differenceTaxType.getMsg(), key, contentJson, 0);
                list.add(currentPosition);
                continue;
            }
            if ("specialMark".equals(key) && specialType != null) {
                PDFTemplatePosition currentPosition2 = this.getContentPositionByXmlAndStr(specialType.getMsg(), key, contentJson, 0);
                list.add(currentPosition2);
                continue;
            }
            if (!dataJson.containsKey((Object)key)) continue;
            String invoiceType = dataJson.getString("invoiceType");
            if (!InvoiceTypeEnum.TRAIN_INVOICE.getValue().equals(invoiceType) && !InvoiceTypeEnum.AIR_INVOICE.getValue().equals(invoiceType) && ("itemList".equals(key) || "drawer".equals(key) || "invoiceAmount".equals(key) || "totalTaxAmount".equals(key) || "totalAmount".equals(key) || "remark".equals(key) || "qrCode".equals(key))) continue;
            if ("issueTime".equals(key)) {
                String issueTimeCn = DateUtil.formatDate("yyyy\u5e74MM\u6708dd\u65e5", dataJson.getDate(key));
                dataJson.put(key, (Object)issueTimeCn);
            }
            if ((currentPosition = this.getContentPositionByXml(dataJson, key, contentJson, 0)) == null) continue;
            list.add(currentPosition);
        }
        return list;
    }

    private void setDifferenceTaxType(JSONObject contentJson, JSONObject dataJson, List<PDFTemplatePosition> list) {
        BigDecimal totalAmount = dataJson.getBigDecimal("totalAmount");
        if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
            PDFTemplatePosition currentPosition = this.getContentPositionByXmlAndStr(null, "negativeMark", contentJson, 0);
            list.add(currentPosition);
        }
    }

    private PDFTemplatePosition getContentPositionByXml(JSONObject dataJson, String key, JSONObject positionJson, int currentPageSize) {
        return this.getContentPositionByXmlAndStr(dataJson.getString(key), key, positionJson, currentPageSize);
    }

    public PDFTemplatePosition getContentPositionByXmlAndStr(String str, String key, JSONObject positionJson, int currentPageSize) {
        return this.getContentPositionByXmlAndStrWithDiff(str, key, positionJson, currentPageSize, 0.0f);
    }

    private PDFTemplatePosition getContentPositionByXmlAndStrWithDiff(String str, String key, JSONObject positionJson, int currentPageSize, float diffY) {
        PDFTemplatePosition position = (PDFTemplatePosition)positionJson.getObject(key, PDFTemplatePosition.class);
        if (position == null) {
            return null;
        }
        if (str != null) {
            position.setMsg(str);
        }
        String textLocation = this.getTextLocation(position.getTextLocation(), currentPageSize, diffY);
        position.setTextLocation(textLocation);
        return position;
    }

    private String getTextLocation(String textLocation, int currentPageSize, float diffY) {
        if (currentPageSize > 0 || diffY != 0.0f) {
            StringBuilder textLocationBd = new StringBuilder();
            String[] textLocationArr = textLocation.split(",");
            diffY = Float.parseFloat(textLocationArr[1]) + diffY;
            if (currentPageSize > 0) {
                diffY -= EInvoicePdfUtils.getPxByMm(4.5f * (float)currentPageSize);
            }
            textLocationBd.append(textLocationArr[0]).append(",").append(diffY);
            if (textLocationArr.length > 2) {
                for (int i = 2; i < textLocationArr.length; ++i) {
                    textLocationBd.append(",").append(textLocationArr[i]);
                }
            }
            textLocation = textLocationBd.toString();
        }
        return textLocation;
    }

    private String getTextLocationByXml(JSONObject contentJson, int currentPageSize) {
        StringBuilder textLocation = new StringBuilder(contentJson.getString("textLocation"));
        if (currentPageSize > 0) {
            String[] textLocationArr = textLocation.toString().split(",");
            float diffY = Float.parseFloat(textLocationArr[1]) - EInvoicePdfUtils.getPxByMm(4.5f * (float)currentPageSize);
            textLocation = new StringBuilder(textLocationArr[0]);
            textLocation.append(",").append(diffY);
            if (textLocationArr.length > 2) {
                for (int i = 2; i < textLocationArr.length; ++i) {
                    textLocation.append(",").append(textLocationArr[i]);
                }
            }
        }
        return textLocation.toString();
    }

    private List<PDFTemplatePosition> getPageNoList(PDFTemplatePosition pageNoPosition, int pageNum, int currentPageNo) {
        PDFTemplatePosition currentPosition;
        try {
            currentPosition = (PDFTemplatePosition)pageNoPosition.getClass().getMethod("clone", new Class[0]).invoke((Object)pageNoPosition, new Object[0]);
        }
        catch (Exception ignore) {
            currentPosition = pageNoPosition;
        }
        String msg = currentPosition.getMsg();
        msg = msg.replace("A", String.valueOf(pageNum));
        msg = msg.replace("B", String.valueOf(currentPageNo));
        String textLocation = currentPosition.getTextLocation();
        String[] textLocationArr = textLocation.split(",");
        if (pageNum >= 10) {
            float ymX = Float.parseFloat(textLocationArr[0]) - 4.1f;
            if (currentPageNo >= 10) {
                ymX -= 4.2f;
            }
            textLocation = ymX + "," + textLocationArr[1];
        }
        currentPosition.setMsg(msg);
        currentPosition.setTextLocation(textLocation);
        ArrayList<PDFTemplatePosition> pageNoList = new ArrayList<PDFTemplatePosition>();
        pageNoList.add(currentPosition);
        return pageNoList;
    }

    private List<List<PDFTemplatePosition>> getRemarkList(JSONObject contentJson, String remark) {
        List<String> remarkDetailList = EInvoicePdfUtils.subStringByChineseLength(remark, 61, true);
        float diffY = 0.0f;
        ArrayList<List<PDFTemplatePosition>> remarkPositionList = new ArrayList<List<PDFTemplatePosition>>();
        ArrayList<PDFTemplatePosition> remarkList = new ArrayList<PDFTemplatePosition>(8);
        boolean firstPage = true;
        int pageSize = 0;
        float firstLineHigh = EInvoicePdfUtils.getPxByMm(3.0f);
        float moreLineHigh = EInvoicePdfUtils.getPxByMm(3.5f);
        for (String remarkStr : remarkDetailList) {
            remarkList.add(this.getContentPositionByXmlAndStrWithDiff(remarkStr, "remark", contentJson, 0, diffY));
            diffY -= firstPage ? firstLineHigh : moreLineHigh;
            if ((++pageSize != 6 || !firstPage) && pageSize != 66) continue;
            remarkPositionList.add(remarkList);
            pageSize = 0;
            diffY = EInvoicePdfUtils.getPxByMm(8.0f);
            firstPage = false;
            remarkList = new ArrayList();
        }
        if (!remarkList.isEmpty()) {
            remarkPositionList.add(remarkList);
        }
        return remarkPositionList;
    }
}

