/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.service.generate;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.service.einvoicepdf.FullDigitalEInvoicePdfService;
import kd.imc.rim.file.service.einvoicepdf.dto.PDFTemplatePosition;
import kd.imc.rim.file.service.einvoicepdf.enums.InvoiceTypeEnum;
import kd.imc.rim.file.service.generate.model.FullDigitalEInvoiceAir;
import kd.imc.rim.file.service.generate.model.FullDigitalEInvoiceTrain;
import kd.imc.rim.file.service.generate.model.item.FullDigitalEInvoiceAirItem;
import kd.imc.rim.file.utils.BigDecimalUtil;
import kd.imc.rim.file.utils.DateUtil;
import kd.imc.rim.file.utils.PDFXmlUtils;
import kd.imc.rim.file.utils.StrUtil;
import kd.imc.rim.file.utils.common.QRCodeUtil;
import kd.imc.rim.file.utils.pdf.PDFTemplateUtils;
import org.apache.commons.lang3.StringUtils;

public class FullDigitalEInvoiceTrainAndAirPdfService {
    private static final Log log = LogFactory.getLog(FullDigitalEInvoiceTrainAndAirPdfService.class);
    private FullDigitalEInvoicePdfService fullDigitalEInvoicePdfService = new FullDigitalEInvoicePdfService();

    public byte[] createElcTrain(FullDigitalEInvoiceTrain fullDigitalEInvoice) throws DocumentException {
        String invoiceStr = JSONObject.toJSONString((Object)fullDigitalEInvoice);
        JSONObject dataJson = JSON.parseObject((String)invoiceStr);
        String carriageAndSeatNo = fullDigitalEInvoice.getCarriageAndSeatNo();
        if (StrUtil.isEmpty(carriageAndSeatNo)) {
            carriageAndSeatNo = dataJson.getString("carriage") + dataJson.getString("seatNo");
            dataJson.put("carriageAndSeatNo", (Object)carriageAndSeatNo);
        }
        LocalDateTime issueDate = fullDigitalEInvoice.getInvoiceDate();
        dataJson.put("issueDate", (Object)DateUtil.formatDate("yyyy\u5e74MM\u6708dd\u65e5", issueDate));
        dataJson.put("invoiceDate", (Object)DateUtil.formatDate("yyyy\u5e74MM\u6708dd\u65e5", fullDigitalEInvoice.getTrainTime()));
        dataJson.put("stationGetOn", (Object)fullDigitalEInvoice.getDepartureStation());
        dataJson.put("stationGetOff", (Object)fullDigitalEInvoice.getDestinationStation());
        dataJson.put("seat", (Object)fullDigitalEInvoice.getSeatLevel());
        dataJson.put("trainTime", (Object)fullDigitalEInvoice.getDepartureTime());
        dataJson.put("customerIdentityNum", (Object)fullDigitalEInvoice.getIdNumber());
        dataJson.put("buyerName", (Object)fullDigitalEInvoice.getPurchaserName());
        dataJson.put("buyerTaxNo", (Object)fullDigitalEInvoice.getPurchaserUnifiedSocialCreditCode());
        dataJson.put("electronicTicketNum", (Object)fullDigitalEInvoice.getEleTicketNumber());
        dataJson.put("phonicsOfStationGetOn", (Object)fullDigitalEInvoice.getDepartureStationPhonics());
        dataJson.put("phonicsOfStationGetOff", (Object)fullDigitalEInvoice.getDestinationStationPhonics());
        String typeOfBusiness = fullDigitalEInvoice.getBusinessType();
        if ("2".equals(typeOfBusiness)) {
            dataJson.put("refundedAmountTitle", (Object)"\u9000\u7968\u8d39:");
        } else {
            dataJson.put("amountTitle", (Object)"\u7968\u4ef7:");
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getTotalAmount())) {
            dataJson.put("totalAmount", (Object)("\u00a5" + fullDigitalEInvoice.getTotalAmount()));
        }
        return this.createCommon(dataJson, issueDate);
    }

    public byte[] createElcAir(FullDigitalEInvoiceAir fullDigitalEInvoice) throws DocumentException {
        String invoiceStr = JSONObject.toJSONString((Object)fullDigitalEInvoice);
        JSONObject dataJson = JSON.parseObject((String)invoiceStr);
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getTicketPrice())) {
            dataJson.put("invoiceAmount", (Object)("CNY " + BigDecimalUtil.transDecimal(fullDigitalEInvoice.getTicketPrice()).setScale(2)));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getTotalAmount())) {
            dataJson.put("totalAmount", (Object)("CNY " + BigDecimalUtil.transDecimal(fullDigitalEInvoice.getTotalAmount()).setScale(2)));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getFuelSurcharge())) {
            dataJson.put("fuelSurcharge", (Object)("CNY " + BigDecimalUtil.transDecimal(fullDigitalEInvoice.getFuelSurcharge()).setScale(2)));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getTaxAmount())) {
            dataJson.put("totalTaxAmount", (Object)("CNY " + BigDecimalUtil.transDecimal(fullDigitalEInvoice.getTaxAmount()).setScale(2)));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getAirportConstructionFee())) {
            dataJson.put("airportConstructionFee", (Object)("CNY " + BigDecimalUtil.transDecimal(fullDigitalEInvoice.getAirportConstructionFee()).setScale(2)));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getOtherTotalTaxAmount())) {
            dataJson.put("otherTotalTaxAmount", (Object)("CNY " + BigDecimalUtil.transDecimal(fullDigitalEInvoice.getOtherTotalTaxAmount()).setScale(2)));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getTaxRate())) {
            dataJson.put("taxRate", (Object)(new BigDecimal(fullDigitalEInvoice.getTaxRate()).multiply(new BigDecimal("100")).intValue() + "%"));
        }
        if (StringUtils.isNotEmpty((CharSequence)fullDigitalEInvoice.getInsurancePremium())) {
            dataJson.put("insurancePremium", (Object)BigDecimalUtil.transDecimal(fullDigitalEInvoice.getInsurancePremium()).setScale(2));
        }
        dataJson.put("issueDate", (Object)DateUtil.formatDate("yyyy-MM-dd", fullDigitalEInvoice.getIssueDate()));
        dataJson.put("checkCode", (Object)fullDigitalEInvoice.getVerificationCode());
        dataJson.put("buyerName", (Object)fullDigitalEInvoice.getPurchaserName());
        dataJson.put("unifiedSocialCreditCodeOfPurchaser", (Object)fullDigitalEInvoice.getPurchaserUnifiedSocialCreditCode());
        String internationalFlag = fullDigitalEInvoice.getInternationalFlag();
        if ("2".equals(internationalFlag)) {
            dataJson.put("internationalFlag", (Object)"\u56fd\u9645");
        } else {
            dataJson.put("internationalFlag", (Object)"\u56fd\u5185");
        }
        String invoiceStatus = dataJson.getString("invoiceStatus");
        if ("3".equals(invoiceStatus)) {
            dataJson.put("originalInvoiceNoTitle", (Object)"\u539f\u53d1\u7968\u53f7\u7801:");
            dataJson.put("invoiceStatus", (Object)"\u7ea2\u51b2");
        } else {
            dataJson.remove((Object)"originalInvoiceNo");
            dataJson.put("invoiceStatus", (Object)"\u6b63\u5e38");
        }
        List<FullDigitalEInvoiceAirItem> itemList = fullDigitalEInvoice.getItems();
        if (itemList != null && !itemList.isEmpty()) {
            for (int i = 0; i < itemList.size(); ++i) {
                FullDigitalEInvoiceAirItem fullDigitalEInvoiceAirItem = itemList.get(i);
                if (i == 0) {
                    dataJson.put("placeOfDeparture", (Object)fullDigitalEInvoiceAirItem.getPlaceOfDeparture());
                }
                dataJson.put("destination" + i, (Object)fullDigitalEInvoiceAirItem.getDestination());
                dataJson.put("carrier" + i, (Object)fullDigitalEInvoiceAirItem.getCarrier());
                dataJson.put("flightNum" + i, (Object)fullDigitalEInvoiceAirItem.getFlightNum());
                dataJson.put("seatGrade" + i, (Object)fullDigitalEInvoiceAirItem.getSeatGrade());
                if (fullDigitalEInvoiceAirItem.getCarrierDate() != null) {
                    dataJson.put("invoiceDate" + i, (Object)DateUtil.formatDate("yyyy-MM-dd", fullDigitalEInvoiceAirItem.getCarrierDate()));
                }
                dataJson.put("takePlaneTime" + i, (Object)fullDigitalEInvoiceAirItem.getTakePlaneTime());
                dataJson.put("fareBasis" + i, (Object)fullDigitalEInvoiceAirItem.getFareBasis());
                if (fullDigitalEInvoiceAirItem.getEffectiveDate() != null) {
                    dataJson.put("effectiveDate" + i, (Object)DateUtil.formatDate("yyyy-MM-dd", fullDigitalEInvoiceAirItem.getEffectiveDate()));
                }
                if (fullDigitalEInvoiceAirItem.getExpirationDate() != null) {
                    dataJson.put("expirationDate" + i, (Object)DateUtil.formatDate("yyyy-MM-dd", fullDigitalEInvoiceAirItem.getExpirationDate()));
                }
                dataJson.put("freeBaggageAllowance" + i, (Object)fullDigitalEInvoiceAirItem.getFreeBaggageAllowance());
            }
        }
        return this.createCommon(dataJson, fullDigitalEInvoice.getIssueDate());
    }

    private byte[] createCommon(JSONObject dataJson, LocalDateTime issueDate) throws DocumentException {
        BaseFont[] fonts;
        JSONObject templateJson = PDFXmlUtils.getPDFTemplateInfoFromXMLFile("template/full-digital-invoice-pdf.xml");
        if (templateJson.containsKey((Object)"TEMPLATE")) {
            templateJson = templateJson.getJSONObject("TEMPLATE");
        }
        String invoiceType = dataJson.getString("invoiceType");
        JSONObject templateContentJson = this.getTemplateContentJson(templateJson, invoiceType);
        String salerTaxNo = dataJson.getString("salerTaxNo");
        dataJson.remove((Object)"salerTaxNo");
        List<PDFTemplatePosition> basicPositionList = this.fullDigitalEInvoicePdfService.getBasicContentPositionList(dataJson, templateContentJson, null);
        if (dataJson.getBoolean("isInput") == null || dataJson.getBoolean("isInput").booleanValue()) {
            PDFTemplatePosition currentPosition = this.fullDigitalEInvoicePdfService.getContentPositionByXmlAndStr(null, "inputDataFlag", templateContentJson, 0);
            basicPositionList.add(currentPosition);
        }
        List<PDFTemplatePosition> jjzPositionList = null;
        String taxBureauCode = dataJson.getString("taxBureauCode");
        if (StringUtils.isNotEmpty((CharSequence)salerTaxNo) || StringUtils.isNotEmpty((CharSequence)taxBureauCode)) {
            JSONObject jjzJson = templateJson.getJSONObject("JJZ");
            jjzPositionList = FullDigitalEInvoicePdfService.getJJZPositionList(jjzJson, salerTaxNo, taxBureauCode, false);
        }
        String invoiceDateStr = DateUtil.formatDate("yyyyMMdd", issueDate);
        String invoiceNo = dataJson.getString("invoiceNo");
        String totalAmount = dataJson.getString("totalAmount");
        String ewmStr = null;
        Image image = null;
        try {
            ewmStr = QRCodeUtil.createStringByStr(invoiceType, invoiceNo, totalAmount, invoiceDateStr);
            image = Image.getInstance((byte[])QRCodeUtil.encoderQRCodeByte(ewmStr));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            BaseFont courierFont = BaseFont.createFont((String)"fonts/cour.ttf", (String)"Identity-H", (boolean)false);
            BaseFont kaiFont = BaseFont.createFont((String)"fonts/simkai.ttf", (String)"Identity-H", (boolean)false);
            BaseFont songFont = BaseFont.createFont((String)"fonts/simsun.ttc,0", (String)"Identity-H", (boolean)false);
            fonts = new BaseFont[]{songFont, courierFont, kaiFont};
        }
        catch (Exception e) {
            log.error("\u5b57\u4f53\u6587\u4ef6\u4e0d\u5b58\u5728", (Throwable)e);
            throw new KDException(new ErrorCode("B0321", "font file is not exist"), new Object[0]);
        }
        String templatePath = "template/full-digital-train-ele.pdf";
        if (InvoiceTypeEnum.AIR_INVOICE.getValue().equals(invoiceType)) {
            templatePath = "template/full-digital-air-ele.pdf";
        }
        byte[] tempBytes = PDFTemplateUtils.getPDFTemplateInfoBytes(templatePath);
        byte[] fileBytes = null;
        try (ByteArrayOutputStream bao = new ByteArrayOutputStream();){
            PdfStamper stamp = null;
            try (PdfReader reader = null;){
                JSONObject jjzIndexJson;
                String jjzIndex;
                reader = new PdfReader(tempBytes);
                stamp = new PdfStamper(reader, (OutputStream)bao);
                PdfContentByte under = stamp.getOverContent(1);
                this.fullDigitalEInvoicePdfService.setData(under, fonts, basicPositionList, 0.0f, 0.0f);
                if (jjzPositionList != null && !jjzPositionList.isEmpty() && StringUtils.isNotEmpty((CharSequence)(jjzIndex = (jjzIndexJson = templateContentJson.getJSONObject("jjzIndex")).getString("textLocation")))) {
                    String[] jjzIndexArr = jjzIndex.split(",");
                    this.fullDigitalEInvoicePdfService.setData(under, fonts, jjzPositionList, Float.parseFloat(jjzIndexArr[0]), Float.parseFloat(jjzIndexArr[1]));
                }
                if (dataJson.getBoolean("isInput") == null || dataJson.getBoolean("isInput").booleanValue()) {
                    try {
                        Rectangle rectangle = reader.getPageSize(1);
                        this.fullDigitalEInvoicePdfService.setInputWaterMark(under, rectangle.getWidth(), rectangle.getHeight(), fonts[2], false);
                    }
                    catch (Exception rectangle) {
                        // empty catch block
                    }
                }
                JSONObject qrCode = templateContentJson.getJSONObject("qrCode");
                String[] str = qrCode.getString("textLocation").split(",");
                String str1 = str[0];
                String str2 = str[1];
                float qrcodeScale = 37.0f;
                if (str.length == 3) {
                    qrcodeScale = Float.parseFloat(str[2]);
                }
                if (image != null) {
                    image.scalePercent(qrcodeScale);
                    image.setAbsolutePosition(Float.parseFloat(str1), Float.parseFloat(str2));
                    under.addImage(image);
                }
                stamp.setFormFlattening(true);
                stamp.close();
                fileBytes = bao.toByteArray();
            }
        }
        catch (Exception e) {
            log.error("\u751f\u6210PDF\u51fa\u9519\uff0c\u65e0\u6cd5\u6b63\u5e38\u8bfb\u53d6/\u5173\u95ed\u6587\u4ef6\u6d41", (Throwable)e);
            throw new KDException(new ErrorCode("B0001", "create pdf error by IOException"), new Object[0]);
        }
        return fileBytes;
    }

    private JSONObject getTemplateContentJson(JSONObject templateJson, String invoiceType) {
        JSONObject contentJson = new JSONObject();
        contentJson.putAll((Map)templateJson.getJSONObject("CONTENT"));
        String specialInvoiceType = null;
        if (InvoiceTypeEnum.TRAIN_INVOICE.getValue().equals(invoiceType)) {
            specialInvoiceType = "trainEle";
        } else if (InvoiceTypeEnum.AIR_INVOICE.getValue().equals(invoiceType)) {
            specialInvoiceType = "airEle";
        }
        if (specialInvoiceType != null && contentJson.getJSONObject(specialInvoiceType) != null) {
            contentJson.putAll((Map)contentJson.getJSONObject(specialInvoiceType));
        }
        return contentJson;
    }
}

