/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.aws.ofd.util.ofd.OfdConvertUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.pdfbox.jbig2.JBIG2ImageReader;
import org.apache.pdfbox.jbig2.JBIG2ImageReaderSpi;
import org.apache.pdfbox.jbig2.io.DefaultInputStreamFactory;

public class ExportQrCode {
    private static final Log LOGGER = LogFactory.getLog(ExportQrCode.class);
    private static final String SUFFIX_JB2 = "jb2";

    public static String getImageBase64(byte[] imageByte, String fileSuffix) {
        if (SUFFIX_JB2.equals(fileSuffix)) {
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(imageByte);
                 ImageInputStream imageInputStream = new DefaultInputStreamFactory().getInputStream((InputStream)inputStream);
                 ByteArrayOutputStream out = new ByteArrayOutputStream();){
                JBIG2ImageReader imageReader = new JBIG2ImageReader((ImageReaderSpi)new JBIG2ImageReaderSpi());
                imageReader.setInput(imageInputStream);
                BufferedImage bufferedImage = imageReader.read(0, imageReader.getDefaultReadParam());
                ImageIO.write((RenderedImage)bufferedImage, "PNG", out);
                imageByte = out.toByteArray();
            }
            catch (Exception e) {
                LOGGER.info(OfdErrorType.CREATE_QR_CODE_ERROR.getDescription() + e.getMessage());
            }
        } else {
            try {
                imageByte = OfdConvertUtil.imageToPng(imageByte);
            }
            catch (IOException e) {
                LOGGER.info(OfdErrorType.CREATE_QR_CODE_ERROR.getDescription() + e.getMessage());
            }
        }
        if (imageByte != null && imageByte.length > 0) {
            return Base64.encodeBase64String((byte[])imageByte);
        }
        return null;
    }
}

