/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class MathUtil {
    private static final String[] CN_UPPER_NUMBER = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String[] CN_UPPER_MONETRAY_UNIT = new String[]{"\u5206", "\u89d2", "\u5706", "\u62fe", "\u4f70", "\u4edf", "\u4e07", "\u62fe", "\u4f70", "\u4edf", "\u4ebf", "\u62fe", "\u4f70", "\u4edf", "\u5146", "\u62fe", "\u4f70", "\u4edf"};
    private static final char CN_FULL = '\u6574';
    private static final char CN_NEGATIVE = '\u8d1f';
    private static final int MONEY_PRECISION = 2;
    private static final String CN_ZEOR_FULL = "\u96f6\u5706\u6574";

    public static String number2CNMontrayUnit(BigDecimal numberOfMoney) {
        StringBuilder sb = new StringBuilder();
        int signum = numberOfMoney.signum();
        if (signum == 0) {
            return CN_ZEOR_FULL;
        }
        long number = numberOfMoney.movePointRight(2).setScale(0, 4).abs().longValue();
        long scale = number % 100L;
        int numUnit = 0;
        int numIndex = 0;
        boolean getZero = false;
        if (scale <= 0L) {
            numIndex = 2;
            number /= 100L;
            getZero = true;
        }
        if (scale > 0L && scale % 10L <= 0L) {
            numIndex = 1;
            number /= 10L;
            getZero = true;
        }
        int zeroSize = 0;
        while (number > 0L) {
            numUnit = (int)(number % 10L);
            if (numUnit > 0) {
                if (numIndex == 9 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[6]);
                }
                if (numIndex == 13 && zeroSize >= 3) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[10]);
                }
                sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                getZero = false;
                zeroSize = 0;
            } else {
                ++zeroSize;
                if (!getZero) {
                    sb.insert(0, CN_UPPER_NUMBER[numUnit]);
                }
                if (numIndex == 2) {
                    if (number > 0L) {
                        sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                    }
                } else if ((numIndex - 2) % 4 == 0 && number % 1000L > 0L) {
                    sb.insert(0, CN_UPPER_MONETRAY_UNIT[numIndex]);
                }
                getZero = true;
            }
            number /= 10L;
            ++numIndex;
        }
        if (signum == -1) {
            sb.insert(0, '\u8d1f');
        }
        if (scale <= 0L) {
            sb.append('\u6574');
        }
        return sb.toString();
    }

    public static int mul2(String value1, String value2) {
        BigDecimal b1 = new BigDecimal(value1);
        BigDecimal b2 = new BigDecimal(value2);
        return b1.multiply(b2).intValue();
    }

    public static String formatDoubleDigit(double value) {
        DecimalFormat df = new DecimalFormat("##########0.00");
        df.setRoundingMode(RoundingMode.HALF_UP);
        return df.format(value);
    }

    public static BigDecimal transDecimal(Object val) {
        if (null == val || "".equals(val)) {
            return BigDecimal.ZERO;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        try {
            return new BigDecimal(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            return BigDecimal.ZERO;
        }
    }

    public static String format(BigDecimal val, String format) {
        if (val == null) {
            return "";
        }
        DecimalFormat decimalFormat = new DecimalFormat(format);
        return decimalFormat.format(val);
    }
}

