/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.imc.rim.file.pdfanalysis.utils.XmlUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;

public class PDFXmlUtils {
    private static ConcurrentHashMap<String, Object> cacheXMLInfoMap = new ConcurrentHashMap();

    public static JSONObject getPDFTemplateInfoFromXMLFile(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        if (!cacheXMLInfoMap.containsKey(fileName)) {
            try {
                String temp = PDFXmlUtils.readTempFileStr(filePath);
                JSONObject templateInfo = PDFXmlUtils.getTemplateInfo(temp);
                cacheXMLInfoMap.putIfAbsent(fileName, templateInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (JSONObject)cacheXMLInfoMap.get(fileName);
    }

    public static JSONObject getTemplateInfo(String xmlStr) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        JSONObject json = new JSONObject();
        XmlUtil.dom4j2Json(doc.getRootElement(), json);
        PDFXmlUtils.removeRoot(new JSONObject(), "", json);
        return json;
    }

    private static void removeRoot(JSONObject parentJson, String currentKey, JSONObject json) {
        for (String key : json.keySet()) {
            if ("ROOT".equals(key)) {
                Object rootObj = json.get((Object)key);
                if (!(rootObj instanceof JSONObject) && !(rootObj instanceof JSONArray)) break;
                parentJson.put(currentKey, rootObj);
                break;
            }
            if (!(json.get((Object)key) instanceof JSONObject)) continue;
            PDFXmlUtils.removeRoot(json, key, json.getJSONObject(key));
        }
    }

    public static String readTempFileStr(String path) throws FileNotFoundException {
        StringBuilder sb = new StringBuilder();
        try (InputStream fis = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            String lineTxt;
            InputStreamReader read = new InputStreamReader(fis, StandardCharsets.UTF_8);
            BufferedReader bufferedReader = new BufferedReader(read);
            while ((lineTxt = bufferedReader.readLine()) != null) {
                sb.append(lineTxt);
            }
            read.close();
        }
        catch (Exception e) {
            throw new FileNotFoundException(String.format(ResManager.loadKDString((String)"\u6a21\u7248\u6587\u4ef6\u4e0d\u5b58\u5728%1$s", (String)"PDFXmlUtils_1", (String)"imc-rim-file", (Object[])new Object[0]), path));
        }
        return sb.toString();
    }
}

