/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.function.BiFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.utils.HexUtil;
import kd.imc.rim.file.utils.PdfVerifyResult;
import kd.imc.rim.file.utils.SM3Util;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PdfVerifyUtils {
    private static Log LOGGER = LogFactory.getLog(PdfVerifyUtils.class);
    public static final PdfVerifyResult FAIL = new PdfVerifyResult(false, "");
    private static final BiFunction<byte[], PdfVerifyResult, PdfVerifyResult>[] VERIFIER_ARR = new BiFunction[]{(pdfByte, previousResult) -> PdfVerifyUtils.verifyNotStandardPDFWithCerInfo((byte[])pdfByte), (pdfByte, previousResult) -> PdfVerifyUtils.verifySM2PDFWithCerInfo((byte[])pdfByte), (pdfByte, previousResult) -> PdfVerifyUtils.verifyFIPDFWithCerInfo((byte[])pdfByte)};

    public static PdfVerifyResult verifyWithCerInfo(byte[] pdfByte) {
        PdfVerifyResult pdfVerifyResult = FAIL;
        for (BiFunction<byte[], PdfVerifyResult, PdfVerifyResult> verifier : VERIFIER_ARR) {
            try {
                pdfVerifyResult = verifier.apply(pdfByte, pdfVerifyResult);
                if (!pdfVerifyResult.isVerify()) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pdfVerifyResult;
    }

    public static PdfVerifyResult verifySM2PDFWithCerInfo(byte[] pdfBytes) {
        PdfVerifyResult pdfVerifyResult;
        PDDocument pdfDoc = null;
        ASN1InputStream signatureAsn1InputStream = null;
        LOGGER.info("verifySM2PDFWithCerInfo");
        try {
            pdfDoc = PDDocument.load((byte[])pdfBytes);
            PDSignature signature = (PDSignature)pdfDoc.getSignatureDictionaries().get(0);
            byte[] signatureAsBytes = signature.getContents(pdfBytes);
            byte[] signedContentAsBytes = signature.getSignedContent(pdfBytes);
            byte[] calDigest = SM3Util.doDigest(signedContentAsBytes);
            String calDigestHex = HexUtil.encodeHexStr(calDigest);
            signatureAsn1InputStream = new ASN1InputStream(signatureAsBytes);
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)signatureAsn1InputStream.readObject());
            ASN1Sequence signedData = ASN1Sequence.getInstance((Object)asn1Sequence.getObjectAt(0));
            ASN1OctetString signCert = ASN1OctetString.getInstance((Object)asn1Sequence.getObjectAt(1));
            DERBitString signValue = (DERBitString)asn1Sequence.getObjectAt(3);
            DERBitString signHashDer = (DERBitString)signedData.getObjectAt(3);
            String signHashHex = HexUtil.encodeHexStr(signHashDer.getOctets());
            boolean hashFlag = signHashHex.equals(calDigestHex);
            if (!hashFlag) {
                PdfVerifyResult pdfVerifyResult2 = FAIL;
                return pdfVerifyResult2;
            }
            pdfVerifyResult = PdfVerifyUtils.verifyWithCertAndGetInfo(signCert.getOctets(), signedData.getEncoded(), signValue.getOctets());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (signatureAsn1InputStream != null) {
                try {
                    signatureAsn1InputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (pdfDoc != null) {
                try {
                    pdfDoc.close();
                }
                catch (IOException iOException) {}
            }
        }
        return pdfVerifyResult;
    }

    public static PdfVerifyResult verifyFIPDFWithCerInfo(byte[] pdfBytes) {
        PDDocument pdfDoc = null;
        ASN1InputStream signatureAsn1InputStream = null;
        LOGGER.info("verifyFIPDFWithCerInfo");
        try {
            pdfDoc = PDDocument.load((byte[])pdfBytes);
            PDSignature signature = (PDSignature)pdfDoc.getSignatureDictionaries().get(0);
            byte[] signatureAsBytes = signature.getContents(pdfBytes);
            try {
                Base64.getDecoder().decode(signatureAsBytes);
            }
            catch (Exception exception) {
                // empty catch block
            }
            byte[] signedContentAsBytes = signature.getSignedContent(pdfBytes);
            signatureAsn1InputStream = new ASN1InputStream(signatureAsBytes);
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)signatureAsn1InputStream.readObject());
            ASN1Sequence instance = ASN1Sequence.getInstance((Object)DLTaggedObject.getInstance((Object)asn1Sequence.getObjectAt(1)));
            ASN1Sequence certSequence = DLSequence.getInstance((Object)DLTaggedObject.getInstance((Object)instance.getObjectAt(1)));
            ASN1Sequence signValueSeq = DLSequence.getInstance((Object)instance.getObjectAt(5));
            byte[] signInfoByte = instance.getObjectAt(4).toASN1Primitive().getEncoded();
            byte[] pdfSm3Byte = SM3Util.doDigest(signedContentAsBytes);
            byte[] signInfoSm3Byte = SM3Util.doDigest(signInfoByte);
            byte[] signedDataBytes = new byte[pdfSm3Byte.length + pdfSm3Byte.length];
            System.arraycopy(pdfSm3Byte, 0, signedDataBytes, 0, pdfSm3Byte.length);
            System.arraycopy(signInfoSm3Byte, 0, signedDataBytes, pdfSm3Byte.length, signInfoSm3Byte.length);
            PdfVerifyResult pdfVerifyResult = PdfVerifyUtils.verifyWithCertAndGetInfo(certSequence.getEncoded(), signedDataBytes, signValueSeq.getEncoded());
            return pdfVerifyResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (signatureAsn1InputStream != null) {
                try {
                    signatureAsn1InputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (pdfDoc != null) {
                try {
                    pdfDoc.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static PdfVerifyResult verifyNotStandardPDFWithCerInfo(byte[] pdfBytes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static PdfVerifyResult verifyWithCertAndGetInfo(byte[] certBytes, byte[] signedDataBytes, byte[] signValueBytes) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        ByteArrayInputStream certStream = null;
        try {
            PdfVerifyResult result;
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            certStream = new ByteArrayInputStream(certBytes);
            Collection<? extends Certificate> certs = factory.generateCertificates(certStream);
            X509Certificate cert = (X509Certificate)certs.iterator().next();
            Signature signatureA = Signature.getInstance(cert.getSigAlgName());
            signatureA.initVerify(cert.getPublicKey());
            signatureA.update(signedDataBytes);
            boolean verify = signatureA.verify(signValueBytes);
            String subjectName = cert.getSubjectDN().getName();
            PdfVerifyResult pdfVerifyResult = result = new PdfVerifyResult(verify, subjectName);
            return pdfVerifyResult;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (certStream != null) {
                try {
                    certStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

