/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.constant.ErrorCodeConstant;
import kd.imc.rim.file.model.qrcode.QrcodeBean;
import kd.imc.rim.file.utils.common.CRCUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class QrcodeUtil {
    private static final Log logger = LogFactory.getLog(QrcodeUtil.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] encode(String content, int width, int height) {
        if (content == null) return null;
        if ("".equals(content)) return null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            content = URLDecoder.decode(content, "UTF-8");
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix m = writer.encode(content, BarcodeFormat.QR_CODE, width, height);
            MatrixToImageWriter.writeToStream((BitMatrix)m, (String)"png", (OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] generateQrBlockc(String content, int width, int height) {
        if (StringUtils.isEmpty((CharSequence)content)) return null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            content = URLDecoder.decode(content, "UTF-8");
            QRCodeWriter writer = new QRCodeWriter();
            HashMap<EncodeHintType, Integer> hints = new HashMap<EncodeHintType, Integer>();
            hints.put(EncodeHintType.MARGIN, 1);
            hints.put(EncodeHintType.ERROR_CORRECTION, (Integer)ErrorCorrectionLevel.H);
            BitMatrix m = writer.encode(content, BarcodeFormat.QR_CODE, width, height, hints);
            MatrixToImageWriter.writeToStream((BitMatrix)m, (String)"png", (OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String generationQrcode(QrcodeBean bean) {
        QrcodeUtil.checkIsNotEmpty(bean);
        StringBuilder sb = new StringBuilder();
        sb.append("01").append(',');
        sb.append(bean.getEXPRESS_eInvoiceType()).append(',');
        sb.append(bean.getEXPRESS_eInvoiceCode()).append(',');
        sb.append(bean.getEXPRESS_EInvoiceNo()).append(',');
        sb.append(bean.getEXPRESS_billingAmount()).append(',');
        sb.append(bean.getEXPRESS_billingDate()).append(',');
        sb.append(bean.getEXPRESS_checkCode()).append(',');
        try {
            sb.append(QrcodeUtil.getCrc(sb.toString()));
            String qrCodeStr = sb.toString();
            QRCodeWriter writer = new QRCodeWriter();
            BarcodeFormat format = BarcodeFormat.QR_CODE;
            BitMatrix matrix = writer.encode(qrCodeStr, format, 75, 75);
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)os);
                String string = QrcodeUtil.encode(os.toByteArray());
                return string;
            }
        }
        catch (Exception e) {
            logger.error("\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (Throwable)e);
            throw new KDException((Throwable)e, ErrorCodeConstant.QR_CODE_FAIL, new Object[0]);
        }
    }

    private static void checkIsNotEmpty(QrcodeBean bean) {
        if (bean == null) {
            throw new IllegalArgumentException("QrcodeBean is not null");
        }
        if (!QrcodeUtil.checkStrIsNotEmpty(bean.getEXPRESS_eInvoiceType()) || bean.getEXPRESS_eInvoiceType().length() != 2) {
            throw new IllegalArgumentException("EXPRESS_eInvoiceType is required or EXPRESS_eInvoiceType is Illegal");
        }
        if (!QrcodeUtil.checkStrIsNotEmpty(bean.getEXPRESS_eInvoiceCode()) || bean.getEXPRESS_eInvoiceCode().length() > 12) {
            throw new IllegalArgumentException("EXPRESS_eInvoiceCode is required or EXPRESS_eInvoiceCode length to long");
        }
        if (!QrcodeUtil.checkStrIsNotEmpty(bean.getEXPRESS_EInvoiceNo()) || bean.getEXPRESS_EInvoiceNo().length() > 8) {
            throw new IllegalArgumentException("EXPRESS_EInvoiceNo is required or EXPRESS_EInvoiceNo length to long");
        }
        if (!QrcodeUtil.checkStrIsNotEmpty(bean.getEXPRESS_billingDate()) || bean.getEXPRESS_billingDate().length() != 8) {
            throw new IllegalArgumentException("EXPRESS_billingDate is required or EXPRESS_billingDate is Illegal");
        }
        if (!QrcodeUtil.checkStrIsNotEmpty(bean.getEXPRESS_billingAmount()) || bean.getEXPRESS_billingAmount().length() > 15) {
            throw new IllegalArgumentException("EXPRESS_billingAmount is required or EXPRESS_billingAmount length to long");
        }
    }

    private static String getCrc(String orgData) throws UnsupportedEncodingException {
        byte[] crcByte = CRCUtil.crc16(orgData.getBytes("UTF-8"));
        StringBuilder crc = new StringBuilder();
        for (int i = 0; i < crcByte.length; ++i) {
            String hex = Integer.toHexString(crcByte[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            crc.append(hex.toUpperCase());
        }
        return crc.toString();
    }

    private static boolean checkStrIsNotEmpty(String str) {
        return str != null && !StringUtils.isEmpty((CharSequence)str);
    }

    private static String encode(byte[] qrCodeByte) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])qrCodeByte), "UTF-8");
    }

    public static byte[] decode(String qrCodeStr) throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])qrCodeStr.getBytes("UTF-8"));
    }
}

