/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.constant.ErrorCodeConstant;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2Util {
    private static final Log LOGGER = LogFactory.getLog(SM2Util.class);
    private static final String ALGORITHM_EC = "EC";

    public static boolean verify(byte[] publicKey, byte[] data, byte[] sign) {
        SM2Signer signer = new SM2Signer((DSAEncoding)StandardDSAEncoding.INSTANCE, (Digest)new SM3Digest());
        ECPublicKeyParameters param = SM2Util.toPublicParams(publicKey);
        signer.init(false, (CipherParameters)param);
        signer.update(data, 0, data.length);
        return signer.verifySignature(sign);
    }

    private static ECPublicKeyParameters toPublicParams(byte[] publicKeyBytes) {
        try {
            PublicKey publicKey = SM2Util.generatePublicKey(publicKeyBytes);
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u7b7e\u540d\u516c\u94a5\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new KDException((Throwable)e, ErrorCodeConstant.PUBLIC_KEY_ERROR, new Object[0]);
        }
    }

    private static PublicKey generatePublicKey(byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
        BouncyCastleProvider provider = new BouncyCastleProvider();
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_EC, (Provider)provider);
        return keyFactory.generatePublic(keySpec);
    }
}

