/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XmlHelperUtils {
    private static Log log = LogFactory.getLog(XmlHelperUtils.class);

    public static Document loadXML(String xml) {
        Document document;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            return null;
        }
        return document;
    }

    public static Document createDocument(String rootName) {
        Element root = DocumentHelper.createElement((String)rootName);
        root.addNamespace("ofd", "http://www.ofdspec.org/2016");
        return DocumentHelper.createDocument((Element)root);
    }

    public static Element addNode(Element parentNode, String nodeName, String nodeText) {
        Element element = parentNode.addElement(nodeName);
        if (nodeText != null) {
            element.setText(nodeText);
        }
        return element;
    }

    public static Element addNode(Element parentNode, String nodeName, String attributeName, String nodeText) {
        Element element = parentNode.addElement(nodeName);
        if (nodeText != null) {
            element.setText(nodeText);
        }
        if (attributeName != null) {
            element.addAttribute("Name", attributeName);
        }
        return element;
    }

    public static void addRefNode(Element parentNode, String nodeName, String nodeText, String pageId) {
        if (nodeText == null) {
            return;
        }
        Element nodeElement = parentNode.addElement(nodeName);
        Element refElement = XmlHelperUtils.addNode(nodeElement, "ofd:ObjectRef", nodeText);
        refElement.addAttribute("PageRef", pageId);
    }

    public static byte[] toByteArray(Document document) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setTrimText(false);
        XMLWriter xmlWriter = new XMLWriter((OutputStream)bos, format);
        xmlWriter.write(document);
        xmlWriter.close();
        byte[] bts = bos.toByteArray();
        bos.close();
        return bts;
    }

    public static int getAttributeValue(Element element, String key, int defaultValue) {
        try {
            String attributeValue;
            if (element != null && (attributeValue = element.attributeValue(key)) != null) {
                return Integer.parseInt(attributeValue);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5c5e\u6027\u503c{}\u51fa\u9519", (Object)key, (Object)e);
        }
        return defaultValue;
    }
}

