/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.imc.rim.file.utils.BigDecimalUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XmlUtil {
    public static Map<String, Object> Dom2Map(String str) throws DocumentException {
        Document documents = DocumentHelper.parseText((String)str);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (documents == null) {
            return map;
        }
        Element root = documents.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                map.put(e.getName(), XmlUtil.Dom2Map(e));
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Map<String, Object> Dom2MapV2(String str) throws DocumentException {
        Document documents = DocumentHelper.parseText((String)str);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (documents == null) {
            return map;
        }
        Element root = documents.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            List list = e.elements();
            if (list.size() > 0) {
                ArrayList<Map<String, Object>> mapList = (ArrayList<Map<String, Object>>)map.get(e.getName());
                if (null == mapList) {
                    mapList = new ArrayList<Map<String, Object>>();
                }
                Map<String, Object> objectMap = XmlUtil.Dom2MapV2(e);
                mapList.add(objectMap);
                map.put(e.getName(), mapList);
                continue;
            }
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map<String, Object> Dom2MapV2(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Object> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map<String, Object> m = XmlUtil.Dom2MapV2(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    private static Map<String, Object> Dom2Map(Element e) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        List list = e.elements();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Element iter = (Element)list.get(i);
                List<Object> mapList = new ArrayList();
                if (iter.elements().size() > 0) {
                    Map<String, Object> m = XmlUtil.Dom2Map(iter);
                    if (map.get(iter.getName()) != null) {
                        Object obj = map.get(iter.getName());
                        if (!(obj instanceof List)) {
                            mapList = new ArrayList();
                            mapList.add(obj);
                            mapList.add(m);
                        }
                        if (obj instanceof List) {
                            mapList = (List)obj;
                            mapList.add(m);
                        }
                        map.put(iter.getName(), mapList);
                        continue;
                    }
                    map.put(iter.getName(), m);
                    continue;
                }
                if (map.get(iter.getName()) != null) {
                    Object obj = map.get(iter.getName());
                    if (!(obj instanceof List)) {
                        mapList = new ArrayList();
                        mapList.add(obj);
                        mapList.add(iter.getText());
                    }
                    if (obj instanceof List) {
                        mapList = (List)obj;
                        mapList.add(iter.getText());
                    }
                    map.put(iter.getName(), mapList);
                    continue;
                }
                map.put(iter.getName(), iter.getText());
            }
        } else {
            map.put(e.getName(), e.getText());
        }
        return map;
    }

    public static Document loadXML(String xml) throws Exception {
        Document document = DocumentHelper.parseText((String)xml);
        return document;
    }

    public static Document loadXML(byte[] xmlData) throws Exception {
        SAXReader reader = new SAXReader();
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlData);
        Document document = reader.read((InputStream)bis);
        return document;
    }

    public static byte[] toByteArray(Document document) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] bts;
            XMLWriter xmlWriter = new XMLWriter((OutputStream)bos);
            xmlWriter.write(document);
            xmlWriter.close();
            byte[] byArray = bts = bos.toByteArray();
            return byArray;
        }
    }

    public static JSONObject Dom2AllElectricInvoiceMap(byte[] invoiceByte) throws Exception {
        Document document = XmlUtil.loadXML(invoiceByte);
        Element root = document.getRootElement();
        JSONObject map = new JSONObject(5);
        Iterator iteBook = root.elementIterator();
        while (iteBook.hasNext()) {
            Element bookEle = (Element)iteBook.next();
            Iterator subBookEle = bookEle.elementIterator();
            while (subBookEle.hasNext()) {
                Element subEle = (Element)subBookEle.next();
                String nodeName = subEle.getName();
                if (!"DocInfo".equals(nodeName)) continue;
                Iterator docInfoEle = subEle.elementIterator();
                while (docInfoEle.hasNext()) {
                    Element t = (Element)docInfoEle.next();
                    String tName = t.getName();
                    if (!"CustomDatas".equals(tName)) continue;
                    Iterator customDataEle = t.elementIterator();
                    while (customDataEle.hasNext()) {
                        Element customData = (Element)customDataEle.next();
                        Attribute name = customData.attribute("Name");
                        if (name == null) continue;
                        String value = name.getValue();
                        if ("\u53d1\u7968\u53f7\u7801".equals(value)) {
                            map.put("invoiceNo", (Object)customData.getText());
                            continue;
                        }
                        if ("\u5408\u8ba1\u7a0e\u989d".equals(value)) {
                            map.put("totalTaxAmount", (Object)BigDecimalUtil.transDecimal(customData.getText()));
                            continue;
                        }
                        if ("\u5408\u8ba1\u91d1\u989d".equals(value)) {
                            map.put("invoiceAmount", (Object)BigDecimalUtil.transDecimal(customData.getText()));
                            continue;
                        }
                        if ("\u5f00\u7968\u65e5\u671f".equals(value)) {
                            map.put("invoiceDate", (Object)customData.getText());
                            continue;
                        }
                        if ("\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7".equals(value)) {
                            map.put("buyerTaxNo", (Object)customData.getText());
                            continue;
                        }
                        if ("\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7".equals(value)) {
                            map.put("salerTaxNo", (Object)customData.getText());
                            continue;
                        }
                        if ("\u6821\u9a8c\u7801".equals(value)) {
                            String checkCode = customData.getText();
                            if (checkCode == null) continue;
                            map.put("checkCode", (Object)checkCode.replace(" ", ""));
                            continue;
                        }
                        if (!"\u53d1\u7968\u4ee3\u7801".equals(value)) continue;
                        map.put("invoiceCode", (Object)customData.getText());
                    }
                }
            }
        }
        return map;
    }

    public static JSONObject readAttach(byte[] invoiceByte) throws Exception {
        Document document = XmlUtil.loadXML(invoiceByte);
        Element root = document.getRootElement();
        JSONObject map = new JSONObject(5);
        List list = root.elements();
        for (Element element : list) {
            List GoodsInfos;
            Element subElement;
            if ("InvoiceCode".equals(element.getName())) {
                map.put("invoiceCode", (Object)element.getTextTrim());
                continue;
            }
            if ("InvoiceNo".equals(element.getName())) {
                map.put("invoiceNo", (Object)element.getTextTrim());
                continue;
            }
            if ("IssueDate".equals(element.getName())) {
                map.put("invoiceDate", (Object)element.getTextTrim());
                continue;
            }
            if ("InvoiceCheckCode".equals(element.getName())) {
                map.put("checkCode", (Object)element.getTextTrim());
                continue;
            }
            if ("MachineNo".equals(element.getName())) {
                map.put("machineNo", (Object)element.getTextTrim());
                continue;
            }
            if ("Buyer".equals(element.getName())) {
                subElement = element.element("BuyerName");
                if (subElement != null) {
                    map.put("buyerName", (Object)subElement.getTextTrim());
                }
                if ((subElement = element.element("BuyerTaxID")) != null) {
                    map.put("buyerTaxNo", (Object)subElement.getTextTrim());
                }
                if ((subElement = element.element("BuyerAddrTel")) != null) {
                    map.put("buyerAddressPhone", (Object)subElement.getTextTrim());
                }
                if ((subElement = element.element("BuyerFinancialAccount")) == null) continue;
                map.put("buyerAccount", (Object)subElement.getTextTrim());
                continue;
            }
            if ("Seller".equals(element.getName())) {
                subElement = element.element("SellerAddrTel");
                if (subElement != null) {
                    map.put("salerAddressPhone", (Object)subElement.getTextTrim());
                }
                if ((subElement = element.element("SellerFinancialAccount")) != null) {
                    map.put("salerAccount", (Object)subElement.getTextTrim());
                }
                if ((subElement = element.element("SellerName")) != null) {
                    map.put("salerName", (Object)subElement.getTextTrim());
                }
                if ((subElement = element.element("SellerTaxID")) == null) continue;
                map.put("salerTaxNo", (Object)subElement.getTextTrim());
                continue;
            }
            if ("TaxTotalAmount".equals(element.getName())) {
                map.put("totalTaxAmount", (Object)BigDecimalUtil.transDecimal(element.getTextTrim()));
                continue;
            }
            if ("TaxExclusiveTotalAmount".equals(element.getName())) {
                map.put("invoiceAmount", (Object)BigDecimalUtil.transDecimal(element.getTextTrim()));
                continue;
            }
            if ("TaxInclusiveTotalAmount".equals(element.getName())) {
                map.put("totalAmount", (Object)BigDecimalUtil.transDecimal(element.getTextTrim()));
                continue;
            }
            if (!"GoodsInfos".equals(element.getName()) || (GoodsInfos = element.elements("GoodsInfo")) == null) continue;
            ArrayList<JSONObject> items = new ArrayList<JSONObject>(8);
            for (Element sub : GoodsInfos) {
                JSONObject item = new JSONObject();
                List subs = sub.elements();
                for (Element sub2 : subs) {
                    if ("Item".equals(sub2.getName())) {
                        item.put("goodsName", (Object)sub2.getText());
                        continue;
                    }
                    if ("TaxAmount".equals(sub2.getName())) {
                        item.put("taxAmount", (Object)BigDecimalUtil.transDecimal(sub2.getText()));
                        continue;
                    }
                    if ("TaxScheme".equals(sub2.getName())) {
                        item.put("taxRate", (Object)sub2.getText());
                        continue;
                    }
                    if ("Amount".equals(sub2.getName())) {
                        item.put("detailAmount", (Object)BigDecimalUtil.transDecimal(sub2.getText()));
                        continue;
                    }
                    if ("Quantity".equals(sub2.getName())) {
                        item.put("quantity", (Object)sub2.getText());
                        continue;
                    }
                    if (!"Price".equals(sub2.getName())) continue;
                    item.put("unitPrice", (Object)sub2.getText());
                }
                items.add(item);
            }
            map.put("items", items);
        }
        return map;
    }

    public static JSONObject readPage0(Map<String, String> keyMap, byte[] invoiceByte) throws Exception {
        JSONObject map = new JSONObject(8);
        Document document = XmlUtil.loadXML(invoiceByte);
        Element root = document.getRootElement();
        Element content = root.element("Content");
        Element layer = content.element("Layer");
        List textObjects = layer.elements();
        HashMap<Integer, JSONObject> goodsInfo = new HashMap<Integer, JSONObject>();
        int maxRow = 0;
        for (Element element : textObjects) {
            String code;
            String id = element.attributeValue("ID");
            if (id == null || keyMap.get(id) == null || (code = keyMap.get(id)) == null) continue;
            int index = code.indexOf("$");
            Integer rowId = -1;
            if (index > 0) {
                rowId = Integer.parseInt(code.substring(index + 1, code.length()));
                code = code.substring(0, index);
                JSONObject itemMap = (JSONObject)goodsInfo.get(rowId);
                if (itemMap == null) {
                    itemMap = new JSONObject();
                }
                XmlUtil.setValue(itemMap, element, code);
                if (rowId > maxRow) {
                    maxRow = rowId;
                }
                goodsInfo.put(rowId, itemMap);
                continue;
            }
            XmlUtil.setValue(map, element, code);
        }
        if (!goodsInfo.isEmpty()) {
            ArrayList items = new ArrayList(8);
            for (int i = 0; i <= maxRow; ++i) {
                items.add(goodsInfo.get(i));
            }
            map.put("items", items);
        }
        return map;
    }

    private static void setValue(JSONObject map, Element element, String code) {
        Element textCode = element.element("TextCode");
        String value = textCode.getTextTrim();
        if (value != null && code.indexOf("Amount") > 0) {
            BigDecimal amount = BigDecimalUtil.transDecimal(value = value.replace("\u00a5", ""));
            if (amount.compareTo(BigDecimal.ZERO) == 0 && map.get((Object)code) == null) {
                map.put(code, (Object)"0");
            } else if (amount.compareTo(BigDecimal.ZERO) != 0) {
                map.put(code, (Object)value);
            }
        } else if (value != null && "checkCode".equals(code)) {
            value = value.replace(" ", "");
            map.put(code, (Object)value);
        } else {
            map.put(code, (Object)value);
        }
    }

    public static String getAttachFileName(byte[] invoiceByte) {
        try {
            Document document = XmlUtil.loadXML(invoiceByte);
            Element root = document.getRootElement();
            Element CustomTag = root.element("Attachment");
            return CustomTag.element("FileLoc").getText();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getTagsFileName(byte[] invoiceByte) {
        try {
            Document document = XmlUtil.loadXML(invoiceByte);
            Element root = document.getRootElement();
            Element CustomTag = root.element("CustomTag");
            return CustomTag.element("FileLoc").getText();
        }
        catch (Exception e) {
            return "CustomTag.xml";
        }
    }

    public static Map<String, String> Dom2TagsMap(byte[] invoiceByte) throws Exception {
        String xml = new String(invoiceByte, StandardCharsets.UTF_8);
        xml = xml.replace("xmlns:=\"\"", "").replace("<:eInvoice", "<eInvoice").replace("</:eInvoice", "</eInvoice").replace("ofd:ObjectRef", "ofd_ObjectRef");
        Document document = XmlUtil.loadXML(xml);
        Element root = document.getRootElement();
        HashMap<String, String> map = new HashMap<String, String>(8);
        XmlUtil.getTagsElementText(root, "InvoiceCode", "invoiceCode", map);
        XmlUtil.getTagsElementText(root, "InvoiceNo", "invoiceNo", map);
        XmlUtil.getTagsElementText(root, "IssueDate", "invoiceDate", map);
        XmlUtil.getTagsElementText(root, "InvoiceCheckCode", "checkCode", map);
        XmlUtil.getTagsElementText(root, "Buyer/BuyerName", "buyerName", map);
        XmlUtil.getTagsElementText(root, "Buyer/BuyerTaxID", "buyerTaxNo", map);
        XmlUtil.getTagsElementText(root, "Buyer/BuyerAddrTel", "buyerAddressPhone", map);
        XmlUtil.getTagsElementText(root, "Buyer/BuyerFinancialAccount", "buyerAccount", map);
        XmlUtil.getTagsElementText(root, "Seller/SellerAddrTel", "salerAddressPhone", map);
        XmlUtil.getTagsElementText(root, "Seller/SellerFinancialAccount", "salerAccount", map);
        XmlUtil.getTagsElementText(root, "Seller/SellerName", "salerName", map);
        XmlUtil.getTagsElementText(root, "Seller/SellerTaxID", "salerTaxNo", map);
        XmlUtil.getTagsElementText(root, "TaxTotalAmount", "totalTaxAmount", map);
        XmlUtil.getTagsElementText(root, "TaxInclusiveTotalAmount", "totalAmount", map);
        XmlUtil.getTagsElementText(root, "TaxExclusiveTotalAmount", "invoiceAmount", map);
        XmlUtil.getTagsElementText(root, "MachineNo", "machineNo", map);
        Element goodsInfos = root.element("GoodsInfos");
        if (goodsInfos != null) {
            List elements = goodsInfos.elements("GoodsInfo");
            if (elements != null) {
                int i = 0;
                for (Element goods : elements) {
                    XmlUtil.getTagsElementText(goods, "TaxScheme", "taxRate$" + i, map);
                    XmlUtil.getTagsElementText(goods, "Price", "unitPrice$" + i, map);
                    XmlUtil.getTagsElementText(goods, "Quantity", "quantity$" + i, map);
                    XmlUtil.getTagsElementText(goods, "Item", "goodsName$" + i, map);
                    XmlUtil.getTagsElementText(goods, "Amount", "detailAmount$" + i, map);
                    XmlUtil.getTagsElementText(goods, "TaxAmount", "taxAmount$" + i, map);
                    ++i;
                }
            }
        } else {
            int i = 0;
            XmlUtil.getTagsElementText(root, "TaxScheme", "taxRate$" + i, map);
            XmlUtil.getTagsElementText(root, "Price", "unitPrice$" + i, map);
            XmlUtil.getTagsElementText(root, "Quantity", "quantity$" + i, map);
            XmlUtil.getTagsElementText(root, "Item", "goodsName$" + i, map);
            XmlUtil.getTagsElementText(root, "Amount", "detailAmount$" + i, map);
            XmlUtil.getTagsElementText(root, "TaxAmount", "taxAmount$" + i, map);
        }
        return map;
    }

    private static void getTagsElementText(Element element, String path, String key, Map<String, String> map) {
        try {
            if (path.indexOf("/") > 0) {
                String[] elementKeys = path.split("/");
                Element subElement = element.element(elementKeys[0]);
                for (int i = 1; i < elementKeys.length; ++i) {
                    if (subElement == null) {
                        return;
                    }
                    subElement = subElement.element(elementKeys[i]);
                }
                if (subElement != null) {
                    List elementList = subElement.elements("ofd_ObjectRef");
                    for (Element element1 : elementList) {
                        map.put(element1.getTextTrim(), key);
                    }
                }
            } else {
                Element invoiceCodeElement = element.element(path);
                if (invoiceCodeElement != null) {
                    List elementList = invoiceCodeElement.elements("ofd_ObjectRef");
                    for (Element element1 : elementList) {
                        map.put(element1.getTextTrim(), key);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

