/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class XmlUtil2 {
    private static Log logger = LogFactory.getLog(XmlUtil2.class);
    private static final String XML_HEAD = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";

    public static Map xmlToMap(String xmlStr, boolean needRootKey) throws DocumentException {
        Document doc;
        try {
            String message = JSONObject.parseObject((String)xmlStr).getString("message");
            doc = DocumentHelper.parseText((String)message);
        }
        catch (Exception e) {
            doc = xmlStr.startsWith("<?xml") ? DocumentHelper.parseText((String)xmlStr.trim()) : DocumentHelper.parseText((String)(XML_HEAD + xmlStr));
        }
        Element root = doc.getRootElement();
        Map map = (Map)XmlUtil2.xmlToMap(root);
        if (root.elements().size() == 0 && root.attributes().size() == 0) {
            return map;
        }
        if (needRootKey) {
            HashMap<String, Map> rootMap = new HashMap<String, Map>(8);
            rootMap.put(root.getName(), map);
            return rootMap;
        }
        return map;
    }

    public static Map xmlToMapWithAttr(String xmlStr, boolean needRootKey) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)xmlStr);
        Element root = doc.getRootElement();
        Map map = (Map)XmlUtil2.xmlToMapWithAttr(root);
        if (root.elements().size() == 0 && root.attributes().size() == 0) {
            return map;
        }
        if (needRootKey) {
            HashMap<String, Map> rootMap = new HashMap<String, Map>(8);
            rootMap.put(root.getName(), map);
            return rootMap;
        }
        return map;
    }

    private static Object xmlToMap(Element element) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(8);
        List elements = element.elements();
        if (elements.size() == 0) {
            map.put(element.getName(), element.getText());
            if (!element.isRootElement()) {
                return element.getText();
            }
        } else if (elements.size() == 1) {
            map.put(((Element)elements.get(0)).getName(), XmlUtil2.xmlToMap((Element)elements.get(0)));
        } else if (elements.size() > 1) {
            LinkedHashMap<String, Element> tempMap = new LinkedHashMap<String, Element>(8);
            for (Element element2 : elements) {
                tempMap.put(element2.getName(), element2);
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                Namespace namespace = ((Element)entry.getValue()).getNamespace();
                List elements2 = element.elements(new QName((String)entry.getKey(), namespace));
                if (elements2.size() > 1) {
                    ArrayList<Object> list = new ArrayList<Object>(8);
                    for (Element ele : elements2) {
                        list.add(XmlUtil2.xmlToMap(ele));
                    }
                    map.put((String)entry.getKey(), list);
                    continue;
                }
                map.put((String)entry.getKey(), XmlUtil2.xmlToMap((Element)elements2.get(0)));
            }
        }
        return map;
    }

    private static Object xmlToMapWithAttr(Element element) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(8);
        List elements = element.elements();
        if (elements.size() == 0) {
            map.put(element.getName(), element.getText());
            if (!element.isRootElement()) {
                return element.getText();
            }
        } else if (elements.size() == 1) {
            map.put(((Element)elements.get(0)).getName(), XmlUtil2.xmlToMapWithAttr((Element)elements.get(0)));
        } else if (elements.size() > 1) {
            LinkedHashMap<String, Element> tempMap = new LinkedHashMap<String, Element>(8);
            for (Element element2 : elements) {
                tempMap.put(element2.getName(), element2);
            }
            for (Map.Entry entry : tempMap.entrySet()) {
                ArrayList<Object> list;
                Namespace namespace = ((Element)entry.getValue()).getNamespace();
                List elements2 = element.elements(new QName((String)entry.getKey(), namespace));
                if (elements2.size() > 1) {
                    list = new ArrayList<Object>(8);
                    for (Element ele : elements2) {
                        if (StringUtils.isEmpty((String)ele.getText())) continue;
                        list.add(XmlUtil2.xmlToMapWithAttr(ele));
                    }
                    map.put((String)entry.getKey(), list);
                    continue;
                }
                if (elements2.size() == 1 && "List".equals(((Element)elements2.get(0)).attributeValue("nodeType"))) {
                    list = new ArrayList(8);
                    Element ele = (Element)elements2.get(0);
                    if (StringUtils.isEmpty((String)ele.getText())) continue;
                    list.add(XmlUtil2.xmlToMapWithAttr(ele));
                    map.put((String)entry.getKey(), list);
                    continue;
                }
                map.put((String)entry.getKey(), XmlUtil2.xmlToMapWithAttr((Element)elements2.get(0)));
            }
        }
        return map;
    }
}

