/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.common;

import java.io.UnsupportedEncodingException;
import kd.imc.rim.file.utils.common.TranslateUtil;

public class CRCUtil {
    public static boolean checkCRC(byte[] data) throws Exception {
        byte[] temp = new byte[data.length - 4];
        System.arraycopy(data, 0, temp, 0, data.length - 4);
        byte[] crc = CRCUtil.crc16(temp);
        temp = new byte[]{data[data.length - 4], data[data.length - 3]};
        int a = Integer.parseInt(TranslateUtil.transformat(temp, "ASC").trim(), 16);
        temp[0] = data[data.length - 2];
        temp[1] = data[data.length - 1];
        int b = Integer.parseInt(TranslateUtil.transformat(temp, "ASC").trim(), 16);
        return a == (crc[0] & 0xFF) && b == (crc[1] & 0xFF);
    }

    public static byte[] crc16(byte[] bytes) {
        return CRCUtil.evalInt(CRCUtil.checkSum(bytes));
    }

    public static String getCrc(String orgData) throws UnsupportedEncodingException {
        byte[] crcByte = CRCUtil.crc16(orgData.getBytes("GBK"));
        StringBuilder crc = new StringBuilder();
        for (int i = 0; i < crcByte.length; ++i) {
            String hex = Integer.toHexString(crcByte[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            crc.append(hex.toUpperCase());
        }
        return crc.toString();
    }

    public static int checkSum(byte[] bytes) {
        int crc = 0;
        if (bytes.length > 0) {
            for (int n = 0; n < bytes.length; ++n) {
                for (int i = 128; i != 0; i /= 2) {
                    if ((crc & 0x8000) != 0) {
                        crc *= 2;
                        crc ^= 0x18005;
                    } else {
                        crc *= 2;
                    }
                    if ((bytes[n] & i) == 0) continue;
                    crc ^= 0x18005;
                }
            }
        }
        return crc;
    }

    public static byte[] evalInt(int data) {
        byte[] bytes = new byte[2];
        String crc = Integer.toHexString(data);
        for (int i = 2; i <= 4; i += 2) {
            if (crc.length() + 2 > i) {
                int start = crc.length() - i;
                start = start <= 0 ? 0 : start;
                bytes[2 - i / 2] = (byte)Integer.parseInt(crc.substring(start, crc.length() - i + 2), 16);
                continue;
            }
            bytes[2 - i / 2] = 0;
        }
        return bytes;
    }
}

