/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.ofd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.aws.ofd.util.OfdErrorType;
import kd.imc.rim.file.model.ofd.OfdInvoiceDto;
import kd.imc.rim.file.model.ofd.OfdTextObject;
import kd.imc.rim.file.model.ofd.OfdTextObjectBlock;
import kd.imc.rim.file.utils.CompressHelper;
import kd.imc.rim.file.utils.ofd.OfdReadUtil;
import org.dom4j.Element;

public class OfdAnalysisUtil {
    private static final Log LOGGER = LogFactory.getLog(OfdAnalysisUtil.class);
    private static Map<String, String> keysMap = new HashMap<String, String>(16){
        {
            this.put("\u53d1\u7968\u4ee3\u7801\uff1a", "invoiceCode");
            this.put("\u53d1\u7968\u53f7\u7801\uff1a", "invoiceNo");
            this.put("\u5f00\u7968\u65e5\u671f\uff1a", "invoiceDate");
            this.put("\u5f00\u7968\u2f47\u671f\uff1a", "invoiceDate");
            this.put("\uff08\u5c0f\u5199\uff09", "totalAmount");
            this.put("\u8d2d\u4e70\u65b9", "buyerName");
            this.put("\u8d2d\u4e70\u65b9\u4fe1\u606f", "buyerName");
            this.put("\u9500\u552e\u65b9", "salerName");
            this.put("\u9500\u552e\u65b9\u4fe1\u606f", "salerName");
            this.put("\u540d\u79f0\uff1a", "name");
            this.put("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a", "taxNo");
            this.put("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a", "taxNo");
            this.put("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801/\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a", "taxNo");
            this.put("\u7edf\u2f00\u793e\u4f1a\u4fe1\u2f64\u4ee3\u7801/\u7eb3\u7a0e\u2f08\u8bc6\u522b\u53f7\uff1a", "taxNo");
            this.put("\u6821\u9a8c\u7801\uff1a", "checkCode");
            this.put("\u5408\u8ba1", "totalAmount");
            this.put("\u673a\u5668\u7f16\u53f7\uff1a", "mcNo");
        }
    };

    public static OfdInvoiceDto analysisOfdByCoordinate(byte[] ofdByteData) {
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(ofdByteData);
        return OfdAnalysisUtil.analysisOfdByCoordinate(decompressFileMap);
    }

    public static OfdInvoiceDto analysisOfdByCoordinate(Map<String, byte[]> decompressFileMap) {
        OfdInvoiceDto invoice = null;
        try {
            byte[] ofdMainByte = decompressFileMap.get("OFD.xml");
            String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
            String doc0Path = OfdReadUtil.getLastDirPath(docRootPath).toString();
            byte[] documentByte = decompressFileMap.get(docRootPath);
            List<String> pages = OfdAnalysisUtil.getOfdPagesPath(documentByte);
            String pagePath = pages.get(pages.size() - 1);
            String doc0PagesPageNPath = doc0Path + pagePath;
            byte[] doc0PagesPageNByte = decompressFileMap.get(doc0PagesPageNPath);
            List<OfdTextObjectBlock> ofdPagesTextObjects = OfdAnalysisUtil.getOfdPagesTextObjectBlockList(doc0PagesPageNByte);
            HashMap<String, List<OfdTextObjectBlock>> invoiceKeyMapList = new HashMap<String, List<OfdTextObjectBlock>>();
            ofdPagesTextObjects.stream().forEach(textObject -> {
                if (keysMap.containsKey(textObject.getTextCodeValue())) {
                    ArrayList<OfdTextObjectBlock> ofdTextObjectBlocks = (ArrayList<OfdTextObjectBlock>)invoiceKeyMapList.get(textObject.getTextCodeValue());
                    if (null == ofdTextObjectBlocks || ofdTextObjectBlocks.size() == 0) {
                        ofdTextObjectBlocks = new ArrayList<OfdTextObjectBlock>();
                    }
                    ofdTextObjectBlocks.add((OfdTextObjectBlock)textObject);
                    invoiceKeyMapList.put(textObject.getTextCodeValue(), ofdTextObjectBlocks);
                }
            });
            invoice = OfdAnalysisUtil.handleTextObjectBlock(invoiceKeyMapList, ofdPagesTextObjects);
        }
        catch (Exception e) {
            LOGGER.error("getInvoiceMap from inputStream fail:", (Throwable)e);
        }
        LOGGER.info("getInvoiceMap from inputStream end result:{}", invoice);
        return invoice;
    }

    private static OfdInvoiceDto handleTextObjectBlock(Map<String, List<OfdTextObjectBlock>> invoiceKeyMapList, List<OfdTextObjectBlock> textObjectList) {
        OfdTextObjectBlock ofdTextObjectBlock;
        List<OfdTextObjectBlock> ofdTextObjectBlocksInvoiceDateList;
        OfdTextObjectBlock ofdTextObjectBlock2;
        List<OfdTextObjectBlock> ofdTextObjectBlocksCheckCodeList;
        OfdTextObjectBlock ofdTextObjectBlock3;
        List<OfdTextObjectBlock> ofdTextObjectBlocksInvoiceCodeList;
        OfdTextObjectBlock ofdTextObjectBlock4;
        OfdInvoiceDto ofdInvoiceDto = new OfdInvoiceDto();
        List<OfdTextObjectBlock> ofdTextObjectBlocksInvoiceNoList = invoiceKeyMapList.get("\u53d1\u7968\u53f7\u7801\uff1a");
        if (null != ofdTextObjectBlocksInvoiceNoList && ofdTextObjectBlocksInvoiceNoList.size() > 0 && null != (ofdTextObjectBlock4 = OfdAnalysisUtil.nearRightTextObjectBlock(ofdTextObjectBlocksInvoiceNoList.get(0), textObjectList, 1.0, 4.0))) {
            ofdInvoiceDto.setInvoiceNo(ofdTextObjectBlock4.getTextCodeValue());
        }
        if (null != (ofdTextObjectBlocksInvoiceCodeList = invoiceKeyMapList.get("\u53d1\u7968\u4ee3\u7801\uff1a")) && ofdTextObjectBlocksInvoiceCodeList.size() > 0 && null != (ofdTextObjectBlock3 = OfdAnalysisUtil.nearRightTextObjectBlock(ofdTextObjectBlocksInvoiceCodeList.get(0), textObjectList, 1.0, 4.0))) {
            ofdInvoiceDto.setInvoiceCode(ofdTextObjectBlock3.getTextCodeValue());
        }
        if (null != (ofdTextObjectBlocksCheckCodeList = invoiceKeyMapList.get("\u6821\u9a8c\u7801\uff1a")) && ofdTextObjectBlocksCheckCodeList.size() > 0 && null != (ofdTextObjectBlock2 = OfdAnalysisUtil.nearRightTextObjectBlock(ofdTextObjectBlocksCheckCodeList.get(0), textObjectList, 1.0, 4.0))) {
            ofdInvoiceDto.setCheckCode(ofdTextObjectBlock2.getTextCodeValue().replaceAll(" ", ""));
        }
        if (null == (ofdTextObjectBlocksInvoiceDateList = invoiceKeyMapList.get("\u5f00\u7968\u65e5\u671f\uff1a")) || ofdTextObjectBlocksInvoiceDateList.size() == 0) {
            ofdTextObjectBlocksInvoiceDateList = invoiceKeyMapList.get("\u5f00\u7968\u2f47\u671f\uff1a");
        }
        if (null != ofdTextObjectBlocksInvoiceDateList && ofdTextObjectBlocksInvoiceDateList.size() > 0 && null != (ofdTextObjectBlock = OfdAnalysisUtil.nearRightTextObjectBlock(ofdTextObjectBlocksInvoiceDateList.get(0), textObjectList, 1.0, 4.0))) {
            ofdInvoiceDto.setInvoiceDate(ofdTextObjectBlock.getTextCodeValue());
        }
        ArrayList ofdTextObjectBlocksNameList = new ArrayList();
        for (Map.Entry<String, List<OfdTextObjectBlock>> entry : invoiceKeyMapList.entrySet()) {
            if (!entry.getKey().contains("\u540d\u79f0\uff1a")) continue;
            ofdTextObjectBlocksNameList.addAll(entry.getValue());
        }
        if (null != ofdTextObjectBlocksNameList && ofdTextObjectBlocksNameList.size() == 2) {
            OfdTextObjectBlock salerNameOfdTextObjectBlock;
            Object temp;
            Object leftUpOfdTextObjectBlock = (OfdTextObjectBlock)ofdTextObjectBlocksNameList.get(0);
            Object rightDownOfdTextObjectBlock = (OfdTextObjectBlock)ofdTextObjectBlocksNameList.get(1);
            double leftUpX = ((OfdTextObjectBlock)leftUpOfdTextObjectBlock).getStarterCoordinateX();
            double leftUpY = ((OfdTextObjectBlock)leftUpOfdTextObjectBlock).getStarterCoordinateY();
            double rightDownX = ((OfdTextObjectBlock)rightDownOfdTextObjectBlock).getStarterCoordinateX();
            double rightDownY = ((OfdTextObjectBlock)rightDownOfdTextObjectBlock).getStarterCoordinateY();
            boolean sameHeight = OfdAnalysisUtil.coordinateSameHeight(leftUpY, rightDownY, 0.5);
            if (sameHeight) {
                if (!(leftUpX < rightDownX) || !(leftUpY <= rightDownY)) {
                    temp = rightDownOfdTextObjectBlock;
                    rightDownOfdTextObjectBlock = leftUpOfdTextObjectBlock;
                    leftUpOfdTextObjectBlock = temp;
                }
            } else if (!(leftUpY < rightDownY)) {
                temp = rightDownOfdTextObjectBlock;
                rightDownOfdTextObjectBlock = leftUpOfdTextObjectBlock;
                leftUpOfdTextObjectBlock = temp;
            }
            OfdTextObjectBlock buyerNameOfdTextObjectBlock = OfdAnalysisUtil.nearRightTextObjectBlock((OfdTextObjectBlock)leftUpOfdTextObjectBlock, textObjectList, 1.0, 20.0);
            if (null != buyerNameOfdTextObjectBlock) {
                ofdInvoiceDto.setBuyerName(buyerNameOfdTextObjectBlock.getTextCodeValue());
            }
            if (null != (salerNameOfdTextObjectBlock = OfdAnalysisUtil.nearRightTextObjectBlock((OfdTextObjectBlock)rightDownOfdTextObjectBlock, textObjectList, 1.0, 20.0))) {
                ofdInvoiceDto.setSalerName(salerNameOfdTextObjectBlock.getTextCodeValue());
            }
        }
        ArrayList ofdTextObjectBlocksTaxNoList = new ArrayList();
        for (Map.Entry<String, List<OfdTextObjectBlock>> entry : invoiceKeyMapList.entrySet()) {
            if (!entry.getKey().contains("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a") && !entry.getKey().contains("\u7eb3\u7a0e\u2f08\u8bc6\u522b\u53f7\uff1a")) continue;
            ofdTextObjectBlocksTaxNoList.addAll(entry.getValue());
        }
        if (null != ofdTextObjectBlocksTaxNoList && ofdTextObjectBlocksTaxNoList.size() == 2) {
            OfdTextObjectBlock salerTaxNoOfdTextObjectBlock;
            OfdTextObjectBlock temp;
            OfdTextObjectBlock leftUpTaxNoOfdTextObjectBlock = (OfdTextObjectBlock)ofdTextObjectBlocksTaxNoList.get(0);
            OfdTextObjectBlock rightTaxNoDownOfdTextObjectBlock = (OfdTextObjectBlock)ofdTextObjectBlocksTaxNoList.get(1);
            double leftUpX = leftUpTaxNoOfdTextObjectBlock.getStarterCoordinateX();
            double leftUpY = leftUpTaxNoOfdTextObjectBlock.getStarterCoordinateY();
            double rightDownX = rightTaxNoDownOfdTextObjectBlock.getStarterCoordinateX();
            double rightDownY = rightTaxNoDownOfdTextObjectBlock.getStarterCoordinateY();
            boolean sameHeight = OfdAnalysisUtil.coordinateSameHeight(leftUpY, rightDownY, 0.5);
            if (sameHeight) {
                if (!(leftUpX < rightDownX) || !(leftUpY <= rightDownY)) {
                    temp = rightTaxNoDownOfdTextObjectBlock;
                    rightTaxNoDownOfdTextObjectBlock = leftUpTaxNoOfdTextObjectBlock;
                    leftUpTaxNoOfdTextObjectBlock = temp;
                }
            } else if (!(leftUpY < rightDownY)) {
                temp = rightTaxNoDownOfdTextObjectBlock;
                rightTaxNoDownOfdTextObjectBlock = leftUpTaxNoOfdTextObjectBlock;
                leftUpTaxNoOfdTextObjectBlock = temp;
            }
            OfdTextObjectBlock buyerTaxNoOfdTextObjectBlock = OfdAnalysisUtil.nearRightTextObjectBlock(leftUpTaxNoOfdTextObjectBlock, textObjectList, 1.0, 20.0);
            if (null != buyerTaxNoOfdTextObjectBlock) {
                ofdInvoiceDto.setBuyerTaxNo(buyerTaxNoOfdTextObjectBlock.getTextCodeValue());
            }
            if (null != (salerTaxNoOfdTextObjectBlock = OfdAnalysisUtil.nearRightTextObjectBlock(rightTaxNoDownOfdTextObjectBlock, textObjectList, 1.0, 20.0))) {
                ofdInvoiceDto.setSalerTaxNo(salerTaxNoOfdTextObjectBlock.getTextCodeValue());
            }
        }
        ArrayList<OfdTextObjectBlock> amountOfdTextObjectBlocks = new ArrayList<OfdTextObjectBlock>();
        textObjectList.stream().forEach(textObject -> {
            if (textObject.getTextCodeValue().startsWith("\u00a5")) {
                amountOfdTextObjectBlocks.add((OfdTextObjectBlock)textObject);
            }
        });
        if (null == amountOfdTextObjectBlocks || amountOfdTextObjectBlocks.size() == 0) {
            for (OfdTextObjectBlock textObject2 : textObjectList) {
                if (textObject2.getTextCodeValue().equals("\u5408\u8ba1")) {
                    List<OfdTextObjectBlock> ofdTextObjectBlocks = OfdAnalysisUtil.nearRightTextObjectListBlock(textObject2, textObjectList, 1.0, 2000.0);
                    amountOfdTextObjectBlocks.addAll(ofdTextObjectBlocks);
                }
                if (!textObject2.getTextCodeValue().equals("\uff08\u2f29\u5199\uff09")) continue;
                OfdTextObjectBlock salerTaxNoOfdTextObjectBlock = OfdAnalysisUtil.nearRightTextObjectBlock(textObject2, textObjectList, 1.0, 20.0);
                amountOfdTextObjectBlocks.add(salerTaxNoOfdTextObjectBlock);
            }
        }
        if (null != amountOfdTextObjectBlocks && amountOfdTextObjectBlocks.size() == 3) {
            List blocks = amountOfdTextObjectBlocks.stream().sorted((textObjectA, textObjectB) -> {
                Double amountA = Double.valueOf(textObjectA.getTextCodeValue().replaceAll("\u00a5", ""));
                Double amountB = Double.valueOf(textObjectB.getTextCodeValue().replaceAll("\u00a5", ""));
                if (amountA > amountB) {
                    return 1;
                }
                if (amountA < amountB) {
                    return -1;
                }
                return 0;
            }).collect(Collectors.toList());
            ofdInvoiceDto.setTotalTaxAmount(((OfdTextObjectBlock)blocks.get(0)).getTextCodeValue());
            ofdInvoiceDto.setInvoiceAmount(((OfdTextObjectBlock)blocks.get(1)).getTextCodeValue());
            ofdInvoiceDto.setTotalAmount(((OfdTextObjectBlock)blocks.get(2)).getTextCodeValue());
        } else if (null != amountOfdTextObjectBlocks && amountOfdTextObjectBlocks.size() == 2) {
            String amount = ((OfdTextObjectBlock)amountOfdTextObjectBlocks.get(0)).getTextCodeValue();
            ofdInvoiceDto.setTotalAmount("\u00a5" + amount);
            ofdInvoiceDto.setInvoiceAmount("\u00a5" + amount);
            ofdInvoiceDto.setTotalTaxAmount("\u00a50.0");
        }
        return ofdInvoiceDto;
    }

    private static OfdTextObjectBlock nearRightTextObjectBlock(OfdTextObjectBlock key, List<OfdTextObjectBlock> textObjectList, double differenceY, double differenceValue) {
        double starterCoordinateY = key.getStarterCoordinateY();
        double starterCoordinateX = key.getStarterCoordinateX();
        List valueTextObject = textObjectList.stream().filter(ofdTextObjectBlock -> !ofdTextObjectBlock.getId().equals(key.getId())).filter(ofdTextObjectBlock -> OfdAnalysisUtil.coordinateSameHeight(ofdTextObjectBlock.getStarterCoordinateY(), starterCoordinateY, differenceY)).filter(ofdTextObjectBlock -> {
            double starterCoordinateXValue = ofdTextObjectBlock.getStarterCoordinateX();
            return OfdAnalysisUtil.coordinateRightValue(starterCoordinateX, key.getTotalOffsetX(), starterCoordinateXValue, differenceValue);
        }).sorted((textObjectA, textObjectB) -> {
            double b;
            double a = OfdAnalysisUtil.proximityValue(textObjectA, key);
            if (a > (b = OfdAnalysisUtil.proximityValue(textObjectB, key))) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        if (null == valueTextObject || valueTextObject.size() == 0) {
            return null;
        }
        return (OfdTextObjectBlock)valueTextObject.get(0);
    }

    private static List<OfdTextObjectBlock> nearRightTextObjectListBlock(OfdTextObjectBlock key, List<OfdTextObjectBlock> textObjectList, double differenceY, double differenceValue) {
        double starterCoordinateY = key.getStarterCoordinateY();
        double starterCoordinateX = key.getStarterCoordinateX();
        List<OfdTextObjectBlock> valueTextObject = textObjectList.stream().filter(ofdTextObjectBlock -> !ofdTextObjectBlock.getId().equals(key.getId())).filter(ofdTextObjectBlock -> OfdAnalysisUtil.coordinateSameHeight(ofdTextObjectBlock.getStarterCoordinateY(), starterCoordinateY, differenceY)).filter(ofdTextObjectBlock -> {
            double starterCoordinateXValue = ofdTextObjectBlock.getStarterCoordinateX();
            return OfdAnalysisUtil.coordinateRightValue(starterCoordinateX, key.getTotalOffsetX(), starterCoordinateXValue, differenceValue);
        }).sorted((textObjectA, textObjectB) -> {
            double b;
            double a = OfdAnalysisUtil.proximityValue(textObjectA, key);
            if (a > (b = OfdAnalysisUtil.proximityValue(textObjectB, key))) {
                return 1;
            }
            if (a < b) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        if (null == valueTextObject || valueTextObject.size() == 0) {
            return new ArrayList<OfdTextObjectBlock>();
        }
        return valueTextObject;
    }

    private static boolean coordinateSameHeight(double left, double right, double differenceValue) {
        return Math.abs(left - right) < differenceValue;
    }

    private static boolean coordinateRightBlock(double left, double leftOffset, double right, double rightOffset) {
        return left + leftOffset > right && left + leftOffset < right + rightOffset;
    }

    public static boolean coordinateRightValue(double left, double leftOffset, double right, double differenceValue) {
        return Math.abs(left + leftOffset - right) < differenceValue;
    }

    private static double proximityValue(OfdTextObjectBlock A, OfdTextObjectBlock B) {
        return Math.abs(A.getStarterCoordinateY() - B.getStarterCoordinateY());
    }

    private static void extractTextObjectElementData(Element startPageBlockElementParent, List<OfdTextObject> result) {
        Iterator pageBlock = startPageBlockElementParent.elementIterator("PageBlock");
        while (pageBlock.hasNext()) {
            Element element = (Element)pageBlock.next();
            OfdAnalysisUtil.extractTextObjectElementData(element, result);
        }
        List textObjects = startPageBlockElementParent.elements("TextObject");
        if (null != textObjects && textObjects.size() > 0) {
            String blockId = startPageBlockElementParent.attributeValue("ID");
            for (Element textObject : textObjects) {
                result.add(OfdAnalysisUtil.elementChangeOfdTextObject(textObject));
            }
        }
    }

    private static OfdTextObject elementChangeOfdTextObject(Element textObject) {
        OfdTextObject ofdTextObject = new OfdTextObject();
        String id = textObject.attributeValue("ID");
        String boundary = textObject.attributeValue("Boundary");
        String textCode = textObject.element("TextCode").getText();
        String[] coordinate = boundary.split(" ");
        Double x = Double.valueOf(coordinate[0]);
        Double y = Double.valueOf(coordinate[1]);
        Double offsetX = Double.valueOf(coordinate[2]);
        Double offsetY = Double.valueOf(coordinate[3]);
        textCode = textCode.replaceAll(" ", "");
        if ((textCode = textCode.replaceAll(":", "\uff1a")).contains("(")) {
            textCode = textCode.replaceAll("\\(", "\uff08");
        }
        if (textCode.contains(")")) {
            textCode = textCode.replaceAll("\\)", "\uff09");
        }
        textCode = textCode.replaceAll("\uffe5", "\u00a5");
        ofdTextObject.setId(id);
        ofdTextObject.setCoordinateX(x);
        ofdTextObject.setCoordinateY(y);
        ofdTextObject.setOffsetX(offsetX);
        ofdTextObject.setOffsetY(offsetY);
        ofdTextObject.setTextCodeValue(textCode);
        return ofdTextObject;
    }

    private static List<OfdTextObject> getOfdPagesTextObjectsList(byte[] pageByte) {
        ArrayList<OfdTextObject> result = new ArrayList<OfdTextObject>();
        try {
            Element rootElement = OfdReadUtil.getElementByByte(pageByte);
            Element contentElement = rootElement.element("Content");
            Element layerElement = contentElement.element("Layer");
            List textObjectList = layerElement.elements("TextObject");
            if (null == textObjectList || textObjectList.size() == 0) {
                OfdAnalysisUtil.extractTextObjectElementData(layerElement, result);
            } else {
                for (Element textObject : textObjectList) {
                    OfdTextObject ofdTextObject = OfdAnalysisUtil.elementChangeOfdTextObject(textObject);
                    result.add(ofdTextObject);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.getErrcode(), OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
        return result;
    }

    private static boolean addOfdTextObject(List<OfdTextObject> invoiceFieldObjects, OfdTextObject nextTextObject) {
        if (invoiceFieldObjects.size() == 0) {
            invoiceFieldObjects.add(nextTextObject);
            return true;
        }
        OfdTextObject lastTextObject = invoiceFieldObjects.get(invoiceFieldObjects.size() - 1);
        boolean sameHeight = OfdAnalysisUtil.coordinateSameHeight(lastTextObject.getCoordinateY(), nextTextObject.getCoordinateY(), 1.0);
        if (sameHeight) {
            invoiceFieldObjects.add(nextTextObject);
            return true;
        }
        return false;
    }

    private static boolean contains(String value, String ... keyArgs) {
        for (String arg : keyArgs) {
            if (!value.contains(arg)) continue;
            return true;
        }
        return false;
    }

    private static List<OfdTextObjectBlock> getOfdPagesTextObjectBlockList(byte[] pageByte) {
        ArrayList<OfdTextObjectBlock> result = new ArrayList<OfdTextObjectBlock>();
        try {
            Element rootElement = OfdReadUtil.getElementByByte(pageByte);
            Element contentElement = rootElement.element("Content");
            Element layerElement = contentElement.element("Layer");
            List textObjectList = layerElement.elements("TextObject");
            ArrayList<OfdTextObject> ofdTextObjects = new ArrayList<OfdTextObject>();
            if (null == textObjectList || textObjectList.size() == 0) {
                OfdAnalysisUtil.extractTextObjectElementData(layerElement, ofdTextObjects);
            } else {
                for (Element textObject : textObjectList) {
                    OfdTextObject ofdTextObject = OfdAnalysisUtil.elementChangeOfdTextObject(textObject);
                    ofdTextObjects.add(ofdTextObject);
                }
            }
            if (null == ofdTextObjects || ofdTextObjects.size() == 0) {
                return result;
            }
            ArrayList<OfdTextObject> ofdTextObjectsTemp = new ArrayList<OfdTextObject>(8);
            for (OfdTextObject ofdTextObject : ofdTextObjects) {
                if (ofdTextObjectsTemp.size() == 0) {
                    ofdTextObjectsTemp.add(ofdTextObject);
                    continue;
                }
                OfdTextObject startOfdTextObject = (OfdTextObject)ofdTextObjectsTemp.get(ofdTextObjectsTemp.size() - 1);
                if (OfdAnalysisUtil.isSameBlock(startOfdTextObject, ofdTextObject, 2.0, startOfdTextObject.getOffsetX() + 3.0) || OfdAnalysisUtil.isSameBlock(ofdTextObjectsTemp, ofdTextObject)) {
                    ofdTextObjectsTemp.add(ofdTextObject);
                    continue;
                }
                result.add(new OfdTextObjectBlock(ofdTextObjectsTemp, ((OfdTextObject)ofdTextObjectsTemp.get(0)).getId()));
                ofdTextObjectsTemp.clear();
                ofdTextObjectsTemp.add(ofdTextObject);
            }
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.getErrcode(), OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
        return result;
    }

    private static boolean isSameBlock(OfdTextObject lastTextObject, OfdTextObject nextTextObject, double differenceValue, double rightValueDifferenceValue) {
        boolean sameHeight = OfdAnalysisUtil.coordinateSameHeight(lastTextObject.getCoordinateY(), nextTextObject.getCoordinateY(), differenceValue);
        boolean coordinateRight = OfdAnalysisUtil.coordinateRightValue(lastTextObject.getCoordinateX(), lastTextObject.getOffsetX(), nextTextObject.getCoordinateX(), rightValueDifferenceValue);
        return sameHeight && coordinateRight;
    }

    private static boolean isSameBlock(List<OfdTextObject> ofdTextObjectsTemp, OfdTextObject nextTextObject) {
        StringBuilder sb = new StringBuilder();
        for (OfdTextObject temp : ofdTextObjectsTemp) {
            sb.append(temp.getTextCodeValue());
        }
        sb.append(nextTextObject.getTextCodeValue());
        Set<String> keySet = keysMap.keySet();
        for (String key : keySet) {
            if (!key.startsWith(sb.toString())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, Object> getOfdPagesContentLayer(byte[] pageByte) {
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        try {
            Element elementNow = OfdReadUtil.getElementByByte(pageByte);
            Element contentElement = elementNow.element("Content");
            Element layerElement = contentElement.element("Layer");
            List textObjectList = layerElement.elements("TextObject");
            for (Element element : textObjectList) {
                String id = element.attributeValue("ID");
                String textCode = element.element("TextCode").getText();
                contentMap.put(id, textCode);
            }
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.getErrcode(), OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
        return contentMap;
    }

    private static List<String> getOfdPagesPath(byte[] documentByte) {
        ArrayList<String> texts = new ArrayList<String>();
        try {
            Element elementNow = OfdReadUtil.getElementByByte(documentByte);
            Element pages = elementNow.element("Pages");
            List pageList = pages.elements("Page");
            for (Element pageElement : pageList) {
                String pagePath = pageElement.attributeValue("BaseLoc");
                texts.add(pagePath);
            }
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.getDescription(), (Throwable)e);
            throw new KDException(new ErrorCode(OfdErrorType.EXTRACT_ERROR.getErrcode(), OfdErrorType.EXTRACT_ERROR.getDescription()), new Object[0]);
        }
        return texts;
    }
}

