/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.ofd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.rim.file.utils.ofd.OfdConvertUtil;
import kd.imc.rim.file.utils.ofd.OfdReadUtil;
import kd.imc.rim.file.utils.ofd.OfdSignUtil;

public class OfdUtil {
    private static Log logger = LogFactory.getLog(OfdUtil.class);

    public static JSONObject analysis(byte[] fileBytes) {
        long start = System.currentTimeMillis();
        JSONObject reuslt = OfdReadUtil.read(fileBytes);
        logger.error("ofd\u89e3\u6790\u8017\u65f6{}", (Object)(System.currentTimeMillis() - start));
        return reuslt;
    }

    public static Map<String, Object> getInvoiceMap(byte[] fileBytes) {
        return OfdReadUtil.extractData(fileBytes);
    }

    public static JSONObject getInvoiceJSON(byte[] fileBytes) {
        return JSONObject.parseObject((String)JSON.toJSONString(OfdUtil.getInvoiceMap(fileBytes)));
    }

    public static boolean verifySign(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, false);
    }

    public static boolean verifySignTax(byte[] fileBytes) {
        return OfdSignUtil.verifySign(fileBytes, true);
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.convertToSvg(fileBytes);
    }

    public static byte[] convertToPng(byte[] fileBytes) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, 1, -1);
    }

    public static byte[] convertToImage(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, imageType, -1);
    }

    public static List<Object> convertToMulPngStr(byte[] fileBytes) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, 1, -1);
    }

    public static List<Object> convertToHDMulImageStr(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, -1);
    }

    public static List<Object> convertToMulImageStr(byte[] fileBytes, int imageType) {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, imageType, -1);
    }

    public static String convertToImageByPageNo(byte[] fileBytes, float zoomScale, int imageType, int pageNo) {
        List<Object> list = OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, pageNo);
        String rsStr = null;
        if (list != null && !list.isEmpty()) {
            rsStr = (String)list.get(0);
        }
        return rsStr;
    }

    public static List<Object> convertToHDMulPngStr(byte[] fileBytes, float zoomScale) {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, 1, -1);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdf(fileBytes);
    }

    public static byte[] convertToPdfNew(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdfNew(fileBytes);
    }

    public static byte[] convertToHDPng(byte[] fileBytes, float multipleNum) {
        return OfdConvertUtil.convertToImage(fileBytes, multipleNum, 1, -1);
    }

    public static byte[] convertToHDImage(byte[] fileBytes, float zoomScale, int imageType) {
        return OfdConvertUtil.convertToImage(fileBytes, zoomScale, imageType, -1);
    }
}

