/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.rim.file.utils.pdf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;

public class PDFTemplateUtils {
    private static ConcurrentHashMap<String, byte[]> cacheTemplateMap = new ConcurrentHashMap();

    public static byte[] getPDFTemplateInfoBytes(String filePath) {
        File file = new File(filePath);
        String fileName = file.getName();
        cacheTemplateMap.putIfAbsent(fileName, Objects.requireNonNull(PDFTemplateUtils.readTempFileBytes(filePath)));
        return cacheTemplateMap.get(fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readTempFileBytes(String path) {
        try (InputStream in = PDFTemplateUtils.class.getClassLoader().getResourceAsStream(path);){
            if (in == null) return null;
            byte[] byArray = PDFTemplateUtils.getByte(in);
            return byArray;
        }
        catch (Exception e) {
            throw new KDException(new ErrorCode("9999", "download template read exception"), new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getByte(InputStream inputStream) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

