/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.constant.InvoiceStatus;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.bill.BillHelper;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceCommonService;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.BillCenterLogEnum;

public class SimBillCenterFillInFormPlugin
extends AbstractFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(SimBillCenterFillInFormPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap1"});
        TextEdit invoiceNoEdit = (TextEdit)this.getView().getControl("invoiceno");
        invoiceNoEdit.addClickListener((ClickListener)this);
        TextEdit invoiceCodeNoEdit = (TextEdit)this.getView().getControl("invoicecode");
        invoiceCodeNoEdit.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initFillInvoiceViewMethod();
    }

    private void initFillInvoiceViewMethod() {
        Label notice = (Label)this.getView().getControl("notice");
        notice.setText(ResManager.loadKDString((String)"\u52fe\u9009\u591a\u4e2a\u5355\u636e\u65f6\uff0c\u9ed8\u8ba4\u4e3a\u591a\u4e2a\u5355\u636e\u5408\u5e76\u5f00\u7968\u3002\u70b9\u51fb\u3010\u786e\u8ba4\u3011\u89c6\u4e3a\u5f00\u7968\u7ed3\u675f\uff0c\u5f00\u7968\u7ed3\u675f\u540e\u4e0d\u53ef\u518d\u6b21\u56de\u586b\u53d1\u7968\u3002", (String)"SimFillInInvoicePlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        this.getView().setVisible(Boolean.TRUE, new String[]{"edittypepane"});
        BigDecimal totalAmount = BigDecimal.ZERO;
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        String fillInOpType = (String)customParamsMap.get("fillInOpType");
        if ("1".equals(fillInOpType)) {
            totalAmount = this.getAllBillTotalAmount();
            this.getView().setVisible(Boolean.TRUE, new String[]{"cofirmaddrelateinvs"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"canceladdrelateinvs"});
            this.initFillInvoiceViewByFillIn(customParamsMap);
        } else if ("2".equals(fillInOpType)) {
            totalAmount = this.getAllBillTotalAmount(customParamsMap);
            this.getView().setVisible(Boolean.TRUE, new String[]{"canceladdrelateinvs"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"cofirmaddrelateinvs"});
            this.initFillInvoiceViewByCancel(customParamsMap);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new", "delete"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"buttonpane"});
        }
        Label billtips = (Label)this.getView().getControl("billtips");
        String billTips = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u52fe\u9009\u7684\u8d26\u5355\u603b\u91d1\u989d\u5408\u8ba1\u662f:%s\u5143", (String)"SimFillInInvoicePlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]), totalAmount.setScale(2, 4));
        billtips.setText(billTips);
    }

    private BigDecimal getAllBillTotalAmount(Map<String, Object> customParamsMap) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        JSONArray jsonArray = (JSONArray)customParamsMap.get("billRelateInvoices");
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject subObject;
                String billCenterData;
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String innerParam = jsonObject.getString("inner_param_tag");
                if (StringUtils.isBlank((CharSequence)innerParam) || StringUtils.isBlank((CharSequence)(billCenterData = (subObject = JSONObject.parseObject((String)innerParam)).getString("billCenterData")))) continue;
                JSONObject billCenterObject = JSONObject.parseObject((String)billCenterData);
                BigDecimal bill_total_amount = billCenterObject.getBigDecimal("bill_total_amount");
                totalAmount = totalAmount.add(bill_total_amount);
            }
        }
        return totalAmount;
    }

    private BigDecimal getAllBillTotalAmount() {
        JSONArray jsonArray;
        BigDecimal totalAmount = new BigDecimal("0.00");
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        if (customParamsMap.containsKey("fillInOpType") && (jsonArray = (JSONArray)customParamsMap.get("dynamicObjects")) != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                totalAmount = totalAmount.add(jsonObject.getBigDecimal("total_amount"));
            }
        }
        return totalAmount;
    }

    private void initFillInvoiceViewByCancel(Map<String, Object> customParamsMap) {
        JSONArray jsonArray = (JSONArray)customParamsMap.get("billRelateInvoices");
        if (jsonArray != null && jsonArray.size() > 0) {
            this.initBillEntryView(jsonArray);
            HashMap<String, JSONObject> invoiceDataMap = new HashMap<String, JSONObject>(jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                JSONArray subArray = this.getInvoiceParamMethod(jsonObject);
                if (subArray == null || subArray.size() == 0) continue;
                for (int j = 0; j < subArray.size(); ++j) {
                    JSONObject invoiceObject = subArray.getJSONObject(j);
                    String invoiceType = invoiceObject.getString("invoicetype");
                    String invoiceCode = invoiceObject.getString("invoicecode");
                    String invoiceNo = invoiceObject.getString("invoiceno");
                    String key = invoiceType + invoiceCode + invoiceNo;
                    if (invoiceDataMap.containsKey(key)) continue;
                    invoiceDataMap.put(key, invoiceObject);
                }
            }
            this.initInvoiceEntryView(invoiceDataMap);
        }
    }

    private void initBillEntryView(JSONArray jsonArray) {
        this.getModel().beginInit();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject subObject;
            String billCenterData;
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String innerParam = jsonObject.getString("inner_param_tag");
            if (StringUtils.isBlank((CharSequence)innerParam) || StringUtils.isBlank((CharSequence)(billCenterData = (subObject = JSONObject.parseObject((String)innerParam)).getString("billCenterData")))) continue;
            JSONObject billCenterObject = JSONObject.parseObject((String)billCenterData);
            int row = this.getView().getModel().createNewEntryRow("bill_entryentity");
            this.getModel().setValue("system_code", (Object)billCenterObject.getString("system_code"), row);
            this.getModel().setValue("bill_no", (Object)billCenterObject.getString("bill_no"), row);
            this.getModel().setValue("bill_total_amount", (Object)billCenterObject.getBigDecimal("bill_total_amount"), row);
            this.getModel().setValue("can_push_amount", (Object)billCenterObject.getBigDecimal("can_push_amount"), row);
            this.getModel().setValue("pushed_amount", (Object)billCenterObject.getBigDecimal("pushed_amount"), row);
            this.getModel().setValue("opened_amount", (Object)billCenterObject.getBigDecimal("opened_amount"), row);
            this.getModel().setValue("can_open_amount", (Object)billCenterObject.getBigDecimal("can_open_amount"), row);
            this.getModel().setValue("fill_in_amount", (Object)billCenterObject.getBigDecimal("fill_in_amount"), row);
            this.getModel().setValue("remain_amount", (Object)billCenterObject.getBigDecimal("remain_amount"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"fill_in_amount"});
        }
        this.getModel().endInit();
        this.getView().updateView("bill_entryentity");
    }

    private JSONArray getInvoiceParamMethod(JSONObject jsonObject) {
        String innerParam = jsonObject.getString("inner_param_tag");
        if (StringUtils.isBlank((CharSequence)innerParam)) {
            return null;
        }
        JSONObject subObject = JSONObject.parseObject((String)innerParam);
        String invoiceDataList = subObject.getString("invoiceDataList");
        if (StringUtils.isBlank((CharSequence)invoiceDataList)) {
            return null;
        }
        JSONArray jsonArray = JSONArray.parseArray((String)invoiceDataList);
        return jsonArray;
    }

    private void initInvoiceEntryView(Map<String, JSONObject> invoiceDataMap) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"new", "delete"});
        this.getModel().beginInit();
        for (Map.Entry<String, JSONObject> entryObject : invoiceDataMap.entrySet()) {
            JSONObject invoiceObject = entryObject.getValue();
            int row = this.getView().getModel().createNewEntryRow("invoice_entryentity");
            this.getModel().setValue("invoicetype", (Object)invoiceObject.getString("invoicetype"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoicetype"});
            String invoiceCode = invoiceObject.getString("invoicecode");
            this.getModel().setValue("invoicecode", (Object)invoiceCode, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoicecode"});
            String invoiceNo = invoiceObject.getString("invoiceno");
            this.getModel().setValue("invoiceno", (Object)invoiceNo, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoiceno"});
            this.getModel().setValue("issuetime", (Object)invoiceObject.getString("issuetime"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"issuetime"});
            this.getModel().setValue("totalamount", (Object)invoiceObject.getBigDecimal("totalamount"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"totalamount"});
            this.getModel().setValue("invoiceamount", (Object)invoiceObject.getBigDecimal("invoiceamount"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoiceamount"});
            this.getModel().setValue("totaltax", (Object)invoiceObject.getBigDecimal("totaltax"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"totaltax"});
        }
        this.getModel().endInit();
        this.getView().updateView("invoice_entryentity");
    }

    private void initFillInvoiceViewByFillIn(Map<String, Object> customParamsMap) {
        JSONArray jsonArray = (JSONArray)customParamsMap.get("dynamicObjects");
        if (jsonArray != null && jsonArray.size() > 0) {
            this.getModel().beginInit();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                int row = this.getView().getModel().createNewEntryRow("bill_entryentity");
                this.getModel().setValue("system_code", (Object)jsonObject.getString("system_code"), row);
                this.getModel().setValue("bill_no", (Object)jsonObject.getString("billno"), row);
                this.getModel().setValue("bill_total_amount", (Object)jsonObject.getString("total_amount"), row);
                this.getModel().setValue("can_push_amount", (Object)jsonObject.getString("invoicable_amount"), row);
                this.getModel().setValue("pushed_amount", (Object)jsonObject.getString("pushamount"), row);
                this.getModel().setValue("opened_amount", (Object)jsonObject.getString("invoice_amount"), row);
                this.getModel().setValue("can_open_amount", (Object)jsonObject.getString("invoicable_amount"), row);
                this.getModel().setValue("remain_amount", (Object)jsonObject.getBigDecimal("remain_amount"), row);
            }
            this.getModel().endInit();
            this.getView().updateView("bill_entryentity");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData changeData = e.getChangeSet()[0];
        int editIndex = changeData.getRowIndex();
        switch (name) {
            case "invoicecode": {
                this.autoWriteAmount(editIndex, name);
                break;
            }
            case "invoiceno": {
                this.autoWriteAmount(editIndex, name);
                break;
            }
            case "invoicetype": {
                this.setTotalAmountMethod(editIndex);
                break;
            }
            case "invoiceamount": {
                this.setTotalAmountMethod(editIndex);
                break;
            }
            case "totaltax": {
                this.setTotalAmountMethod(editIndex);
                break;
            }
            case "issuetime": {
                this.setTotalAmountMethod(editIndex);
                break;
            }
            case "fill_in_amount": {
                this.checkFillInAmount(editIndex, null);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "cofirmaddrelateinvs": {
                LOGGER.info("\u53d1\u7968\u56de\u586b\u5f00\u59cb");
                this.confirmFillInInvoiceMethod();
                this.getView().returnDataToParent((Object)"cofirmaddrelateinvs");
                this.getView().close();
                break;
            }
            case "canceladdrelateinvs": {
                LOGGER.info("\u53d6\u6d88\u56de\u586b\u5f00\u59cb");
                this.cancelFillInInvoiceMethod();
                this.getView().returnDataToParent((Object)"canceladdrelateinvs");
                this.getView().close();
                break;
            }
            case "cancel": {
                this.getView().close();
            }
        }
    }

    private void confirmFillInInvoiceMethod() {
        DynamicObjectCollection billCenterCollection = this.getView().getModel().getEntryEntity("bill_entryentity");
        if (billCenterCollection == null || billCenterCollection.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u8d26\u5355\u533a\u57df\u7684\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4\u56de\u586b", (String)"SimFillInInvoicePlugin_16", (String)"imc-sim-webapi", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        String errorMsg = ResManager.loadKDString((String)"\u53d1\u7968\u533a\u57df\u7684\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4\u56de\u586b", (String)"SimFillInInvoicePlugin_15", (String)"imc-sim-webapi", (Object[])new Object[0]);
        for (int editIndex = 0; editIndex < billCenterCollection.size(); ++editIndex) {
            this.checkFillInAmount(editIndex, errorMsg);
        }
        DynamicObjectCollection invoiceItemCollection = this.getView().getModel().getEntryEntity("invoice_entryentity");
        if (invoiceItemCollection == null || invoiceItemCollection.isEmpty()) {
            String errorMsg2 = ResManager.loadKDString((String)"\u53d1\u7968\u533a\u57df\u7684\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4\u56de\u586b", (String)"SimFillInInvoicePlugin_15", (String)"imc-sim-webapi", (Object[])new Object[0]);
            throw new KDBizException(errorMsg2);
        }
        int rowIndex = 1;
        for (DynamicObject invoiceItem : invoiceItemCollection) {
            String invoiceType = invoiceItem.getString("invoicetype");
            String invoiceNo = invoiceItem.getString("invoiceno");
            Date issueTime = invoiceItem.getDate("issuetime");
            if (StringUtils.isBlank((CharSequence)invoiceType) || StringUtils.isBlank((CharSequence)invoiceNo) || issueTime == null) {
                String errorMsg3 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u5217\u8868\u533a\u57df\u4e2d\u7b2c:%s\u884c\u7684\u5206\u5f55\u6570\u636e\u53d1\u7968\u7c7b\u578b\u3001\u53d1\u7968\u53f7\u7801\u3001\u5f00\u7968\u65f6\u95f4\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4\u56de\u586b", (String)"SimFillInInvoicePlugin_22", (String)"imc-sim-webapi", (Object[])new Object[0]), rowIndex);
                throw new KDBizException(errorMsg3);
            }
            BigDecimal invoiceAmount = invoiceItem.getBigDecimal("invoiceamount");
            BigDecimal taxAmount = invoiceItem.getBigDecimal("totaltax");
            BigDecimal totalAmount = invoiceItem.getBigDecimal("totalamount");
            if (invoiceAmount == null || taxAmount == null || totalAmount == null) {
                String errorMsg4 = String.format(ResManager.loadKDString((String)"\u53d1\u7968\u5217\u8868\u533a\u57df\u4e2d\u7b2c:%s\u884c\u7684\u5206\u5f55\u6570\u636e\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)\u3001\u7a0e\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c\u786e\u8ba4\u56de\u586b", (String)"SimFillInInvoicePlugin_23", (String)"imc-sim-webapi", (Object[])new Object[0]), rowIndex);
                throw new KDBizException(errorMsg4);
            }
            ++rowIndex;
        }
        String tipMsg = this.dealCheckBillAndInvoiceMethod(invoiceItemCollection);
        if (StringUtils.isNotBlank((CharSequence)tipMsg)) {
            throw new KDBizException(tipMsg);
        }
        tipMsg = this.dealCheckBillAndInvoiceAmount(billCenterCollection, invoiceItemCollection);
        if (StringUtils.isNotBlank((CharSequence)tipMsg)) {
            throw new KDBizException(tipMsg);
        }
        this.dealCheckInvoiceNoUsedMethod(invoiceItemCollection);
        this.dealUpdateFillInBillCenterData(billCenterCollection, invoiceItemCollection);
        this.dealSaveBillAndInvoiceRelation(billCenterCollection, invoiceItemCollection);
        ThreadPools.executeOnceIncludeRequestContext((String)"sync_notice_front_system", () -> this.dealNoticeResultToFrontSystem(billCenterCollection, "1"));
    }

    private void dealCheckInvoiceNoUsedMethod(DynamicObjectCollection invoiceItemCollection) {
        int editExit = 0;
        for (DynamicObject invoiceItem : invoiceItemCollection) {
            String invoiceNo = invoiceItem.getString("invoiceno");
            boolean flag = this.dealCheckInvoiceIsExist(invoiceNo);
            if (flag) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801:%s\uff0c\u91cd\u590d\u6dfb\u52a0\u53d1\u7968\u5206\u5f55\u6570\u636e", (String)"SimFillInInvoicePlugin_9", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            Set<String> invoiceNoSet = this.getNotUsedInvoiceNoList(editExit);
            if (!invoiceNoSet.isEmpty() && invoiceNoSet.contains(invoiceNo)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801\uff1a%s\u4e0d\u53ef\u56de\u586b\uff0c\u539f\u56e0\uff1a\u8ddf\u8d26\u5355\u6709\u5173\u8054\u7684\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u56de\u586b\u5230\u8d26\u5355\u3002", (String)"SimFillInInvoicePlugin_21", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo);
                throw new KDBizException(errorMsg);
            }
            ++editExit;
        }
    }

    private void dealNoticeResultToFrontSystem(DynamicObjectCollection billCenterCollection, String callBackType) {
        LOGGER.info("dealNoticeResultToFrontSystem, callBackType:{}", (Object)callBackType);
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (DynamicObject billCenterObject : billCenterCollection) {
            String systemCode = billCenterObject.getString("system_code");
            String billNo = billCenterObject.getString("bill_no");
            DynamicObject dynamicObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
            if (dynamicObject == null) continue;
            ExternalSystemDataHandler externalSystemDataHandler = new ExternalSystemDataHandler();
            DynamicObject invoiceObject = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice");
            invoiceObject.set("systemsource", (Object)systemCode);
            DynamicObjectCollection invoiceCollection = dynamicObject.getDynamicObjectCollection("invoice");
            for (DynamicObject invoiceItem : invoiceCollection) {
                InvoiceVo invoiceVo = new InvoiceVo();
                invoiceVo.setSystemSource(systemCode);
                invoiceVo.setBillNo(billNo);
                String invoiceNum = invoiceItem.getString("invoiceno");
                invoiceVo.setInvoiceNum(invoiceNum);
                invoiceVo.setInvoiceCode(invoiceItem.getString("invoicecode"));
                QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNum);
                DynamicObject invoiceObjectDB = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"invoicetype", (QFilter[])qFilter.toArray());
                if (invoiceObjectDB != null) {
                    invoiceVo.setInvoiceType(invoiceObjectDB.getString("invoicetype"));
                } else {
                    invoiceVo.setInvoiceType(dynamicObject.getString("invoicetype"));
                }
                invoiceVo.setIncludeTaxAmount(invoiceItem.getBigDecimal("totalamount"));
                invoiceVo.setRemark(callBackType);
                invoiceVo.setBuyerTaxpayerId(dynamicObject.getString("buyertaxno"));
                invoiceVo.setBuyerName(dynamicObject.getString("buyername"));
                invoiceVo.setInvoiceDate(invoiceItem.getDate("issuetime"));
                externalSystemDataHandler.dealUpdateOpenInvoiceStatus(invoiceObject, invoiceVo);
                LOGGER.info("dealNoticeResultToFrontSystem, \u63a8\u9001\u56de\u8c03\u901a\u77e5\u5b8c\u6210\uff01");
            }
        }
    }

    private void dealSaveBillAndInvoiceRelation(DynamicObjectCollection billCenterCollection, DynamicObjectCollection invoiceItemCollection) {
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        String opType = BillCenterLogEnum.INVOICE_FILL_IN_OP_TYPE.getBillStatus();
        for (DynamicObject dynamicObject : billCenterCollection) {
            JSONObject jsonObject = new JSONObject();
            JSONObject subObject = new JSONObject();
            subObject.put("system_code", (Object)dynamicObject.getString("system_code"));
            subObject.put("bill_no", (Object)dynamicObject.getString("bill_no"));
            subObject.put("bill_total_amount", (Object)dynamicObject.getBigDecimal("bill_total_amount"));
            subObject.put("can_open_amount", (Object)dynamicObject.getBigDecimal("can_open_amount"));
            subObject.put("can_push_amount", (Object)dynamicObject.getBigDecimal("can_push_amount"));
            subObject.put("opened_amount", (Object)dynamicObject.getBigDecimal("opened_amount"));
            subObject.put("pushed_amount", (Object)dynamicObject.getBigDecimal("pushed_amount"));
            subObject.put("fill_in_amount", (Object)dynamicObject.getBigDecimal("fill_in_amount"));
            subObject.put("remain_amount", (Object)dynamicObject.getBigDecimal("remain_amount"));
            jsonObject.put("billCenterData", (Object)subObject);
            JSONArray subArray = new JSONArray();
            for (DynamicObject invoiceItem : invoiceItemCollection) {
                JSONObject invoiceObject = new JSONObject();
                invoiceObject.put("invoicetype", (Object)invoiceItem.getString("invoicetype"));
                invoiceObject.put("invoiceno", (Object)invoiceItem.getString("invoiceno"));
                invoiceObject.put("invoicecode", (Object)invoiceItem.getString("invoicecode"));
                invoiceObject.put("issuetime", (Object)DateUtils.format((Date)invoiceItem.getDate("issuetime"), (String)"yyyy-MM-dd HH:mm:ss"));
                invoiceObject.put("invoiceamount", (Object)invoiceItem.getBigDecimal("invoiceamount"));
                invoiceObject.put("totaltax", (Object)invoiceItem.getBigDecimal("totaltax"));
                invoiceObject.put("totalamount", (Object)invoiceItem.getBigDecimal("totalamount"));
                subArray.add((Object)invoiceObject);
            }
            jsonObject.put("invoiceDataList", (Object)subArray);
            String systemCode = dynamicObject.getString("system_code");
            String billNoParam = dynamicObject.getString("bill_no");
            String innerParam = jsonObject.toJSONString();
            billCenterInvoiceLogService.dealSaveInterfaceLogDataByType(systemCode, opType, billNoParam, innerParam, null);
        }
    }

    private void dealUpdateFillInBillCenterData(DynamicObjectCollection billCenterCollection, DynamicObjectCollection invoiceItemCollection) {
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        for (DynamicObject dynamicObject : billCenterCollection) {
            String systemCode = dynamicObject.getString("system_code");
            String billNo = dynamicObject.getString("bill_no");
            BigDecimal fillInAmount = dynamicObject.getBigDecimal("fill_in_amount");
            DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
            if (billCenterObject == null) continue;
            billCenterObject.set("invoice_status", (Object)"1");
            BigDecimal invoicedAmount = fillInAmount.add(billCenterObject.getBigDecimal("invoice_amount"));
            billCenterObject.set("invoice_amount", (Object)invoicedAmount);
            BigDecimal remainAmount = billCenterObject.getBigDecimal("invoicable_amount").subtract(invoicedAmount);
            billCenterObject.set("remain_amount", (Object)remainAmount);
            billCenterObject.set("fill_in_status", (Object)"1");
            DynamicObjectCollection billCenterInvoiceCollection = billCenterObject.getDynamicObjectCollection("invoice");
            for (DynamicObject invoiceItem : invoiceItemCollection) {
                DynamicObject billCenterInvoice = billCenterInvoiceCollection.addNew();
                billCenterInvoice.set("invoiceno", (Object)invoiceItem.getString("invoiceno"));
                billCenterInvoice.set("invoicecode", (Object)invoiceItem.getString("invoicecode"));
                billCenterInvoice.set("issuetime", invoiceItem.get("issuetime"));
                billCenterInvoice.set("invoiceamount", (Object)invoiceItem.getBigDecimal("invoiceamount"));
                billCenterInvoice.set("totaltax", (Object)invoiceItem.getBigDecimal("totaltax"));
                billCenterInvoice.set("totalamount", (Object)invoiceItem.getBigDecimal("totalamount"));
            }
            ImcSaveServiceHelper.save((DynamicObject)billCenterObject);
        }
    }

    private String dealCheckBillAndInvoiceAmount(DynamicObjectCollection billCenterCollection, DynamicObjectCollection invoiceItemCollection) {
        BigDecimal total_fill_in_amount = BigDecimal.ZERO;
        for (Object billCenterObject : billCenterCollection) {
            total_fill_in_amount = total_fill_in_amount.add(billCenterObject.getBigDecimal("fill_in_amount"));
        }
        BigDecimal total_invoice_amount = BigDecimal.ZERO;
        for (DynamicObject invoiceItem : invoiceItemCollection) {
            total_invoice_amount = total_invoice_amount.add(invoiceItem.getBigDecimal("totalamount"));
        }
        String tipMsg = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fillInBillType = (String)customParams.get("fillInBillType");
        if ("Positive".equals(fillInBillType)) {
            if (total_fill_in_amount.compareTo(BigDecimal.ZERO) <= 0 || total_fill_in_amount.compareTo(total_invoice_amount) > 0) {
                tipMsg = ResManager.loadKDString((String)"\u56de\u586b\u7684\u603b\u91d1\u989d\u8d85\u51fa\u53d1\u7968\u603b\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002\u5177\u4f53\u89c4\u5219\uff1a0<\u56de\u586b\u91d1\u989d\u4e4b\u548c<=\u53d1\u7968\u603b\u91d1\u989d", (String)"SimFillInInvoicePlugin_17", (String)"imc-sim-webapi", (Object[])new Object[0]);
            }
        } else if ("Negative".equals(fillInBillType)) {
            if (total_fill_in_amount.compareTo(BigDecimal.ZERO) > 0 || total_fill_in_amount.compareTo(total_invoice_amount) < 0) {
                tipMsg = ResManager.loadKDString((String)"\u56de\u586b\u7684\u603b\u91d1\u989d\u8d85\u51fa\u53d1\u7968\u603b\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002\u5177\u4f53\u89c4\u5219\uff1a0>\u56de\u586b\u91d1\u989d\u4e4b\u548c>=\u53d1\u7968\u603b\u91d1\u989d", (String)"SimFillInInvoicePlugin_18", (String)"imc-sim-webapi", (Object[])new Object[0]);
            }
        } else if (total_fill_in_amount.compareTo(total_invoice_amount) != 0) {
            tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u5408\u8ba1\u91d1\u989d\u4e3a0\u65f6\uff0c\u56de\u586b\u7684\u53d1\u7968\u603b\u91d1\u989d\u5fc5\u987b\u4e3a0", (String)"SimFillInInvoicePlugin_20", (String)"imc-sim-webapi", (Object[])new Object[0]);
        }
        return tipMsg;
    }

    private void cancelFillInInvoiceMethod() {
        DynamicObjectCollection billCenterCollection = this.getView().getModel().getEntryEntity("bill_entryentity");
        if (billCenterCollection == null || billCenterCollection.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u8d26\u5355\u533a\u57df\u7684\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c\u53d6\u6d88\u56de\u586b", (String)"SimFillInInvoicePlugin_19", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fillInBillType = (String)customParams.get("fillInBillType");
        BillCenterInvoiceCommonService billCenterInvoiceCommonService = new BillCenterInvoiceCommonService();
        BillCenterInvoiceLogService billCenterInvoiceLogService = new BillCenterInvoiceLogService();
        for (DynamicObject dynamicObject : billCenterCollection) {
            String systemCode = dynamicObject.getString("system_code");
            String billNo = dynamicObject.getString("bill_no");
            BigDecimal fillInAmount = dynamicObject.getBigDecimal("fill_in_amount");
            DynamicObject billCenterObject = billCenterInvoiceCommonService.dealCheckBillCenterDataMethod("billno", billNo, systemCode);
            if (billCenterObject == null) continue;
            if ("Positive".equals(fillInBillType)) {
                this.dealUpdateBillCenterHeaderByPositive(billCenterObject, fillInAmount);
            } else if ("Negative".equals(fillInBillType)) {
                this.dealUpdateBillCenterHeaderByNegative(billCenterObject, fillInAmount);
            } else {
                billCenterObject.set("invoice_status", (Object)"0");
            }
            billCenterObject.set("fill_in_status", (Object)"0");
            DynamicObjectCollection invoiceItemCollection = billCenterObject.getDynamicObjectCollection("invoice");
            if (!invoiceItemCollection.isEmpty()) {
                invoiceItemCollection.clear();
            }
            ImcSaveServiceHelper.save((DynamicObject)billCenterObject);
            QFilter qFilter = new QFilter("system_code", "=", (Object)systemCode).and("billno", "like", (Object)billNo).and("operate_type", "=", (Object)BillCenterLogEnum.INVOICE_FILL_IN_OP_TYPE.getBillStatus());
            DynamicObject billLogObject = billCenterInvoiceLogService.dealLoadInvoiceLogByCondition(qFilter);
            if (billLogObject == null) continue;
            QFilter pkFilter = new QFilter("id", "=", billLogObject.getPkValue());
            DeleteServiceHelper.delete((String)"sim_bill_log", (QFilter[])pkFilter.toArray());
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"sync_notice_front_system", () -> this.dealNoticeResultToFrontSystem(billCenterCollection, "2"));
    }

    private void dealUpdateBillCenterHeaderByNegative(DynamicObject billCenterObject, BigDecimal fillInAmount) {
        BigDecimal canPushAmount = billCenterObject.getBigDecimal("invoicable_amount");
        BigDecimal openedInvoiceAmount = billCenterObject.getBigDecimal("invoice_amount");
        openedInvoiceAmount = openedInvoiceAmount.subtract(fillInAmount);
        billCenterObject.set("invoice_amount", (Object)openedInvoiceAmount);
        BigDecimal remainAmount = canPushAmount.subtract(openedInvoiceAmount);
        billCenterObject.set("remain_amount", (Object)remainAmount);
        if (openedInvoiceAmount.compareTo(canPushAmount) > 0) {
            billCenterObject.set("invoice_status", (Object)"2");
            if (openedInvoiceAmount.compareTo(BigDecimal.ZERO) == 0) {
                billCenterObject.set("invoice_status", (Object)"0");
            }
        } else if (openedInvoiceAmount.compareTo(canPushAmount) <= 0) {
            billCenterObject.set("invoice_status", (Object)"1");
        }
    }

    private void dealUpdateBillCenterHeaderByPositive(DynamicObject billCenterObject, BigDecimal fillInAmount) {
        BigDecimal canPushAmount = billCenterObject.getBigDecimal("invoicable_amount");
        BigDecimal openedInvoiceAmount = billCenterObject.getBigDecimal("invoice_amount");
        openedInvoiceAmount = openedInvoiceAmount.subtract(fillInAmount);
        billCenterObject.set("invoice_amount", (Object)openedInvoiceAmount);
        BigDecimal remainAmount = canPushAmount.subtract(openedInvoiceAmount);
        billCenterObject.set("remain_amount", (Object)remainAmount);
        if (openedInvoiceAmount.compareTo(canPushAmount) < 0) {
            billCenterObject.set("invoice_status", (Object)"2");
            if (openedInvoiceAmount.compareTo(BigDecimal.ZERO) == 0) {
                billCenterObject.set("invoice_status", (Object)"0");
            }
        } else if (openedInvoiceAmount.compareTo(canPushAmount) >= 0) {
            billCenterObject.set("invoice_status", (Object)"1");
        }
    }

    private void checkFillInAmount(int editIndex, String errorMsg) {
        DynamicObjectCollection invoiceItemCollection = this.getView().getModel().getEntryEntity("invoice_entryentity");
        if (invoiceItemCollection == null || invoiceItemCollection.isEmpty()) {
            if (StringUtils.isBlank((CharSequence)errorMsg)) {
                errorMsg = ResManager.loadKDString((String)"\u53d1\u7968\u533a\u57df\u7684\u5206\u5f55\u6570\u636e\u4e3a\u7a7a\uff0c\u672c\u6b21\u56de\u586b\u91d1\u989d\u4e0d\u5141\u8bb8", (String)"SimFillInInvoicePlugin_14", (String)"imc-sim-webapi", (Object[])new Object[0]);
            }
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        BigDecimal fillInAmount = (BigDecimal)this.getView().getModel().getValue("fill_in_amount", editIndex);
        BigDecimal totalAmount = (BigDecimal)this.getView().getModel().getValue("bill_total_amount", editIndex);
        BigDecimal openedAmount = (BigDecimal)this.getView().getModel().getValue("opened_amount", editIndex);
        BigDecimal comparedAmount = totalAmount.subtract(openedAmount);
        String tipMsg = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fillInBillType = (String)customParams.get("fillInBillType");
        if ("Positive".equals(fillInBillType)) {
            if (fillInAmount.compareTo(BigDecimal.ZERO) <= 0) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d26\u5355\u7684\u56de\u586b\u91d1\u989d\u4e0d\u5408\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002\u5177\u4f53\u89c4\u5219\uff1a0<\u5355\u884c\u56de\u586b\u91d1\u989d<=\uff08\u8d26\u5355\u603b\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09", (String)"SimFillInInvoicePlugin_10", (String)"imc-sim-webapi", (Object[])new Object[0]), editIndex + 1);
            } else if (fillInAmount.compareTo(comparedAmount) > 0) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d26\u5355\u7684\u56de\u586b\u91d1\u989d\u4e0d\u5408\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002\u5177\u4f53\u89c4\u5219\uff1a0<\u5355\u884c\u56de\u586b\u91d1\u989d<=\uff08\u8d26\u5355\u603b\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09", (String)"SimFillInInvoicePlugin_11", (String)"imc-sim-webapi", (Object[])new Object[0]), editIndex + 1);
            }
        } else if ("Negative".equals(fillInBillType)) {
            if (fillInAmount.compareTo(BigDecimal.ZERO) >= 0) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d26\u5355\u7684\u56de\u586b\u91d1\u989d\u4e0d\u5408\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002\u5177\u4f53\u89c4\u5219\uff1a0>\u5355\u884c\u56de\u586b\u91d1\u989d>=\uff08\u8d26\u5355\u603b\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09", (String)"SimFillInInvoicePlugin_12", (String)"imc-sim-webapi", (Object[])new Object[0]), editIndex + 1);
            } else if (fillInAmount.compareTo(comparedAmount) < 0) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d26\u5355\u7684\u56de\u586b\u91d1\u989d\u4e0d\u5408\u7406\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199\u3002\u5177\u4f53\u89c4\u5219\uff1a0>\u5355\u884c\u56de\u586b\u91d1\u989d>=\uff08\u8d26\u5355\u603b\u91d1\u989d-\u5df2\u5f00\u7968\u91d1\u989d\uff09", (String)"SimFillInInvoicePlugin_13", (String)"imc-sim-webapi", (Object[])new Object[0]), editIndex + 1);
            }
        }
        if (StringUtils.isNotBlank(tipMsg)) {
            throw new KDBizException(tipMsg);
        }
    }

    private void autoWriteAmount(int editIndex, String name) {
        QFilter filter;
        String invoiceCode = (String)this.getView().getModel().getValue("invoicecode", editIndex);
        String invoiceNo = (String)this.getView().getModel().getValue("invoiceno", editIndex);
        String invoiceType = (String)this.getView().getModel().getValue("invoicetype", editIndex);
        this.getView().setEnable(Boolean.TRUE, editIndex, new String[]{"issuetime"});
        DynamicObject invoiceObject = null;
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            if (this.checkInvoiceNo(name, invoiceNo)) {
                return;
            }
            filter = new QFilter("invoiceno", "=", (Object)invoiceNo);
            invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])filter.toArray());
        } else if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isNotBlank((CharSequence)invoiceNo)) {
            if (this.checkInvoiceCodeAndNo(name, invoiceCode, invoiceNo, invoiceType)) {
                return;
            }
            filter = new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNo);
            invoiceObject = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])filter.toArray());
        }
        boolean flag = this.dealCheckInvoiceIsExist(invoiceNo);
        if (flag) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801:%s\uff0c\u91cd\u590d\u6dfb\u52a0\u53d1\u7968\u5206\u5f55\u6570\u636e", (String)"SimFillInInvoicePlugin_9", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo);
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        if (invoiceObject != null) {
            this.getModel().setValue("invoicetype", (Object)invoiceObject.getString("invoicetype"), editIndex);
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"invoicetype"});
            this.getModel().setValue("issuetime", (Object)invoiceObject.getString("issuetime"), editIndex);
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"issuetime"});
            this.getModel().setValue("invoiceamount", (Object)this.trimEndZero(invoiceObject.get("invoiceamount")), editIndex);
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"invoiceamount"});
            this.getModel().setValue("totaltax", (Object)this.trimEndZero(invoiceObject.get("totaltax")), editIndex);
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"totaltax"});
            this.getModel().setValue("totalamount", (Object)this.trimEndZero(invoiceObject.get("totalamount")), editIndex);
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"totalamount"});
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"invoiceno"});
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"invoicecode"});
        } else {
            Set<String> invoiceNoSet = this.getNotUsedInvoiceNoList(editIndex);
            if (!invoiceNoSet.isEmpty() && invoiceNoSet.contains(invoiceNo)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u53d1\u7968\u53f7\u7801\uff1a%s\u4e0d\u53ef\u56de\u586b\uff0c\u539f\u56e0\uff1a\u8ddf\u8d26\u5355\u6709\u5173\u8054\u7684\u53d1\u7968\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u56de\u586b\u5230\u8d26\u5355\u3002", (String)"SimFillInInvoicePlugin_21", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo);
                throw new KDBizException(errorMsg);
            }
            this.setTotalAmountMethod(editIndex);
        }
    }

    private void setTotalAmountMethod(int editIndex) {
        Object[] objectArray;
        String invoiceCode = (String)this.getView().getModel().getValue("invoicecode", editIndex);
        String invoiceNo = (String)this.getView().getModel().getValue("invoiceno", editIndex);
        String invoiceType = (String)this.getView().getModel().getValue("invoicetype", editIndex);
        Date issueTime = (Date)this.getModel().getValue("issuetime", editIndex);
        BigDecimal invoiceAmount = (BigDecimal)this.getModel().getValue("invoiceamount", editIndex);
        BigDecimal totalTax = (BigDecimal)this.getModel().getValue("totaltax", editIndex);
        if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
            invoiceCode = "\u53d1\u7968\u4ee3\u7801";
            this.getView().setEnable(Boolean.FALSE, editIndex, new String[]{"invoicecode"});
        } else {
            this.getView().setEnable(Boolean.TRUE, editIndex, new String[]{"invoicecode"});
        }
        boolean flag = true;
        for (Object object : objectArray = new Object[]{invoiceType, invoiceCode, invoiceNo, issueTime, invoiceAmount, totalTax}) {
            if (!StringUtils.isBlank((Object)object)) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.getModel().setValue("totalamount", (Object)invoiceAmount.add(totalTax), editIndex);
        }
    }

    private boolean dealCheckInvoiceIsExist(String invoiceNo) {
        int count = 0;
        DynamicObjectCollection invoiceItemCollection = this.getView().getModel().getEntryEntity("invoice_entryentity");
        for (DynamicObject invoiceItem : invoiceItemCollection) {
            if (!StringUtils.isNotBlank((CharSequence)invoiceNo) || !invoiceNo.equals(invoiceItem.getString("invoiceno"))) continue;
            ++count;
        }
        return count > 1;
    }

    private String trimEndZero(Object num) {
        if (null == num || StringUtils.isEmpty((CharSequence)num.toString())) {
            return "";
        }
        BigDecimal result = new BigDecimal(num.toString()).stripTrailingZeros();
        return result.toPlainString();
    }

    private boolean checkInvoiceNo(String name, String invoiceNo) {
        if ("invoiceno".equals(name) && !RegexUtil.isAllElectricInvoiceNo((String)invoiceNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u7535\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u516520\u4f4d\u6570\u5b57", (String)"SimFillInInvoicePlugin_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkInvoiceCodeAndNo(String name, String invoiceCode, String invoiceNo, String invoiceType) {
        if ("invoiceno".equals(name) && !RegexUtil.isInvoiceNo((String)invoiceNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u51658\u4f4d\u6570\u5b57", (String)"SimFillInInvoicePlugin_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return true;
        }
        if ("invoicecode".equals(name)) {
            if (("028".equals(invoiceType) || "026".equals(invoiceType)) && !RegexUtil.isEtcInvoiceCode((String)invoiceCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u7968\u53d1\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u516512\u4f4d\u6570\u5b57", (String)"SimFillInInvoicePlugin_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return true;
            }
            if (("004".equals(invoiceType) || "007".equals(invoiceType)) && !RegexUtil.isPaperInvoiceCode((String)invoiceCode)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7eb8\u7968\u53d1\u7968\u53f7\u7801\u53ea\u5141\u8bb8\u8f93\u516510\u4f4d\u6570\u5b57", (String)"SimFillInInvoicePlugin_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("invoiceno".equals(key) || "invoicecode".equals(key)) {
            this.openVatInvoiceListView();
        }
    }

    private void openVatInvoiceListView() {
        QFilter qFilter1 = new QFilter("orgid", "=", this.getOrgId()).and("invoicestatus", "in", (Object)InvoiceStatus.NormalStatusArray);
        String invoiceType = (String)this.getModel().getValue("invoicetype");
        if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
            if (InvoiceUtils.isNormalInvoice((String)invoiceType)) {
                qFilter1.and("invoicetype", "in", (Object)InvoiceUtils.getNormalInvoiceType());
            } else if (InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                qFilter1.and("invoicetype", "in", (Object)InvoiceUtils.getSpecialInvoiceType());
            } else if (InvoiceUtils.isAllEInvoice((Object)invoiceType)) {
                qFilter1.and("invoicetype", "in", (Object)InvoiceUtils.getAllEInvoiceType());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53d1\u7968\u7c7b\u578b, \u8bf7\u624b\u5de5\u8f93\u5165", (String)"SimBillCenterFillInFormPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return;
            }
        }
        ViewUtil.openListPage((AbstractFormPlugin)this, (QFilter)qFilter1, (String)"sim_vatinvoice", (String)"invoicechoose", (boolean)true, (boolean)true, null);
    }

    private Set<String> getNotUsedInvoiceNoList(int editIndex) {
        DynamicObject[] originalBillObjects;
        DynamicObject[] billCenterObjects;
        DynamicObject[] billRelateInvoices;
        long startTime = System.currentTimeMillis();
        LOGGER.info("getNotUsedInvoiceNoList, \u5f00\u59cb\u65f6\u95f4:{}", (Object)startTime);
        HashSet<String> invoiceNoSet = new HashSet<String>(16);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("invoice_entryentity");
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            DynamicObject invoiceObject = (DynamicObject)dynamicObjectCollection.get(i);
            String invoiceNo = invoiceObject.getString("invoiceno");
            if (editIndex == i) continue;
            invoiceNoSet.add(invoiceNo);
        }
        String selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_bill_add_invoice", (boolean)false);
        QFilter relateQFilter = new QFilter("org", "=", this.getOrgId()).and("createtime", ">=", (Object)DateUtils.addMonth((Date)new Date(), (int)-2)).and(BillHelper.notCancelFilter());
        for (DynamicObject dynamicObject : billRelateInvoices = BusinessDataServiceHelper.load((String)"sim_bill_add_invoice", (String)selectProperties, (QFilter[])relateQFilter.toArray())) {
            String invoiceNo = dynamicObject.getString("invoiceno");
            if (!StringUtils.isNotBlank((CharSequence)invoiceNo)) continue;
            invoiceNoSet.add(invoiceNo);
        }
        selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_isomerism_bill_data", (boolean)true);
        ArrayList<String> invoiceStatusList = new ArrayList<String>(2);
        invoiceStatusList.add("1");
        invoiceStatusList.add("2");
        QFilter billCenterFilter = new QFilter("org", "=", this.getOrgId()).and("invoice_status", "in", invoiceStatusList);
        for (DynamicObject dynamicObject : billCenterObjects = BusinessDataServiceHelper.load((String)"sim_isomerism_bill_data", (String)selectProperties, (QFilter[])billCenterFilter.toArray())) {
            boolean flag = this.dealCheckNoFillBillDataMethod(dynamicObject);
            if (!flag) continue;
            DynamicObjectCollection invoiceObjectCollection = dynamicObject.getDynamicObjectCollection("invoice");
            for (DynamicObject invoiceObject : invoiceObjectCollection) {
                String invoiceNo = invoiceObject.getString("invoiceno");
                if (!StringUtils.isNotBlank((CharSequence)invoiceNo)) continue;
                invoiceNoSet.add(invoiceNo);
            }
        }
        selectProperties = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_original_bill", (boolean)true);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        arrayList.add("6");
        arrayList.add("1");
        QFilter originalFilter = new QFilter("orgid", "=", this.getOrgId()).and("validstate", "=", (Object)"2").and("billsource", "in", arrayList);
        for (DynamicObject originalBill : originalBillObjects = BusinessDataServiceHelper.load((String)"sim_original_bill", (String)selectProperties, (QFilter[])originalFilter.toArray())) {
            String invoiceNo = originalBill.getString("invoiceno");
            if (!StringUtils.isNotBlank((CharSequence)invoiceNo)) continue;
            invoiceNoSet.add(invoiceNo);
        }
        LOGGER.info("getNotUsedInvoiceNoList, \u6d88\u8017\u7684\u65f6\u95f4:{}", (Object)(System.currentTimeMillis() - startTime));
        return invoiceNoSet;
    }

    private boolean dealCheckNoFillBillDataMethod(DynamicObject dynamicObject) {
        HashSet hashSet;
        ArrayList billDds;
        DynamicObject[] originalBillList;
        String fillInStatus = dynamicObject.getString("fill_in_status");
        if ("1".equals(fillInStatus)) {
            return true;
        }
        String giftStatus = dynamicObject.getString("giftstatus");
        String giftNo = dynamicObject.getString("giftbillno");
        if (StringUtils.isNotBlank((CharSequence)giftNo) && "2".equals(giftStatus)) {
            return true;
        }
        Long billCenterId = dynamicObject.getLong("id");
        Long[] longIds = new Long[]{billCenterId};
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"sim_isomerism_bill_data", (Long[])longIds);
        return targetBills != null && targetBills.size() > 0 && (originalBillList = BusinessDataServiceHelper.load((Object[])(billDds = new ArrayList(hashSet = (HashSet)targetBills.get("sim_original_bill"))).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sim_original_bill"))) != null && originalBillList.length > 0;
    }

    private Object getOrgId() {
        Long orgId = RequestContext.get().getOrgId();
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        if (customParamsMap.containsKey("orgId")) {
            orgId = customParamsMap.get("orgId");
        }
        return orgId;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("invoicechoose".equals(actionId)) {
            if (null == returnData) {
                String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff01", (String)"SimFillInInvoicePlugin_6", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            ListSelectedRowCollection selectedRowCollection = (ListSelectedRowCollection)returnData;
            if (null == selectedRowCollection) {
                String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff01", (String)"SimFillInInvoicePlugin_6", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            QFilter invoiceFilter = new QFilter("id", "in", (Object)selectedRowCollection.getPrimaryKeyValues());
            DynamicObjectCollection invoiceCollection = QueryServiceHelper.query((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false), (QFilter[])invoiceFilter.toArray());
            if (null == invoiceCollection || invoiceCollection.isEmpty()) {
                String errorMsg = ResManager.loadKDString((String)"\u6240\u9009\u62e9\u7684\u53d1\u7968\u6570\u636e\u4e3a\u7a7a\uff01", (String)"SimFillInInvoicePlugin_6", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            Set<String> invoiceNoSet = this.getNotUsedInvoiceNoList(-1);
            for (DynamicObject invoiceObject : invoiceCollection) {
                String invoiceNo = invoiceObject.getString("invoiceno");
                if (!invoiceNoSet.contains(invoiceNo)) continue;
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u62e9\u7684\u53d1\u7968\u53f7\u7801\uff1a%s\u4e0d\u7b26\u5408\u6761\u4ef6,\u4e0d\u5141\u8bb8\u589e\u52a0\u5230\u5206\u5f55\u91cc\u9762", (String)"SimFillInInvoicePlugin_24", (String)"imc-sim-webapi", (Object[])new Object[0]), invoiceNo);
                this.getView().showErrorNotification(errorMsg);
                return;
            }
            this.setChooseInvoiceForEditByInvoice(invoiceCollection);
        }
    }

    private String dealCheckBillAndInvoiceMethod(DynamicObjectCollection invoiceCollection) {
        String tipMsg = null;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fillInBillType = (String)customParams.get("fillInBillType");
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (DynamicObject invoiceObject : invoiceCollection) {
            totalAmount = totalAmount.add(invoiceObject.getBigDecimal("totalamount"));
        }
        if (totalAmount.compareTo(BigDecimal.ZERO) > 0 && "Negative".equals(fillInBillType)) {
            tipMsg = ResManager.loadKDString((String)"\u5355\u636e\u5408\u8ba1\u4e3a\u8d1f\uff0c\u56de\u586b\u7684\u53d1\u7968\u603b\u91d1\u989d\u5fc5\u987b\u4e3a\u8d1f", (String)"SimFillInInvoicePlugin_7", (String)"imc-sim-webapi", (Object[])new Object[0]);
        } else if (totalAmount.compareTo(BigDecimal.ZERO) < 0 && "Positive".equals(fillInBillType)) {
            tipMsg = ResManager.loadKDString((String)"\u5355\u636e\u5408\u8ba1\u4e3a\u6b63\uff0c\u56de\u586b\u7684\u53d1\u7968\u603b\u91d1\u989d\u5fc5\u987b\u4e3a\u6b63", (String)"SimFillInInvoicePlugin_8", (String)"imc-sim-webapi", (Object[])new Object[0]);
        } else if ("Zerotive".equals(fillInBillType) && totalAmount.compareTo(BigDecimal.ZERO) != 0) {
            tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u5408\u8ba1\u91d1\u989d\u4e3a0\u65f6\uff0c\u56de\u586b\u7684\u53d1\u7968\u603b\u91d1\u989d\u5fc5\u987b\u4e3a0", (String)"SimFillInInvoicePlugin_20", (String)"imc-sim-webapi", (Object[])new Object[0]);
        }
        return tipMsg;
    }

    private void setChooseInvoiceForEditByInvoice(DynamicObjectCollection invoiceCollection) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("invoice_entryentity");
        if (dynamicObjectCollection != null) {
            for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
                String invoiceNo = dynamicObject.getString("invoiceno");
                if (!StringUtils.isBlank((CharSequence)invoiceNo)) continue;
                this.getView().getModel().deleteEntryRow("invoice_entryentity", i);
            }
        }
        this.getView().getModel().beginInit();
        for (DynamicObject invoiceObject : invoiceCollection) {
            int row = this.getView().getModel().createNewEntryRow("invoice_entryentity");
            String invoiceCode = invoiceObject.getString("invoicecode");
            String invoiceNo = invoiceObject.getString("invoiceno");
            this.getModel().setValue("invoicetype", invoiceObject.get("invoicetype"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoicetype"});
            this.getModel().setValue("invoicecode", (Object)invoiceCode, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoicecode"});
            this.getModel().setValue("invoiceno", (Object)invoiceNo, row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoiceno"});
            this.getModel().setValue("issuetime", invoiceObject.get("issuetime"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"issuetime"});
            this.getModel().setValue("invoiceamount", invoiceObject.get("invoiceamount"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"invoiceamount"});
            this.getModel().setValue("totaltax", invoiceObject.get("totaltax"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"totaltax"});
            this.getModel().setValue("totalamount", invoiceObject.get("totalamount"), row);
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"totalamount"});
        }
        this.getView().getModel().endInit();
        this.getView().updateView("invoice_entryentity");
    }
}

