/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.util.ViewUtil;
import kd.imc.sim.billcenter.BillCenterInvoiceLogService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import org.apache.commons.lang3.StringUtils;

public class SimBillLogListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(SimBillLogListPlugin.class);

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageData = e.getPageData();
        for (DynamicObject data : pageData) {
            DynamicObject billLogObject = BillCenterInvoiceLogService.loadSingle((Object)data.getPkValue());
            String innerParamTag = billLogObject.getString("inner_param_tag");
            String outterParamTag = billLogObject.getString("outter_param_tag");
            data.set("inner_param", (Object)innerParamTag);
            data.set("outter_param", (Object)outterParamTag);
        }
        e.setPageData(pageData);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("push_callback_status".equals(operateKey)) {
            this.dealPushCallBackStatusToFrontSystem(afterDoOperationEventArgs);
        } else if ("push_bill_status".equals(operateKey)) {
            this.dealOpenPushBillStatusMethod();
        }
    }

    private void dealOpenPushBillStatusMethod() {
        ViewUtil.openDialog((AbstractFormPlugin)this, (String)ResManager.loadKDString((String)"\u83b7\u53d6\u8d26\u5355\u6570\u636e", (String)"SimBillLogListPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]), null, (String)"sim_push_status_condition", null);
    }

    private void dealPushCallBackStatusToFrontSystem(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateType;
        String billNo;
        String innerParam;
        String systemCode;
        Donothing donothing = (Donothing)afterDoOperationEventArgs.getSource();
        ListSelectedRow listSelectedRow = donothing.getListFocusRow();
        Long pkId = (Long)listSelectedRow.getPrimaryKeyValue();
        DynamicObject dynamicObject = BillCenterInvoiceLogService.loadSingle((Object)pkId);
        if (dynamicObject != null) {
            systemCode = dynamicObject.getString("system_code");
            innerParam = dynamicObject.getString("inner_param_tag");
            billNo = dynamicObject.getString("billno");
            operateType = dynamicObject.getString("operate_type");
            if ("1".equals(operateType)) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u8bb0\u5f55\u4e0d\u5c5e\u4e8e\u7ed3\u679c\u72b6\u6001\u56de\u4f20\u5904\u7406\u7684\u6570\u636e\uff01", (String)"SimBillLogListPlugin_3", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(errorMsg);
            }
            if (StringUtils.isEmpty((CharSequence)systemCode) || StringUtils.isEmpty((CharSequence)innerParam) || StringUtils.isEmpty((CharSequence)billNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u65e5\u5fd7\u6570\u636e\u7cfb\u7edf\u7f16\u7801\u3001\u8ba2\u5355\u53f7\u3001\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01", (String)"SimBillLogListPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u65e5\u5fd7\u6570\u636e\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01", (String)"SimBillLogListPlugin_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("systemCode", (Object)systemCode);
        jsonObject.put("innerParam", (Object)innerParam);
        jsonObject.put("billNo", (Object)billNo);
        jsonObject.put("opType", (Object)operateType);
        logger.info("dealPushCallBackStatusToFrontSystem, \u624b\u5de5\u63a8\u9001\u56de\u8c03\u901a\u77e5\u7684\u8bf7\u6c42\u53c2\u6570:{}", (Object)SerializationUtils.toJsonString((Object)jsonObject));
        ExternalSystemDataHandler.dealPushCallBackStatusToFrontSystem((JSONObject)jsonObject);
    }
}

