/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.billcenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.billcenter.BillCenterOrgMappingService;
import kd.imc.sim.billcenter.sys.ExternalSystemDataHandler;
import kd.imc.sim.common.constant.BillCenterSystemEnum;
import kd.imc.sim.common.model.billcenter.BillErrorVo;
import kd.imc.sim.common.model.billcenter.BillWarnVo;
import kd.imc.sim.formplugin.billcenter.SimCommonGetDataLogic;
import org.apache.commons.lang3.StringUtils;

public class SimPopBoxGetBillDataPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static Log logger = LogFactory.getLog(SimPopBoxGetBillDataPlugin.class);
    private String[] fields = new String[]{"bill_no", "date", "syjh", "fphm", "location", "phone_no", "block_code", "sub_bill_no", "daokong_order_no", "daokong_area_code", "daokong_order_source"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        this.addBeforeAndAfterF7SelectListener("front_system");
    }

    private void addBeforeAndAfterF7SelectListener(String ... keys) {
        for (String key : keys) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(key);
            if (null == basedataEdit) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            basedataEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("front_system".equals(fieldKey)) {
            QFilter qFilter = new QFilter("number", "!=", (Object)"DaoKong");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent event) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = RequestContext.get().getCurrUserId();
        String value = CacheHelper.get((String)String.valueOf(userId));
        logger.info("afterCreateNewData, value:{}", (Object)value);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.initGetBillDataView();
        } else {
            BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
            String[] array = value.split(",");
            String systemCode = array[0];
            QFilter qFilter2 = new QFilter("number", "=", (Object)systemCode);
            DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingle(qFilter2);
            if (frontSystemObject != null) {
                this.getView().getModel().setValue("front_system", (Object)frontSystemObject);
                boolean flag = this.dealCheckIsHeroGourmet(systemCode);
                boolean isDaoKong = this.dealCheckIsDaoKong(systemCode);
                if (flag) {
                    if (array.length == 3) {
                        String dateStr = array[1];
                        String location = array[2];
                        this.getModel().setValue("date", (Object)DateUtils.stringToDate((String)dateStr));
                        this.getModel().setValue("location", (Object)location);
                    } else {
                        this.getModel().setValue("date", (Object)new Date());
                    }
                } else if (isDaoKong) {
                    this.getView().getModel().setValue("daokong_area_code", (Object)this.getDaoKongAreaCodeMethod(systemCode));
                    this.getView().setEnable(Boolean.FALSE, new String[]{"daokong_area_code"});
                }
            }
        }
    }

    private void initGetBillDataView() {
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        long orgId = RequestContext.get().getOrgId();
        QFilter qFilter = new QFilter("target_org_id", "=", (Object)orgId);
        DynamicObject targetOrgMappingObject = billCenterOrgMappingService.loadSingleTargetOrgMapping(qFilter);
        if (targetOrgMappingObject != null) {
            String system_code = targetOrgMappingObject.getString("system_code");
            String source_org_code = targetOrgMappingObject.getString("number");
            String source_org_name = targetOrgMappingObject.getString("name");
            logger.info("SimPopBoxGetBillDataPlugin, system_code:{}, source_org_code:{}, source_org_name:{}", new Object[]{system_code, source_org_code, source_org_name});
            QFilter qFilter2 = new QFilter("number", "=", (Object)system_code);
            DynamicObject frontSystemObject = billCenterOrgMappingService.loadSingle(qFilter2);
            if (frontSystemObject != null) {
                this.getView().getModel().setValue("front_system", (Object)frontSystemObject);
                this.dealSaveDataToCacheMethod(system_code);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject frontSystem = (DynamicObject)this.getModel().getValue("front_system");
        if (frontSystem == null) {
            this.hideField();
            return;
        }
        String systemCode = frontSystem.getString("number");
        this.displayField(systemCode);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if ("btnok".equals(source.getKey())) {
            DynamicObject frontSystemObject = (DynamicObject)this.getModel().getValue("front_system");
            if (frontSystemObject == null) {
                this.getView().getParentView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7cfb\u7edf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"SimPopBoxGetBillDataPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
                return;
            }
            String systemCode = frontSystemObject.getString("number");
            StringBuilder builder = new StringBuilder();
            JSONObject paramContent = this.getParamContentBySystem(systemCode, builder);
            if (StringUtils.isNotEmpty((CharSequence)builder.toString())) {
                this.getView().showErrorNotification(builder.toString());
                return;
            }
            JSONObject paramObject = new JSONObject();
            SimCommonGetDataLogic simCommonGetDataLogic = new SimCommonGetDataLogic();
            systemCode = simCommonGetDataLogic.dealSpecialSystemCodeMethod(systemCode);
            paramObject.put("systemCode", (Object)systemCode);
            paramObject.put("paramContent", (Object)paramContent);
            logger.info("\u624b\u5de5\u53d1\u8d77\u62c9\u5355\uff0c\u8bf7\u6c42\u53c2\u6570\u662f:{}", (Object)SerializationUtils.toJsonString((Object)paramObject));
            List applyBillList = ExternalSystemDataHandler.getExternalSystemData((JSONObject)paramObject);
            logger.info("\u8fd4\u56de\u7ed3\u679c\u5185\u5bb9\uff0c\u5bf9\u8c61\u5927\u5c0f\u662f\uff1a{}", (Object)applyBillList.size());
            String block_code = (String)this.getModel().getValue("block_code");
            if (StringUtils.isNotEmpty((CharSequence)block_code)) {
                String tipMsg = ResManager.loadKDString((String)"\u6b63\u5728\u540c\u6b65\u4f1a\u8bae\u56e2\u8ba2\u5355\u6570\u636e\uff0c\u7a0d\u5019\u53ef\u5728\u8d26\u5355\u4e2d\u5fc3\u6570\u636e\u2014\u2014\u300b\u7cfb\u7edf\u4ea4\u4e92\u65e5\u5fd7\u83dc\u5355\u4e2d\u67e5\u770b\u540c\u6b65\u7ed3\u679c\uff01", (String)"SimPopBoxGetBillDataPlugin_11", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showSuccessNotification(tipMsg);
                return;
            }
            if (applyBillList == null || applyBillList.isEmpty()) {
                String tipMsg = ResManager.loadKDString((String)"\u672a\u67e5\u5230\u5f85\u5f00\u7968\u6570\u636e\uff01", (String)"SimPopBoxGetBillDataPlugin_12", (String)"imc-sim-webapi", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipMsg);
            } else {
                this.dealGetDataResultMethod(applyBillList);
            }
        }
    }

    private void dealGetDataResultMethod(List<BillVo> applyBillList) {
        String tipMsg;
        Object tipMsg2;
        int successNum = 0;
        int failNum = 0;
        int warnNum = 0;
        ArrayList<BillErrorVo> errorArray = new ArrayList<BillErrorVo>(applyBillList.size());
        ArrayList<BillWarnVo> warnArray = new ArrayList<BillWarnVo>(applyBillList.size());
        for (BillVo billVo : applyBillList) {
            if (billVo instanceof BillErrorVo) {
                BillErrorVo billErrorVo = (BillErrorVo)billVo;
                if (billErrorVo != null) {
                    successNum += billErrorVo.getSuccessNum();
                    failNum += billErrorVo.getFailNum();
                }
                logger.error("\u6253\u5370\u9519\u8bef\u5185\u5bb9\uff1a{}", (Object)billErrorVo.getErrorMsg());
                if (!StringUtils.isNotEmpty((CharSequence)billErrorVo.getErrorMsg())) continue;
                errorArray.add(billErrorVo);
                continue;
            }
            if (billVo instanceof BillWarnVo) {
                BillWarnVo billWarnVo = (BillWarnVo)billVo;
                if (billWarnVo != null) {
                    warnNum += billWarnVo.getWarnNum();
                }
                logger.error("\u6253\u5370\u8b66\u544a\u5185\u5bb9\uff1a{}", (Object)billWarnVo.getWarnMsg());
                if (!StringUtils.isNotEmpty((CharSequence)billWarnVo.getWarnMsg())) continue;
                warnArray.add(billWarnVo);
                continue;
            }
            logger.info("\u62c9\u53d6\u5230\u6210\u529f\u7684\u8ba2\u5355\u6570\u636e\uff01");
            ++successNum;
        }
        logger.info("\u62c9\u53d6\u8ba2\u5355\u6210\u529f\u7684\u6570\u91cf\u662f:{}\uff0c \u5931\u8d25\u7684\u6570\u91cf\u662f:{}", (Object)successNum, (Object)failNum);
        if (successNum > 0 && failNum == 0) {
            tipMsg2 = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u6210\u529f\u6570\u91cf\u662f\uff1a%1$s", (String)"SimPopBoxGetBillDataPlugin_10", (String)"imc-sim-webapi", (Object[])new Object[0]), successNum);
            this.getView().showSuccessNotification((String)tipMsg2);
        } else if (successNum == 0 && failNum > 0) {
            for (BillErrorVo billErrorVo : errorArray) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u5931\u8d25\u6570\u91cf\u662f\uff1a%1$s\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%2$s", (String)"SimPopBoxGetBillDataPlugin_20", (String)"imc-sim-webapi", (Object[])new Object[0]), failNum, billErrorVo.getErrorMsg());
                this.getView().showErrorNotification(tipMsg);
            }
        } else if (successNum > 0 && failNum > 0) {
            tipMsg2 = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u6210\u529f\u6570\u91cf\u662f\uff1a%1$s\uff0c\u5931\u8d25\u6570\u91cf\u662f\uff1a%2$s", (String)"SimPopBoxGetBillDataPlugin_21", (String)"imc-sim-webapi", (Object[])new Object[0]), successNum, failNum);
            this.getView().showTipNotification((String)tipMsg2);
        } else if (warnNum > 0) {
            for (BillWarnVo billWarnVo : warnArray) {
                tipMsg = String.format(ResManager.loadKDString((String)"\u62c9\u53d6\u8ba2\u5355\u5904\u7406\uff0c\u6570\u91cf\u662f\uff1a%1$s\uff0c\u8b66\u544a\u5185\u5bb9\uff1a%2$s", (String)"SimPopBoxGetBillDataPlugin_22", (String)"imc-sim-webapi", (Object[])new Object[0]), warnNum, billWarnVo.getWarnMsg());
                this.getView().showTipNotification(tipMsg);
            }
        } else {
            String errorMsg = ResManager.loadKDString((String)"\u6682\u672a\u5339\u914d\u5230\u76f8\u5173\u7684\u8ba2\u5355\u6570\u636e\uff01", (String)"SimPopBoxGetBillDataPlugin_23", (String)"imc-sim-webapi", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMsg);
        }
    }

    private JSONObject getParamContentBySystem(String systemCode, StringBuilder builder) {
        JSONObject jsonObject = StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_OPERA_GZCLXJH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CHIMEL.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PANDAH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_HQBH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_YH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_MSH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_QYH.getCode()}) ? this.getParamContentByOpera(builder) : (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_FU_SHI_IMAGE.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_GZPK.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_ZHPK.getCode(), BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode(), BillCenterSystemEnum.SYSTEM_NEW_GZPWN.getCode(), BillCenterSystemEnum.SYSTEM_NEW_ZHPWN.getCode()}) ? this.getParamContentByJieShun(builder) : (StringUtils.equalsIgnoreCase((CharSequence)systemCode, (CharSequence)BillCenterSystemEnum.SYSTEM_CENTER_ELECTRONICS_9999.getCode()) ? this.getParamContentBy9999(builder) : (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode()}) ? this.getParamContentByGala(builder) : (StringUtils.equalsIgnoreCase((CharSequence)systemCode, (CharSequence)BillCenterSystemEnum.SYSTEM_FU_JI.getCode()) ? this.getParamContentByFuJi(builder) : (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_HERO_GZCLXJH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_PANDAH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_MSH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_QYCLGC1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CHIMEL1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_HQBH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_PH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CH1.getCode()}) ? this.getParamContentByHeroGourmet(builder) : (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG_GZ.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_ZH.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_QY.getCode()}) ? this.getParamContentByDaoKong(builder) : new JSONObject()))))));
        return jsonObject;
    }

    private JSONObject getParamContentByDaoKong(StringBuilder builder) {
        String daokong_order_no = (String)this.getModel().getValue("daokong_order_no");
        String daokong_area_code = (String)this.getModel().getValue("daokong_area_code");
        String daokong_order_source = (String)this.getModel().getValue("daokong_order_source");
        if (StringUtils.isBlank((CharSequence)daokong_area_code) || StringUtils.isBlank((CharSequence)daokong_order_no) || StringUtils.isBlank((CharSequence)daokong_order_source)) {
            String tipMsg = ResManager.loadKDString((String)"\u9053\u63a7\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"SimPopBoxGetBillDataPlugin_27", (String)"imc-sim-webapi", (Object[])new Object[0]);
            builder.append(tipMsg).append("\r\n");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("opKey", (Object)"PC");
        JSONArray jsonArray = new JSONArray();
        JSONObject subObject = new JSONObject();
        subObject.put("OrderNO", (Object)daokong_order_no);
        subObject.put("DistrictCode", (Object)daokong_area_code);
        subObject.put("OrderSource", (Object)daokong_order_source);
        jsonArray.add((Object)subObject);
        jsonObject.put("billNo", (Object)SerializationUtils.toJsonString((Object)jsonArray));
        return jsonObject;
    }

    private JSONObject getParamContentByHeroGourmet(StringBuilder builder) {
        String[] array;
        long userId;
        String value;
        String billNo = (String)this.getModel().getValue("bill_no");
        Date date = (Date)this.getModel().getValue("date");
        String location = (String)this.getModel().getValue("location");
        if (StringUtils.isEmpty((CharSequence)location) && StringUtils.isNotEmpty((CharSequence)(value = CacheHelper.get((String)String.valueOf(userId = RequestContext.get().getCurrUserId())))) && (array = value.split(",")).length == 3) {
            location = array[2];
        }
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            String tipMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d26\u5355\u7f16\u53f7\uff01", (String)"SimPopBoxGetBillDataPlugin_5", (String)"imc-sim-webapi", (Object[])new Object[0]);
            builder.append(tipMsg).append("\r\n");
        }
        if (date == null) {
            String tipMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8ba2\u5355\u65e5\u671f\uff01", (String)"SimPopBoxGetBillDataPlugin_7", (String)"imc-sim-webapi", (Object[])new Object[0]);
            builder.append(tipMsg).append("\r\n");
        }
        if (StringUtils.isEmpty((CharSequence)location)) {
            String tipMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9152\u9910\u8425\u4e1a\u5385\u4ee3\u7801\uff01", (String)"SimPopBoxGetBillDataPlugin_14", (String)"imc-sim-webapi", (Object[])new Object[0]);
            builder.append(tipMsg).append("\r\n");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("location", (Object)location);
        jsonObject.put("businessDate", (Object)DateUtils.format((Date)date, (String)"yyyy-MM-dd"));
        jsonObject.put("checkNumber", (Object)billNo);
        jsonObject.put("opKey", (Object)"PC");
        return jsonObject;
    }

    private JSONObject getParamContentByFuJi(StringBuilder builder) {
        String syjh = (String)this.getModel().getValue("syjh");
        String fphm = (String)this.getModel().getValue("fphm");
        if (StringUtils.isEmpty((CharSequence)syjh)) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6536\u94f6\u673a\u53f7\uff01", (String)"SimPopBoxGetBillDataPlugin_8", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        }
        if (StringUtils.isEmpty((CharSequence)fphm)) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5c0f\u7968\u53f7\u7801\uff01", (String)"SimPopBoxGetBillDataPlugin_9", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("SYJH", (Object)syjh);
        jsonObject.put("FPHM", (Object)fphm);
        jsonObject.put("opKey", (Object)"PC");
        return jsonObject;
    }

    private JSONObject getParamContentByGala(StringBuilder builder) {
        String billNo = (String)this.getModel().getValue("bill_no");
        Date date = (Date)this.getModel().getValue("date");
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d26\u5355\u7f16\u53f7\uff01", (String)"SimPopBoxGetBillDataPlugin_5", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        }
        if (date == null) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8ba2\u5355\u65e5\u671f\uff01", (String)"SimPopBoxGetBillDataPlugin_7", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("codeNo", (Object)billNo);
        jsonObject.put("date", (Object)DateUtils.format((Date)date, (String)"yyyy-MM-dd"));
        jsonObject.put("opKey", (Object)"PC");
        return jsonObject;
    }

    private JSONObject getParamContentByJieShun(StringBuilder builder) {
        String billNo = (String)this.getModel().getValue("bill_no");
        if (StringUtils.isEmpty((CharSequence)billNo)) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d26\u5355\u7f16\u53f7\uff01", (String)"SimPopBoxGetBillDataPlugin_5", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("billNo", (Object)billNo);
        jsonObject.put("opKey", (Object)"PC");
        return jsonObject;
    }

    private JSONObject getParamContentByOpera(StringBuilder builder) {
        String billNo = (String)this.getModel().getValue("bill_no");
        String phoneNo = (String)this.getModel().getValue("phone_no");
        String blockCode = (String)this.getModel().getValue("block_code");
        if (StringUtils.isEmpty((CharSequence)billNo) && StringUtils.isEmpty((CharSequence)phoneNo) && StringUtils.isEmpty((CharSequence)blockCode)) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7\u7801\u6216\u8d26\u5355\u7f16\u53f7\u6216\u4f1a\u8bae\u56e2\u53f7\uff01", (String)"SimPopBoxGetBillDataPlugin_13", (String)"imc-sim-webapi", (Object[])new Object[0]);
            builder.append(errorMsg);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("billNo", (Object)billNo);
        jsonObject.put("phoneNumber", (Object)phoneNo);
        jsonObject.put("opKey", (Object)"PC");
        Date date = (Date)this.getModel().getValue("date");
        jsonObject.put("date", (Object)DateUtils.format((Date)date, (String)"yyyy-MM-dd"));
        if (StringUtils.isNotEmpty((CharSequence)blockCode)) {
            jsonObject.put("blockCode", (Object)blockCode);
            jsonObject.put("opKey", (Object)"PC_BLOCK");
        }
        return jsonObject;
    }

    private JSONObject getParamContentBy9999(StringBuilder builder) {
        JSONObject subObject;
        JSONArray jsonArray;
        JSONObject jsonObject = new JSONObject();
        String billNoStr = (String)this.getModel().getValue("bill_no");
        String subBillNoStr = (String)this.getModel().getValue("sub_bill_no");
        if (StringUtils.isEmpty((CharSequence)billNoStr) && StringUtils.isEmpty((CharSequence)subBillNoStr)) {
            builder.append(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8d26\u5355\u7f16\u53f7\u6216\u5b50\u8d26\u5355\u7f16\u53f7\uff01", (String)"SimPopBoxGetBillDataPlugin_6", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        } else if (StringUtils.isNotEmpty((CharSequence)billNoStr) && StringUtils.isNotEmpty((CharSequence)subBillNoStr)) {
            builder.append(ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7\u6216\u5b50\u8d26\u5355\u7f16\u53f7\uff0c\u53ea\u80fd\u591f\u8f93\u5165\u5176\u4e2d\u4e00\u4e2a\u53c2\u6570\uff01", (String)"SimPopBoxGetBillDataPlugin_25", (String)"imc-sim-webapi", (Object[])new Object[0])).append("\r\n");
        }
        if (StringUtils.isNotEmpty((CharSequence)billNoStr)) {
            String[] billNos;
            jsonArray = new JSONArray();
            for (String billNo : billNos = billNoStr.split(";")) {
                subObject = new JSONObject();
                subObject.put("billNo", (Object)billNo);
                jsonArray.add((Object)subObject);
            }
            jsonObject.put("billNoList", (Object)jsonArray);
        }
        if (StringUtils.isNotEmpty((CharSequence)subBillNoStr)) {
            String[] subBillNos;
            jsonArray = new JSONArray();
            for (String subBillNo : subBillNos = subBillNoStr.split(";")) {
                subObject = new JSONObject();
                subObject.put("subBillNo", (Object)subBillNo);
                jsonArray.add((Object)subObject);
            }
            jsonObject.put("subBillNoList", (Object)jsonArray);
        }
        jsonObject.put("opKey", (Object)"PC");
        return jsonObject;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)"front_system", (CharSequence)name)) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject frontSystem = (DynamicObject)changeSet[0].getNewValue();
            if (frontSystem == null) {
                this.hideField();
                return;
            }
            String systemCode = frontSystem.getString("number");
            this.displayField(systemCode);
            this.dealSaveDataToCacheMethod(systemCode);
        } else if (StringUtils.equals((CharSequence)"location", (CharSequence)name)) {
            DynamicObject frontSystem = (DynamicObject)this.getModel().getValue("front_system");
            if (frontSystem == null) {
                String tipMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u6765\u6e90\u4e3a\u7a7a\uff01", (String)"SimPopBoxGetBillDataPlugin_26", (String)"imc-sim-webapi", (Object[])new Object[0]);
                throw new KDBizException(tipMsg);
            }
            String systemCode = frontSystem.getString("number");
            this.dealSaveDataToCacheMethod(systemCode);
        }
    }

    private void dealSaveDataToCacheMethod(String systemCode) {
        long userId = RequestContext.get().getCurrUserId();
        boolean flag = this.dealCheckIsHeroGourmet(systemCode);
        boolean isDaoKong = this.dealCheckIsDaoKong(systemCode);
        StringBuilder stringBuilder = new StringBuilder();
        if (flag) {
            Date date = (Date)this.getModel().getValue("date");
            String location = (String)this.getModel().getValue("location");
            String dateStr = DateUtils.format((Date)date);
            stringBuilder.append(systemCode).append(",").append(dateStr).append(",").append(location);
        } else if (isDaoKong) {
            String daokong_area_code = (String)this.getModel().getValue("daokong_area_code");
            stringBuilder.append(systemCode).append(",").append(daokong_area_code);
        } else {
            stringBuilder.append(systemCode).append(",");
        }
        CacheHelper.put((String)String.valueOf(userId), (String)stringBuilder.toString(), (int)43200);
    }

    private boolean dealCheckIsDaoKong(String systemCode) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_ZH.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_QY.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_GZ.getCode()});
    }

    private boolean dealCheckIsHeroGourmet(String systemCode) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_HERO_GZCLXJH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_PANDAH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_MSH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_QYCLGC1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CHIMEL1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_HQBH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_PH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CH1.getCode()});
    }

    private void displayField(String systemCode) {
        this.hideField();
        String tipMsg = ResManager.loadKDString((String)"\u8d26\u5355\u7f16\u53f7", (String)"SimPopBoxGetBillDataPlugin_15", (String)"imc-sim-webapi", (Object[])new Object[0]);
        String tipMsg2 = ResManager.loadKDString((String)"\u8d26\u5355\u65e5\u671f", (String)"SimPopBoxGetBillDataPlugin_16", (String)"imc-sim-webapi", (Object[])new Object[0]);
        String tipMsg3 = ResManager.loadKDString((String)"\u8f66\u724c\u53f7", (String)"SimPopBoxGetBillDataPlugin_17", (String)"imc-sim-webapi", (Object[])new Object[0]);
        String tipMsg4 = ResManager.loadKDString((String)"\u63d0\u53d6\u7801", (String)"SimPopBoxGetBillDataPlugin_18", (String)"imc-sim-webapi", (Object[])new Object[0]);
        String tipMsg5 = ResManager.loadKDString((String)"\u63d0\u53d6\u7801\u65e5\u671f", (String)"SimPopBoxGetBillDataPlugin_19", (String)"imc-sim-webapi", (Object[])new Object[0]);
        String tipMsg6 = ResManager.loadKDString((String)"\u5b50\u8d26\u5355\u7f16\u53f7", (String)"SimPopBoxGetBillDataPlugin_24", (String)"imc-sim-webapi", (Object[])new Object[0]);
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_OPERA_GZCLXJH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CHIMEL.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PANDAH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_HQBH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_PH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_CH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_YH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_MSH.getCode(), BillCenterSystemEnum.SYSTEM_OPERA_QYH.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"phone_no"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"block_code"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"date"});
            this.updateMetaData("bill_no", tipMsg);
            this.updateMetaData("date", tipMsg2);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_CENTER_ELECTRONICS_9999.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no", "sub_bill_no"});
            this.updateMetaData("bill_no", tipMsg);
            this.updateMetaData("sub_bill_no", tipMsg6);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_FU_SHI_IMAGE.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no"});
            this.updateMetaData("bill_no", tipMsg);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_JIE_SHUN.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_GZPK.getCode(), BillCenterSystemEnum.SYSTEM_JIE_SHUN_ZHPK.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no"});
            this.updateMetaData("bill_no", tipMsg3);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_NEW_TAX.getCode(), BillCenterSystemEnum.SYSTEM_NEW_GZPWN.getCode(), BillCenterSystemEnum.SYSTEM_NEW_ZHPWN.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no"});
            this.updateMetaData("bill_no", tipMsg4);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_GALA_GZPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHPW.getCode(), BillCenterSystemEnum.SYSTEM_GALA_GZCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_ZHCY.getCode(), BillCenterSystemEnum.SYSTEM_GALA_QYCY.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no", "date"});
            this.updateMetaData("bill_no", tipMsg4);
            this.updateMetaData("date", tipMsg5);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_FU_JI.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"syjh", "fphm"});
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_HERO_GZCLXJH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_PANDAH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_MSH1.getCode(), BillCenterSystemEnum.SYSTEM_HERO_QYCLGC1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CHIMEL1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_HQBH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_PH1.getCode(), BillCenterSystemEnum.SYSTEM_GOURMET_CH1.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bill_no", "date", "location"});
            this.getModel().setValue("date", (Object)new Date());
            this.setBillDateValueMethod();
            TreeMap<String, String> itemMap = new TreeMap<String, String>();
            this.dealLoadSourceOrgMethod(systemCode, itemMap);
            SimPopBoxGetBillDataPlugin.setDropDownViewData(this, "location", itemMap);
            this.updateMetaData("bill_no", tipMsg);
            this.updateMetaData("date", tipMsg2);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_GZ.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_ZH.getCode(), BillCenterSystemEnum.SYSTEM_DAO_KONG_QY.getCode()})) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"daokong_order_no", "daokong_area_code", "daokong_order_source"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"daokong_area_code"});
            this.getView().getModel().setValue("daokong_area_code", (Object)this.getDaoKongAreaCodeMethod(systemCode));
        }
    }

    private String getDaoKongAreaCodeMethod(String systemCode) {
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG_GZ.getCode()})) {
            return "2000";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG_ZH.getCode()})) {
            return "3000";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)systemCode, (CharSequence[])new CharSequence[]{BillCenterSystemEnum.SYSTEM_DAO_KONG_QY.getCode()})) {
            return "4000";
        }
        return null;
    }

    private void setBillDateValueMethod() {
        String[] array;
        long userId = RequestContext.get().getCurrUserId();
        String value = CacheHelper.get((String)String.valueOf(userId));
        if (StringUtils.isNotEmpty((CharSequence)value) && (array = value.split(",")).length == 3) {
            String dateStr = array[1];
            this.getModel().setValue("date", (Object)DateUtils.stringToDate((String)dateStr));
        }
    }

    private void updateMetaData(String controlId, String newName) {
        HashMap<String, String> captionMap = new HashMap<String, String>();
        captionMap.put("zh_CN", newName);
        HashMap<String, HashMap<String, String>> metaDataMap = new HashMap<String, HashMap<String, String>>();
        metaDataMap.put("caption", captionMap);
        this.getView().updateControlMetadata(controlId, metaDataMap);
    }

    private void dealLoadSourceOrgMethod(String systemCode, TreeMap<String, String> itemMap) {
        BillCenterOrgMappingService billCenterOrgMappingService = new BillCenterOrgMappingService();
        DynamicObject dynamicObject = billCenterOrgMappingService.loadSingleBySystemCode(systemCode);
        if (dynamicObject != null) {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("system_source_org");
            for (DynamicObject sourceOrgObject : dynamicObjectCollection) {
                String source_org_code = sourceOrgObject.getString("source_org_code");
                String source_org_name = sourceOrgObject.getString("source_org_name");
                itemMap.put(source_org_code, source_org_name);
            }
        }
    }

    public static void setDropDownViewData(AbstractFormPlugin formPlugin, String controlId, TreeMap<String, String> itemMap) {
        ComboEdit comboEdit = (ComboEdit)formPlugin.getControl(controlId);
        ArrayList items2 = Lists.newArrayListWithCapacity((int)itemMap.size());
        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
            String code = entry.getKey();
            String name = entry.getValue();
            ComboItem comboItem = new ComboItem(new LocaleString(name + "/" + code), code);
            items2.add(comboItem);
        }
        formPlugin.getView().setEnable(Boolean.TRUE, new String[]{controlId});
        comboEdit.setComboItems((List)items2);
    }

    private void hideField() {
        this.setFieldNull();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bill_no", "date", "block_code", "syjh", "fphm", "location", "phone_no", "sub_bill_no"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"daokong_order_no", "daokong_area_code", "daokong_order_source"});
    }

    private void setFieldNull() {
        for (String field : this.fields) {
            this.getModel().setValue(field, (Object)"");
        }
    }
}

