/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.helper.DataRepairHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.message.model.MsgResponse;
import kd.imc.bdm.common.util.BigDecimalUtil;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.model.invoice.TaxedTypeEnum;
import kd.imc.sim.common.service.ImcPushInvoiceToIsmcService;
import kd.imc.sim.common.service.InvoiceIsmcSyncToImcService;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.common.service.WideInvoiceSevice;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.formplugin.invoice.helper.RedConfirmAndInvoiceRepairHelper;
import org.apache.commons.collections.CollectionUtils;

public class DataRepairPlugin
extends AbstractFormPlugin {
    private static final String PDF_RECREATE = "0";
    private static final String RECREATE_PAPER_INVOICE = "1";
    private static final String TIME_PERIOD_REPAIR = "2";
    private static final Log LOGGER = LogFactory.getLog(DataRepairPlugin.class);
    private static final String DATA_NOT_FOUNT = "3333";
    private static final int singleQuerySize = 500;

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        String businessType = (String)this.getModel().getValue("businesstype");
        if (RECREATE_PAPER_INVOICE.equals(ImcConfigUtil.getValue((String)"repairtInvoiceFile", (String)"repairtInvoiceFile"))) {
            this.repairInvoiceFile();
            this.getView().showSuccessNotification("repairInvoiceFileSucceess,YouNeedEnterSimVatinvoiceFileRecreateFile");
            return;
        }
        if (StringUtils.isBlank((CharSequence)businessType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b", (String)"DataRepairPlugin_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        switch (businessType) {
            case "0": {
                this.createPdf();
                break;
            }
            case "1": {
                this.createInvoiceFile();
                break;
            }
            case "2": {
                this.queryTimePeriodInvoice(TIME_PERIOD_REPAIR);
                break;
            }
            case "3": {
                this.queryTimePeriodInvoice("3");
                break;
            }
            case "4": {
                this.createAndFileUrl("fileurl");
                break;
            }
            case "5": {
                this.createAndFileUrl("snapshoturl");
                break;
            }
            case "10": {
                this.repairRedConfirm();
                break;
            }
            case "11": {
                this.repairRedInvoiceAndConfirm();
                break;
            }
            case "12": {
                int size = this.setRemainRedAmountFromRedConfirm();
                String tip = String.format(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f%s\u5f20\u7ea2\u5b57\u786e\u8ba4\u5355\u7684\u539f\u84dd\u7968\u5df2\u5f00\u4fe1\u606f", (String)"DataRepairPlugin_19", (String)"imc-sim-webapi", (Object[])new Object[0]), size);
                this.getView().showSuccessNotification(tip);
                break;
            }
            case "permisson": {
                this.permissionTransfer();
                break;
            }
            case "repairinvoiceremainamount": {
                this.repairInvoiceRemainAmount();
            }
        }
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_repair_invoice", (String)"id,orderno", (QFilter[])new QFilter("orderno", "=", (Object)" ").toArray());
        ArrayList<Object> pks = new ArrayList<Object>();
        for (DynamicObject object : array) {
            if (!StringUtils.isBlank((CharSequence)object.getString("orderno"))) continue;
            pks.add(object.getPkValue());
        }
        if (pks.size() > 0) {
            DeleteServiceHelper.delete((String)"sim_repair_invoice", (QFilter[])new QFilter("id", "in", (Object)pks.toArray(new Object[0])).toArray());
        }
    }

    private void repairInvoiceFile() {
        QFilter filter = new QFilter("taxedtype", "=", (Object)TaxedTypeEnum.all_e_deduction.getValue());
        String taxedType = ImcConfigUtil.getValue((String)"repairInvoiceFileTaxedType", (String)"repairInvoiceFileTaxedType");
        if (StringUtils.isNotBlank((CharSequence)taxedType)) {
            String[] array = taxedType.split(",");
            filter = new QFilter("taxedtype", "in", (Object)array);
        }
        Date startDate = DateUtils.stringToDate((String)"2025-02-05", (String)"yyyy-MM-dd");
        filter = filter.and("issuetime", ">=", (Object)startDate).and("issuesource", "=", (Object)"13");
        String fields = PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)false);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(100);
        long maxInvoicePk = 0L;
        for (int i = 0; i < 200; ++i) {
            DynamicObject[] invoices;
            QFilter onceFilter = filter.copy();
            if (maxInvoicePk != 0L) {
                onceFilter.and("id", ">", (Object)maxInvoicePk);
            }
            if ((invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)fields, (QFilter[])onceFilter.toArray(), (String)"id asc", (int)1000)).length == 0) break;
            maxInvoicePk = invoices[invoices.length - 1].getLong("id");
            for (DynamicObject invoice : invoices) {
                BigDecimal deduction = invoice.getBigDecimal("deduction");
                String deductionDescription = "\u6263\u9664\u989d\uff1a%s\u3002".substring(0, 3);
                String remark = invoice.getString("remark");
                if (BigDecimalUtil.compareZero((BigDecimal)deduction) || String.valueOf(remark).contains(deductionDescription)) continue;
                String deducRemark = String.format("\u6263\u9664\u989d\uff1a%s\u3002", deduction.setScale(2, 4).stripTrailingZeros().toPlainString());
                invoice.set("remark", (Object)(deducRemark + (StringUtils.isBlank((CharSequence)remark) ? "" : System.lineSeparator() + remark)));
                updateList.add(invoice);
            }
            if (updateList.size() <= 0) continue;
            ImcSaveServiceHelper.update(updateList);
            ArrayList<String> updateInvoiceNos = new ArrayList<String>();
            ArrayList<DynamicObject> addInvoiceRecords = new ArrayList<DynamicObject>();
            for (DynamicObject invoice : updateList) {
                String invoiceNo = invoice.getString("invoiceno");
                QFilter qFilter = new QFilter("invoiceno", "=", (Object)invoiceNo);
                if (QueryServiceHelper.exists((String)"sim_vatinvoice_file", (QFilter[])qFilter.toArray())) {
                    updateInvoiceNos.add(invoiceNo);
                    continue;
                }
                this.addFileRecord(addInvoiceRecords, invoice, "lqpt");
            }
            if (updateInvoiceNos.size() > 0) {
                DynamicObject[] updateArray;
                QFilter updateFileFilter = new QFilter("invoiceno", "in", updateInvoiceNos);
                for (DynamicObject file : updateArray = BusinessDataServiceHelper.load((String)"sim_vatinvoice_file", (String)"remotefilestatus,localfilestatus", (QFilter[])updateFileFilter.toArray())) {
                    file.set("remotefilestatus", (Object)"-1");
                    file.set("localfilestatus", (Object)"-1");
                }
                ImcSaveServiceHelper.update((DynamicObject[])updateArray);
            }
            if (addInvoiceRecords.size() > 0) {
                ImcSaveServiceHelper.save(addInvoiceRecords);
            }
            updateList.clear();
        }
    }

    private void addFileRecord(List<DynamicObject> addInvoiceRecords, DynamicObject invoice, String issueChannel) {
        String[] fileTypes;
        for (String fileType : fileTypes = new String[]{FileType.XML.getFileExtension(), FileType.OFD.getFileExtension(), FileType.PDF.getFileExtension(), FileType.JPG.getFileExtension()}) {
            DynamicObject invoiceFile = BusinessDataServiceHelper.newDynamicObject((String)"sim_vatinvoice_file");
            invoiceFile.set("salertaxno", (Object)invoice.getString("salertaxno"));
            invoiceFile.set("orderno", (Object)invoice.getString("orderno"));
            invoiceFile.set("invoiceno", (Object)invoice.getString("invoiceno"));
            invoiceFile.set("invoiceid", invoice.getPkValue());
            invoiceFile.set("issuetime", invoice.get("issuetime"));
            invoiceFile.set("issuechannel", (Object)issueChannel);
            invoiceFile.set("filetype", (Object)fileType);
            invoiceFile.set("remotefilestatus", (Object)"-1");
            invoiceFile.set("localfilestatus", (Object)"-1");
            String notUploadS3 = ImcConfigUtil.getValue((String)"invoicefile_config", (String)"not_upload_s3");
            if ("notUploadS3".equals(notUploadS3)) {
                invoiceFile.set("callbacktype", (Object)"local");
            } else {
                invoiceFile.set("callbacktype", (Object)"remote");
            }
            addInvoiceRecords.add(invoiceFile);
        }
    }

    private void permissionTransfer() {
        this.getView().showTipNotification("manualPermissionTransfer");
        Object upgradeResult = DispatchServiceHelper.invokeBizService((String)"imc", (String)"sim", (String)"SimPermissonTransferUpgradeImpl", (String)"afterExecuteSqlWithResult", (Object[])new Object[]{"", "", "", ""});
        this.getView().showSuccessNotification(SerializationUtils.toJsonString((Object)upgradeResult));
    }

    /*
     * Exception decompiling
     */
    private int setRemainRedAmountFromRedConfirm() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [16[FORLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int repairBlueInvRemainRedAmount(DynamicObject[] redConfirms) {
        Set pkSet = Arrays.stream(redConfirms).map(o -> String.valueOf(o.getLong("id"))).collect(Collectors.toSet());
        QFilter alreadySetFilter = new QFilter("invoiceno", "in", pkSet);
        DynamicObject[] alreadySetRedRemainAmount = BusinessDataServiceHelper.load((String)"invsm_botp_callback_log", (String)"invoiceno", (QFilter[])alreadySetFilter.toArray());
        Set alreadySetPk = Arrays.stream(alreadySetRedRemainAmount).map(o -> o.getString("invoiceno")).collect(Collectors.toSet());
        QFilter blueInvoiceFilter = null;
        HashMap<String, DynamicObject> invoicePkRedConfirmMap = new HashMap<String, DynamicObject>();
        for (DynamicObject redConfirm : redConfirms) {
            String pkStr = String.valueOf(redConfirm.getLong("id"));
            if (alreadySetPk.contains(pkStr)) continue;
            String oriInvoiceCode = redConfirm.getString("originalinvoicecode");
            String oriInvoiceNo = redConfirm.getString("originalinvoiceno");
            if (!StringUtils.isNotBlank((CharSequence)oriInvoiceNo)) continue;
            if (null == blueInvoiceFilter) {
                blueInvoiceFilter = new QFilter("invoiceno", "=", (Object)oriInvoiceNo).and("invoicecode", "=", (Object)oriInvoiceCode);
            } else {
                blueInvoiceFilter.or(new QFilter("invoiceno", "=", (Object)oriInvoiceNo).and("invoicecode", "=", (Object)oriInvoiceCode));
            }
            invoicePkRedConfirmMap.put(oriInvoiceNo + oriInvoiceCode, redConfirm);
        }
        if (invoicePkRedConfirmMap.size() == 0) {
            return 0;
        }
        ArrayList<DynamicObject> repairRecords = new ArrayList<DynamicObject>();
        if (null != blueInvoiceFilter) {
            DynamicObject[] invoices;
            for (DynamicObject invoice : invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])blueInvoiceFilter.toArray())) {
                String invoiceCode = invoice.getString("invoicecode");
                String invoiceNO = invoice.getString("invoiceno");
                String key = invoiceNO + invoiceCode;
                DynamicObject redConfirm = (DynamicObject)invoicePkRedConfirmMap.get(key);
                if (null == redConfirm) continue;
                this.setRemainRedAmountFromRedConfirm(invoice, redConfirm);
                this.addRepairRecords(repairRecords, redConfirm);
            }
            this.saveDB(redConfirms, repairRecords, invoices);
        }
        return repairRecords.size();
    }

    private void saveDB(DynamicObject[] redConfirms, List<DynamicObject> repairRecords, DynamicObject[] invoices) {
        try (TXHandle tx = TX.required();){
            try {
                if (invoices.length > 0) {
                    ImcSaveServiceHelper.update((DynamicObject[])invoices);
                }
                ImcSaveServiceHelper.update((DynamicObject[])redConfirms);
                if (repairRecords.size() > 0) {
                    ImcSaveServiceHelper.save(repairRecords);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b", (String)"DataRepairPlugin_21", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
        }
    }

    private void addRepairRecords(List<DynamicObject> repairRecords, DynamicObject redConfirm) {
        long redConfirmPk = redConfirm.getLong("id");
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"invsm_botp_callback_log");
        log.set("invoiceno", (Object)redConfirmPk);
        log.set("createtime", (Object)new Date());
        log.set("business", (Object)ResManager.loadKDString((String)"\u5c06\u7ea2\u5b57\u786e\u8ba4\u5355\u7684\u5df2\u5f00\u4fe1\u606f\u5199\u5165\u539f\u84dd\u7968", (String)"DataRepairPlugin_22", (String)"imc-sim-webapi", (Object[])new Object[0]));
        repairRecords.add(log);
    }

    private void setRemainRedAmountFromRedConfirm(DynamicObject blueInvoice, DynamicObject redConfirm) {
        DynamicObject copyRedConfirm = BusinessDataServiceHelper.newDynamicObject((String)"sim_red_confirm_bill");
        DynamicObjectUtil.copyDynamicObject((DynamicObject)redConfirm, (DynamicObject)copyRedConfirm, (boolean)true);
        DynamicObjectCollection items2 = copyRedConfirm.getDynamicObjectCollection("items");
        Map<Long, DynamicObject> seqItemMap = this.getSeqItemMapFromRedConfirm(items2);
        DynamicObjectCollection oriInvoiceItems = blueInvoice.getDynamicObjectCollection("items");
        long firstSeq = ((DynamicObject)oriInvoiceItems.get(0)).getLong("seq");
        int seqAddNum = firstSeq == 0L ? 1 : 0;
        BigDecimal totalRemainAmount = BigDecimal.ZERO;
        BigDecimal totalRemainTax = BigDecimal.ZERO;
        HashMap<Long, Long> seqBlueInvoiceItemPkMap = new HashMap<Long, Long>();
        for (DynamicObject oriInvoiceItem : oriInvoiceItems) {
            Long redConfirmBlueItemSeq = oriInvoiceItem.getLong("seq") + (long)seqAddNum;
            DynamicObject redItem = seqItemMap.get(redConfirmBlueItemSeq);
            if (redItem != null) {
                seqBlueInvoiceItemPkMap.put(redConfirmBlueItemSeq, oriInvoiceItem.getLong("id"));
                BigDecimal itemRemainRedAmount = oriInvoiceItem.getBigDecimal("itemremainredamount").add(redItem.getBigDecimal("amount"));
                BigDecimal itemRemainRedTax = oriInvoiceItem.getBigDecimal("itemremainredtax").add(redItem.getBigDecimal("tax"));
                BigDecimal redNum = redItem.getBigDecimal("num");
                BigDecimal oriNum = oriInvoiceItem.getBigDecimal("num");
                BigDecimal itemRemainRedNum = oriInvoiceItem.getBigDecimal("itemremainrednum");
                if (MathUtils.isNullOrZero((BigDecimal)itemRemainRedNum) && MathUtils.isNotZero((BigDecimal)oriNum)) {
                    itemRemainRedNum = oriNum;
                }
                if (MathUtils.isNotZero((BigDecimal)redNum)) {
                    itemRemainRedNum = itemRemainRedNum.add(redNum);
                }
                oriInvoiceItem.set("itemremainredamount", (Object)(itemRemainRedAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : itemRemainRedAmount));
                oriInvoiceItem.set("itemremainredtax", (Object)(itemRemainRedTax.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : itemRemainRedTax));
                oriInvoiceItem.set("itemremainrednum", (Object)(itemRemainRedNum.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : itemRemainRedNum));
            }
            totalRemainAmount = totalRemainAmount.add(oriInvoiceItem.getBigDecimal("itemremainredamount"));
            totalRemainTax = totalRemainTax.add(oriInvoiceItem.getBigDecimal("itemremainredtax"));
        }
        this.setOriginalItemPk2RedConfirm(redConfirm, seqBlueInvoiceItemPkMap);
        blueInvoice.set("remainredamount", (Object)(totalRemainAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalRemainAmount));
        blueInvoice.set("canredtaxamount", (Object)(totalRemainTax.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalRemainTax));
        if (MathUtils.isZero((BigDecimal)totalRemainAmount)) {
            blueInvoice.set("invoicestatus", (Object)"3");
        }
    }

    private Map<Long, DynamicObject> getSeqItemMapFromRedConfirm(DynamicObjectCollection items2) {
        HashMap<Long, DynamicObject> seqItemMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject item : items2) {
            Long originalInvoiceSeq = item.getLong("originseq");
            DynamicObject redConfirmItem = (DynamicObject)seqItemMap.get(originalInvoiceSeq);
            if (redConfirmItem == null) {
                seqItemMap.put(originalInvoiceSeq, item);
                continue;
            }
            redConfirmItem.set("amount", (Object)redConfirmItem.getBigDecimal("amount").add(item.getBigDecimal("amount")));
            redConfirmItem.set("tax", (Object)redConfirmItem.getBigDecimal("tax").add(item.getBigDecimal("tax")));
            redConfirmItem.set("num", (Object)redConfirmItem.getBigDecimal("num").add(item.getBigDecimal("num")));
        }
        return seqItemMap;
    }

    private void setOriginalItemPk2RedConfirm(DynamicObject redConfirm, HashMap<Long, Long> seqBlueInvoiceItemPkMap) {
        DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
        for (DynamicObject redConfirmItem : redConfirmItems) {
            long oriSeq = redConfirmItem.getLong("originseq");
            Long blueItemPk = seqBlueInvoiceItemPkMap.get(oriSeq);
            if (null == blueItemPk) continue;
            redConfirmItem.set("originalinvoiceitemid", (Object)blueItemPk);
        }
    }

    private void createAndFileUrl(String field) {
        String invoiceCode = (String)this.getModel().getValue("invoicecode");
        String invoiceNo = (String)this.getModel().getValue("invoiceno");
        if (StringUtils.isBlank((CharSequence)invoiceCode) && StringUtils.isBlank((CharSequence)invoiceNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u3001\u53d1\u7968\u53f7\u7801\u5fc5\u586b", (String)"DataRepairPlugin_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        String[] invoiceNos = invoiceNo.split(",");
        HashSet invoiceNoSet = new HashSet();
        Collections.addAll(invoiceNoSet, invoiceNos);
        QFilter[] filters = new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "in", (Object)invoiceNos).toArray();
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filters);
        Set dbInvoiceNoSet = Arrays.stream(invoices).map(o -> o.getString("invoiceno")).collect(Collectors.toSet());
        ArrayList<DynamicObject[]> noQueryedList = new ArrayList<DynamicObject[]>();
        for (DynamicObject[] s : invoiceNoSet) {
            if (dbInvoiceNoSet.contains(s)) continue;
            noQueryedList.add(s);
        }
        if (noQueryedList.size() > 0) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801%s\u6ca1\u6709\u627e\u5230\u53d1\u7968", (String)"DataRepairPlugin_15", (String)"imc-sim-webapi", (Object[])new Object[0]), JSONObject.toJSONString(noQueryedList)));
            return;
        }
        ArrayList<String> ofdFailList = new ArrayList<String>();
        for (DynamicObject invoice : invoices) {
            if (RECREATE_PAPER_INVOICE.equals(invoice.getString("ofdstatus"))) continue;
            ofdFailList.add(invoice.getString("invoiceno"));
        }
        HashMap<String, DynamicObject> invoiceMap = new HashMap<String, DynamicObject>();
        for (DynamicObject invoice : invoices) {
            if (StringUtils.isEmpty((CharSequence)invoice.getString("uploadismcstatus")) || PDF_RECREATE.equals(invoice.get("uploadismcstatus"))) {
                ImcPushInvoiceToIsmcService.componentInvoicePushToISMCRequest((DynamicObject)invoice, (boolean)true);
            } else if (!RECREATE_PAPER_INVOICE.equals(invoice.getString("ofdstatus"))) {
                ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("orderno", (Object)invoice.getString("orderno"));
                jsonObjects.add(jsonObject);
                InvoiceIsmcSyncToImcService.executeSyncIsmcInvoice(jsonObjects, null);
            }
            invoiceMap.put(invoice.getString("invoiceno"), invoice);
        }
        StringBuilder textBuilder = new StringBuilder();
        for (String invoiceNo1 : invoiceNos) {
            DynamicObject invoice = (DynamicObject)invoiceMap.get(invoiceNo1);
            textBuilder.append(invoice.getString(field)).append(System.lineSeparator());
        }
        this.getModel().setValue("bigtext", (Object)textBuilder.toString());
        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7248\u5f0f\u6587\u4ef6\u6ca1\u6709\u751f\u6210\u7684\uff1a%1$s", (String)"DataRepairPlugin_18", (String)"imc-sim-webapi", (Object[])new Object[0]), JSONObject.toJSONString(ofdFailList)));
    }

    private void queryTimePeriodInvoice(String busType) {
        Date startTime = (Date)this.getModel().getValue("starttime");
        Date endTime = (Date)this.getModel().getValue("endtime");
        Object invoiceType = this.getModel().getValue("invoicetype");
        Object buyerType = this.getModel().getValue("buyertype");
        if (null == startTime) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u586b", (String)"DataRepairPlugin_0", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (null == endTime) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u65f6\u95f4\u5fc5\u586b", (String)"DataRepairPlugin_1", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (DateUtils.timeDifferenceDay((Date)startTime, (Date)endTime) > 30) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e30\u5929", (String)"DataRepairPlugin_40", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)invoiceType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u5fc5\u586b", (String)"DataRepairPlugin_2", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)buyerType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6765\u6e90\u5fc5\u586b", (String)"DataRepairPlugin_3", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        QFilter filter = new QFilter("issuetime", ">=", (Object)startTime).and("issuetime", "<", (Object)endTime).and("invoicetype", "=", invoiceType).and("buyertype", "=", buyerType);
        ORM orm = ORM.create();
        int page = 1;
        DynamicObjectCollection collection = new DynamicObjectCollection();
        do {
            try (DataSet ds = this.queryInvoiceData(orm, page, filter);){
                collection = ORMUtil.toDynamicObjectCollection((DataSet)ds, (String)"sim_vatinvoice");
                if (CollectionUtils.isEmpty((Collection)collection)) break;
                DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("id", "in", (Object)collection.stream().map(invoice -> invoice.get("id")).toArray()).toArray());
                if ("3".equals(busType)) {
                    for (DynamicObject invoice2 : invoices) {
                        IssueInvoiceService.setBlueInvoiceRemainRedAmount((DynamicObject)invoice2);
                    }
                    SaveServiceHelper.update((DynamicObject[])invoices);
                    for (DynamicObject invoice2 : invoices) {
                        WideInvoiceSevice.addInvoiceToWide((DynamicObject)invoice2);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f", (String)"DataRepairPlugin_23", (String)"imc-sim-webapi", (Object[])new Object[0]));
                    continue;
                }
                if (!TIME_PERIOD_REPAIR.equals(busType)) continue;
                List<DynamicObject> needRepairInvoices = this.saveAllInvoice(invoices);
                int allSize = needRepairInvoices.size();
                int successSize = 0;
                ArrayList<String> invoiceNos = new ArrayList<String>();
                int count = 0;
                for (DynamicObject invoice3 : needRepairInvoices) {
                    MsgResponse response;
                    String errorCode;
                    if (++count == 50) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        count = 0;
                    }
                    if (DATA_NOT_FOUNT.equals(errorCode = (response = DataRepairHelper.recreateInvoiceFile((DynamicObject)invoice3)).getErrorCode())) {
                        --allSize;
                        continue;
                    }
                    if (!ErrorType.SUCCESS.getCode().equals(errorCode)) continue;
                    String invoiceInfo = invoice3.getString("invoicecode") + invoice3.getString("invoiceno");
                    invoiceNos.add(invoiceInfo);
                    ++successSize;
                }
                LOGGER.info(String.format("\u53d1\u7968\u4fe1\u606f\uff1a%s,\u5b8c\u6210\u53d1\u7968\u4e91\u6570\u636e\u4fee\u590d\u548c\u7a0e\u63a7\u7cfb\u7edf\u4e91\u6570\u636e\u4fee\u590d\uff0c\u5e76\u53d1\u9001\u7a0e\u63a7\u7cfb\u7edf\u4e91\u91cd\u65b0\u751f\u6210\u53d1\u7968\u6587\u4ef6\u7684\u6d88\u606f", JSONObject.toJSONString(invoiceNos)));
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u603b\u6570\uff1a%1$s,\u6210\u529f\uff1a%2$s,\u5931\u8d25\uff1a%3$s", (String)"DataRepairPlugin_12", (String)"imc-sim-webapi", (Object[])new Object[0]), allSize, successSize, allSize - successSize));
            }
            catch (Exception e) {
                LOGGER.error("\u4fee\u590d\u9519\u8bef" + busType, (Throwable)e);
            }
        } while (collection.size() == 500 && ++page <= 500);
    }

    private DataSet queryInvoiceData(ORM orm, int page, QFilter filter) {
        int from = (page - 1) * 500;
        return orm.queryDataSet("DataRepairPlugin.sim_vatinvoice", "sim_vatinvoice", "id", filter.toArray(), "id", from, 500);
    }

    private List<DynamicObject> saveAllInvoice(DynamicObject[] invoiceArray) {
        DynamicObject[] repairArray;
        ArrayList<Object> repairPks = new ArrayList<Object>();
        HashMap<Object, DynamicObject> invoiceMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject invoice : invoiceArray) {
            repairPks.add(invoice.getPkValue());
            invoiceMap.put(invoice.getPkValue(), invoice);
        }
        for (DynamicObject object : repairArray = BusinessDataServiceHelper.load((String)"sim_repair_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_repair_invoice"), (QFilter[])new QFilter("invoicepk", "in", (Object)repairPks.toArray()).toArray())) {
            invoiceMap.remove(object.getPkValue());
        }
        ArrayList<DynamicObject> repairInvoices = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> needRepairInvoices = new ArrayList<DynamicObject>();
        for (Map.Entry entry : invoiceMap.entrySet()) {
            DynamicObject invoice = (DynamicObject)entry.getValue();
            String orderNo = invoice.getString("orderno");
            if (StringUtils.isBlank((CharSequence)orderNo)) {
                LOGGER.info(String.format("invoiceOrderNoIsEmpty,invoiceCode:%s,invoiceNo:%s", invoice.getString("invoicecode"), invoice.getString("invoiceno")));
                continue;
            }
            DynamicObject repair = BusinessDataServiceHelper.newDynamicObject((String)"sim_repair_invoice");
            repair.set("invoicecode", invoice.get("invoicecode"));
            repair.set("invoiceno", invoice.get("invoiceno"));
            repair.set("invoicepk", invoice.getPkValue());
            repair.set("orderno", (Object)orderNo);
            repair.set("businesstype", (Object)RECREATE_PAPER_INVOICE);
            repairInvoices.add(repair);
            needRepairInvoices.add(invoice);
        }
        if (repairInvoices.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])repairInvoices.toArray(new DynamicObject[0]));
        }
        return needRepairInvoices;
    }

    private void createInvoiceFile() {
        try {
            LOGGER.info("DataRepairPlugincreatePaperInvoice_start");
            CacheHelper.put((String)"sim_repair_invoice", (String)"sim_repair_invoice");
            DynamicObject[] array = this.checkData();
            this.saveRepairData(array[0], RECREATE_PAPER_INVOICE);
            MsgResponse response = DataRepairHelper.recreateInvoiceFile((DynamicObject)array[0]);
            this.showStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("createPdfError:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5931\u8d25\uff1a%s", (String)"DataRepairPlugin_13", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void createPdf() {
        try {
            LOGGER.info("DataRepairPlugincreatePdf_start");
            CacheHelper.put((String)"sim_repair_invoice", (String)"sim_repair_invoice");
            DynamicObject[] array = this.checkData();
            String issueSource = array[0].getString("issuesource");
            if (!RECREATE_PAPER_INVOICE.equals(issueSource) && !TIME_PERIOD_REPAIR.equals(issueSource)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u63a7\u76d8\u6216\u5219\u91d1\u7a0e\u76d8\u5f00\u5177\u7684\u53d1\u7968\u624d\u53ef\u4ee5\u8fdb\u884c\u6b64\u7c7b\u578b\u7684\u4fee\u590d", (String)"DataRepairPlugin_7", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            MsgResponse response = DataRepairHelper.repairImcAndIsmcData((DynamicObject)array[0]);
            this.saveRepairData(array[0], PDF_RECREATE);
            this.showStatus(response);
        }
        catch (Exception e) {
            LOGGER.error("createPdfError:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5931\u8d25\uff1a%s", (String)"DataRepairPlugin_13", (String)"imc-sim-webapi", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void showStatus(MsgResponse response) {
        if (ErrorType.SUCCESS.getCode().equals(response.getErrorCode())) {
            CacheHelper.put((String)"sim_repair_invoice", (String)"sim_repair_invoice");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u53d1\u7968\u6587\u4ef6\u7684\u751f\u6210\u60c5\u51b5", (String)"DataRepairPlugin_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5931\u8d25\uff1a%s", (String)"DataRepairPlugin_13", (String)"imc-sim-webapi", (Object[])new Object[0]), response.getErrorMsg()));
        }
    }

    private void saveRepairData(DynamicObject object, String businesssType) {
        DynamicObject[] repairtArray = BusinessDataServiceHelper.load((String)"sim_repair_invoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_repair_invoice"), (QFilter[])new QFilter("invoicepk", "=", object.getPkValue()).toArray());
        if (repairtArray.length == 0) {
            String orderNo = object.getString("orderno");
            if (StringUtils.isBlank((CharSequence)orderNo)) {
                LOGGER.info(String.format("invoiceOrderNoIsEmpty,invoiceCode:%s,invoiceNo:%s", object.getString("invoicecode"), object.getString("invoiceno")));
                return;
            }
            DynamicObject repair = BusinessDataServiceHelper.newDynamicObject((String)"sim_repair_invoice");
            repair.set("invoicecode", object.get("invoicecode"));
            repair.set("invoiceno", object.get("invoiceno"));
            repair.set("invoicepk", object.getPkValue());
            repair.set("orderno", (Object)orderNo);
            repair.set("businesstype", (Object)businesssType);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repair});
        }
    }

    private DynamicObject[] checkData() {
        Object invoiceCode = this.getModel().getValue("invoicecode");
        Object invoiceNo = this.getModel().getValue("invoiceno");
        Object businessType = this.getModel().getValue("businesstype");
        if (StringUtils.isBlank((Object)invoiceCode) || StringUtils.isBlank((Object)invoiceNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u3001\u53d1\u7968\u53f7\u7801\u5fc5\u586b", (String)"DataRepairPlugin_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        DynamicObject[] array = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])new QFilter("invoicecode", "=", invoiceCode).and(new QFilter("invoiceno", "=", invoiceNo)).toArray());
        if (array.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u91cc\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53d1\u7968", (String)"DataRepairPlugin_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((Object)businessType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b\u5fc5\u9009", (String)"DataRepairPlugin_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        return array;
    }

    private void repairRedConfirm() {
        String redConfirmBillNos = (String)this.getModel().getValue("redconfirmbillno");
        if (StringUtils.isBlank((CharSequence)redConfirmBillNos)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7\u5fc5\u586b\u3002", (String)"DataRepairPlugin_24", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return;
        }
        String[] redConfirmBillNoArr = redConfirmBillNos.split(",");
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)String.join((CharSequence)",", "number", "source", "items.goodsname", "originalinvoicecode", "originalinvoiceno"), (QFilter[])new QFilter("number", "in", (Object)redConfirmBillNoArr).toArray());
        if (redConfirms.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u4e0d\u5b58\u5728\u3002", (String)"DataRepairPlugin_25", (String)"imc-sim-webapi", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Map<Object, DynamicObject>> blueInvoiceItemMap = new HashMap<String, Map<Object, DynamicObject>>(16);
        HashMap<Object, Map<Object, Map<Object, DynamicObject>>> matchBillMap = new HashMap<Object, Map<Object, Map<Object, DynamicObject>>>(16);
        ArrayList<String> message = new ArrayList<String>(redConfirms.length);
        for (DynamicObject redConfirm : redConfirms) {
            String source = redConfirm.getString("source");
            if (!"10".equals(source)) {
                message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u975e\u5339\u914d\u63a8\u9001\u3002", (String)"DataRepairPlugin_26", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                continue;
            }
            DynamicObjectCollection items2 = redConfirm.getDynamicObjectCollection("items");
            if (items2.size() > 0) {
                message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u5b58\u5728\u660e\u7ec6\u3002", (String)"DataRepairPlugin_27", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                continue;
            }
            DynamicObjectCollection matchBillInvRelations = QueryServiceHelper.query((String)"sim_match_inv_relation", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_match_inv_relation"), (QFilter[])new QFilter("tbillid", "=", redConfirm.getPkValue()).toArray());
            long matchBillId = ((DynamicObject)matchBillInvRelations.get(0)).getLong("sbillid");
            Map<Object, Map<Object, DynamicObject>> matchItemMap = this.getMatchBill(matchBillId, matchBillMap);
            if (matchItemMap == null) {
                message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u5bf9\u5e94\u5339\u914d\u5355\u4e0d\u5b58\u5728\u3002", (String)"DataRepairPlugin_28", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                continue;
            }
            Map<Object, DynamicObject> blueItemMap = this.getBlueItemMap(redConfirm, blueInvoiceItemMap);
            if (blueItemMap == null) {
                message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u5bf9\u5e94\u539f\u84dd\u7968\u4e0d\u5b58\u5728\u3002", (String)"DataRepairPlugin_29", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                continue;
            }
            redConfirm = BusinessDataServiceHelper.loadSingle((Object)redConfirm.getPkValue(), (String)"sim_red_confirm_bill");
            DynamicObjectCollection redConfirmItems = redConfirm.getDynamicObjectCollection("items");
            for (DynamicObject relation : matchBillInvRelations) {
                long sDetailId = relation.getLong("sdetailid");
                long sSubDetailid = relation.getLong("ssubdetailid");
                Map<Object, DynamicObject> oriItemMap = matchItemMap.get(sDetailId);
                if (oriItemMap == null) {
                    message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u672a\u627e\u5230\u5339\u914d\u5355\u5bf9\u5e94\u7684\u539f\u84dd\u7968\u660e\u7ec6\u96c6\u5408\u4fe1\u606f\u3002", (String)"DataRepairPlugin_30", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                    continue;
                }
                DynamicObject oriItem = oriItemMap.get(sSubDetailid);
                if (oriItem == null) {
                    message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u672a\u627e\u5230\u5339\u914d\u5355\u5bf9\u5e94\u7684\u539f\u84dd\u7968\u4fe1\u606f\u3002", (String)"DataRepairPlugin_31", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                    continue;
                }
                DynamicObject invoiceItem = blueItemMap.get(oriItem.getLong("oriitemid"));
                if (invoiceItem == null) {
                    message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u672a\u627e\u5230\u539f\u84dd\u7968\u660e\u7ec6\u4fe1\u606f\u3002", (String)"DataRepairPlugin_32", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
                    continue;
                }
                DynamicObject confirmItem = redConfirmItems.addNew();
                DynamicObjectUtil.copyDynamicObject((DynamicObject)invoiceItem, (DynamicObject)confirmItem, (boolean)false, (boolean)true, (boolean)true);
                confirmItem.set("id", relation.get("tdetailid"));
                confirmItem.set("taxratecodeid", (Object)TaxClassCodeCheckHelper.geTaxCode((String)invoiceItem.getString("goodscode")));
                confirmItem.set("rowtype", (Object)PDF_RECREATE);
                confirmItem.set("originseq", oriItem.get("oriitemseq"));
                BigDecimal amount = oriItem.getBigDecimal("oriitemamount").negate();
                confirmItem.set("amount", (Object)amount);
                BigDecimal tax = oriItem.getBigDecimal("oriitemtax").negate();
                confirmItem.set("tax", (Object)tax);
                confirmItem.set("taxamount", (Object)amount.add(tax));
                confirmItem.set("originalinvoiceitemid", oriItem.get("oriitemid"));
                if (RedConfirmBillRedReasonEnum.SALES_DISCOUNTS.getCode().equals(redConfirm.getString("redreason"))) {
                    confirmItem.set("num", (Object)BigDecimal.ZERO);
                    confirmItem.set("unitprice", (Object)BigDecimal.ZERO);
                    confirmItem.set("taxunitprice", (Object)BigDecimal.ZERO);
                    continue;
                }
                this.calcUnitPriceAndNum(oriItem, confirmItem);
            }
            ImcSaveServiceHelper.save((DynamicObject)redConfirm);
            message.add(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u786e\u8ba4\u5355\u7f16\u53f7%s\u4fee\u590d\u6210\u529f\u3002", (String)"DataRepairPlugin_33", (String)"imc-sim-webapi", (Object[])new Object[0]), redConfirm.getString("number")));
        }
        if (CollectionUtils.isNotEmpty(message)) {
            this.getView().showTipNotification(String.join((CharSequence)System.lineSeparator(), message), Integer.valueOf(10000));
        }
    }

    private void calcUnitPriceAndNum(DynamicObject oriItem, DynamicObject redInvoiceOrRedConfirmItem) {
        BigDecimal num = oriItem.getBigDecimal("oriitemnum").negate();
        redInvoiceOrRedConfirmItem.set("num", (Object)num);
        if (!MathUtils.isNullOrZero((BigDecimal)num)) {
            BigDecimal unitPrice = redInvoiceOrRedConfirmItem.getBigDecimal("unitprice");
            BigDecimal amount = redInvoiceOrRedConfirmItem.getBigDecimal("amount");
            if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)unitPrice), (BigDecimal)amount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                num = UnitPriceHelper.calcNum((BigDecimal)amount, (BigDecimal)unitPrice);
                redInvoiceOrRedConfirmItem.set("num", (Object)num);
            }
            BigDecimal taxUnitPrice = redInvoiceOrRedConfirmItem.getBigDecimal("taxunitprice");
            BigDecimal taxAmount = redInvoiceOrRedConfirmItem.getBigDecimal("taxamount");
            if (BigDecimalUtil.compare((BigDecimal)BigDecimalUtil.multiply((BigDecimal)num, (BigDecimal)taxUnitPrice), (BigDecimal)taxAmount, (BigDecimal)InvoiceConstant.DIFF_01)) {
                redInvoiceOrRedConfirmItem.set("taxunitprice", (Object)PriceHelper.calcPriceOrNum((BigDecimal)taxAmount, (BigDecimal)num, (boolean)true));
            }
        }
    }

    private Map<Object, DynamicObject> getBlueItemMap(DynamicObject redConfirm, Map<String, Map<Object, DynamicObject>> blueInvoiceItemMap) {
        DynamicObject blueInvoice;
        String oriInvoiceCode = redConfirm.getString("originalinvoicecode");
        String oriInvoiceNo = redConfirm.getString("originalinvoiceno");
        String key = oriInvoiceCode + '_' + oriInvoiceNo;
        Map<Object, DynamicObject> blueItemMap = blueInvoiceItemMap.get(key);
        if (blueItemMap == null && (blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)oriInvoiceCode, (String)oriInvoiceNo).toArray())) != null) {
            DynamicObjectCollection invoiceItems = blueInvoice.getDynamicObjectCollection("items");
            blueItemMap = invoiceItems.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (v1, v2) -> v1));
            blueInvoiceItemMap.put(key, blueItemMap);
        }
        return blueItemMap;
    }

    private Map<Object, Map<Object, DynamicObject>> getMatchBill(long matchBillId, Map<Object, Map<Object, Map<Object, DynamicObject>>> matchBillMap) {
        DynamicObject matchBill;
        Map<Object, Map<Object, DynamicObject>> matchItemMap = matchBillMap.get(matchBillId);
        if (matchItemMap == null && (matchBill = BusinessDataServiceHelper.loadSingle((String)"sim_match_bill", (String)"", (QFilter[])new QFilter("id", "=", (Object)matchBillId).toArray())) != null) {
            matchBill = BusinessDataServiceHelper.loadSingle((Object)matchBill.getPkValue(), (String)"sim_match_bill");
            matchItemMap = matchBill.getDynamicObjectCollection("sim_original_bill_item").stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> {
                DynamicObjectCollection subentryentity = v.getDynamicObjectCollection("subentryentity");
                return subentryentity.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v1 -> v1, (v1, v2) -> v1));
            }, (v1, v2) -> v1));
            matchBillMap.put(matchBillId, matchItemMap);
        }
        return matchItemMap;
    }

    private void repairRedInvoiceAndConfirm() {
        this.getView().showSuccessNotification("success");
    }

    private void repairInvoiceRemainAmount() {
        String invoiceCode = (String)this.getModel().getValue("invoicecode");
        String invoiceNo = (String)this.getModel().getValue("invoiceno");
        if (StringUtils.isBlank((CharSequence)invoiceNo)) {
            return;
        }
        LOGGER.info("\u5f00\u59cb\u4fee\u590d\u53d1\u7968\u5269\u4f59\u53ef\u7ea2\u51b2\u91d1\u989d\uff0c\u53d1\u7968\u4ee3\u7801:{}\uff0c\u53d1\u7968\u53f7\u7801:{}", (Object)invoiceCode, (Object)invoiceNo);
        DynamicObject invoice = QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)"id", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)invoiceCode, (String)invoiceNo).toArray());
        if (invoice == null) {
            LOGGER.info("\u672a\u67e5\u8be2\u5230\u53d1\u7968\u6216\u53d1\u7968\u4e3a\u7ea2\u7968\uff0c\u4e0d\u4fee\u590d");
            return;
        }
        new RedConfirmAndInvoiceRepairHelper().repairInvoiceRemainAmount(invoice.getLong("id"));
        this.getView().showSuccessNotification("success");
    }
}

