/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.invoice.op;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import org.apache.commons.lang3.tuple.Pair;

public class InvoiceFileRecreateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(PropertieUtil.addFieldKey((String)"sim_vatinvoice_file"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] invoiceFiles = e.getDataEntities();
        ArrayList<DynamicObject> invoiceFileList = new ArrayList<DynamicObject>(invoiceFiles.length);
        HashSet<DynamicObject> invoiceList = new HashSet<DynamicObject>(invoiceFiles.length);
        HashMap<Long, DynamicObject> invoiceMap = new HashMap<Long, DynamicObject>(invoiceFiles.length);
        for (DynamicObject invoiceFile : invoiceFiles) {
            DynamicObject invoice = this.getInvoice(invoiceMap, invoiceFile);
            if (invoice == null) continue;
            if ("rpa".equals(invoiceFile.getString("issuechannel"))) {
                invoiceFile.set("localfileurl", (Object)"");
                invoiceFile.set("localfilestatus", (Object)"-1");
                invoiceFileList.add(invoiceFile);
                continue;
            }
            invoiceList.add(invoice);
            String fileType = invoiceFile.getString("filetype");
            if (FileType.XML.getFileExtension().equals(fileType)) {
                AllEleInvoiceFileHelper.createXml((DynamicObject)invoice, (DynamicObject)invoiceFile);
            } else if (FileType.PDF.getFileExtension().equals(fileType)) {
                Pair pdf = AllEleInvoiceFileHelper.createPdf((DynamicObject)invoice, (DynamicObject)invoiceFile);
                DynamicObject jpgInvoiceFile = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_file"), (QFilter[])new QFilter("invoiceno", "=", (Object)invoiceFile.getString("invoiceno")).and("filetype", "=", (Object)FileType.JPG.getFileExtension()).toArray());
                if (pdf != null && jpgInvoiceFile != null) {
                    AllEleInvoiceFileHelper.createJpg((DynamicObject)invoice, (DynamicObject)jpgInvoiceFile, (Pair)pdf);
                    if ("local".equals(invoiceFile.getString("callbacktype"))) {
                        invoice.set("snapshoturl", (Object)jpgInvoiceFile.getString("localfileurl"));
                    } else {
                        invoice.set("snapshoturl", (Object)jpgInvoiceFile.getString("remotefileurl"));
                    }
                    invoiceFileList.add(jpgInvoiceFile);
                }
            } else if (FileType.OFD.getFileExtension().equals(fileType)) {
                AllEleInvoiceFileHelper.createOfd((DynamicObject)invoice, (DynamicObject)invoiceFile);
            }
            invoiceFileList.add(invoiceFile);
        }
        ImcSaveServiceHelper.save((DynamicObject[])invoiceList.toArray(new DynamicObject[0]));
        ImcSaveServiceHelper.save(invoiceFileList);
    }

    private DynamicObject getInvoice(Map<Long, DynamicObject> invoiceMap, DynamicObject invoiceFile) {
        long invoiceId = invoiceFile.getLong("invoiceid");
        DynamicObject invoice = invoiceMap.get(invoiceId);
        if (invoice != null) {
            return invoice;
        }
        invoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id", (QFilter[])new QFilter("id", "=", (Object)invoiceId).toArray());
        if (invoice != null) {
            invoice = BusinessDataServiceHelper.loadSingle((Object)invoice.getPkValue(), (String)"sim_vatinvoice");
            invoiceMap.put(invoiceId, invoice);
        }
        return invoice;
    }
}

