/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.openapi.check;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.ApiErrCodeEnum;
import kd.imc.bdm.common.constant.CheckPhoneEnum;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.constant.table.BdmIssueInvSettingConstant;
import kd.imc.bdm.common.constant.table.GoodsInfoConstant;
import kd.imc.bdm.common.constant.table.RedReasonEnum;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EquipmentHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.InvoiceValidHelper;
import kd.imc.bdm.common.helper.IssueInvSettingHelper;
import kd.imc.bdm.common.helper.cache.MsgAuthSettingCacheHelper;
import kd.imc.bdm.common.helper.cache.TaxClassCodeCheckHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.openapi.InvoiceVo;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.EquipmentUtil;
import kd.imc.bdm.common.util.GBKUtils;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.RegexUtil;
import kd.imc.bdm.common.util.TaxRateUtil;
import kd.imc.sim.common.constant.InvoiceConstant;
import kd.imc.sim.common.helper.issueinvoice.PriceHelper;
import kd.imc.sim.common.helper.issueinvoice.UnitPriceHelper;
import kd.imc.sim.common.utils.ApiVerifyUtil;
import kd.imc.sim.common.utils.InvoiceQFilterUtil;
import kd.imc.sim.common.utils.MathUtils;
import kd.imc.sim.common.utils.TaxCalcUtil;
import kd.imc.sim.formplugin.openapi.check.BaseCheckService;
import kd.imc.sim.formplugin.openapi.check.VerifyResult;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class CheckInvoiceOpenService {
    private static final Log log = LogFactory.getLog(CheckInvoiceOpenService.class);

    public static VerifyResult checkInvoiceVo(InvoiceVo invoice) {
        VerifyResult result1;
        DynamicObject bank;
        boolean checkRedGoodSInfo;
        Map rMap = ApiVerifyUtil.checkAndFillOrgCode((String)invoice.getSellerTaxpayerId(), (String)invoice.getOrgCode(), (String)invoice.getDeviceNo());
        String orgCodeCheckMsg = (String)rMap.get("checkMsg");
        if (StringUtils.isNotBlank((CharSequence)orgCodeCheckMsg)) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_ILLEGAL_ORG_CODE.getCode(), orgCodeCheckMsg);
        }
        invoice.setOrg(Long.valueOf(Long.parseLong((String)rMap.get("orgId"))));
        VerifyResult x = CheckInvoiceOpenService.baseCheck(invoice);
        if (x != null) {
            return x;
        }
        try {
            checkRedGoodSInfo = CheckInvoiceOpenService.checkRedGoodSInfo(invoice);
        }
        catch (MsgException e) {
            return VerifyResult.error(e.getErrorCode(), e.getErrorMsg());
        }
        CheckInvoiceOpenService.checkSpecialType(invoice);
        if (invoice.getInvoiceProperty() == 1 && InvoiceUtils.isNormalInvoice((String)invoice.getInvoiceType())) {
            DynamicObject blueInvoice;
            try {
                blueInvoice = CheckInvoiceOpenService.getBlueInvoice(invoice);
            }
            catch (MsgException e) {
                return VerifyResult.error(e.getErrorCode(), e.getErrorMsg());
            }
            if (null != blueInvoice) {
                invoice.setOriginalInvoiceType(blueInvoice.getString("invoicetype"));
                invoice.setOriginalIssueTime(blueInvoice.getDate("issuetime"));
            } else {
                if (StringUtils.isBlank((CharSequence)invoice.getOriginalInvoiceType()) || null == invoice.getOriginalIssueTime()) {
                    return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICETYPE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICETYPE.getMsg());
                }
                if (InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoice.getInvoiceType()) && !InvoiceType.PAPER_VOLUME_INVOICE.getTypeCode().equals(invoice.getOriginalInvoiceType())) {
                    return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_VOLUME_INVOICE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_VOLUME_INVOICE.getMsg());
                }
            }
            if (StringUtils.isBlank((CharSequence)invoice.getRedReason()) || !RedReasonEnum.getAllTypeCode().contains(invoice.getRedReason())) {
                invoice.setRedReason(RedReasonEnum.INVOICE_ERR.getTypeCode());
            }
        }
        if (StringUtils.isEmpty((CharSequence)invoice.getBuyerBankAndAccount()) || StringUtils.isEmpty((CharSequence)invoice.getBuyerAddressAndTel())) {
            QFilter qFilter = new QFilter("taxno", "=", (Object)invoice.getBuyerTaxpayerId());
            DynamicObject title = BusinessDataServiceHelper.loadSingle((String)"bdm_inv_issue_title", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_inv_issue_title"), (QFilter[])qFilter.toArray());
            if (title != null) {
                if (StringUtils.isEmpty((CharSequence)invoice.getBuyerBankAndAccount())) {
                    invoice.setBuyerBankAndAccount(title.getString("openingbank"));
                }
                if (StringUtils.isEmpty((CharSequence)invoice.getBuyerAddressAndTel())) {
                    invoice.setBuyerAddressAndTel(title.getString("addr"));
                }
            }
        }
        QFilter filter = new QFilter("number", "=", (Object)invoice.getSellerTaxpayerId());
        DynamicObject eqInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_enterprise_baseinfo", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_baseinfo"), (QFilter[])filter.toArray());
        if (eqInfo == null) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_EQINFONOTFOND.getCode(), ApiErrCodeEnum.INVOICE_OPEN_EQINFONOTFOND.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)invoice.getSellerName())) {
            invoice.setSellerName(eqInfo.getString("name"));
        } else if (!invoice.getSellerName().equals(eqInfo.get("name"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_EP_INFO_NAME_ERROR.getCode(), ApiErrCodeEnum.INVOICE_OPEN_EP_INFO_NAME_ERROR.getMsg());
        }
        if ((StringUtils.isEmpty((CharSequence)invoice.getSellerBankAndAccount()) || StringUtils.isEmpty((CharSequence)invoice.getSellerAddressAndTel())) && (bank = BusinessDataServiceHelper.loadSingle((String)"sim_invoice_setting", (String)"invoiceaddr,openuserbank", (QFilter[])(filter = new QFilter("taxno", "=", (Object)invoice.getSellerTaxpayerId())).toArray())) != null) {
            if (StringUtils.isEmpty((CharSequence)invoice.getSellerBankAndAccount())) {
                invoice.setSellerBankAndAccount(bank.getString("openuserbank"));
            }
            if (StringUtils.isEmpty((CharSequence)invoice.getSellerAddressAndTel())) {
                invoice.setSellerAddressAndTel(bank.getString("invoiceaddr"));
            }
        }
        if ((result1 = CheckInvoiceOpenService.checkDevice(invoice)) != null) {
            return result1;
        }
        VerifyResult result = CheckInvoiceOpenService.checkItem(invoice, checkRedGoodSInfo);
        if (result != null) {
            return result;
        }
        try {
            CheckInvoiceOpenService.checkRedInfo(invoice);
            InvoiceValidHelper.checkMultiMobile((String)invoice.getBuyerRecipientPhone());
            InvoiceValidHelper.checkMultiEmail((String)invoice.getBuyerRecipientMail());
        }
        catch (MsgException e) {
            return VerifyResult.error(e.getErrorCode(), e.getErrorMsg());
        }
        return VerifyResult.succeed();
    }

    private static VerifyResult checkDevice(InvoiceVo vo) {
        if (StringUtils.isEmpty((CharSequence)vo.getDeviceNo())) {
            VerifyResult result = CheckInvoiceOpenService.autoGetDevice(vo.getSellerTaxpayerId(), vo.getOrgCode());
            if (!result.isSucceed()) {
                return result;
            }
            vo.setDeviceNo(result.getData() + "");
        } else {
            VerifyResult devRes = BaseCheckService.checkDevNo(vo.getDeviceNo(), vo.getSellerTaxpayerId());
            if (!devRes.isSucceed()) {
                return devRes;
            }
        }
        return null;
    }

    public static VerifyResult autoGetDevice(String taxNo, String orgCode) {
        DynamicObject queryOrg;
        log.info("autoGetDevice " + taxNo + ", orgCode: " + orgCode);
        QFilter filter = new QFilter("epinfo.number", "=", (Object)taxNo);
        if (StringUtils.isNotEmpty((CharSequence)orgCode)) {
            filter.and("number", "=", (Object)orgCode);
        }
        if (null == (queryOrg = BusinessDataServiceHelper.loadSingle((String)"bdm_org", (String)"id,defaultdev,devlist_tag", (QFilter[])filter.toArray())) || StringUtils.isBlank((CharSequence)queryOrg.getString("devlist_tag"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_DEVSNOTFOND.getCode(), ApiErrCodeEnum.INVOICE_OPEN_DEVSNOTFOND.getMsg());
        }
        String orgDefaultDev = queryOrg.getString("defaultdev");
        if (StringUtils.isNotEmpty((CharSequence)orgDefaultDev) && EquipmentHelper.isEnable((Object)taxNo, (Object)orgDefaultDev)) {
            return VerifyResult.succeed(queryOrg.getString("defaultdev"));
        }
        DynamicObject defaultDev = EquipmentUtil.getDefaultDev((Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)queryOrg));
        if (null != defaultDev) {
            return VerifyResult.succeed(defaultDev.getString("equipmentno"));
        }
        return VerifyResult.succeed("");
    }

    private static boolean checkRedGoodSInfo(InvoiceVo vo) {
        boolean checkRedGoodSInfo;
        if (1 == vo.getInvoiceProperty()) {
            if (InvoiceType.PAPER_SPECIAL_INVOICE.getTypeCode().equals(vo.getInvoiceType()) || InvoiceType.ELECTRICAL_SPECIAL_INVOICE.getTypeCode().equals(vo.getInvoiceType())) {
                checkRedGoodSInfo = true;
            } else {
                if (StringUtils.isEmpty((CharSequence)vo.getOriginalInvoiceCode()) || StringUtils.isEmpty((CharSequence)vo.getOriginalInvoiceNumber())) {
                    throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getMsg());
                }
                checkRedGoodSInfo = true;
            }
        } else {
            checkRedGoodSInfo = false;
        }
        return checkRedGoodSInfo;
    }

    private static VerifyResult baseCheck(InvoiceVo vo) {
        if (ApiVerifyUtil.checkLength100((String)vo.getSellerName())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME.getCode(), ApiErrCodeEnum.INVOICE_OPEN_SELLERNAME.getMsg());
        }
        if (ApiVerifyUtil.checkLength100((String)vo.getBuyerName())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_BUYERNAMELEN.getCode(), ApiErrCodeEnum.INVOICE_OPEN_BUYERNAMELEN.getMsg());
        }
        if (ApiVerifyUtil.checkLength100((String)vo.getSellerBankAndAccount())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_SELLERBANK.getCode(), ApiErrCodeEnum.INVOICE_OPEN_SELLERBANK.getMsg());
        }
        if (ApiVerifyUtil.checkLength100((String)vo.getBuyerBankAndAccount())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_BUYERBANK.getCode(), ApiErrCodeEnum.INVOICE_OPEN_BUYERBANK.getMsg());
        }
        if (ApiVerifyUtil.checkLength100((String)vo.getSellerAddressAndTel())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS.getCode(), ApiErrCodeEnum.INVOICE_OPEN_SELLERADDRESS.getMsg());
        }
        if (ApiVerifyUtil.checkLength100((String)vo.getBuyerAddressAndTel())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS.getCode(), ApiErrCodeEnum.INVOICE_OPEN_BUYERADDRESS.getMsg());
        }
        if (vo.getInvoiceProperty() == 0 && ("028".equals(vo.getInvoiceType()) || "026".equals(vo.getInvoiceType()))) {
            String checkPhone = MsgAuthSettingCacheHelper.getCacheCheckPhoneByOrgId((long)vo.getOrg());
            if (CheckPhoneEnum.DEFAULT.getCode().equals(checkPhone) && StringUtils.isBlank((CharSequence)vo.getBuyerRecipientMail()) && StringUtils.isBlank((CharSequence)vo.getBuyerRecipientPhone())) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_EMAIL_OR_PHONE_NEW.getCode(), ApiErrCodeEnum.INVOICE_OPEN_EMAIL_OR_PHONE_NEW.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getBuyerRecipientMail())) {
            if (ApiVerifyUtil.checkLength((String)vo.getBuyerRecipientMail(), (int)300)) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getCode(), ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getMsg());
            }
            String[] emails = vo.getBuyerRecipientMail().split(";");
            if (emails.length > 10) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getCode(), ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getMsg());
            }
            for (String email : emails) {
                if (RegexUtil.isEmail((String)email)) continue;
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getCode(), ApiErrCodeEnum.INVOICE_OPEN_EMAIL.getMsg());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getBuyerRecipientPhone()) && !InvoiceValidHelper.isMobile((String)vo.getBuyerRecipientPhone())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_PHONE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_PHONE.getMsg());
        }
        if (!RegexUtil.isNsrsbh((String)vo.getSellerTaxpayerId())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_SELLERTAXPAYERID.getCode(), ApiErrCodeEnum.INVOICE_OPEN_SELLERTAXPAYERID.getMsg());
        }
        vo.setSellerTaxpayerId(vo.getSellerTaxpayerId().toUpperCase());
        if (StringUtils.isEmpty((CharSequence)(vo.getBuyerProperty() + ""))) {
            vo.setBuyerProperty(0);
        } else if (BaseCheckService.checkNotContainsValue(vo.getBuyerProperty())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_BUYERPROPERTY.getCode(), ApiErrCodeEnum.INVOICE_OPEN_BUYERPROPERTY.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)(vo.getInvoiceProperty() + "")) && BaseCheckService.isNotOneOrZore(vo.getInvoiceProperty())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_INVOICEPROPERTY.getCode(), ApiErrCodeEnum.INVOICE_OPEN_INVOICEPROPERTY.getMsg());
        }
        if (!BaseCheckService.checkInvoiceType(vo.getInvoiceType())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_INVOICETYPE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_INVOICETYPE.getMsg());
        }
        if (BaseCheckService.isPerson(vo.getBuyerProperty(), vo.getInvoiceType())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_INVOICETYPEBUYER.getCode(), ApiErrCodeEnum.INVOICE_OPEN_INVOICETYPEBUYER.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)vo.getRedInfoBillNo()) && CheckInvoiceOpenService.checkRedInfo(vo.getInvoiceProperty(), vo.getInvoiceType())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_REDINFOBILLNO.getCode(), ApiErrCodeEnum.INVOICE_OPEN_REDINFOBILLNO.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)vo.getBuyerName())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME.getCode(), ApiErrCodeEnum.INVOICE_OPEN_BUYERNAME.getMsg());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getBuyerTaxpayerId())) {
            vo.setBuyerTaxpayerId(vo.getBuyerTaxpayerId().toUpperCase());
        }
        if (StringUtils.isEmpty((CharSequence)(vo.getIncludeTaxFlag() + "")) && BaseCheckService.isNotOneOrZore(vo.getIncludeTaxFlag())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_INCLUDETAXFLAG.getCode(), ApiErrCodeEnum.INVOICE_OPEN_INCLUDETAXFLAG.getMsg());
        }
        if (StringUtils.isNotEmpty((CharSequence)vo.getRemark()) && GBKUtils.getGBKLength((String)vo.getRemark()) > 230) {
            vo.setRemark(vo.getRemark().substring(GBKUtils.getGBKLength((String)vo.getRemark())));
        }
        if (!MathUtils.isNullOrZero((BigDecimal)vo.getDeduction())) {
            vo.setTaxedType(2);
            if (vo.getInvoiceDetail().size() > 1) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_ONLYONE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_ONLYONE.getMsg());
            }
        }
        if (StringUtils.isEmpty((CharSequence)vo.getDrawer()) || BaseCheckService.checkNameLen(vo.getDrawer())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_DRAWER.getCode(), ApiErrCodeEnum.INVOICE_OPEN_DRAWER.getMsg());
        }
        if (BaseCheckService.checkNameLen(vo.getPayee())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_PAYEE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_PAYEE.getMsg());
        }
        if (BaseCheckService.checkNameLen(vo.getReviewer())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_REVIEWER.getCode(), ApiErrCodeEnum.INVOICE_OPEN_REVIEWER.getMsg());
        }
        return null;
    }

    public static boolean checkRedInfo(int prop, String invoiceType) {
        return prop == 1 && ("004".equals(invoiceType) || "028".equals(invoiceType));
    }

    private static void checkSpecialType(InvoiceVo vo) {
        String invoiceType;
        List details = vo.getInvoiceDetail();
        String specialType = vo.getSpecialType();
        String billNo = vo.getSerialNo();
        if ("18".equals(specialType)) {
            invoiceType = vo.getInvoiceType();
            if (!InvoiceUtils.isSpecialInvoice((String)invoiceType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u7684\u53d1\u7968\u7c7b\u578b\u5fc5\u987b\u4e13\u7968", (String)"CheckInvoiceOpenService_0", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
            }
            for (InvoiceDetailVo detail : details) {
                String num = detail.getQuantity();
                String price = detail.getPrice();
                String unit = detail.getUnits();
                int lineProperty = detail.getLineProperty();
                if (1 == lineProperty) continue;
                if (!RegexUtil.isIntegerLargeZero((String)num)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6574\u6570", (String)"CheckInvoiceOpenService_1", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
                }
                if (!RegexUtil.isFloatLargeZero((String)price)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u673a\u52a8\u8f66\u589e\u503c\u7a0e\u53d1\u7968\u5355\u4ef7\u5fc5\u987b\u4e3a\u6b63\u6570", (String)"CheckInvoiceOpenService_2", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
                }
                if ("\u8f86".equals(unit)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s,\u5355\u4f4d\u680f\u5fc5\u987b\u4e3a:\u8f86", (String)"CheckInvoiceOpenService_3", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
            }
        }
        invoiceType = vo.getInvoiceType();
        if ("E12".equals(specialType)) {
            if (!InvoiceType.ALL_E_NORMAL.getTypeCode().equals(invoiceType)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff1a%s\u7684\u53d1\u7968\u7c7b\u578b\u4e0d\u652f\u6301\u81ea\u4ea7\u519c\u4ea7\u54c1\u6536\u8d2d\u53d1\u7968", (String)"CheckInvoiceOpenService_22", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo));
            }
            int i = 1;
            for (InvoiceDetailVo detail : details) {
                int privilegeFlag = detail.getPrivilegeFlag();
                String privilegeContent = detail.getPrivilegeContent();
                String taxRate = detail.getTaxRate();
                BigDecimal taxRateDecimalValue = BigDecimal.TEN;
                try {
                    taxRateDecimalValue = new BigDecimal(taxRate);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (privilegeFlag != 1 || !"\u514d\u7a0e".equals(privilegeContent) || taxRateDecimalValue.compareTo(BigDecimal.ZERO) != 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\u7b2c%2$s\u884c\u660e\u7ec6\u660e\u7ec6\u7a0e\u7387\u5fc5\u987b\u4e3a\uff1a0,\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56\u6807\u8bc6\u4e3a\uff1a\u4eab\u53d7\uff0c\u4f18\u60e0\u653f\u7b56\u5185\u5bb9\u4e3a\uff1a\u514d\u7a0e\uff08\u81ea\u4ea7\u519c\u4ea7\u54c1\u9500\u552e\u53d1\u7968\u660e\u7ec6\u7a0e\u7387\u8981\u6c42\u5fc5\u987b\u4e3a\u514d\u7a0e\uff09", (String)"CheckInvoiceOpenService_23", (String)"imc-sim-webapi", (Object[])new Object[0]), billNo, i));
                }
                ++i;
            }
        }
    }

    private static void checkRedInfo(InvoiceVo vo) {
        if (!CheckInvoiceOpenService.checkRedInfo(vo.getInvoiceProperty(), vo.getInvoiceType())) {
            return;
        }
        DynamicObject redInfo = QueryServiceHelper.queryOne((String)"sim_red_info", (String)String.join((CharSequence)",", "originalinvoicecode", "originalinvoiceno", "status", "buyername", "buyertaxno", "invoiceamount", "totaltax"), (QFilter[])new QFilter("infocode", "=", (Object)vo.getRedInfoBillNo()).toArray());
        if (redInfo == null) {
            return;
        }
        if (!redInfo.getString("buyername").equals(vo.getBuyerName())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u8d2d\u65b9\u540d\u79f0\u4e0e\u5355\u636e\u8d2d\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"CheckInvoiceOpenService_4", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (!redInfo.getString("buyertaxno").equals(vo.getBuyerTaxpayerId())) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u8d2d\u65b9\u7a0e\u53f7\u4e0e\u5355\u636e\u8d2d\u65b9\u7a0e\u53f7\u4e0d\u4e00\u81f4", (String)"CheckInvoiceOpenService_5", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (redInfo.getBigDecimal("invoiceamount").compareTo(vo.getTotalAmount()) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\u4e0e\u53d1\u7968\u91d1\u989d\u4e0d\u4e00\u81f4\u3002\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\uff1a%s", (String)"CheckInvoiceOpenService_6", (String)"imc-sim-webapi", (Object[])new Object[0]), redInfo.getBigDecimal("invoiceamount")));
        }
        if (redInfo.getBigDecimal("totaltax").compareTo(vo.getTotalTaxAmount()) != 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u7a0e\u989d\u4e0e\u53d1\u7968\u7a0e\u989d\u4e0d\u4e00\u81f4\u3002\u7ea2\u5b57\u4fe1\u606f\u8868\u91d1\u989d\uff1a%s", (String)"CheckInvoiceOpenService_7", (String)"imc-sim-webapi", (Object[])new Object[0]), redInfo.getBigDecimal("totaltax")));
        }
        String redInfoStatus = redInfo.getString("status");
        if ("4".equals(redInfoStatus)) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5df2\u5f00\u7968\uff0c\u4e0d\u80fd\u518d\u6b21\u4f7f\u7528", (String)"CheckInvoiceOpenService_8", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if ("1".equals(redInfoStatus)) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u672a\u63d0\u4ea4", (String)"CheckInvoiceOpenService_9", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if ("2".equals(redInfoStatus)) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u7ea2\u5b57\u4fe1\u606f\u8868\u5ba1\u6838\u5931\u8d25", (String)"CheckInvoiceOpenService_10", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getOriginalInvoiceCode()) && StringUtils.isNotBlank((CharSequence)redInfo.getString("originalinvoicecode")) && !vo.getOriginalInvoiceCode().equals(redInfo.getString("originalinvoicecode"))) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u4ee3\u7801\u4e0e\u7ea2\u5b57\u4fe1\u606f\u539f\u84dd\u7968\u4ee3\u7801\u4e0d\u4e00\u81f4", (String)"CheckInvoiceOpenService_11", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getOriginalInvoiceNumber()) && StringUtils.isNotBlank((CharSequence)redInfo.getString("originalinvoiceno")) && !vo.getOriginalInvoiceNumber().equals(redInfo.getString("originalinvoiceno"))) {
            throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u539f\u84dd\u7968\u53f7\u7801\u4e0e\u7ea2\u5b57\u4fe1\u606f\u539f\u84dd\u7968\u53f7\u7801\u4e0d\u4e00\u81f4", (String)"CheckInvoiceOpenService_12", (String)"imc-sim-webapi", (Object[])new Object[0]));
        }
        vo.setOriginalInvoiceCode(redInfo.getString("originalinvoicecode"));
        vo.setOriginalInvoiceNumber(redInfo.getString("originalinvoiceno"));
        DynamicObject blueInvoice = CheckInvoiceOpenService.getBlueInvoice(vo);
        if (null != blueInvoice) {
            vo.setOriginalInvoiceType(blueInvoice.getString("invoicetype"));
            vo.setOriginalIssueTime(blueInvoice.getDate("issuetime"));
        }
        if (StringUtils.isBlank((CharSequence)vo.getRedReason()) || !RedReasonEnum.getAllTypeCode().contains(vo.getRedReason())) {
            vo.setRedReason(RedReasonEnum.INVOICE_ERR.getTypeCode());
        }
    }

    private static DynamicObject getBlueInvoice(InvoiceVo vo) {
        if (StringUtils.isBlank((CharSequence)vo.getOriginalInvoiceCode()) || StringUtils.isBlank((CharSequence)vo.getOriginalInvoiceNumber())) {
            return null;
        }
        DynamicObject blueInvoice = BusinessDataServiceHelper.loadSingle((String)"sim_vatinvoice", (String)"id,invoicestatus,issuetime,invoicetype", (QFilter[])InvoiceQFilterUtil.getInvoiceByCodeAndNo((String)vo.getOriginalInvoiceCode(), (String)vo.getOriginalInvoiceNumber()).toArray());
        if (null != blueInvoice) {
            if ("6".equals(blueInvoice.getString("invoicestatus"))) {
                throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u84dd\u7968\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ea2\u51b2", (String)"CheckInvoiceOpenService_13", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            if ("3".equals(blueInvoice.getString("invoicestatus"))) {
                throw new MsgException(ApiErrCodeEnum.INVOICE_OPEN_ORIGINALINVOICECODE.getCode(), ResManager.loadKDString((String)"\u84dd\u7968\u5df2\u7ea2\u51b2\uff0c\u4e0d\u80fd\u8fdb\u884c\u7ea2\u51b2", (String)"CheckInvoiceOpenService_14", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            return blueInvoice;
        }
        return null;
    }

    private static VerifyResult checkItem(InvoiceVo invoice, boolean checkRedGoodSInfo) {
        BigDecimal totalDiff = BigDecimal.ZERO;
        String invoiceType = invoice.getInvoiceType();
        boolean isElePaper = AllEleAuthHelper.elePaperSetValue((Object)invoice.getSellerTaxpayerId(), (Object)invoiceType);
        boolean isAllEle = InvoiceUtils.isAllEInvoice((Object)invoiceType) || isElePaper;
        for (int i = 0; i < invoice.getInvoiceDetail().size(); ++i) {
            InvoiceDetailVo invoiceDetailVo;
            InvoiceDetailVo good = (InvoiceDetailVo)invoice.getInvoiceDetail().get(i);
            VerifyResult result = CheckInvoiceOpenService.checkGoodInfo(good, checkRedGoodSInfo, invoice.getIncludeTaxFlag(), invoice.getOrg(), invoice.getDeduction(), isAllEle);
            good.setDetailId(null);
            good.setSeq(i);
            if (!result.isSucceed()) {
                result.setDesc(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5546\u54c1\u660e\u7ec6\uff0c%2$s", (String)"CheckInvoiceOpenService_15", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, result.getDesc()));
                return result;
            }
            totalDiff = totalDiff.add((BigDecimal)result.getData());
            invoice.setTotalAmount(invoice.getTotalAmount().add(good.getAmount()));
            invoice.setTotalTaxAmount(invoice.getTotalTaxAmount().add(good.getTaxAmount()));
            try {
                good.setPrice(PriceHelper.getStrValue((String)good.getPrice(), (String)"\u5355\u4ef7", (boolean)isAllEle));
                good.setIncludeTaxPrice(PriceHelper.getStrValue((String)good.getIncludeTaxPrice(), (String)"\u542b\u7a0e\u5355\u4ef7", (boolean)isAllEle));
                good.setQuantity(UnitPriceHelper.getNumStrValue((String)good.getQuantity(), (String)"\u6570\u91cf"));
            }
            catch (KDBizException e) {
                return VerifyResult.error("9999", String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u660e\u7ec6%2$s", (String)"CheckInvoiceOpenService_16", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1, e.getMessage()));
            }
            if (good.getLineProperty() == 2) {
                if (i == invoice.getInvoiceDetail().size() - 1) {
                    return VerifyResult.error("9999", String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u662f\u88ab\u6298\u6263\u884c\uff0c\u4e0b\u4e00\u884c\u5fc5\u987b\u4e3a\u6298\u6263\u884c", (String)"CheckInvoiceOpenService_17", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1));
                }
                invoiceDetailVo = (InvoiceDetailVo)invoice.getInvoiceDetail().get(i + 1);
                if (invoiceDetailVo == null || invoiceDetailVo.getLineProperty() != 1) {
                    return VerifyResult.error("9999", String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u662f\u88ab\u6298\u6263\u884c\uff0c\u4e0b\u4e00\u884c\u5fc5\u987b\u4e3a\u6298\u6263\u884c", (String)"CheckInvoiceOpenService_17", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1));
                }
            }
            if (good.getLineProperty() == 1) {
                invoiceDetailVo = (InvoiceDetailVo)invoice.getInvoiceDetail().get(i - 1);
                if (invoiceDetailVo == null || invoiceDetailVo.getLineProperty() != 2) {
                    return VerifyResult.error("9999", String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u660e\u7ec6\u662f\u6298\u6263\u884c\uff0c\u4e0a\u4e00\u884c\u5fc5\u987b\u4e3a\u88ab\u6298\u6263\u884c", (String)"CheckInvoiceOpenService_18", (String)"imc-sim-webapi", (Object[])new Object[0]), i + 1));
                }
                good.setDiscountAmount(BigDecimal.ZERO);
                good.setSpecification("");
                good.setUnits("");
                good.setPrice("");
                good.setIncludeTaxPrice("");
                good.setQuantity("");
                if (!StringUtils.isEmpty((CharSequence)good.getQuantity())) {
                    return VerifyResult.error("9999", ResManager.loadKDString((String)"\u6298\u6263\u884c\u6570\u91cf,\u5355\u4ef7\u90fd\u5e94\u4e3a\u7a7a", (String)"CheckInvoiceOpenService_19", (String)"imc-sim-webapi", (Object[])new Object[0]));
                }
            }
            if (MathUtils.isNullOrZero((BigDecimal)good.getDiscountAmount())) continue;
            InvoiceDetailVo copyGood = new InvoiceDetailVo();
            try {
                PropertyUtils.copyProperties((Object)copyGood, (Object)good);
            }
            catch (Exception e) {
                VerifyResult.error(ApiErrCodeEnum.ERROR.getCode(), ResManager.loadKDString((String)"\u521b\u5efa\u6298\u6263\u884c\u5931\u8d25", (String)"CheckInvoiceOpenService_20", (String)"imc-sim-webapi", (Object[])new Object[0]));
            }
            CheckInvoiceOpenService.copyInvoiceDetailVo(good, copyGood);
            copyGood.setSeq(i + 1);
            invoice.getInvoiceDetail().add(i + 1, copyGood);
        }
        invoice.setInventoryMark(invoice.getInvoiceDetail().size() > 8 ? "1" : "0");
        invoice.setIncludeTaxAmount(invoice.getTotalTaxAmount().add(invoice.getTotalAmount()));
        if (totalDiff.abs().compareTo(InvoiceConstant.DIFF_127) > 0) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODTAXAMOUNT.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODTAXAMOUNT.getMsg());
        }
        BigDecimal invoiceAmount = invoice.getTotalAmount();
        BigDecimal totalTax = invoice.getTotalTaxAmount();
        if (invoice.getInvoiceProperty() == 0) {
            if (invoiceAmount.compareTo(BigDecimal.ZERO) < 0) {
                return VerifyResult.error(ApiErrCodeEnum.BLUE_INVOICE_AMOUNT_ERROR.getCode(), ApiErrCodeEnum.BLUE_INVOICE_AMOUNT_ERROR.getMsg());
            }
            if (totalTax.compareTo(BigDecimal.ZERO) < 0) {
                return VerifyResult.error(ApiErrCodeEnum.BLUE_INVOICE_TAX_ERROR.getCode(), ApiErrCodeEnum.BLUE_INVOICE_TAX_ERROR.getMsg());
            }
        } else if (invoice.getInvoiceProperty() == 1) {
            if (invoiceAmount.compareTo(BigDecimal.ZERO) > 0) {
                return VerifyResult.error(ApiErrCodeEnum.RED_INVOICE_AMOUNT_ERROR.getCode(), ApiErrCodeEnum.RED_INVOICE_AMOUNT_ERROR.getMsg());
            }
            if (totalTax.compareTo(BigDecimal.ZERO) > 0) {
                return VerifyResult.error(ApiErrCodeEnum.RED_INVOICE_TAX_ERROR.getCode(), ApiErrCodeEnum.RED_INVOICE_TAX_ERROR.getMsg());
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VerifyResult checkGoodInfo(InvoiceDetailVo good, boolean red, int includeTaxFlag, Long org, BigDecimal deduction, boolean isAllEle) {
        BigDecimal taxAmount;
        BigDecimal calcAmount;
        if (StringUtils.isNotEmpty((CharSequence)good.getDetailId()) && !BaseCheckService.checkCodeLen(good.getDetailId())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODID.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODID.getMsg());
        }
        if (red) {
            if (StringUtils.isNotBlank((CharSequence)good.getQuantity()) && new BigDecimal(good.getQuantity()).compareTo(BigDecimal.ZERO) > 0) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_LINEPROPERTYRED_QUANTITY.getCode(), ApiErrCodeEnum.INVOICE_OPEN_LINEPROPERTYRED_QUANTITY.getMsg());
            }
            if (StringUtils.isNotBlank((CharSequence)good.getPrice()) && new BigDecimal(good.getPrice()).compareTo(BigDecimal.ZERO) < 0) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_LINEPROPERTYRED_PRICE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_LINEPROPERTYRED_PRICE.getMsg());
            }
        }
        DynamicObject issueInvSetting = IssueInvSettingHelper.getIssueInvSetting((Long)org);
        if (StringUtils.isEmpty((CharSequence)good.getGoodsCode()) && StringUtils.isEmpty((CharSequence)good.getGoodsName())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODCODEANDNAME.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODCODEANDNAME.getMsg());
        }
        QFilter filter = new QFilter("number", "=", (Object)good.getGoodsCode());
        filter.or("name", "=", (Object)good.getGoodsName());
        DynamicObject goodInfo = BusinessDataServiceHelper.loadSingle((String)"bdm_goods_info", (String)GoodsInfoConstant.SELECT_PROPERTIES, (QFilter[])new QFilter[]{ImcBaseDataHelper.getGoodsInfoFilter((Object)org), filter});
        if (StringUtils.isEmpty((CharSequence)good.getGoodsCode()) && goodInfo != null) {
            good.setGoodsCode(goodInfo.getString("number"));
        }
        if (StringUtils.isEmpty((CharSequence)good.getGoodsName()) && goodInfo != null) {
            good.setGoodsName(goodInfo.getString("name"));
        }
        if (StringUtils.isEmpty((CharSequence)good.getGoodsName()) && goodInfo == null) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODCODEANDNAME.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODCODEANDNAME.getMsg());
        }
        if (GBKUtils.getGBKLength((String)good.getGoodsName()) > 92 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
            good.setGoodsName(GBKUtils.cutGBKString((String)good.getGoodsName(), (int)92));
        } else if (GBKUtils.getGBKLength((String)good.getGoodsName()) > 92 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODNAMEISGBK.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODNAMEISGBK.getMsg());
        }
        String spec = good.getSpecification();
        if (StringUtils.isNotEmpty((CharSequence)spec) && GBKUtils.getGBKLength((String)spec) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
            good.setSpecification(GBKUtils.cutGBKString((String)spec, (int)40));
        } else if (StringUtils.isNotEmpty((CharSequence)spec) && GBKUtils.getGBKLength((String)spec) > 40 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getCode(), ApiErrCodeEnum.INVOICE_OPEN_SPECIFICATION.getMsg());
        }
        String unit = good.getUnits();
        if (StringUtils.isNotBlank((CharSequence)unit) && GBKUtils.getGBKLength((String)good.getUnits()) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
            good.setUnits(GBKUtils.cutGBKString((String)unit, (int)22));
        } else if (StringUtils.isNotBlank((CharSequence)unit) && GBKUtils.getGBKLength((String)good.getUnits()) > 22 && BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_HINT.getValue().equals(issueInvSetting.getString("fieldtolong"))) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODUNIT.getMsg());
        }
        if (StringUtils.isEmpty((CharSequence)good.getTaxRate())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getMsg());
        }
        String taxRate = good.getTaxRate();
        if (taxRate.contains("%") && !Arrays.asList(ApiVerifyUtil.getPercentTaxRate()).contains(taxRate)) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getMsg());
        }
        if (taxRate.contains(".") && !Arrays.asList(ApiVerifyUtil.getFloatTaxRate()).contains(taxRate)) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getMsg());
        }
        if (RegexUtil.isInteger((String)taxRate) && !Arrays.asList(ApiVerifyUtil.getIntTaxRate()).contains(taxRate)) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODRATE.getMsg());
        }
        if (taxRate.contains("%")) {
            good.setTaxRate(TaxRateUtil.percent2Point((String)taxRate));
        } else if (RegexUtil.isInteger((String)taxRate)) {
            good.setTaxRate(new BigDecimal(taxRate).multiply(new BigDecimal("0.01")).toString());
        }
        if (!MathUtils.isNullOrZero((BigDecimal)good.getAmount()) && BaseCheckService.checkStringNotZore(good.getQuantity()) && BaseCheckService.checkStringNotZore(good.getPrice()) && (calcAmount = new BigDecimal(good.getQuantity()).multiply(new BigDecimal(good.getPrice())).setScale(2, 4)).abs().subtract(good.getAmount().abs()).abs().compareTo(InvoiceConstant.DIFF_01) > 0) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_AMOUNT_NUM_PRICE.getCode(), String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u5546\u54c1\u5355\u4ef7[%1$s]*\u6570\u91cf[%2$s]\u4e0e\u91d1\u989d[%3$s]\u8bef\u5dee\u5927\u4e8e0.01", (String)"CheckInvoiceOpenService_21", (String)"imc-sim-webapi", (Object[])new Object[0]), good.getPrice(), good.getQuantity(), good.getAmount()));
        }
        BigDecimal diffTax = BigDecimal.ZERO;
        if (includeTaxFlag == 0) {
            if (!MathUtils.isNullOrZero((BigDecimal)good.getAmount())) {
                good.setAmount(good.getAmount().setScale(2, 4));
            } else {
                if (!BaseCheckService.checkStringNotZore(good.getQuantity()) || !BaseCheckService.checkStringNotZore(good.getPrice())) return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_AMOUNT_NUM_PRICE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_AMOUNT_NUM_PRICE.getMsg());
                good.setAmount(new BigDecimal(good.getPrice()).multiply(new BigDecimal(good.getQuantity())).setScale(2, RoundingMode.HALF_UP));
            }
            taxAmount = TaxCalcUtil.calTax((BigDecimal)good.getAmount(), (BigDecimal)(good.getLineProperty() == 1 ? null : deduction), (BigDecimal)new BigDecimal(good.getTaxRate()), (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE, (int)8);
            if (MathUtils.isNullOrZero((BigDecimal)good.getTaxAmount())) {
                good.setTaxAmount(taxAmount.setScale(2, 4));
            } else {
                diffTax = taxAmount.subtract(good.getTaxAmount());
            }
            good.setIncludeTaxAmount(good.getAmount().add(good.getTaxAmount()).setScale(2, RoundingMode.HALF_UP));
        } else {
            if (!MathUtils.isNullOrZero((BigDecimal)good.getAmount())) {
                good.setIncludeTaxAmount(good.getAmount().setScale(2, RoundingMode.HALF_UP));
            } else {
                if (!BaseCheckService.checkStringNotZore(good.getQuantity()) || !BaseCheckService.checkStringNotZore(good.getPrice())) return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_AMOUNT_NUM_PRICE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_AMOUNT_NUM_PRICE.getMsg());
                good.setIncludeTaxAmount(new BigDecimal(good.getPrice()).multiply(new BigDecimal(good.getQuantity())).setScale(2, RoundingMode.HALF_UP));
            }
            if (!MathUtils.isNullOrZero((BigDecimal)good.getTaxAmount())) {
                taxAmount = TaxCalcUtil.calTax((BigDecimal)good.getIncludeTaxAmount().subtract(good.getTaxAmount()), (BigDecimal)(good.getLineProperty() == 1 ? null : deduction), (BigDecimal)new BigDecimal(good.getTaxRate()), (Boolean)Boolean.FALSE, (Boolean)Boolean.FALSE, (int)8);
                diffTax = taxAmount.subtract(good.getTaxAmount());
            } else {
                good.setTaxAmount(TaxCalcUtil.calTax((BigDecimal)good.getIncludeTaxAmount(), (BigDecimal)(good.getLineProperty() == 1 ? null : deduction), (BigDecimal)new BigDecimal(good.getTaxRate()), (Boolean)Boolean.TRUE, (Boolean)Boolean.FALSE, (int)2));
            }
            good.setAmount(good.getIncludeTaxAmount().subtract(good.getTaxAmount()).setScale(2, RoundingMode.HALF_UP));
        }
        if (diffTax.abs().compareTo(InvoiceConstant.DIFFF_06) > 0) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODTAXAMOUNT.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODTAXAMOUNT.getMsg());
        }
        if (red) {
            if (good.getLineProperty() == 1 || good.getAmount().doubleValue() > 0.0) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_LINEPROPERTYRED.getCode(), ApiErrCodeEnum.INVOICE_OPEN_LINEPROPERTYRED.getMsg());
            }
        } else {
            if (good.getAmount().doubleValue() < 0.0 && good.getLineProperty() != 1) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_LINE_ERROR1.getCode(), ApiErrCodeEnum.INVOICE_OPEN_LINE_ERROR1.getMsg());
            }
            if (good.getAmount().doubleValue() > 0.0 && good.getLineProperty() == 1) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_LINE_ERROR2.getCode(), ApiErrCodeEnum.INVOICE_OPEN_LINE_ERROR2.getMsg());
            }
        }
        CheckInvoiceOpenService.calculateUnitPrice(good, includeTaxFlag, deduction, isAllEle);
        if (!MathUtils.isNullOrZero((BigDecimal)good.getDiscountAmount()) && good.getDiscountAmount().doubleValue() > 0.0) {
            good.setDiscountAmount(good.getDiscountAmount().negate());
        }
        if (BaseCheckService.checkStringNotZore(good.getDiscountRate())) {
            String disRate = good.getDiscountRate();
            boolean equals = "%".equals(disRate.substring(disRate.length() - 1));
            if (!RegexUtil.isFloat((String)disRate) && !equals) {
                return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODDISRATE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODDISRATE.getMsg());
            }
            if (equals) {
                good.setDiscountRate(TaxRateUtil.percent2Point((String)disRate));
            }
            if (MathUtils.isNullOrZero((BigDecimal)good.getDiscountAmount())) {
                BigDecimal discountAmount = includeTaxFlag == 0 ? good.getAmount().multiply(new BigDecimal(good.getDiscountRate())) : good.getIncludeTaxAmount().multiply(new BigDecimal(good.getDiscountRate()));
                if (discountAmount.compareTo(BigDecimal.ZERO) > 0) {
                    discountAmount = discountAmount.setScale(2, 4).negate();
                }
                good.setDiscountAmount(discountAmount);
            }
        }
        if (StringUtils.isBlank((CharSequence)good.getGoodsCode()) && StringUtils.isBlank((CharSequence)good.getRevenueCode())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODCODES.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODCODES.getMsg());
        }
        DynamicObject taxClassCode = TaxClassCodeCheckHelper.geTaxCode((String)good.getRevenueCode());
        if (null == taxClassCode) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_REVENUECODE.getCode(), ApiErrCodeEnum.INVOICE_OPEN_REVENUECODE.getMsg());
        }
        good.setRevenueName(taxClassCode.getString("simplename"));
        String goodsName = good.getGoodsName();
        if (!good.getGoodsName().contains(String.format("*%s*", good.getRevenueName()))) {
            goodsName = String.format("*%s*%s", good.getRevenueName(), good.getGoodsName());
        }
        if (GBKUtils.getGBKLength((String)goodsName) > 92) {
            if (!BdmIssueInvSettingConstant.FieldToLongValueEnum.TO_LONG_SPLIT.getValue().equals(issueInvSetting.getString("fieldtolong"))) return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_GOODNAMEISGBK.getCode(), ApiErrCodeEnum.INVOICE_OPEN_GOODNAMEISGBK.getMsg());
            good.setGoodsName(GBKUtils.cutGBKString((String)goodsName, (int)92).substring(good.getRevenueName().length() + 2));
        } else {
            good.setGoodsName(goodsName);
        }
        int privilegeFlag = good.getPrivilegeFlag();
        if (1 == privilegeFlag && StringUtils.isBlank((CharSequence)good.getPrivilegeContent())) {
            return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_PRIVILEGEFLAGY.getCode(), ApiErrCodeEnum.INVOICE_OPEN_PRIVILEGEFLAGY.getMsg());
        }
        if (0 != privilegeFlag || StringUtils.isBlank((CharSequence)good.getPrivilegeContent())) return VerifyResult.succeed(diffTax);
        return VerifyResult.error(ApiErrCodeEnum.INVOICE_OPEN_PRIVILEGEFLAGN.getCode(), ApiErrCodeEnum.INVOICE_OPEN_PRIVILEGEFLAGN.getMsg());
    }

    private static void calculateUnitPrice(InvoiceDetailVo good, int includeTaxFlag, BigDecimal deduction, boolean isAllEle) {
        if (BaseCheckService.checkStringNotZore(good.getQuantity()) && !BaseCheckService.checkStringNotZore(good.getPrice())) {
            if (includeTaxFlag == 1) {
                CheckInvoiceOpenService.getUnitPriceByHS(good, deduction, isAllEle);
            } else {
                good.setPrice(PriceHelper.calcPriceOrNum((BigDecimal)good.getAmount(), (BigDecimal)new BigDecimal(good.getQuantity()), (boolean)isAllEle).toPlainString());
            }
            good.setIncludeTaxPrice(PriceHelper.calcPriceOrNum((BigDecimal)good.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(good.getQuantity()), (boolean)isAllEle).toPlainString());
        } else if (!BaseCheckService.checkStringNotZore(good.getQuantity()) && BaseCheckService.checkStringNotZore(good.getPrice())) {
            if (includeTaxFlag == 0) {
                good.setQuantity(UnitPriceHelper.calcNum((BigDecimal)good.getAmount(), (BigDecimal)new BigDecimal(good.getPrice())).toPlainString());
                good.setIncludeTaxPrice(PriceHelper.calcPriceOrNum((BigDecimal)good.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(good.getQuantity()), (boolean)isAllEle).toPlainString());
            } else {
                good.setIncludeTaxPrice(good.getPrice());
                good.setQuantity(UnitPriceHelper.calcNum((BigDecimal)good.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(good.getIncludeTaxPrice())).toPlainString());
                CheckInvoiceOpenService.getUnitPriceByHS(good, deduction, isAllEle);
            }
        } else if (BaseCheckService.checkStringNotZore(good.getQuantity()) && BaseCheckService.checkStringNotZore(good.getPrice())) {
            if (includeTaxFlag == 0) {
                good.setIncludeTaxPrice(PriceHelper.calcPriceOrNum((BigDecimal)good.getIncludeTaxAmount(), (BigDecimal)new BigDecimal(good.getQuantity()), (boolean)isAllEle).toPlainString());
            } else {
                good.setIncludeTaxPrice(good.getPrice());
                CheckInvoiceOpenService.getUnitPriceByHS(good, deduction, isAllEle);
            }
        }
    }

    private static void getUnitPriceByHS(InvoiceDetailVo good, BigDecimal deduction, boolean isAllEle) {
        BigDecimal unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)good.getIncludeTaxAmount().divide(BigDecimal.ONE.add(new BigDecimal(good.getTaxRate())), 15, RoundingMode.HALF_UP), (BigDecimal)new BigDecimal(good.getQuantity()), (boolean)isAllEle);
        if (!MathUtils.isZero((BigDecimal)deduction)) {
            unitPrice = PriceHelper.calcPriceOrNum((BigDecimal)good.getAmount(), (BigDecimal)new BigDecimal(good.getQuantity()), (boolean)isAllEle);
        }
        good.setPrice(unitPrice.toString());
    }

    public static void copyInvoiceDetailVo(InvoiceDetailVo good, InvoiceDetailVo copyGood) {
        good.setLineProperty(2);
        good.setDiscountAmount(null);
        good.setDiscountRate("");
        copyGood.setLineProperty(1);
        copyGood.setAmount(copyGood.getDiscountAmount());
        copyGood.setTaxAmount(null);
        copyGood.setDiscountAmount(null);
        copyGood.setDiscountRate("");
        copyGood.setIncludeTaxAmount(null);
        copyGood.setSpecification(null);
        copyGood.setPrice(null);
        copyGood.setUnits(null);
        copyGood.setQuantity(null);
        copyGood.setIncludeTaxPrice(null);
    }
}

